;;; -*- Mode: LISP; Package: common-lisp-user; Syntax: Common-lisp;      -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   np-make.cl
;;; Short Desc: Compile & load code & documentation
;;; Version:    1.0
;;; Status:     Experimental (July 1990)
;;; Last Mod:   27.1.92 - TW
;;; Author:     Thomas Wehrle
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; Build Backprop Simulator
;;;


(in-package :np)


(defparameter *nppath* (add-subdir *pail-path* "np"))
(defparameter *libpath* (add-subdir *pail-path* "pail-lib"))

(ensure-loaded (add-path "tables" *libpath*))
(ensure-loaded (add-path "np-def" *nppath*))
(ensure-loaded (add-path "np" *nppath*))
(ensure-loaded (add-path "np-bp" *nppath*))

(when *gin-p*
  (ensure-loaded (add-path "table-ed" *libpath*))
  (ensure-loaded (add-path "np-graphics" *nppath*))
  (ensure-loaded (add-path "np-tables" *libpath*))
  (ensure-loaded (add-path "np-dialog" *nppath*)))

(ensure-loaded (add-path "np-demo" *nppath*))
(ensure-loaded (add-path "np-demo1" *nppath*))


(format *standard-output* "~%Neural Network Simulator loaded")

;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
