;;; -*- Mode: LISP; Package: NP; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   np-dialog.cl
;;; Short Desc: dialog handling for np
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   25.3.92 - TW
;;; Author:     Thomas Wehrle & Nick Almassy
;;;

;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;



;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;; 25.3.92 ask checks the input for the definition of a network (TW)
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :np)

(defvar *tolerance*)
(defvar *max-trials*)
(defvar *demo-training-data*)
(defvar *stop* nil)
(defvar *total-count* 0)
(defvar *text-disp* nil)
(defvar *demo-net*)
(defvar *graphics*)
(defvar *pausing*)
(defvar *demo-in-execution* nil)
(defvar *show-test-button* nil)
(defvar *show-cont-button* nil)
(defvar *show-closed* nil)
(defvar *show-done* nil)
(defvar *learn-done* nil)

(defvar *connection-p* nil)
(defvar *auto-update* nil)
(defvar *w-max* 8)
(defvar *a-max* 1)
(defparameter *demo-def* '((output-layer 4) (hidden-layer1 2) (input-layer 4)))
(defvar *net-display-exit-button* nil)
(defparameter *number-of-demos* 1)



(defun define-network ()
  (when (equal (y-or-n-dialog (format nil "~a Redefine?" (reverse *demo-def*))) :yes)
    (let* ((nbr-of-layers (read-from-string (ask "How many layers should your net have (>1) "
						 :condition (function
							     (lambda (input)
							       (let ((val (read-from-string input)))
								 (and (integerp val) (> val 1)))))
						 :error-message "Enter a interger > 1")))
	   (def nil))
      (dotimes (i nbr-of-layers)
	(setf def
	  (cons
	   (list
	    (if (zerop i)
		(read-from-string (format nil "input-layer"))
	      (if (eq i (1- nbr-of-layers))
		  (read-from-string (format nil "output-layer"))
		(read-from-string (format nil "hidden-layer~a" i))))
	    (if (zerop i)
		(read-from-string (ask "How many nodes should your input layer have (>=1) "
				       :condition (function
						   (lambda (input)
						     (let ((val (read-from-string input)))
						       (and (integerp val) (plusp val)))))
				       :error-message "Enter a interger >= 1"))
	      (if (eq i (1- nbr-of-layers))
		  (read-from-string (ask "How many nodes should your output layer have (>=1) "
					 :condition (function
						     (lambda (input)
						       (let ((val (read-from-string input)))
							 (and (integerp val) (plusp val)))))
					 :error-message "Enter a interger >= 1"))
		(read-from-string (ask (format nil "How many nodes should your ~:R hidden layer have (>=1) " i)
				       :condition (function
						   (lambda (input)
						     (let ((val (read-from-string input)))
						       (and (integerp val) (plusp val)))))
				       :error-message "Enter a interger >= 1")))))
	   def)))
      (setf *demo-def* def))))


(defun set-net (spec)
  (if (not (loop for s in spec always (and (integerp s) (>= s 1))))
      (display-error "All layers must have integer sizes, >= 1")
    (setf *demo-def* (reverse (loop for i from 0 to (1- (length spec)) collect
			   (list (if (zerop i)
				     (read-from-string (format nil "input-layer"))
				   (if (eq i (1- (length spec)))
				       (read-from-string (format nil "output-layer"))
				     (read-from-string (format nil "hidden-layer~a" i))))
				 (nth i spec)))))))


				 
(make-editor-fcn
 pattern-edit
 :obj-var tab
 :default-menu-entries nil
 :menu
 `(("Add Example" ,(function
		    (lambda ()
		      (if (equal tab (input-patterns *demo-training-data*))
			  (progn
			    (setf (rows (input-patterns *demo-training-data*))
			      (append
			       (rows (input-patterns *demo-training-data*))
			       (list
				(mapcar (function (lambda (attr)
						    (intern-all
						     (read-from-string
						      (ask (format nil "Enter value for attribute ~a.~%=> " attr))) :dump)))
					(attributes (input-patterns *demo-training-data*))))))
			    (refresh (input-patterns *demo-training-data*))
			    (setf (rows (target-patterns *demo-training-data*))
			      (append
			       (rows (target-patterns *demo-training-data*))
			       (list
				(mapcar (function (lambda (attr)
						    (intern-all
						     (read-from-string
						      (ask (format nil "Enter value for attribute ~a.~%=> " attr))) :dump)))
					(attributes (target-patterns *demo-training-data*))))))
			    (refresh (target-patterns *demo-training-data*)))
			(progn
			  (setf (rows (target-patterns *demo-training-data*))
			    (append
			     (rows (target-patterns *demo-training-data*))
			     (list
			      (mapcar (function (lambda (attr)
						  (intern-all
						   (read-from-string
						    (ask (format nil "Enter value for attribute ~a.~%=> " attr))) :dump)))
				      (attributes (target-patterns *demo-training-data*))))))
			  (refresh (target-patterns *demo-training-data*))
			  (setf (rows (input-patterns *demo-training-data*))
			    (append
			     (rows (input-patterns *demo-training-data*))
			     (list
			      (mapcar (function (lambda (attr)
						  (intern-all
						   (read-from-string
						    (ask (format nil "Enter value for attribute ~a.~%=> " attr))) :dump)))
				      (attributes (input-patterns *demo-training-data*))))))
			  (refresh (input-patterns *demo-training-data*))))))
		  "Add a new example (a row) to the table")
   ("Delete Example" ,(function
		       (lambda ()
			 (let ((pos nil))
			   (setf pos
			     (read-from-string
			      (ask "Please enter the number of the example.~%=> "
				   :condition 
				   (function (lambda (string)
					       (let ((x (read-from-string string nil)))
						 (and (integerp x) (plusp x)))))
				   :error-message "The example has to be identified with a number.")))
			   (if (and (plusp pos) (<= pos (number-of-rows tab)))
			       (progn
				 (setf (rows (input-patterns *demo-training-data*))
				   (remove-nth (1- pos) (rows (input-patterns *demo-training-data*))))
				 (setf (rows (target-patterns *demo-training-data*))
				   (remove-nth (1- pos) (rows (target-patterns *demo-training-data*))))
				 (refresh (input-patterns *demo-training-data*))
				 (refresh (target-patterns *demo-training-data*)))
			     (display-error "Example does not exist!")))))
		     "Deete an example (a row)")))




(defun make-training-data (def)
  (let* ((nbrs (mapcar (function (lambda (layer-def)
				   (second layer-def)))
		       def))
	 (min (min (first nbrs) (first (last nbrs)))))
    (make-instance 'training-data-class
      :input-patterns
      (make-table :attributes (let ((list nil))
				(dotimes (i (first (last nbrs)) list)
				  (setf list (append list (list (read-from-string (format nil "i~a" (1+ i))))))))
		  :rows (if (or (> (first (last nbrs)) 8) (> (first nbrs) 8)) nil
			  (let ((list nil))
			    (dotimes (i min list)
			      (setf list (cons
					  (let ((list2 nil))
					    (dotimes (j (first (last nbrs)) list2)
					      (setf list2 (cons (if (eq i j) 1 0) list2))))
					  list))))))
      :target-patterns
      (make-table :attributes (let ((list nil))
				(dotimes (i (first nbrs) list)
				  (setf list (append list (list (read-from-string (format nil "t~a" (1+ i))))))))
		  :rows (if (or (> (first nbrs) 8) (> (first (last nbrs)) 8)) nil
			  (let ((list nil))
			    (dotimes (i min list)
			      (setf list (cons
					  (let ((list2 nil))
					    (dotimes (j (first nbrs) list2)
					      (setf list2 (cons (if (eq (1+ i) (- (first nbrs) j)) 1 0) list2))))
					  list)))))))))


(defun convert (input target)
  (if (and input target)
      (cons (list (car input) (car target))
	    (convert (cdr input) (cdr target)))
    nil))


(defmethod learn ((training-data training-data-class)
		  (net bp-net-class)
		  &key 
		  (error-tolerance 0.1)
		  (max-count 500))
  (reset-net net)
  (dotimes (counter max-count (progn
				(format-display *text-disp* "Not stable at ~a." max-count)
				max-count))
    (format-display *text-disp* "~a " counter)
    (when (or *stop*
	      (prog1
		  (learn-patterns net (convert (rows (input-patterns training-data))
					       (rows (target-patterns training-data)))
				  (get-node-seq-names net)
				  :error-tolerance error-tolerance)
		(when *auto-update* (show-weights *graphics*))))
      (progn
	(format-display *text-disp* "~%~a learning cycles." counter)
	(return (1+ counter))))))


(defun start-np-dialog (&optional (from-button nil))
  (setf *tolerance* 0.1)
  (setf *max-trials* 500)
  (setf gin::*default-push-button-size-p* nil)
  (let* ((disp (make-instance 'display :title "NP:Main Window"
			     :width 300
			     :height 150
			     :borders 1
			     :left (+ (width pail-lib::*main-window*) (left pail-lib::*main-window*))
			     :bottom (bottom pail-lib::*main-window*)))
	 (exit-button (make-instance 'push-button :label "Exit" :width 70))
	 (help-button (make-instance 'help-button
			:technical (add-path "np-desc.tec" *nppath*)
			:general (add-path "np-desc.gen" *nppath*)
			:subject "NP"))
;	 (def-button (make-instance 'push-button :label "Define" :width 70))
	 (menu-button (make-instance 'pop-up-button
			:label "Demos"
			:width 70))
	 (tool-button (make-instance 'push-button :label "Tool" :width 70))
	 (menu (make-instance 'menu
		 :items  (let ((mlist nil))
			   (dotimes (i *number-of-demos* (nreverse mlist))
			     (setf mlist 
			       (cons (list (format nil "Demo ~a" (1+ i)) 
					   `(lambda () 
					      (demo ,(1+ i) ,menu-button 
						    ,exit-button ,tool-button ,disp))
					   (make-title (1+ i)))
				     mlist))))
		 
       		 :query " DEMOS ")))

    (setf (menu menu-button) menu)
    
    (copy-mask *pail-logo* 0 0 disp
	       (- (width disp) (width *pail-logo*) 15)
	       (- (height disp) (height *pail-logo*) 15))
  
    (setf (font disp) (open-font :courier :italic 16 :weight :bold))
    (write-display disp
		   "Welcome to ..."
		   15 (- (height disp) 15 (font-ascent (font disp))))
    (setf (font disp) (open-font :courier :italic 20 :weight :bold))
    (write-display disp
		   "Back Propagation"
		   (floor (width disp) 10)
		   (- (height disp) 40 (font-ascent (font disp))))
    (setf (font disp) *default-font*)
 
    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) 15)
		:bottom 15
		:action `(lambda nil
			   (close-display ,disp)
			   (if ,from-button (reset-button ,from-button))))

    (set-button help-button disp :left 15 :bottom 15)
    #| (set-button def-button disp :left (- (floor (width disp) 2) (floor (width tool-button) 2)) :bottom 42
		:action `(lambda nil
			   (disable-button ,tool-button)
			   (define-network)
			   (reset-button ,def-button)
			   (enable-button ,tool-button))) |#
    (set-button tool-button disp :left (- (floor (width disp) 2) (floor (width tool-button) 2)) :bottom 15
		:action `(lambda nil
			   (start-tool ,tool-button ,exit-button )))
    (set-button menu-button disp 
		:left (/ (- (width disp) (width menu-button)) 2)
		:bottom 45)
    disp))


(defun start-tool (from-button m-exit-button )
  (disable-button m-exit-button)
					;  (disable-button def-button)
  (let* ((*default-font* (findfont (round (width *root-window*) 4) 300 13))
	 (demo-disp (progn (documentation-print "Creating Demo Network...")
			   (setf *demo-training-data* (make-training-data *demo-def*))
			   (bp-make-net '*demo-net* *demo-def*)
			   (setf *graphics* (make-instance 'net-graphics))
			   (setf (a-disp-width *graphics*)
			     (- (min 280 (round (width *root-window*) 4))
				cwex::*static-scroll-bar-width*))
			   (setf (a-disp-height *graphics*)
			     (- (min 540 (* 2 (round (height *root-window*) 3)))
				cwex::*static-pann-bar-height* 82))
			   (init *graphics* *demo-net* :max-weight *w-max*)
			   (make-instance 'display :title "NP:Tool"
					  :width (round (width *root-window*) 2)
					  :height (round (height *root-window*) 3)
					  :left 5
					  :font *default-font*
					  :bottom (- (height *root-window*)
						     (round (height *root-window*) 3) 20))))
	 (help-button (make-instance 'help-button
			:technical (add-path "tool-desc.tec" *nppath*)
			:general (add-path "tool-desc.gen" *nppath*)
			:subject "NP"
			:width (round (width demo-disp) 8)))
	 (exit-button (make-instance 'push-button :label "Exit" :width (round (width demo-disp) 8)))
	 (clear-button (make-instance 'push-button :label "Clear" :width (round (width demo-disp) 8)))
	 (show-button (make-instance 'push-button :label "Show" :width (round (width demo-disp) 8)))
	 (learn-button (make-instance 'push-button :label "Learn" :width (round (width demo-disp) 8)))
	 (stop-button (make-instance 'push-button :label "Stop" :width (round (width demo-disp) 8)))
	 (new-button (make-instance 'push-button :label "New" :width (round (width demo-disp) 8)))
	 (net-button (make-instance 'value-button 
		       :name "Network Topology:" 
		       :value nil
		       :width (round (width demo-disp) 4)
		       :border t
		       ))
	 (table-button (make-instance 'pool-button
			 :name "Training Set:"
			 :value ""
			 :width (round (width demo-disp) 4)
			 :target-class 'pail-lib::training-data-class
			 :pool *pail-pool*
			 :border t
			 :after-get `(lambda (item)
				       (setf *demo-training-data* (start-object item))
				       (when (/=  (status ,show-button) 0)
					 (let (estw)
					   (close-pattern-edit 'bla :close-all t)
					   
					   (multiple-value-bind (table window)
					       (pattern-edit
					    (input-patterns *demo-training-data*)
					    :left (min (- (width *root-window*)
							  (* 80 (length (attributes (input-patterns *demo-training-data*)))))
						       (round (width *root-window*) 2))
					    :bottom 10
					    :font (findfont (width *root-window*) 1100 10)
					    :cell-font (findfont (width *root-window*) 1100 10)
					    :cell-width 8
					    :title "NP:Input Patterns")
					     (setf (left window) (- (width *root-window*)
							  (width window)))
					   
					   (multiple-value-bind (table window)
					       (pattern-edit (target-patterns *demo-training-data*)
							 :left (min (- (width *root-window*)
								       (* 80 (length (attributes (target-patterns *demo-training-data*)))))
								    (round (width *root-window*) 2))
							 :bottom (+ (bottom window) (height window) 25)
							 :font (findfont (width *root-window*) 1100 10)
							 :cell-font (findfont (width *root-window*) 1100 10)
							 :cell-width 8
							 :title "NP:Target Patterns")
					     (setf (left window) (- (width *root-window*)
							  (width window)))))))
				       (if (not
					    (and
					     (= (cadar *demo-def*)
						(length (attributes (target-patterns *demo-training-data*))))
					     (= (cadar (reverse *demo-def*))
						(length (attributes (input-patterns *demo-training-data*))))))
					   (progn
					     (display-error
					      (format nil
						      "Your current training set~
                                                        does not match this network topology. ~
                                                        (~d -> ~d) ~%Please update your network."
						      (length (attributes (input-patterns *demo-training-data*)))
						      (length (attributes (target-patterns *demo-training-data*)))))
					     (disable-button ',learn-button))
					 (enable-button ',learn-button)
					 ))
			 ))
	 (tolerance-button (make-instance 'value-button :numeric t :label "Tolerance:" :width (round (width demo-disp) 8) :value *tolerance*))
	 (l-rate-button (make-instance 'value-button :numeric t :label "Learn Rate:" :width (round (width demo-disp) 8) :value (l-rate *demo-net*)))
	 (momentum-button (make-instance 'value-button :numeric t :label "Momentum:" :width (round (width demo-disp) 8) :value (momentum *demo-net*)))
	 (max-trials-button (make-instance 'value-button :numeric t :label "Max Trials:" :width (round (width demo-disp) 8) :value *max-trials*))
	 (file-button (make-instance 'file-button
			:w-directory *nppath*)))

    (setf *total-count* 0)
    
    (copy-mask *pail-logo* 0 0 demo-disp
	       (- (width demo-disp) (width *pail-logo*) 15)
	       (- (height demo-disp) (height *pail-logo*) 15))
    (set-button file-button demo-disp
		:left (- (width demo-disp) (width file-button) 7)
		:bottom (- (height demo-disp) (height file-button) (cw:bitmap-height *pail-logo*) 20))
    (setf *text-disp* (make-instance 'scroll-display
			:title "NP:Comments"
			:font (findfont (width demo-disp) 360 10)
			:parent demo-disp
			:width (- (round (width demo-disp)  2) 15)
			:height (- (bottom file-button) (+ 15 (height exit-button)) 30)
			:borders 1
			:left (round (width demo-disp)  2)
			:bottom  (+ 20 (height exit-button)) ))
    (setf (button-value table-button) (make-instance 'pool-item
					:start-object *demo-training-data*
					:name-part "Data"
					))
    (set-button table-button demo-disp
		:left (- (left file-button) (width table-button) 15)
		:bottom (- (height demo-disp) (height *pail-logo*) 25)
		)
    (set-button net-button demo-disp
		:left (left table-button)
		:bottom (+ (bottom table-button) (height table-button))
		:action `(lambda nil
			   (set-net (read-from-string (button-value ,net-button)))
			   (if (not
				(and
				 (= (cadar *demo-def*)
				    (length (attributes (target-patterns *demo-training-data*))))
				 (= (cadar (reverse *demo-def*))
				    (length (attributes (input-patterns *demo-training-data*))))))
			       (progn
				 (display-error "Your current training set does not match this network topology.  ~%Please update your training set.")
				 (disable-button ',learn-button))
			     (enable-button ',learn-button)
			     )
			   (bp-make-net '*demo-net* *demo-def*)
			   #| (setf (a-disp-width *graphics*)
			     (- (min 250 (round (width *root-window*) 4))
				cwex::*static-scroll-bar-width*)) |#
			   #| (setf (a-disp-height *graphics*)
			     (- (min 400 (round (height *root-window*) 2))
				cwex::*static-pann-barh-eight* 82)) |#
			   (init *graphics* *demo-net* :max-weight *w-max*)
			   (if (/= 0 (status ,show-button)) (reshow-net))
			   )
		)
    (set-button help-button demo-disp :left (round (* (+ .5 (* 4 0)) (round (width demo-disp) 24))) :bottom 15)
  (set-button exit-button demo-disp 
	      :left (round (* (+ .5 (* 4 5)) (round (width demo-disp) 24)))
	      :bottom 15
	      :action `(lambda nil
			 (when *net-display-exit-button*
			   (software-push *net-display-exit-button*)
			   (setf *show-closed* nil)
			   (mp:process-wait "wait-on-continue"
					    (function
					     (lambda ()
					       (or (not *net-display-exit-button*)
						   *show-closed*)))))
			 (if ,from-button (reset-button ,from-button))
					;			   (enable-button ,def-button)
			 (enable-button ,m-exit-button)
			 (close-display ,demo-disp)
			 ))
  (set-button clear-button demo-disp 
	      :left (round (* (+ .5 (* 4 3)) (round (width demo-disp) 24)))
	      :bottom 15
	      :action `(lambda nil
			 (when (equal (y-or-n-dialog "Do you really want to re-initialize the whole Network?")
				      :yes)
			   (documentation-print "Reinitializing Demo Network...")
			   (reinit-net *demo-net*)
			   (setf *total-count* 0)
			   (clear-scroll *text-disp*)
			   (format-display *text-disp* "Network reinitialized.")
			   (documentation-print "Done."))
			 (reset-button ,clear-button)))
  (set-button show-button demo-disp
	      :left (round (* (+ .5 (* 4 1)) (round (width demo-disp) 24)))
	      :bottom 15
	      :action `(lambda ()
			 (show-net ,show-button)))
  (set-button learn-button demo-disp
	      :left (round (* (+ .5 (* 4 2)) (round (width demo-disp) 24)))
	      :bottom 15
	      :action `(lambda ()
			 (setf *stop* nil)
			 (enable-button ,stop-button)
			 (incf *total-count*
			       (learn *demo-training-data*
				      *demo-net*
				      :error-tolerance *tolerance*
				      :max-count *max-trials*))
			 (setf (w-max *graphics*)
			   (1+ (truncate (loop for i from 0 to (1- (matrix-len *graphics*)) maximize
					       (loop for j from 0 to (1- (matrix-len *graphics*))
						   when (aref (w-positions *graphics*) i j)
						   maximize (abs (weight (third (aref (w-positions *graphics*) i j)))))))))
			 (when (w-max-button *graphics*)
			   (setf (button-value (w-max-button *graphics*))
			     (w-max *graphics*)))
			 (show-weights *graphics*)
			 (format-display *text-disp* "~%~a total steps." *total-count*)
			 (unless *stop* (disable-button ,stop-button))
			 (reset-button ,learn-button)
			 (setf *learn-done* t)))
  (set-button new-button demo-disp
	      :left 80
	      :bottom 145
	      :active t
	      :action #'(lambda ()
			 (setf (button-value table-button)
			   (make-instance 'pool-item
			     :start-object (make-instance 'training-data-class
					     :input-patterns
					     (make-table :attributes
							 (loop for i from 1 to
							       (let
								   ((rows (car (read-from-string(button-value net-button)))))
								 (if rows rows 1))
							     collect (intern (format nil "a~a" i) :dump))
							 :rows nil)
					     :target-patterns
					     (make-table :attributes
							 (loop for i from 1 to
							       (let
								   ((rows (car (last (read-from-string(button-value net-button))))))
								 (if rows rows 1))
							     collect (intern (format nil "a~a" i) :dump))
							 :rows nil))
			     :name-part "NewData"))
			 (setf *demo-training-data* (start-object (button-value table-button)))
			 (reset-button new-button))
	      )
  (set-button stop-button demo-disp
	      :left (round (* (+ .5 (* 4 4)) (round (width demo-disp) 24)))
	      :bottom 15
	      :active nil
	      :action `(lambda ()
			 (setf *stop* t)
			 (disable-button ,stop-button)
			 (reset-button ,stop-button)))
  (set-button max-trials-button demo-disp
	      :left 120
	      :bottom 123 :border t
	      :action `(lambda nil (setf *max-trials* (button-value ,max-trials-button))))
  (set-button tolerance-button demo-disp
	      :left 120
	      :bottom (- (bottom max-trials-button) (height tolerance-button))
	      :border t
	      :action `(lambda nil (setf *tolerance* (button-value ,tolerance-button))))
  (set-button l-rate-button demo-disp
	      :left 120
	      :bottom (- (bottom tolerance-button) (height l-rate-button)) :border t
	      :action `(lambda nil (setf (l-rate *demo-net*) (button-value ,l-rate-button))))
  (set-button momentum-button demo-disp
	      :left 120
	      :bottom (- (bottom l-rate-button) (height momentum-button)) :border t
	      :action `(lambda nil (setf (momentum *demo-net*) (button-value ,momentum-button))))
  (documentation-print "Done.")
  (values demo-disp exit-button net-button table-button show-button learn-button)
  ))


(defun show-net (from-button &key (show-tables t))
  (let* ((*default-font* (findfont (min 400 (round (width *root-window*) 3)) 400 13))
	 (window-width (+ (a-disp-width *graphics*)
				cwex::*static-scroll-bar-width*))
	 (net-disp (make-instance 'display
		     :title "NP:Network Topology"
		     :width window-width
		     :height (+ 82 cwex::*static-scroll-bar-width* (a-disp-height *graphics*))
		     :left 10
		     :bottom 10))
	 (weight-disp (make-instance 'display
			:title "NP:Weight Pattern"
			:width window-width
			:height (+ 82 cwex::*static-scroll-bar-width* (a-disp-height *graphics*))
			:left (+ 5 (width net-disp) (left net-disp))
			:bottom 10))
	 (test-button (make-instance 'push-button :label "Test Net"))
	 (arrow-button (make-instance 'radio-button :label "Connections"
				      :status *connection-p*))
	 (auto-button (make-instance 'radio-button :label "Auto Update"
				     :status *auto-update*))
	 (continue-button (make-instance 'push-button :label "Continue" :active nil))
	 (exit-button (make-instance 'push-button :label "Dismiss"))
	 (a-update-button (make-instance 'push-button :label "Update"))
	 (w-update-button (make-instance 'push-button :label "Update"))
	 (w-max-button (make-instance 'value-button
			 :value *w-max*
			 :width 55
			 :border t
			 :numeric t
			 :name "max "))
	 (a-max-button (make-instance 'value-button
			 :value *a-max*
			 :width 55
			 :border t
			 :numeric t
			 :name "max "))
	 (help-button (make-instance 'help-button
			:technical (add-path "show-net-desc.tec" *nppath*)
			:general (add-path "show-net-desc.gen" *nppath*)
			:subject "NP"
			:width (width w-update-button)
			)))

    (setf (w-max-button *graphics*) w-max-button)
    (setf (net-display *graphics*) net-disp
	  (weight-display *graphics*) weight-disp
;	  (a-disp-width *graphics*) (- (width net-disp) cwex::*static-scroll-bar-width*)
;	  (a-disp-height *graphics*) (- (height net-disp) cwex::*static-pann-bar-height* 82)
	  )

    (open-activation-display *graphics*
			     :title nil
			     :parent net-disp
			     :width (- (width net-disp) cwex::*static-scroll-bar-width*)
			     :height (- (height net-disp) cwex::*static-pann-bar-height* 82)
			     :left 0
			     :bottom 82
			     :arrows-p *connection-p*)
    (open-weight-display *graphics*
			 :title nil
			 :parent weight-disp
			 :width (- (width weight-disp) cwex::*static-scroll-bar-width*)
			 :height (- (height weight-disp) cwex::*static-pann-bar-height* 82)
			 :left 0
			 :bottom 82)
    (set-button exit-button weight-disp :left (- (width weight-disp) (width exit-button) 15)
		:bottom 15
		:action `(lambda ()
			   (setf *auto-update* nil)
			   (reset-button ,from-button)
			   (close-pattern-edit 'bla :close-all t)
			   (close-display ,weight-disp)
			   (close-display ,net-disp)
			   (setf *show-closed* t)
			   (setf *net-display-exit-button* nil)))
    (setf *net-display-exit-button* exit-button)
    (set-button arrow-button net-disp :left 15 :bottom 51 
		:action `(lambda () 
			   (setf *connection-p* (status ,arrow-button))
			   (show-activities *graphics* :arrows-p *connection-p*)))
    (set-button auto-button weight-disp :left 15 :bottom 51 
		:action `(lambda () 
			   (setf *auto-update* (status ,auto-button))))
    (set-button w-max-button weight-disp
		:left (- (width weight-disp) (width w-max-button) 15)
		:bottom 45
		:action `(lambda ()
			   (if (> (button-value ,w-max-button) 0)
			       (progn 
				 (setf (w-max *graphics*) (button-value ,w-max-button))
				 (show-weights *graphics*))
			     (progn (display-error "Positive number expected" :wait nil :title "Error")
				    (setf (button-value ,w-max-button) (w-max *graphics*))))))
    (set-button a-max-button net-disp
		:left (- (width net-disp) (width a-max-button) 15)
		:bottom 45
		:action `(lambda () 
			   (if (> (button-value ,a-max-button) 0)
			       (progn 
				 (setf (a-max *graphics*) (button-value ,a-max-button))
				 (show-activities *graphics* :arrows-p *connection-p*))
			     (progn (display-error "Positive number expected" :wait nil :title "Error")
				    (setf (button-value ,a-max-button) (a-max *graphics*))))))
    (set-button test-button net-disp :left 15 :bottom 15
		:action `(lambda ()
			   (dolist (input-pattern (rows (input-patterns *demo-training-data*)))
			     (compute-net-output *demo-net* input-pattern)
			     (show-activities *graphics* :arrows-p *connection-p*)
			     (setf *pausing* t)
			     (enable-button ,continue-button)
			     (unless (equal input-pattern (car (last (rows (input-patterns *demo-training-data*)))))
			       (mp:process-wait "wait-on-continue" ,(function (lambda () (not *pausing*))))))
			   (disable-button ,continue-button)
			   (reset-button ,test-button)))
    (set-button continue-button net-disp
		:left (- (width net-disp) (width continue-button) 15)
		:bottom 15
		:active nil
		:action `(lambda ()
			   (setf *pausing* nil)
			   (reset-button ,continue-button)))
    (set-button a-update-button net-disp
		:left (- (floor (width net-disp) 2) (floor (width a-update-button) 2))
		:bottom 15
		:action `(lambda ()
			   (show-activities *graphics* :arrows-p *connection-p*)
			   (reset-button ,a-update-button)))
    (set-button w-update-button weight-disp
		:left (- (floor (width weight-disp) 2) (floor (width w-update-button) 2))
		:bottom 15
		:action `(lambda ()
			   (show-weights *graphics*)
			   (reset-button ,w-update-button)))
    (set-button help-button weight-disp :left 15 :bottom 15)
    (when show-tables
      (multiple-value-bind (table window)
	  (pattern-edit
	   (input-patterns *demo-training-data*)
	   :left (min (- (width *root-window*)
			 (* 80 (length (attributes (input-patterns *demo-training-data*)))))
		      (round (width *root-window*) 2))
	   :bottom 10
	   :font (findfont (width *root-window*) 1100 10)
	   :cell-font (findfont (width *root-window*) 1100 10)
	   :cell-width 8
	   :title "NP:Input Patterns")
	(setf (left window) (- (width *root-window*)
			       (width window)))
					   
	(multiple-value-bind (table window)
	    (pattern-edit (target-patterns *demo-training-data*)
			  :left (min (- (width *root-window*)
					(* 80 (length (attributes (target-patterns *demo-training-data*)))))
				     (round (width *root-window*) 2))
			  :bottom (+ (bottom window) (height window) 25)
			  :font (findfont (width *root-window*) 1100 10)
			  :cell-font (findfont (width *root-window*) 1100 10)
			  :cell-width 8
			  :title "NP:Target Patterns")
	  (setf (left window) (- (width *root-window*)
				 (width window)))))
      
      
      
      )
    (setf *show-test-button* test-button)
    (setf *show-cont-button* continue-button)
    (setf *show-done* t)))



(defun reshow-net ()
  (close-display  (a-disp *graphics*))
  (close-display (w-disp *graphics*))
  (open-activation-display *graphics*
			   :title nil
			   :parent (net-display *graphics*)
			   :width (- (width (net-display *graphics*)) cwex::*static-scroll-bar-width*)
			   :height (- (height (net-display *graphics*)) cwex::*static-pann-bar-height* 82)
			   :left 0
			   :bottom 82
			   :arrows-p *connection-p*)
  (open-weight-display *graphics*
		       :title nil
		       :parent (weight-display *graphics*)
		       :width (- (width (weight-display *graphics*)) cwex::*static-scroll-bar-width*)
		       :height (- (height (weight-display *graphics*)) cwex::*static-pann-bar-height* 82)
		       :left 0
		       :bottom 82)
    
  )


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
