;;; -*- Mode: LISP; Package: np; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   np-demo1.cl
;;; Short Desc: First demo on Backpropagation
;;; Version:    0.1
;;; Status:     Experimental
;;; Last Mod:   24.6.92 -dta
;;; Author:     Dean Allemang (after atn-demo1.cl)
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :np)


;;=====================================================================
;; The definition of demo1
;;=====================================================================


(defun demo-1 ( )
  (setq *demo-in-execution* 1)
  (load-file-no-questions (add-path "fourencode" (add-subdir *pail-path* "pool")))
  
  (format-display-fill  demo-text-disp 
		   "Here is the first demo of backpropagation 
		    networks. Push <continue> to
		    load the Backpropagation module")
  (when (wait)
    (let ((training-set (pool-find-object *pail-pool* "fourencode")))
      (multiple-value-bind (display exit-button net-button table-button show-button learn-button)
	  (start-tool nil nil)

  
	(format-display-fill  demo-text-disp 
			 "Now we select the current net
                      topology and the current training
                      set.")
	(when (wait)
	  (setf (button-value net-button) '(4 2 4))
	  (set-net '(4 2 4))
	  (bp-make-net '*demo-net* *demo-def*)
	  
	  (init *graphics* *demo-net* :max-weight *w-max*)
	  (setf (button-value table-button) (make-instance 'pool-item
					      :start-object training-set
					      :name-part "fourencode"))
	  (setf *demo-training-data* training-set)
	  
	  (format-display-fill  demo-text-disp 
			   "The Show button displays the 
                            net topology and the training set.
                           ")
	  (when (wait)
	    (setf *show-done* nil)
	    (software-push show-button)
	    
	    (format-display-fill  demo-text-disp 
			     "Each layer in the net has an
                              extra `bias node' for the next
                              layer.  
                              The training set is all four-bit
                              strings with exactly one 1.
                              The network will learn to encode
                              these strings into two activation
                              values.  This is an `encoding'
                              because the net can reproduce the 
                              original string from the encoded 
                              representation.  
                              ")
	    (mp:process-wait "show-done" (function (lambda () (or *show-done* *quit* *pause*))))
	    (when (wait)
	      (format-display-fill  demo-text-disp 
			       "The net usually takes just under
                              one hundred cycles to learn this
                              encoding.  
                              The learned weights are displayed
                              in the weights window.
                              We can test to see that the
                              net has learned these encodings by
                              pressing the Test and Continue
                              buttons. 
                              ")
    
	      (setf *learn-done* nil)
	      (software-push learn-button)
	      #| (mp:process-wait "learn-done"
			       (function (lambda ()
					   (or *learn-done* *quit* *pause*)))) |#
	      (when (wait)
		(mp:process-run-function "push test" #'software-push *show-test-button*)
		(when (wait)
		  (software-push *show-cont-button*  )
		  
		  (when (wait)
		    (software-push *show-cont-button*  )
		    (when (wait) 
		      (software-push *show-cont-button*  )
		      (format-display-fill demo-text-disp 
			       "You can test your own bit
                              strings by setting/unsetting
                              values of the input (bottom)
                              layer of the activation diagram,
                              using the middle mouse button.
                              Try it.
                              Press Continue when you are done. 
                              ")
		      (when (wait)      
			(format-display-fill  demo-text-disp 
					 "You can also change the 
                              network topology, as long
                              as the input/output lengths
                              are still consistent with the
                              training data.
                              ")
			(setf (button-value net-button) '(4 4 4))
			(set-net '(4 4 4))
			(bp-make-net '*demo-net* *demo-def*)

			(init *graphics* *demo-net* :max-weight *w-max*)
			(reshow-net)
			(when (wait)   
			  (format-display-fill  demo-text-disp 
					   "Of course, this resets the
                              network weights, and you have
                              to learn again.
                              ")
			  (setf *learn-done* nil)
			  (software-push learn-button)
			  #| (mp:process-wait "learn-done"
			       (function (lambda ()
					   (or *learn-done* *quit* *pause*)))) |#
			  
			  (when (wait)  
			    (format-display-fill  demo-text-disp 
					     "Play with the new net.
                              press `Contine' to end the demo.
                              ")
			    
			    
			    (when (wait)  
			       
			      
			      )))))))))))
	(software-push exit-button))
      
      )))



;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
