;;; -*- Mode: LISP; Package: GTRE; Syntax: Common-lisp;                 -*-
;;;
;;; **********************************************************************
;;;
;;; PORTABLE AI LAB - EPFL
;;;
;;; **********************************************************************
;;;
;;; Filename:   nmjtms.cl
;;; Short Desc: Debugging functions for NMJTMS
;;; Version:    1.0
;;; Status:     experimental
;;; Last Mod:   06.02.92 - Fatma FEKIH-AHMED
;;; Author:     Fatma FEKIH-AHMED
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; -------------------------------------------------------
;;; RCS $Log: util.cl,v $
;;; Revision 1.3  1992/02/20  19:32:55  fekih
;;; *** empty log message ***
;;;
;;; Revision 1.2  1992/02/20  16:35:10  fekih
;;; reamenage le traitement graphique de la contradiction.
;;;
;;; Revision 1.2  1992/02/20  16:35:10  fekih
;;; reamenage le traitement graphique de la contradiction.
;;;
;;; -------------------------------------------------------


;;; =======================================================================
;;; PACKAGE DECLARATIONS
;;; =======================================================================

(in-package :gtre)

(defun show-frame (facet)
  (dolist (fr *frames*)
    (dolist (slot (get-slots fr))
      (when (fget fr slot facet)
	(format t "~% frame= ~a ~% slot= ~a ~% facet= ~a ~% "
		fr slot (fget fr slot facet))))))


 (defun p-assertion-n (n)
   (dolist (assert *assert*)
     (when (equal (assertion-counter assert) n)
       (format t "~%")
       (format t "tre-assertion-counter: ~A~%" (assertion-counter assert))
       (format t "tre-assertion-lisp-form: ~A~%" (assertion-lisp-form assert))
       (format t "tre-assertion-tms-node: ~A~%" (assertion-tms-node assert))
       (return assert))))

 (defun p-t-node-n (n)
   (dolist (x *node*)
     (when (equal (tms-node-index x) n)
       (format t "~%")
       (format t "tms-node-index: ~S~%" (tms-node-index x))
       (format t "tms-node-datum: ~S~%" (tms-node-datum x))
       (format t "tms-node-status: ~S~%" (tms-node-status x))
       (format t "tms-node-support: ~S~%" (tms-node-support x))
       (format t "tms-node-justifications: ~S~%" (tms-node-justifications x))
       (format t "tms-node-consequences: ~S~%" (tms-node-consequences x))
       (format t "tms-node-mark: ~S~%" (tms-node-mark x))
       (format t "tms-node-contradictory?: ~S~%" (tms-node-contradictory? x))
       (format t "tms-node-not-root: ~S~%" (tms-node-not-root x))
       (return x)))) 

 (defun node-n (n)
   (let ((res nil))
     (dolist (x *node* res)
       (when (equal (tms-node-index x) n)
	 (setq res x)))))

  (defun p-justif-n (n)
    (dolist (x *just*)
      (when (equal (justification-index x) n)
	(format t "~%")
	(format t "justif-index: ~S~%" (justification-index x))
	(format t "justif-type: ~S~%" (justification-type x))
	(format t "justif-consequence: ~S~%" (justification-consequence x))
	(format t "justif-in-list: ~S~%" (justification-in-list x))
	(format t "justif-out-list: ~S~%" (justification-out-list x))
	(return x))))


(defun p-rule-n (n)
  (dolist (x *rule*)
    (when (equal (rule-counter x) n)
      (format t "~%")
      (format t "rule-tre-class ~S~%" (pprint (rule-tre-class x))))
      (format t "rule-matcher ~S~%" (pprint (rule-matcher x)))
      (format t "rule-body ~S~%" (pprint (rule-body x)))
     (return x)))


;;;===============================================================
;;;                       END OF FILE                             
;;;===============================================================
 
