				      ;-*- Mode:  LISP; Syntax: Common-lisp -*-

;;Simple Dynamic Constraint Satisfaction Problem example: (JTRE)
;;(adapted to car design)
;;
;;;SPECIFICATION:
;;
;; V= {engine, battery, air-cond, sunroof}
;; Vi= {engine, battery}
;;
;; D1={small, large}  -  D2={small, large} -  D3={included, no}  -  D4={included, no}
;;
;; Compatibility constraints Cc:
;;(Notice that a variable can be assigned a value only if it's active)
;;
;;  1- engine <- small => battery <- small
;;
;;  2- engine <- large => battery <- large
;;
;;  3- battery <- large and air-cond <- included => sunroof <- no
;;
;; Activity constraints Ca:
;;
;;  1- engine <- large => active:air-cond
;;
;;  2- air-cond <- no => active:sunroof
;;
;; Goal:
;;
;; Find all the assignments such that:
;;
;;   - Constraints in both Cc and Ca are satisfied
;;   - All the variables in Vi are active (<-> appear in the solution)
;;   - Each value assigned to a variable belongs to its associated domain.
;;
;;;;;;;;;

(in-package :gtre-example)

(import '(pail-lib::tre-example
	  gtre::rule
	  gtre::assert!
	  gtre::rassert!
	  gtre::retract!
	  gtre::rretract!
	  gtre::contradiction
	  ))

(let ((DCSP (make-instance 'tre-example
	      :rule-set '(	
			  (rule ((:in (active ?v) :var ?V1)
				 (:in (assign ?v ?val1) :var ?V2)
				 (:in (assign ?v ?val2) :var ?V3
				      :test (neq ?val1 ?val2)))
				(rassert! contradiction-found 
					  (just (:in ?V1) (:in ?V2) (:in ?V3))))

			  #| (rule ((:out (active ?v) :var ?V1)
				 (:in (assign ?v ?val) :var ?V2))
			   (rassert! contradiction-found
			    (just (:out ?V1) (:in ?V2)))) |#
	
			  (rule ((:in (active engine) :var ?V1)
				 (:in (assign engine small) :var ?V2)
				 (:in (active battery) :var ?V3))
			   (rassert! (assign battery small)
			    (just (:in ?V1) (:in ?V2) (:in ?V3))))

			  (rule ((:in (active engine) :var ?V1)
				 (:in (assign engine small) :var ?V2)
				 (:in (active battery) :var ?V3)
				 (:out (assign battery small) :var ?V4))
			   (rassert! contradiction-found
			    (just (:in ?V1) (:in ?V2) (:in ?V3) (:out ?V4))))
 
			  (rule ((:in (active engine) :var ?V1)
				 (:in (assign engine large) :var ?V2)
				 (:in (active battery) :var ?V3))
			   (rassert! (assign battery large)
			    (just (:in ?V1) (:in ?V2) (:in ?V3))))
			  
			  (rule ((:in (active engine) :var ?V1)
				 (:in (assign engine large) :var ?V2)
				 (:in (active battery) :var ?V3)
				 (:out (assign battery large) :var ?V4))
			   (rassert! contradiction-found
			    (just (:in ?V1) (:in ?V2) (:in ?V3) (:out ?V4))))

			  (rule ((:in (active battery) :var ?V1)
				 (:in (assign battery large) :var ?V2)
				 (:in (active air-cond) :var ?V3)
				 (:in (assign air-cond included) :var ?V4)
				 (:in (active sunroof) :var ?V5))
			   (rassert! (assign sunroof no)
			    (just (:in ?V1) (:in ?V2) (:in ?V3) (:in ?V4) (:in ?V5))))

			  (rule ((:in (active battery) :var ?V1)
				 (:in (assign battery large) :var ?V2)
				 (:in (active air-cond) :var ?V3)
				 (:in (assign air-cond included) :var ?V4)
				 (:in (active sunroof) :var ?V5)
				 (:out (assign sunroof no) :var ?V6))
			   (rassert! contradiction-found
			    (just (:in ?V1) (:in ?V2) (:in ?V3) (:in ?V4) (:in ?V5) 
			     (:out ?V6))))
			  
			  (rule ((:in (active engine) :var ?V1)
				 (:in (assign engine large) :var ?V2))
			   (rassert! (active air-cond)
			    (just (:in ?V1) (:in ?V2))))

			  (rule ((:in (active engine) :var ?V1)
				 (:in (assign engine large) :var ?V2)
				 (:out (active air-cond) :var ?V3))
			   (rassert! contradiction-found
			    (just (:in ?V1) (:in ?V2) (:out ?V3))))
			  
			  (rule ((:in (active air-cond) :var ?V1)
				 (:in (assign air-cond no) :var ?V2))
			   (rassert! (active sunroof)
			    (just (:in ?V1) (:in ?V2))))
			  
			  (rule ((:in (active air-cond) :var ?V1)
				 (:in (assign air-cond no) :var ?V2)
				 (:out (active sunroof) :var ?V3))
			   (rassert! contradiction-found
			    (just (:in ?V1) (:in ?V2) (:out ?V3))))

			  (rule ((:in (active ?v) :var ?V1)
				 (:in (assign ?v ?val) :var ?V2))
			   (rassert! (in-solution ?v ?val)
			    (just (:in ?V1) (:in ?V2))))

			  (rule ((:out (active ?v) :var ?V1)
				 (:in (in-solution ?v ?val) :var ?V2))
			   (rassert! contradiction-found
			    (just (:out ?V1) (:in ?V2))))
			  
			  (rule ((:in (in-solution engine ?val1) :var ?V1)
				 (:in (in-solution battery ?val2) :var ?V2)
				 (:out (active air-cond) :var ?V3)
				 (:out (active sunroof) :var ?V4))
			   (rassert! (solution engine ?val1 battery ?val2)
			    (just (:in ?V1) (:in ?V2) (:out ?V3) (:out ?V4))))
			  
			  (rule ((:in (in-solution engine ?val1) :var ?V1)
				 (:in (in-solution battery ?val2) :var ?V2)
				 (:in (in-solution air-cond ?val3) :var ?V3)
				 (:out (active sunroof) :var ?V4))
			   (rassert! (solution engine ?val1 battery ?val2 air-cond ?val3)
			    (just (:in ?V1) (:in ?V2) (:in ?V3) (:out ?V4))))
			  
			  (rule ((:in (in-solution engine ?val1) :var ?V1)
				 (:in (in-solution battery ?val2) :var ?V2)
				 (:in (in-solution air-cond ?val3) :var ?V3)
				 (:in (in-solution sunroof ?val4) :var ?V4))
			   (rassert! (solution engine ?val1 battery ?val2 
				      air-cond ?val3 sunroof ?val4)
			    (just (:in ?V1) (:in ?V2) (:in ?V3) (:in ?V4))))
			  )
	      :assertions '(
			    (assert! '(assign engine small))
			    (assert! '(assign engine large))
			    
			    (assert! '(assign battery small))
			    (assert! '(assign battery large))
			    
			    (assert! '(assign air-cond included))
			    (assert! '(assign air-cond no))
			    
			    (assert! '(assign sunroof included))
			    (assert! '(assign sunroof no))(rule ((:in (active ?v) :var ?V1)
				 (:out (assign ?v ?val1) :var ?V2)
				 (:out (assign ?v ?val2) :var ?V3
				  :test (neq ?val1 ?val2)))
			   (rassert! contradiction-found
			    (just (:in ?V1) (:out ?V2) (:out ?V3))))
			    
			    (assert! '(active engine) 'gtre::GOD)
			    (assert! '(active battery) 'gtre::GOD)

			    (assert! '(active air-cond))
			    (assert! '(active sunroof))
			    )

	      :contradiction '((contradiction 'contradiction-found))
)))

  (pail-lib::put-pool pail-lib:*pail-pool* DCSP :name "Car design2"))

(defun neq (x1 x2)
  (not (eq x1 x2)))