;;; -*- Mode: LISP; Package: GTRE; Syntax: Common-lisp;                 -*-
;;;
;;; **********************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH & EPFL
;;;
;;; **********************************************************************
;;;
;;; Filename:   jtms-dialog.cl
;;; Short Desc: dialog handling for JTMS
;;; Version:    1.1
;;; Status:     experimental
;;; Last Mod:   19.02.91 - Fatma Fekih-Ahmed
;;; Author:     Dean Allemang
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; -----------------------------------------------------------------------
;;; RCS $Log$
;;; -------------------------------------------------------


;;; =======================================================================
;;; PACKAGE DECLARATIONS
;;; =======================================================================


(in-package :gtre)
(import '(pail-lib::pool-button
	  pail-lib::pool-item
	  pail-lib::tms-tree
	  pail-lib::name-part
	  pail-lib::get-from-pool
	  pail-lib::ruledefs
	  pail-lib::asserts
	  pail-lib:jtms-browser
	  pail-lib::tre-example
	  ))


;;; =======================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; =======================================================================

(defvar *verbose-disp* nil)
(defvar *contra-handler-disp* nil)
(defvar *filename* nil)
(defvar *last-contra-browser* nil)

(defparameter *jtmspath* (add-subdir *pail-path* "jtms"))

(defun start-jtms-dialog (&optional (from-button nil))
  (setf *nmjtms-call* nil)
  (setf *verbose-disp* (make-instance 'scroll-display
				     :title "Verbose Comments"
				     :font (open-font-named "fixed")
				     :width 400
				     :height 300
				     :borders 1
				     :active nil
				     :left 600
				     :bottom 90))
  (if *debug-tms*
      (progn (activate-display *verbose-disp*)
	     (setf *debug-tms* *verbose-disp*))
    (deactivate-display *verbose-disp*))
       
  (let* ((*default-font* (pail-lib::findfont (width *root-window*) 1140 13))
	 (disp (make-instance 'display :title "JTMS: Main Window"
			      :width (round (width *root-window*) 2) 
			      :height (round (height *root-window*) 4)
			      :borders 1
			      :left (round (width *root-window*) 2)
			      :bottom (- (height *root-window*)
					 (round (height *root-window*) 4)
					 25)))
	 
	 (exit-button (make-instance 'push-button :label "Exit" :width (round (width disp) 8)))
	 (init-button (make-instance 'push-button :label "Init" :width (round (width disp) 8)))
	 (view-button (make-instance 'push-button :label "View" :width (round (width disp) 8)))
	 (help-button (make-instance 'help-button 
			:technical (add-path "jtms-doc.tec" *jtmspath*)
			:general (add-path "jtms-doc.gen"*jtmspath*)
			:subject "JTMS"
			:width (round (width disp) 8)))

	(verb-button (make-instance 'radio-button :label "Verbose Mode"
			     :status *debug-tms*
			     :action 
			     '(lambda ()
			       (if *debug-tms*
				   (progn
				     (setf *debug-tms* nil)
				     (deactivate-display *verbose-disp*))
				 (progn
				   (setf *debug-tms* *verbose-disp*)
				   (activate-display *verbose-disp*))))))

	(run-button (make-instance 'push-button :label "Run" :width (round (width disp) 8)))

	tms-button
	(menu-button-rules (make-instance 'pool-button
			     :name "Input:"
			     :pool pail::*pail-pool*
			     :value ""
			     :width (round (width disp) 3)
			     :target-class 'tre-example
			     :border t
			     ))

	(menu-button-tms (make-instance 'pool-button
			   :name "Output:"
			   :pool pail::*pail-pool*
			   :value ""
			   :width (round (width disp) 3)
			   :target-class 'tms-tree
			   :border t
			   :show-function
			   #'(lambda (item)
			       (declare (ignore item))
			       (let ((display-nodes (printable-node-list *node*)))
				 (if (null display-nodes)
				     (mp:process-wait
				      "There are no solutions"
				      #'(lambda ()
					  (eq 'Continue
					      (ack-dialog "There are no solutions"
							  :title "JTMS: Error"))))
				   (make-instance 'jtms-browser
				     :roots display-nodes))))))
	(file-button (make-instance 'pail-lib::file-button
			:w-directory *jtmspath*)))

    (let ((*default-push-button-size-p* nil))
      (setf tms-button (make-instance 'push-button :label "Show TMS")))
    (copy-mask *pail-logo* 0 0 disp
	       (- (width disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height disp) (cw:bitmap-height *pail-logo*) 15))

    (set-button file-button disp
		:left (- (width disp) (width file-button) 7)
		:bottom (- (height disp) (height file-button) (cw:bitmap-height *pail-logo*) 20))
    (setf (font disp) (cw:open-font :courier :italic 45 :weight :bold))
    (write-display disp
		   "JTMS"
		   15 (- (height disp) 15 (cw:font-ascent (font disp))))

    
    (setf (font disp) *default-font*)
    (set-button help-button disp :left (- (* 1 (round (width disp) 6))
					  (round (width help-button) 2)) :bottom 15)

    (set-button run-button disp 
		:left (- (* 2 (round (width disp) 6))
					  (round (width help-button) 2))
		:bottom 15
		:action `(lambda ()
			   (run-rules)
			   (setq *nmjtms-call* nil)
			   (setf (button-value ,menu-button-tms)
			     (make-instance 'pool-item
			       :start-object
			       t)
			     )
			   (reset-button ,run-button)
			   (documentation-print "JTMS Rules have been run.")
			   ))

    (set-button menu-button-rules disp 
		:left (- (width disp) (*  2  (width menu-button-rules)) 40)
		:bottom 85
		)

    (set-button menu-button-tms disp 
		:left (- (width disp) (*  2  (width menu-button-rules)) 40)
		:bottom 55
		)

    (set-button verb-button disp :left (round (width disp) 10)
		:bottom (+ (bottom menu-button-rules)
			   (height menu-button-rules)
			   20))

    (set-button exit-button disp 
		:left (- (* 5 (round (width disp) 6))
			 (round (width help-button) 2))
		:bottom 15
		:action `(lambda nil
			   (close-display *verbose-disp*)
			   (close-display ,disp)
			   (when *fdisp*
			     (close-display *fdisp*))
			   (if ,from-button (reset-button ,from-button))))
    
    (set-button init-button disp 
		:left (- (* 3 (round (width disp) 6))
					  (round (width help-button) 2))
		:bottom 15
		:action `(lambda nil
			   (gtre::tre-init)
			   (reset-button ,init-button)
			   (reset-button ,run-button)
			   (reset-button ,exit-button)
			   (reset-button ,menu-button-tms)
			   (setf (button-value ,menu-button-tms) 
			     (make-instance 'pool-item
			       :start-object (make-instance 'tms-tree)
			       :name-part "no name"
			       :from-button ,menu-button-tms))
			   (reset-button ,menu-button-rules)
			   (setf (button-value ,menu-button-rules)
			     (make-instance 'pool-item
			       :start-object (make-instance 'tms-tree)
			       :name-part "no name"
			       :from-button ,menu-button-rules))
			   (when *last-contra-browser*
			     (pail-lib::close-display *last-contra-browser*))
			   ))

    (set-button view-button disp
		:left (- (* 4 (round (width disp) 6))
					  (round (width help-button) 2))
		:bottom 15
		:action `(lambda () 
			   (choose-file)
			   (reset-button ,view-button)))))

(defmethod pail-lib::edit-object ((entry pool-item) (target tre-example))
  (display-error "Please use the View button to edit TMS files"))

(defun choose-file ()
  (setq *filename* 
    (choose-file-dialog)))

(defun make-multiple-menu (sets)
  (make-instance 'menu
    :items (let ((result nil))
	     (dolist (set sets result)
	       (push `(,(name-part set)
		       ,set)
		     result)))
    :query "Rule sets")
  )  

(defun dialog-handler (nr parent start-button cont-button exit-button)
  (let ((text-disp (make-instance 'display :title "Comments"
				 :font (open-font-named "fixed")
				 :parent parent
				 :width 300
				 :height 100
				 :borders 1
				 :left 400
				 :bottom 60))
	(rule-disp (make-instance 'display :title "Rules"
				 :font (open-font-named "fixed")
				 :width 480
				 :height 200
				 :borders 1
				 :left 10
				 :bottom 143))
	(table-disp (make-instance 'display :title "Examples"
				  :font (open-font-named "fixed")
				  :width 480
				  :height 200
				  :borders 1
				  :left 10
				  :bottom 375)))
    (labels ((clean-up ()
	       (close-display text-disp)
	       (close-display rule-disp)
	       (close-display table-disp)
	       (unless *quit*
		 (enable-button exit-button)
		 (reset-button cont-button)
		 (disable-button cont-button)
		 (reset-button start-button))))
      (defun wait ()
	(unless *quit*
	  (enable-button cont-button)
	  (reset-button cont-button)
	  (enable-button exit-button)
	  (format (window text-disp) "~&~%[Press <Continue> Button]")
	  (do () ((or *quit* *pause*)))
	  (if *quit* (clean-up)
	    (setf *pause* nil)))
	(not *quit*))
      (setf *pause* nil)
      (setf *quit* nil)
      (let ((fun-sym (find-symbol (format nil "dialog-~a" nr) :rules)))
	(if fun-sym
	    (funcall fun-sym text-disp rule-disp table-disp)
	  (format t "Demo not implemented")))
      (wait)
      (clean-up))))

(defun store-display (disp)
  (declare (ignore disp)))

;;; =======================================================================
;;; END OF FILE
;;; ======================================================================= 
