;;; -*- Mode: LISP; Package: common-lisp-user; Syntax: Common-lisp;      -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   id3-exm.cl
;;; Short Desc: Examples for wild explorations
;;; Version:    2.0
;;; Status:     Review
;;; Last Mod:   5.2.91 - TW
;;; Author:     Thomas Wehrle
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; Precondition: pail-make with *gin-p*=nil

#|

(use-package '(:id3 :pail-lib))

(setf *readable* t)
; (setf *readable* nil)

; Now starting wild explorations

;;; e1 the ordinary example
(setf e1 (make-table
	   :attributes '(profit      age         competition type)
	   :rows      '((down        old         no          software)
			(down        midlife     yes         software)
			(up          midlife     no          hardware)
			(down        old         no          hardware)
			(up          new         no          hardware)
			(up          new         no          software)
			(up          midlife     no          software)
			(up          new         yes         software)
			(down        midlife     yes         hardware)
			(down        old         yes         software))))


;;; e2 is e1 with a clash
(setf e2 (make-table
	   :attributes '(profit      age         competition type)
	   :rows      '((down        old         no          software)
			(down        midlife     yes         software)
			(up          midlife     no          hardware)
			(down        old         no          hardware)
			(up          new         no          hardware)
			(up          new         no          software)
			(up          midlife     no          software)
			(up          new         yes         software)
			(down        midlife     no          hardware)
			(down        old         yes         software))))


;;; e3 is an example where the target attribute values can be lists
(setf e3 (make-table
	   :attributes '(profit      age         competition type)
	   :rows      '((down        old         no          software)
			((up down)   midlife     yes         software)
			((up down)   midlife     no          software)
			(down        old         no          hardware)
			(up          new         no          hardware)
			(up          new         no          software)
			(up          new         yes         software)
			(down        old         yes         software))))

;;; e5 si an example with wildcards
(setf e5 (make-table
	   :attributes '(profit      age         competition type)
	   :rows      '((down        *           no          software)
			(down        midlife     yes         software)
			(up          midlife     no          hardware)
			(down        old         *           *)
			(up          new         no          hardware)
			(up          new         no          software)
			(up          midlife     no          software)
			(up          new         yes         software)
			(down        midlife     yes         hardware)
			(down        old         yes         software))))

;;; e6 is an example with numbers
(setf e6 (make-table
	   :attributes '(profit      age         competition type)
	   :rows      '((down        20          no          software)
			(down        8           yes         software)
			(up          5           no          hardware)
			(down        18          no          hardware)
			(up          1           no          hardware)
			(up          2           no          software)
			(up          6           no          software)
			(up          3           yes         software)
			(down        5           yes         hardware)
			(down        15          yes         software))))


(print e1)
(print e2)
(print e3)

(setf t1 (classify 'profit e1))
(setf t2 (classify 'profit e2))
(setf t3 (classify 'profit e3))

(print t1)
(print t2)
(print t3)

(let ((*verbose* t))
  (print (classify 'profit e1)))
(let ((*verbose* t))
  (print (classify 'profit e2)))

(print (revise t2))

(query t1)

(let ((*print-rules* t)) (print t1))
(let ((*print-rules* t)) (print t2))
(let ((*print-rules* t)) (print t3))

(let ((*print-rules* t)) (print (revise t1)))
(let ((*print-rules* t)) (print (revise t2)))

(let ((*accept-clashes* t))
  (print (classify 'profit e2)))


(print (sexpr-to-tree (tree-to-sexpr t1)))

(save-obj (tree-to-sexpr t1)  :filename "my-tree")
(save-obj (table-to-sexpr e1) :filename "my-table")
(print (sexpr-to-tree (load-obj :filename "my-tree")))
(print (sexpr-to-table (load-obj :filename "my-table")))

(print (expand-wildcards e5))

(setf e7 (substitute-values e6 'age value
			    (cond ((<= value 3) 'new)
				  ((<= value 10) 'midlife)
				  (t 'old))))
; or

(print (cut-value e6 'age 50))

(setf e7 (substitute-values e6 'age value
			    (cond 
			     ((<= value (cut-value e6 'age 33.333)) 'new)
			     ((<= value (cut-value e6 'age 66.666)) 'midlife)
			     (t 'old))))

(setf e7 (substitute-values e6 'age value 'anything))

(setf e7 (substitute-values e6 'age value
			    (* (truncate (/ value 10)) 10)))

; or


(setf e7 (substitute-values e6 'age 3))
(setf e7 (substitute-values e6 'age 5))

(print e6)
(print e7)
(print (classify 'profit e7))

(print (cumulated-values e6 'age))

--------------

(setf e1 (make-table
	   :attributes '(profit      age         competition type)
	   :rows      '((down        old         no          software)
			(down        midlife     yes         software)
			(up          midlife     no          hardware)
			(down        old         no          hardware)
			(up          new         no          hardware)
			(up          new         no          software)
			(up          midlife     no          software)
			(up          new         yes         software)
			(down        midlife     yes         software)
			(down        old         yes         software))))


(multiple-value-bind (clashes examples)
    (clash-p e1 'profit)
  (format t "~%Clashes: ~a  Unique Examples: ~a" clashes examples))
(multiple-value-bind (clashes examples)
    (clash-p e2 'profit)
  (format t "~%Clashes: ~a  Unique Examples: ~a" clashes examples))



(setf e1 (make-table
	  :attributes '(profit      age         competition type)
	  :rows      '((down        old         no          software)
		       (down        midlife     yes         software)
		       (up          midlife     no          hardware)
		       (down        old         no          hardware)
		       (up          new         no          hardware)
		       (up          new         no          software)
		       (up          midlife     no          software)
		       (up          new         yes         software)
		       (down        midlife     yes         hardware)
		       (down        old         yes         software))))


|#

;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
