;;; -*- Mode: LISP; Package: ID3; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   id3-ex1.cl
;;; Short Desc: 1st demo for id3
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   6.5.91 - TW
;;; Author:     Thomas Wehrle
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :id3)

(defun dialog-1 (text-disp table-disp rule-disp)
  (let ((exm (make-table
	      :attributes '(profit      age         competition type)
	      :rows      '((down        old         no          software)
			   (down        midlife     yes         software)
			   (up          midlife     no          hardware)
			   (down        old         no          hardware)
			   (up          new         no          hardware)
			   (up          new         no          software)
			   (up          midlife     no          software)
			   (up          new         yes         software)
			   (down        midlife     yes         hardware)
			   (down        old         yes         software))))
	(attribute 'profit)
	(*readable* t)
	(dtree nil)
	(*default-font* (findfont (width *root-window*) 1140 13)))
    (table-edit exm :font *default-font* :left 10 :bottom (+ 5 (round (height *root-window*) 2))
		:title "ID3:examples")
    (format-display-fill text-disp "In the <Examples> window you can see
                 a table of values describing several
                 companies.")
    (when (wait)
      (format-display-fill text-disp (format nil "Now trying to find rules in data.
              Target attribute for classifying is
              ~a ..." attribute))
      (setf dtree (classify attribute exm))
      (if (and (not *accept-clashes*)
	       (plusp (clash-p exm attribute)))
	  (format-display-fill text-disp "Generated a decision tree.
                     (see <Decision tree> window)
                     There were clashes!")
	(progn
	  (format-display text-disp "~%Generated a decision tree.")
	  (format-display text-disp "~& (see <Decision tree> window)")))
      (setf browse (make-instance 'browser
		     :starting-tree dtree
		     :title "ID3:Decision tree"
		     :left (round (width *root-window*) 2)
		     :bottom 0
		     :font *default-font*))
      (setf (left browse) (- (width *root-window*) (width browse) 5))
      (when (wait)
	(format-display-fill  text-disp "Rules can be derived from this
                 decision tree.  You can see these
                 rules in the <Rules> window.  The
                 descision tree organizes the gained
                 knowledge so that it is optimal for a
                 query.")
	
	(format-display rule-disp "~a"
			(change-type dtree
				     (clos:class-prototype (find-class 'rule-set))))
	(when (wait)
	  (loop
	    (unless (equal :yes (y-or-n-dialog "Query decision tree ?"
					       :title "ID3:Query ?"
					       :cancel-button nil)) (return))
	    (funcall (function query2) text-disp dtree))
	  (when (wait) (format-display text-disp "~%End of demo."))))
      (close-display (display browse)))
    (close-table-edit exm)))


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
