;;; -*- Mode: LISP; Package: common-lisp-user; Syntax: Common-lisp;      -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   id3-demo.cl
;;; Short Desc: demos
;;; Version:    2.0
;;; Status:     Review
;;; Last Mod:   5.2.91 - TW
;;; Author:     Thomas Wehrle
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;;
;;; Just type in: (id3-exm1 [:*verbose* STREAM] [:*accept-clashes* BOOLEAN])
;;;               (id3-exm2 [:*verbose* STREAM] [:*accept-clashes* BOOLEAN])
;;;               (id3-exm3 [:*verbose* STREAM] [:*accept-clashes* BOOLEAN])
;;;


(in-package :common-lisp-user)
(use-package '(:id3 :pail-lib))


(defmethod demo (attribute (data table) &key (*verbose* nil)
					     (*accept-clashes* nil))
  (let ((tree nil))
    (format t "~%********************************************************")
    (when (yes-or-no-p "~%~%Do you want to see the examples (yes/no) ? ")
      (let ((*readable* t)) (print data)))
    (format t "~%~%Classify ...")
    (setf tree (classify attribute data))
    (when (and (not *accept-clashes*)
	       (clash-p data attribute)
	       (yes-or-no-p "~%~%There were clashes!~
                               ~%Do you want to remove bad subtrees (yes/no) ? "))
      (setf tree (revise tree)))
    (when (yes-or-no-p "~%~%Do you want to see the resulting decision tree (yes/no) ? ")
      (let ((*readable* t)) (print tree)))
    (when (yes-or-no-p "~%~%Do you want to see the result as rules (yes/no) ? ")
      (let ((*print-rules* t))
	(print tree)))
    (do nil
	((not (yes-or-no-p "~%~%Query decision tree (yes/no) ? ")))
      (apply (function query) 
	     (list tree)))
    (format t  "~%********************************************************~%")))


(defun id3-exm1 (&key (*verbose* nil)
		  (*accept-clashes* nil))
  (let ((examples (make-table
		    :attributes '(profit      age         competition type)
		    :rows      '((down        old         no          software)
                                 (down        midlife     yes         software)
                                 (up          midlife     no          hardware)
                                 (down        old         no          hardware)
                                 (up          new         no          hardware)
                                 (up          new         no          software)
                                 (up          midlife     no          software)
                                 (up          new         yes         software)
                                 (down        midlife     yes         hardware)
                                 (down        old         yes         software)))))
    (demo 'profit examples 
	  :*verbose* *verbose* 
	  :*accept-clashes* *accept-clashes*)))


(defun id3-exm2 (&key (*verbose* nil)
		  (*accept-clashes* nil))
  (let ((examples (make-table
		    :attributes '(profit      age         competition type)
		    :rows      '((down        old         no          software)
                                 (down        midlife     yes         software)
                                 (up          midlife     no          hardware)
                                 (down        old         no          hardware)
                                 (up          new         no          hardware)
                                 (up          new         no          software)
                                 (up          midlife     no          software)
                                 (up          new         yes         software)
                                 (down        midlife     no          hardware)
                                 (down        old         yes         software)))))
    (demo 'profit examples 
	  :*verbose* *verbose* 
	  :*accept-clashes* *accept-clashes*)))


(defun id3-exm3 (&key (*verbose* nil)
		  (*accept-clashes* nil))
  (let ((examples (make-table
		    :attributes '(height hair   eyes   mytype?)
		    :rows      '((short  blond  blue   yes)
                                 (tall   blond  brown  no)
                                 (tall   red    blue   yes)
                                 (short  dark   blue   no)
                                 (tall   dark   blue   no)
                                 (tall   blond  blue   yes)
                                 (tall   dark   brown  no)
                                 (short  blond  brown  no)))))
    (demo 'mytype? examples
	  :*verbose* *verbose* 
	  :*accept-clashes* *accept-clashes*)))


#|

;;; ordinary example
(id3-exm1)
(id3-exm1 :*verbose* t)

;;; same example but with a clash
(id3-exm2)
(id3-exm2 :*verbose* t)
(id3-exm2 :*accept-clashes* t)

;;; second ordinary example
(id3-exm3)

|#

;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
