;;;
;;; ******************************
;;; *  PORTABLE AI LAB - UNI ZH  *
;;; ******************************
;;;
;;; Filename:   hopfield-main.cl
;;; Short Desc: Opening Window
;;; Version:    0.1
;;; Status:     Experimental
;;; Last Mod:   Apr 22 1992
;;; Author:     Erik Vinkhuyzen

;;; ==========================================================================
;;; DESCRIPTION
;;; ==========================================================================

(defclass hopfield-main (display)
	  ((exit-button :initform (make-instance 'push-button 
				    :label "Exit")
			:accessor exit-button)
	   (help-button :initform (make-instance 'help-button
				    :technical (add-path "hopfield-desc.tec" *hoppath*)
				    :general (add-path "hopfield-desc.gen" *hoppath*)
				    :subject "")
			:accessor help-button)
	   (tool-button :initform (make-instance 'push-button 
				    :label "Tool")
			:accessor tool-button)
	   (demo-button     :accessor demo-button
			    :initform (make-instance 'demo-button :label "Demo"))
	   (hopfield-network
	                :initform nil
	                :accessor hopfield-network)))


(defmethod initialize-instance :after ((hm hopfield-main) &key)
  (copy-mask *pail-logo* 0 0 hm
	       (- (width hm) (cw:bitmap-width *pail-logo*) 10)
	       (- (height hm) (cw:bitmap-height *pail-logo*) 10))
  (set-button (exit-button hm) hm
	      :left (- (width hm) (width (exit-button hm)) 10)
	      :bottom 10
	      :action `(lambda nil
			 (when (hopfield-network ,hm)
			     (exit (hopfield-network ,hm)))
			 (close-display ,hm)
			 (if ,*from-button* (reset-button ,*from-button*))))
  (set-button (tool-button hm) hm
	      :left (/ (- (width hm) (width (tool-button hm))) 2)
	      :bottom 10
	      :action `(lambda nil
			 (setf (hopfield-network ,hm) 
			   (make-instance 'hopfield-network
			     :size 16))
			 (reset-button (tool-button ,hm))
			 (enable-button (demo-button ,hm))
			 ))
  (set-button (demo-button hm) hm
	      :left (/ (- (width hm) (width (tool-button hm))) 2)
	      :bottom 50
	      :action `(lambda ()
			 (when (not (hopfield-network ,hm))
			   (software-push (tool-button ,hm)))
			 (case  (accept-items ,(menu (demo-button hm)))
			   ((demo1) (demo1 (make-instance 'demo-manager
					     :hopfield-network (hopfield-network ,hm))))
			   ((demo2) (demo2 (make-instance 'demo-manager
					     :hopfield-network (hopfield-network ,hm))))
			   ((demo3) (demo3 (make-instance 'demo-manager
					     :hopfield-network (hopfield-network ,hm))))
			   ((demo4) (demo4 (make-instance 'demo-manager
					     :hopfield-network (hopfield-network ,hm)))))
			 (reset-button ,(demo-button hm))))
  (set-button (help-button hm) hm
	      :left 10
	      :bottom 10)
  (setf (font hm) (cw:open-font :courier :italic 16 :weight :bold))
  (write-display hm
		   "Welcome to ..."
		   15 (- (height hm) 10 (cw:font-ascent (font hm))))
  (setf (font hm) (cw:open-font :courier :italic 20 :weight :bold))
  (write-display hm
		 "Hopfield Network"
		   15
		   (- (height hm) 35 (cw:font-ascent (font hm)))))

