;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:HOPFIELD; Base:10; -*-
;;;
;;; ******************************
;;; *  PORTABLE AI LAB - UNI ZH  *
;;; ******************************
;;;
;;; Filename:   hopfield-data.cl
;;; Short Desc: hopfield-data
;;; Version:    0.1
;;; Status:     Experimental
;;; Last Mod:   Apr 24 1992
;;; Author:     Erik Vinkhuyzen

;;; ==========================================================================
;;; DESCRIPTION
;;; ==========================================================================


(setf gin::*use-new-version* t)



(use-package :pail :pail-lib)

(defclass pail::hopfield-data ()
	  ((activations :initarg :activations
			:accessor activations
			:type array)))


 
  

(defmethod pail-lib::change-type ((hd1 pail::hopfield-data) (hd2 pail::hopfield-data))
  hd1)

 

(defclass hopfield-patterns ()
	  ((patterns :accessor patterns
		     :initarg :patterns
		     :initform nil
		     :type list)
	   (current  :accessor current
		     :initarg :current
		     :initform 0
		     :type integer)
	   (hopfield-network 
	             :accessor hopfield-network
		     :initarg :hopfield-network
		     :type hopfield-network)
	   (editor-window 
	             :accessor editor-window
		     :initarg :editor-window
		     :type editor-window)		     
	   (size     :accessor size
		     :initarg :size
		     :initform 0
		     :type integer)))

(defmethod pail-lib::change-type ((hp1 hopfield-patterns) (hp2 hopfield-patterns))
  hp1)


(defmethod pail-lib::change-type ((np pail-lib::training-data-class) (hp hopfield-patterns))
  (let ((nsq (expt (ceiling (sqrt (+ (length (attributes (input-patterns np)))
				     (length (attributes (target-patterns np)))))) 2))
	(counter 0))
    (setf (patterns hp) 
	  (loop for rowi in (rows (input-patterns np))
		as rowo in (rows (target-patterns np))
		do (setf counter (1+ counter))
		collect (pad (append rowi rowo) nsq)))
    (setf (size hp) counter)
    hp))


(defun pad (list length)
  (let* ((l (length list))
	(a (loop for i from length downto (1+ l)
	    collect -1))
;; Hopfield Networks require activations to be -1, not 0!!
	(b (loop for j in list
	     if (zerop j)
	     collect -1
	     else collect j)))
  (make-array length :initial-contents (append b a))))



(defmethod pail-lib::clos-copy ((item hopfield-patterns))
  (prog (ans (hopfield-network nil) (editor-window nil))
    (if (slot-boundp item 'hopfield-network)
	(setf hopfield-network (hopfield-network item)))
    (if (slot-boundp item 'editor-window)
	(setf editor-window (editor-window item)))
    (setf (hopfield-network item) nil)
    (setf (editor-window item) nil)
    (setf ans (eval (database::get-fasd-form item :reset t)))
    (setf (hopfield-network item) hopfield-network)
    (setf (editor-window item) editor-window)
    (return ans)))

  
(defmethod pail-lib::dump-editable ((item hopfield-patterns)   )
  (let ((dim (1- (round (sqrt (length (car (patterns item))))))))
    (concatenate 'string
			(format nil "~%")
			(format nil "(" )
			(format nil "~%")
			(format nil "    (SIZE   ~a)" (size item))
			(format nil "~%")
			(format nil "    (PATTERNS ")
			(let ((s (format nil "~%")))
			  (loop for pat in (patterns item) do
				(progn
				  (setf s (format nil "~a(~%" s))
				  (loop for row from 0 to dim do
					(progn
					  (loop for col from 0 to dim do
						(setf s (format nil "~a ~2d"
								s
								(aref pat (+ (* row (1+ dim)) col))))
					    )
					  (setf s (format nil "~a~%" s)))
				    )
				  (setf s (format nil "~a)~%" s))))
			  s)
			(format nil ")~%")
			(format nil "    )" ))))


(defmethod pail-lib::read-instance ((hp hopfield-patterns) desc name)
  (let ((size (cadar desc))
	(dim (length (cadr (cadr desc)))))
    (setf (size hp) size)
    (setf (patterns hp)
      (loop for pattern in (cdr (cadr desc)) collect
	  (make-array dim :initial-contents pattern))
      )
    hp))

(export '(hopfield-patterns))
(import '(hopfield-patterns) :pail-lib)

(defmethod (setf current) :after (current (hp hopfield-patterns))
  (let ((size (size (hopfield-network hp))))
    (adjust-array (activations (editor-window hp)) size
		  :initial-contents
		  (loop for i from 0 to (- size 1)
		      collect (aref (first (nthcdr (- current 1) (patterns hp))) i)))
    (update-display (editor-window hp))))


(defmethod add-pattern (pat (hp hopfield-patterns))
  (setf (size hp) (+ (size hp) 1))
  (setf (patterns hp) (append (patterns hp)
			      (list (make-array (size (hopfield-network hp))
					:initial-contents
					(loop for i from 0 to (- (size (hopfield-network hp)) 1)
					    collect (aref pat i))))))
  (setf (slot-value hp 'current) (size hp))
  (if *debug* (format t "The appended pattern is: ~a~%" (patterns hp))))
  


#|(defmethod learn-all-patterns ((hp hopfield-patterns))
  (let ((size (floor (sqrt (size (hopfield-network hp))))))
    (hopfield-learn-more-patterns (make-one-dimensional-list-from-two-dimensional-array (patterns hp) size) 
				  (hopfield-network hp))))|#

#|(defmethod learn-current-pattern ((hp hopfield-patterns))
  (hopfield-learn (aref (patterns hp) (current hp)) (hopfield-network hp)))|#


  

(defmethod next-pattern ((hp hopfield-patterns))
  ; If the current is the last pattern it becomes 1
  ; otherwise it beomes the next
  (when (<= 0 (size hp))
      (if (<= (size hp) (current hp))
	  (progn (setf (current hp) 1)
		 (if *debug* (format t "Set the current to 1~%")))
	(progn (setf (current hp) (+ (current hp) 1))
	       (if *debug* (format t "Set the current to ~a~%" (current hp)))))))
	 
  
(defmethod delete-pattern ((hp hopfield-patterns))
  (let ((size (size (hopfield-network hp))))
    (cond  ((< 1 (size hp))
	    (setf (patterns hp) (loop for i from 1 to (length (patterns hp))
				    for j in (patterns hp)
				    unless (= i (current hp))
				    collect j))
	    (setf (size hp) (- (size hp) 1))
	    (if *debug* (format t "set the size of the hopfield-patterns to ~a~%" (size hp)))
	    (next-pattern hp))
	   (t
	    (setf (patterns hp) ())
	    (setf (size hp) 0)
	    (adjust-array (activations (editor-window hp)) size
			  :initial-contents 
			  (loop for i from 0 to (- size 1)
			    collect -1))
	    (update-display (editor-window hp))
	    (disable-button (next-button (parent (editor-window hp))))
	    (disable-button (learn-all-button (parent (editor-window hp))))
	    (disable-button (delete-button (parent (editor-window hp))))))))


(defmethod reset ((hp hopfield-patterns))
  (setf (patterns hp) ())
  (setf (size hp) 0)
  (setf (slot-value hp `current) 0))


;;;================================================================================================
;;; TEST-GROUND
;;;================================================================================================
