;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:PAIL-LIB; Base:10; -*-
;;; ***********************************************************************
;;;                       EXPLANATION BASED LEARNING BROWSER
;;; ***********************************************************************
;;;
;;; Filename:   contra-specif.cl
;;; Short Desc: Specification for contradiction-handling browsers
;;; Version:    0.1
;;; Status:     Experimental
;;; Last Mod:   05.02.92 Fatma FEKIH-AHMED
;;; Author:     Fatma FEKIH-AHMED
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; -------------------------------------------------------
;;; RCS $Log$
;;; -------------------------------------------------------

 

(in-package :pail-lib)

(eval-when (load compile eval)
  (export '(contradiction-resolved-p
	    jtms-contradiction-browser
	    nmjtms-contradiction-browser)))

(defclass contradiction-browser (tms-browser)
	  ((title :initform "Contradiction found")
	   (resolved-p
	    :initform nil
	    :accessor contradiction-resolved-p)
	   (help-window :initarg :help-window ; Only one help window per browser
			:initform nil
			:accessor help-window
			:type help-stream
			:documentation "attached help window for this browser")))

(defclass jtms-contradiction-browser (contradiction-browser jtms-browser)
	  ())

(defclass nmjtms-contradiction-browser (contradiction-browser nmjtms-browser)
	  ())

;;; =======================================================
;;; END OF FILE
;;; =======================================================
