;;; -*- Mode: LISP; Package: GTRE-EXAMPLE; Syntax: Common-lisp; -*-
;;;
;;; *******************************************************
;;;
;;; PORTABLE AI LAB - EPFL
;;;
;;; *******************************************************
;;;
;;; Filename:   contra-browser.cl
;;; Short Desc: Implements an interactive graphical 
;;;             contradiction handler.
;;; Version:    1.0
;;; Status:     experimental
;;; Last Mod:   05.02.91 - Fatma FEKIH-AHMED
;;; Authors:    Simon LEINEN & Fatma FEKIH-AHMED
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; -------------------------------------------------------
;;; RCS $Log$
;;; -------------------------------------------------------


;;; =======================================================
;;; PACKAGE DECLARATIONS
;;; =======================================================
 
(in-package :pail-lib)

(defmethod retract-node ((item tree) (b contradiction-browser))
  (let* ((node (content item)) (just (gtre::tms-node-support node)))
    (cond ((gtre::in-node? node)
	   (cond ((and (gtre::assumption-node? node) (equal 'gtre::USER just))
		  (gtre::retract-assumption node)
		  (recompute-labels b)
		  (close-display b)
		  (setq gtre::*contra-assumptions* nil)
		  (setf (contradiction-resolved-p b) t))
		 (t (documentation-print  "THIS NODE IS NOT AN  ASSUMPTION"))))
	   (t (documentation-print  "THIS NODE IS NOT IN.")))))

(defmethod assert-node ((item tree) (b contradiction-browser))
  (let* ((node (content item)) (supp (gtre::tms-node-support node))
	 (justifs (gtre::tms-node-justifications node)))
    (cond ((gtre::out-node? node)
	   (cond ((and (null supp) (null justifs))
		  (gtre::install-support node 'gtre::USER)
		  (recompute-labels b)
		  (close-display b)
		  (setq gtre::*contra-assumptions* nil)
		  (setf (contradiction-resolved-p b) t))
		 (t (documentation-print  "THIS NODE IS NOT AN  ASSUMPTION"))))
	  (t (documentation-print  "THIS NODE IS NOT OUT.")))))

(defmethod help-window ((b contradiction-browser))
  (setf (help-window b) (make-instance 'help-display
			 :width 520
			 :button-region t
			 :title "TMS browser help")))

(defmethod help ((item tms-tree) (b contradiction-browser))
  (setf (filename (help-window b)) (add-path "contra-browser.asc" pail::*gtrepath*)))

(defmethod help ((item just-tree) (b contradiction-browser))
  (setf (filename (help-window b)) (add-path "contra-browser.asc" pail::*gtrepath*)))

(defmethod make-help-window ((item tms-tree) (b contradiction-browser))
  (gin::expose 
   (if (or (not (help-window item)) (not (status (help-window item))))
       (setf (help-window item)
	 (make-instance  'help-display :width 520 
		       :left 20 

		       :button-region t 
		       :title (format nil "Contradiction Browser Documentation") 
		       :filename (add-path "contra-browser.asc" pail::*gtrepath*)))
     (help-window item))))

(defmethod make-help-window ((item just-tree) (b contradiction-browser))
  (gin::expose 
   (if (or (not (help-window item)) (not (status (help-window item))))
       (setf (help-window item)
	 (make-instance 'help-display :width 520 
		       :left 20 
		       :button-region t 
		       :title (format nil "Contradiction browser Documentation") 
		       :filename (add-path "contra-browser.asc" pail::*gtrepath*)))
     (help-window item))))

(defmethod initialize-instance :after ((b contradiction-browser) &rest ignore)
  (declare (ignore ignore))
  (setq gtre::*last-contra-browser* b)
  (with-slots (left-menu)
     b
       (setf left-menu
	 (make-instance
	     'menu
	   :items
	   `( 
	     ("Assert this node" assert-node "Asserts this node.")
	     ("Help" make-help-window "Documentation about the contradiction browser")
	     ("Inspect" inspect-tree
			"Calls the inspector on the selected item.")
	     ("Put pool" pool-enter "Puts this explanation into the pool.")
	     ("Recompute" recompute-me "Recomputes the browser")
	     ("Recompute labels" recompute-labels-me
				"Recomputes browser labels.")
	     ("Retract this node" retract-node "Retracts this node")
	     ("Show database" show-database "Prints the content of the database in Verbose mode")
	     )))))
;;; =======================================================
;;; END OF FILE
;;; =======================================================
