;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:GA; Base:10; -*-
;;;
;;; ******************************
;;; *  PORTABLE AI LAB - UNI ZH  *
;;; ******************************
;;;
;;; Filename:   ga-dialog.cl
;;; Short Desc: dialog handling for the Genetic Algorithm
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   Jan. 1991
;;; Author:     Nick Almassy
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;; --------------------------------------------------------------------------
;;; Files required: ga-dialog	(this-file)
;;;		    ga.cl	(the genetic algorithm)
;;;		    acl-gin	(the window-functions)
;;; Change History: 
;;; --------------------------------------------------------------------------

;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :ga)
(use-package :cwex)

;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================

(defvar *main-display*	nil)
(defvar *analyze-display*	nil)
(defvar *schemata-display*	nil)
(defvar *t-display*	nil)
(defvar *monitor-disp*	nil)
(defvar *window-list*	nil)
(defvar *button-list*	nil)
(defvar *param-display*	nil)
(defvar *start-button*	nil)
(defvar *stop-button*	nil)
(defvar *defined-f*	nil)
(defvar *new-f*		nil)
(defvar *parameter-done* nil)
(defvar *analyze-button* nil)
(defvar *perf-disp*	nil)
(defvar *gs-button*	nil)
(defvar *verbose-mode*  nil)
(defvar *monitor-button*  nil)
(defvar *start-button-label* " Start ")

;;; ==========================================================================
;;; DIALOG
;;; ==========================================================================
 
;;; (setf *default-font* (open-font :times :roman 30 :weight :bold))
;;; (setf *normal-font*  (open-font :times :roman 30))
;;; Just in case If you forgot your glasses

(defun start-ga-dialog (from-button)
  
  
  (let* ((*default-push-button-size-p* t)
	 (*default-push-button-width* (round (* 120 (width *root-window*)) 1140))
	 (*default-font* (findfont (width *root-window*) 1140 13))
	 (exit-button	 (make-instance 'push-button :label "Exit"))
	 (help-button	 (make-instance 'help-button
			   :subject "GA"
			   :technical (add-path "ga-main-help.tec" *ga-path*)
			   :general (add-path "ga-main-help.gen" *ga-path*)
			   :width (width exit-button)))
	 (param-button	 (make-instance 'push-button :label "Parameter"  )))
    (setf *start-button* (make-instance 'push-button :label *start-button-label*))
    (setf *stop-button*	 (make-instance 'push-button :label "Stop"))
    (setf *monitor-button* (make-instance 'push-button :label "Monitor"  ))
    (setf *main-display* (make-instance 'display
			   :title "GA:Main Window"
			   :left (- (width *root-window*) (+ 11 (* 3 *default-push-button-width*)) 10)
			   :bottom (- (height *root-window*)
				      (max 115 (+ (height *pail-logo*)
					       (* 2 (height exit-button))
					       15))
				      15)
			   :width (+ 11 (* 3 *default-push-button-width*))
			   :height (max 115 (+ (height *pail-logo*)
					       (* 2 (height exit-button))
					       15))))
    (setf *window-list* (list *main-display*))
    (write-display *main-display*
		   "Welcome to ..."
		   10 (- (height *main-display*) 10 (cw:font-ascent (font *main-display*)))
		   :font (cw:open-font :courier :italic 18 :weight :bold))
    (write-display *main-display*
		   "Genetic Algorithms"
		   40
		   (- (height *main-display*) 35 (cw:font-ascent (font *main-display*)))
		   :font (cw:open-font :courier :italic 18 :weight :bold))
    

    (copy-mask *pail-logo* 0 0 *main-display* (- (width *main-display*) 5 (width *pail-logo*)) (- (height *main-display*) 5 (height *pail-logo*)))
    (set-button help-button *main-display* :left 5 :bottom 5)
    (set-button *monitor-button* *main-display* :left (+ 5 (width help-button)) :bottom 5
		:active *fitness-function*
		:action `(lambda nil (open-monitor ,*monitor-button*)))
    (set-button exit-button *main-display* :left (+ 5 (width help-button) (width *monitor-button*)) :bottom 5
		:action `(lambda ()
			 ;;;  evolving is going on then ask for confirmation and break if T else 
			   (block check-exit
			     (let ((ga-process (find *start-button-label* mp:*all-processes* :test #'equal :key #'mp:process-name)))
			       (if ga-process
				   (if (equal (y-or-n-dialog (format nil "If you terminate now you will break the GA~
									~&and loose all your data~
									~&~
								        ~&Are you sure that you want to do that?")
							     :left 740 :bottom 651) :yes)
				       (mp:process-kill ga-process)
				     (progn (reset-button ,exit-button)
					    (return-from check-exit))))
			       (close-display *window-list*)
			       (reset-button ,from-button)))))
    (set-button param-button *main-display* :left (+ 5 (width *start-button*) (width *stop-button*)) :bottom (+ 5 (height exit-button))
		:action `(lambda () (get-parameter-settings ,param-button)))
    (setf *button-list* (list param-button)) ;;; these buttons will be disabled during evolving.
  
    (set-button *stop-button* *main-display* :left (+ 5 (width *start-button*)) :bottom (+ 5 (height *monitor-button*))
		:action `(lambda ()
			   (setf *proceed* nil)
			   (display-message "Interrupt-request sent to GA.")
			   (reset-button *start-button*)
			   (reset-button *stop-button*))
		:active nil)
    (set-button *start-button* *main-display* :left 5 :bottom (+ 5 (height help-button))
		:active *fitness-function*
		:action `(lambda ()
			   (setf *proceed* t)
			   (enable-button *stop-button*)
			   (start-evolving (list ,*analyze-button* ,*start-button*))))
    (unless *fitness-function*
      (documentation-print (format nil "Welcome to the GA-tool~%~%First you have to select a fitness-function...~%to do so open up the Parameter Window")))
    *main-display*))

;;; ==========================================================================
;;; Setup of the Fitness function to be used.
;;; ==========================================================================

(defun get-parameter-settings (called-by-button)
  (clear-display *prompt-window*)
  (let* ((*default-push-button-size-p* t)
	 (*default-push-button-width* (round (* 120 (width *root-window*)) 1140))
	 (*default-font* (findfont (width *root-window*) 1140 13))
	 (ps-button (make-instance 'value-button :name "Population size:"       :numeric t :value *population-size*))
	 (mp-button (make-instance 'value-button :name "Mutation probability:"  :numeric t :value *mutation-probability*))
	 (cp-button (make-instance 'value-button :name "Crossover probability:" :numeric t :value *crossover-probability*))
	 (scale-button	 (make-instance 'radio-button :label "Scale Fitness"	 :status *scale-fitness-p*))
	 (mutation-button (make-instance 'radio-button :label "Allow Mutations"	 :status *mutations-p*))
	 (normal-button   (make-instance 'radio-button :label "Normalize Fitness" :status *normalize-fitness-p*))
	 (verbose-button	 (make-instance 'radio-button :label "Verbose mode"	 :status *verbose-mode*))
	 (new-button	 (make-instance 'push-button  :label "Reset"))
	 (p-help		 (make-instance 'push-button  :label "Help"))
	 window-height
	 (vb-height (height ps-button))
	 (rb-height (max (height normal-button) (font-character-height *default-font*))))
    (setf *gs-button*	 (make-instance 'value-button :name "Number of Generations:" :numeric t :value *generations-to-evolve*))
    (setf *parameter-done* (make-instance 'push-button :label "Exit"))
    (setf *new-f* (make-instance 'push-button :label "New Function"))
    (setf *defined-f* (make-instance 'select-button :label "Defined functions" :exclusive t
				     :width (- (min 371 (+ (font-string-width *default-font* (name *gs-button*)) (width ps-button) 10))
					       (width *new-f*)
					       30)
				     :height 90
				     :action `(lambda ()
						(change-ff (item-label) (list *start-button* *monitor-button* *new-f* *defined-f* *parameter-done*)))
				     :items (mapcar #'write-to-string (mapcar #'intern (mapcar #'fitness-function *known-functions*)))))
    (setf window-height (+ (* 5 vb-height) (* 4 rb-height)
			   (height *defined-f*) (font-character-height *default-font*) ;; fuer select-button
			   75))
    (setf *param-display* (make-instance 'display :title "GA:Parameter"
					 :left (- (width *root-window*) (+ 11 (* 3 *default-push-button-width*)) 10)
					 :bottom (- (bottom *main-display*) window-height 20)
					 :width (min 371 (+ (font-string-width *default-font* (name *gs-button*)) (width ps-button) 10))
					 :height window-height))
    
    (setf *window-list* (cons *param-display* *window-list*))
    (setf *button-list* (append `(,*new-f* ,*defined-f* ,new-button ,normal-button) *button-list*))

    (set-button cp-button *param-display*   :left (- (width *param-display*) (width cp-button) 5) :bottom (- window-height vb-height 5)	  :action `(lambda nil (setf *crossover-probability* (button-value ,cp-button))))
    (set-button mp-button *param-display*   :left (left cp-button) :bottom (- window-height (* 2 vb-height) 5) :action `(lambda nil (setf *mutation-probability* (button-value ,mp-button))))
    (set-button ps-button *param-display*   :left (left cp-button) :bottom (- window-height (* 3 vb-height) 5) :action `(lambda nil (setf *population-size* (button-value ,ps-button))))
    (set-button *gs-button* *param-display* :left (left cp-button) :bottom (- window-height (* 4 vb-height) 5) :action `(lambda nil (setf *generations-to-evolve* (button-value *gs-button*))))

    
    (set-button normal-button *param-display*	:left 10 :bottom (- window-height (* 4 vb-height) 14 rb-height) :action `(lambda () (setf *normalize-fitness-p* (status ,normal-button))))
    (set-button scale-button *param-display*	:left 10 :bottom (- (bottom normal-button) (+ 10 rb-height)) :action `(lambda () (setf *scale-fitness-p* (status ,scale-button))))
    (set-button mutation-button *param-display* :left 10 :bottom (- (bottom scale-button) (+ 10 rb-height)) :action `(lambda ()
														       (setf *mutations-p* (status ,mutation-button))
														       (setf *mutation-events* 0)))
    (set-button verbose-button *param-display* :left 10 :bottom (- (bottom mutation-button) (+ 10 rb-height)) :action `(lambda ()
															 (setf *verbose-mode* (status ,verbose-button))
															 (if *t-display*
															     (if *verbose-mode*
																 (activate-display *t-display*)
															       (deactivate-display *t-display*)))))
    (set-button new-button *param-display* :left (- (width *param-display*) (width new-button) 5) :bottom (bottom verbose-button)
		:action `(lambda ()
			   (if (or (not *current-generation*)
				   (equal (y-or-n-dialog (format nil "This Button initializes the~%current Generation randomly~%Dou you really want to do that?")
							 :left 835 :bottom 440 :title "Warning")
					  :yes))
			       (setf *current-generation* nil))
			   (reset-button ,new-button)))
    (draw-line *param-display* 0 (- window-height (* 4 vb-height) 10) (width *param-display*) (- window-height (* 4 vb-height) 10))
    (draw-line *param-display* 0 (- (bottom verbose-button) 5) (width *param-display*) (- (bottom verbose-button) 5))
    (draw-line *param-display* 0 (+ vb-height 10) (width *param-display*) (+ vb-height 10))
    (set-button *defined-f* *param-display* :left 5  :bottom (+ 16 (height *parameter-done*)))
    (set-button *new-f* *param-display* :left (- (width *param-display*) (width *new-f*) 5) :bottom (bottom *defined-f*)
		:action `(lambda () (new-ff (list *start-button* *monitor-button* *new-f* *defined-f* *parameter-done*))))
    (if *fitness-function* (dolist (i (items *defined-f*) t)
			     (if (equal (write-to-string (intern *fitness-function*)) (label i))
				 (unless (status i) (toggle-button i))
			       (clear-button i))))
    (set-button *parameter-done* *param-display* :left (- (width *param-display*) 5 (width *parameter-done*)) :bottom 5
		:action `(lambda nil
			   (if (active *defined-f*)
			       (enable-button (list *start-button* *monitor-button*)))
			   (setf *button-list* (nthcdr 4 *button-list*))
			   (close-display ,*param-display*)
			   (reset-button ,called-by-button)))
    (set-button p-help *param-display* :left 5 :bottom 5
		:action `(lambda nil (setf *window-list*
				       (cons (make-instance 'help-display
					       :left 620 :bottom 10 :width 520 :height 300
					       :title "GA:Help for Parameter setting"
					       :filename (add-path "ga-parameter-help.asc" *ga-path*)
					       :from-button ,p-help :button-region t) *window-list*))))
    ))

(defun change-ff (function-name called-by-button)
 ;;;(unless (equal (write-to-string (intern *fitness-function*)) function-name))
  (disable-button called-by-button)
  (edit-function called-by-button function-name))

(defun new-ff (called-by-button)
  (disable-button called-by-button)
  (edit-function called-by-button "undefined"))

(defun edit-function (called-by-button name)
  (let* ((*default-push-button-size-p* t)
	 (*default-push-button-width* (round (* 120 (width *root-window*)) 1140))
	 (*default-font* (findfont (width *root-window*) 1140 13))
	 (p-done (make-instance 'push-button :label "Done"))
	 (p-canc (make-instance 'push-button :label "Cancel"  ))
	 (cb-list (list p-done p-canc))
	 (f-obj (find-function name *known-functions*))
	 (ff-button   (make-instance 'value-button :inhibit-buttons cb-list :name "Function:" :value name))
	 (nop-button  (make-instance 'value-button :inhibit-buttons cb-list :numeric t :name "Number of Parameter:" :value (nparameter f-obj)))
	 (lb-button   (make-instance 'value-button :inhibit-buttons cb-list :numeric t :name "Lower bound:"	    :value (lower-bound f-obj)))
	 (ub-button   (make-instance 'value-button :inhibit-buttons cb-list :numeric t :name "Upper bound:"	    :value (upper-bound f-obj)))
	 (bpp-button  (make-instance 'value-button :inhibit-buttons cb-list :numeric t :name "Bits per Parameter:"  :value (bits-per-parameter f-obj)))
	 (minf-button (make-instance 'value-button :inhibit-buttons cb-list :numeric t :name "Minimum value:"	    :value (min-f f-obj)))
	 (maxf-button (make-instance 'value-button :inhibit-buttons cb-list :numeric t :name "Maximum value:"	    :value (max-f f-obj)))
	 (gray-button (make-instance 'radio-button	     :label "Use gray-coding"	  :status (gray-coded f-obj)))
	 (vb-height (height ff-button)) (rb-height (max (height gray-button) (font-character-height *default-font*)))
	 (ff-width (min 326 (+ (font-string-width *default-font* (name nop-button))
						      (width nop-button) 10)))
	 (ff-height (min 212 (+ (* 8 vb-height) rb-height 20)))
	 (ff-display (make-instance 'display :title (format nil "GA:~AFitness Function" (if (equal name "undefined") "New " ""))
				   :width ff-width
				   :height (min 212 (+ (* 8 vb-height) rb-height 20))
				   :left (- (left *param-display*) ff-width 20)
				   :bottom (bottom *param-display*)))
	 (b-off (- (height ff-display) vb-height 5)))
    (set-button ff-button ff-display   :left (- (width ff-display) (width ff-button) 5) :bottom b-off :active (equal name "undefined")
		:action `(lambda nil (if (find (button-value ,ff-button) (items *defined-f*) :key #'label :test #'equal)
					 (progn (display-error (format nil "The Function `~a' is already defined" (button-value ,ff-button))
							       :wait nil :title "Warning")
						(setf (button-value ,ff-button) "undefined"))
				       (unless (or (equal (button-value ,ff-button) "undefined")
						   (fboundp (intern (button-value ,ff-button) :ga)))
					 (display-error (format nil "The Function `~a' is not defined~
								   ~&in the GA Package." (intern (button-value ,ff-button))) :wait nil)
					 (setf (button-value ,ff-button) "undefined")))))
    (set-button minf-button ff-display :left (left ff-button) :bottom (- b-off      vb-height ))
    (set-button maxf-button ff-display :left (left ff-button) :bottom (- b-off (* 2 vb-height)))
    (set-button nop-button  ff-display :left (left ff-button) :bottom (- b-off (* 3 vb-height)))
    (set-button lb-button   ff-display :left (left ff-button) :bottom (- b-off (* 4 vb-height)))
    (set-button ub-button   ff-display :left (left ff-button) :bottom (- b-off (* 5 vb-height)))
    (set-button bpp-button  ff-display :left (left ff-button) :bottom (- b-off (* 6 vb-height)))
    (set-button gray-button ff-display :left 15 :bottom (- (+ b-off 9) (* 7 vb-height))
		:action `(lambda ()
			   (disable-button (list ,gray-button ,p-done ,p-canc))
			   (if (or (not *current-generation*) (equal (y-or-n-dialog (format nil "If you switch to ~a-coding now,~
								~&all previously learned optima will~
								~&be misinterpreted and therefore lost.~
								~&~%~
								~&Do you want to do that?" (if (status ,gray-button) "gray" "integer"))
										    :left 732 :bottom 184
										    :title "Warning"
										    :cancel-button nil) :yes))
			       (progn (setf *gray-coding* (status ,gray-button))
				      (if *gray-coding*
					  (compile (defun degray1 (l) (degray l)))
					(compile (defun degray1 (l) l))))
			     (progn (enable-button ,gray-button) (toggle-button ,gray-button)))
			   (enable-button (list ,gray-button ,p-done ,p-canc))))
    (draw-line ff-display 0 (+ 10 (height p-done)) (width ff-display) (+ 10 (height p-done)))
    (set-button p-canc ff-display :left (- (width ff-display) 10 (width p-canc) (width p-done)) :bottom 5
		:action `(lambda nil
			   (enable-button (list *defined-f* *new-f* *parameter-done*))
			   (clear-button *defined-f*)
			   (when *fitness-function*
			     (dolist (i (items *defined-f*) t)
			       (if (equal (write-to-string (intern *fitness-function*)) (label i))
				   (unless (status i) (toggle-button i))
				 (clear-button i)))
			     (enable-button (list *start-button* *monitor-button*)))
			   (close-display ,ff-display)
			   (if (equal ,name "undefined") (reset-button *new-f*))))
    (set-button p-done ff-display :left (- (width ff-display) 5 (width p-done)) :bottom 5)
    (if (equal name "undefined")
	(setf (action p-done) `(lambda nil
				 (when (and (> (length (button-value ,ff-button)) 0)
					    (not (equal "undefined" (button-value ,ff-button))))
				   (setf *known-functions* (cons (make-instance 'ga-function
					; I am making a new object to get the rest of the accessors set up by initialize-instance
								   :lower-bound (button-value ,lb-button)
								   :upper-bound (button-value ,ub-button)
								   :nparameter (button-value ,nop-button)
								   :bits-per-parameter (button-value ,bpp-button)
								   :fitness-function (intern (button-value ,ff-button) :ga)
								   :min-f (button-value ,minf-button)
								   :max-f (button-value ,maxf-button)
								   :gray-coded (status ,gray-button))
								 *known-functions*))
				   (add-item *defined-f* (write-to-string (intern (fitness-function (car *known-functions*)))))
				   (setf (action *defined-f*) `(lambda () (change-ff (item-label) (list *defined-f* *new-f* *parameter-done*))))
				   (setf *current-function* (car *known-functions*))
				   (setup-globals *current-function*))
				 (if *fitness-function*
				     (dolist (i (items *defined-f*) t)
				       (if (equal (write-to-string (intern *fitness-function*))
						  (label i))
					   (unless (status i) (toggle-button i))
					 (clear-button i))))
				 (close-display ,ff-display)
				 (reset-button *new-f*)
				 (enable-button (list *start-button* *monitor-button*))
				 (enable-button (list *defined-f* *new-f* *parameter-done* *monitor-button* *start-button*))))
      (setf (action p-done) `(lambda nil
			       (setf (lower-bound ,f-obj) (button-value ,lb-button))
			       (setf (upper-bound ,f-obj) (button-value ,ub-button))
			       (setf (nparameter ,f-obj) (button-value ,nop-button))
			       (setf (bits-per-parameter ,f-obj) (button-value ,bpp-button))
			       (setf (fitness-function ,f-obj) (intern (button-value ,ff-button) :ga))
			       (setf (min-f ,f-obj) (button-value ,minf-button))
			       (setf (max-f ,f-obj) (button-value ,maxf-button))
			       (setf *current-function* ,f-obj)
			       (setf (gray-coded ,f-obj) (status ,gray-button))
			       (setup-globals *current-function*) (enable-button (list *monitor-button* *start-button*))
			       (enable-button (list *defined-f* *new-f* *parameter-done* *monitor-button* *start-button*))
			       (close-display ,ff-display))))
    ))

(defun find-function (this-function function-list)
  (let ((hook nil))
    (dolist (i function-list hook)
      (if (equal this-function (write-to-string (intern (fitness-function i))))
	  (setq hook i)))
    (if hook
	hook
      (make-instance 'ga-function :fitness-function this-function))))

(defun setup-globals (from-this-object)
  (setf *fitness-function* (fitness-function from-this-object))
  (setf *parameter* (nparameter from-this-object))
  (setf *bits-per-parameter* (bits-per-parameter from-this-object))
  (setf *lower-bound* (lower-bound from-this-object))
  (setf *upper-bound* (upper-bound from-this-object))
  (setf *precision* (expt 2 (bits-per-parameter from-this-object)))
  (setf *max-allele* (* *bits-per-parameter* *parameter*))
  (setf *itervall-length* (- *upper-bound* *lower-bound*))
  (setf *gray-coding* (gray-coded from-this-object)))

;;; ==========================================================================
;;; 
;;; ==========================================================================

(defun start-evolving (called-by-button)
  (disable-button *button-list*)
  (disable-button *analyze-button*)
  (display-wait-status *window-list* t)
  (display-message (format nil "evolving ~a generations" *generations-to-evolve*))
  (unless *current-generation*
    (setf *current-generation* (make-instance 'population
				 :size *population-size*)))
  (when *perf-disp*
    (if (> (length (plist *perf-disp*)) 0)
	(let ((iw (inner-width *perf-disp*)))
	  (setf (inner-width *perf-disp*) (- (* 2 iw) (floor (- iw (* (length (plist *perf-disp*))
								      (vxunit *perf-disp*))))))
	  (dotimes (i *generations-to-evolve*)
	    (let ((x (+ iw (* i (vxunit *perf-disp*)))))
	      (draw-line *perf-disp* x 0 x (if (eql (mod i 10 ) 0) 5 2))))))
    (refresh-display *perf-disp*)) ;;; to refresh the pann-bar.
  (setf *current-generation* (evolve *current-generation* :generations *generations-to-evolve*))
  (disable-button *stop-button*)
  (reset-button called-by-button)
  (enable-button *button-list*) (enable-button *analyze-button*)
  (display-wait-status *window-list* nil))


(defclass graph-display (display)
	  ((vxunit	:accessor vxunit :initarg :vxunit)
	   (vyunit	:accessor vyunit :initarg :vyunit)
	   (plist	:accessor plist))
  (:documentation "This is a display for line Graphs"))

(defmethod initialize-instance :after ((d graph-display) &rest ignore)
  (setf (vxunit d) (/ (inner-width d) *generations-to-evolve*))
  (setf (vyunit d) (/ (inner-height d) (- (max-f *current-function*) (min-f *current-function*))))
  (setf (plist d) nil))

(defvar *gen-l* nil) (defvar *mut-l* nil) (defvar *avf-l* nil)
(defvar *gen-b* nil) (defvar *mut-b* nil) (defvar *avf-b* nil)

(defun open-monitor (called-by-button)
  (let* ((*default-push-button-size-p* nil)
	 (*default-push-button-width* (round (* 120 (width *root-window*)) 1140))
	 (*default-font* (findfont (width *root-window*) 1140 13))
	 (dispwidth (round (width *root-window*) 3))
	 (m-help (make-instance 'push-button :label "Help" :width (round dispwidth 5)))
	 (m-done (make-instance 'push-button :label "Exit" :width (round dispwidth 5))))
    (setf *analyze-button* (make-instance 'push-button :label "Analyze" :width (round dispwidth 5)))
    (disable-button *gs-button*)
    (setf *monitor-disp* (make-instance 'display
			   :title "GA:Monitor"
			   :left (round (width *root-window*) 3.5)
			   :bottom (round (height *root-window*) 2)
			   :width dispwidth
			   :height (max 275 (+ (height m-help)
					       165
					       (* 3 (font-character-height *default-font*))
					       *static-pann-bar-height*))
			   :font *default-font*))
    (setf *t-display* (make-instance 'scroll-display
			:width dispwidth
			:height (round (height *root-window*) 6)
			:left (round (width *root-window*) 3.5)
			:bottom (round (height *root-window*) 2.5)
			:inner-width 600
			:button-region *verbose-mode*
			:active *verbose-mode*
			:title "GA:Trace"
			:font *default-font*))
    (setf *window-list* (append (list *t-display* *monitor-disp*) *window-list*))
    (draw-line *monitor-disp* 0 (+ (height m-help) 10) (width *monitor-disp*) (+ (height m-help) 10))
    (setf *gen-b* (+ (height m-help) 12 (font-baseline *default-font*)))
    (setf *mut-b* (+ *gen-b* (font-character-height *default-font*)))
    (setf *avf-b* (+ *mut-b* (font-character-height *default-font*)))
    (write-display *monitor-disp* "Generation:" 10 *gen-b*)		(setf *gen-l* (+ 15 (font-string-width *default-font* "Generation:")))
    (write-display *monitor-disp* "Mutations:" 10 *mut-b*)		(setf *mut-l* (+ 15 (font-string-width *default-font* "Mutations:")))
    (write-display *monitor-disp* "Average-fitness:" 10 *avf-b*)	(setf *avf-l* (+ 15 (font-string-width *default-font* "Average-fitness:")))
    (setf *perf-disp* (make-instance 'graph-display
			:title nil
			:width dispwidth
			:height (round (height *root-window*) 6)
			:left -1
			:bottom (- (height *monitor-disp*) 150)
			:parent *monitor-disp*))
    (make-static-pann-bar (window *perf-disp*))
    (redraw-perf-disp nil t)
    (set-button m-help *monitor-disp*
		:left (round (width m-help) 2)
		:bottom 5
		:action `(lambda nil (setf *window-list*
				       (cons (make-instance 'help-display
					       :left 20 :bottom 10 :width 520 :height 300
					       :title "GA:Help for Monitor"
					       :filename (add-path "ga-monitor-help.asc" (add-subdir *pail-path* "ga"))
					       :from-button ,m-help :button-region t) *window-list*))))
    (set-button *analyze-button* *monitor-disp* :left (* 2 (width m-help))  :bottom 5
		:action `(lambda nil (open-analyze-display ,*analyze-button*)))
    (set-button m-done *monitor-disp* :left (* 7 (round (width m-help) 2)) :bottom 5
		:action `(lambda nil
			   (close-display ,*monitor-disp*)
			   (close-display ,*t-display*)
			   (enable-button *gs-button*)
			   (reset-button ,called-by-button)))
    ))

(defun redraw-perf-disp (point &optional (refresh-p nil))
  (if refresh-p
      (progn (clear-display *perf-disp*)
	     (dotimes (i *generations-to-evolve*)
	       (let ((x (* i (vxunit *perf-disp*))))
		 (draw-line *perf-disp* x 0 x (if (eql (mod i 10 ) 0) 5 2)))))
    (let* ((l (length (plist *perf-disp*)))
	   (x (* (length (plist *perf-disp*)) (vxunit *perf-disp*)))
	   (x- (- x (vxunit *perf-disp*))))
      (if (and point (> l 0))
	  (draw-line *perf-disp*
		     x- (* (+ (min-f *current-function*) (car (last (plist *perf-disp*)))) (vyunit *perf-disp*))
		     x (* point (vyunit *perf-disp*)) :color blue  ))
      (setf (plist *perf-disp*) (append (plist *perf-disp*) (list point))))
    ))


(defun update-monitor (ngen nmut pop)
  (when (and *monitor-disp* (status *monitor-disp*))
;    (setf (font *monitor-disp*) *normal-font*)
    (redraw-perf-disp (maximum-fitness pop))
    (clear-display *monitor-disp* :left *gen-l* :bottom (- *gen-b* (font-baseline (font *monitor-disp*))) :height (font-character-height (font *monitor-disp*)))
    (write-display *monitor-disp* (format nil "~a" (- *generations-to-evolve* ngen)) *gen-l* *gen-b*)
    (clear-display *monitor-disp* :left *mut-l* :bottom (- *mut-b* (font-baseline (font *monitor-disp*))) :height (font-character-height (font *monitor-disp*)))
    (write-display *monitor-disp* (format nil "~a" nmut) *mut-l* *mut-b*)
    (clear-display *monitor-disp* :left *avf-l* :bottom (- *avf-b* (font-baseline (font *monitor-disp*))) :height (font-character-height (font *monitor-disp*)))
    (write-display *monitor-disp* (format nil "~6:F" (average-fitness pop)) *avf-l* *avf-b*)
    ))

(defun open-analyze-display (from-button)
  (if *current-generation*
      (let* ((a-done (make-instance 'push-button :label "Exit"))
	     (ngens (ask "How many Generations to analyze [5]: " :condition '(lambda (s)
									      (or (equal (length s) 0)
									       (numberp (read-from-string s))))))
	     (ngen (min (length (populations *current-generation*))
			(if (> (length ngens) 0) (read-from-string ngens) 5)))
	     (ninds (ask "How many Individuals per Generation [5]: " :condition '(lambda (s)
										  (or (equal (length s) 0)
										   (numberp (read-from-string s))))))
	     (nind (min *population-size*
			(if (> (length ninds) 0) (read-from-string ninds) 5)))
	     (genoffset (max (- (length (populations *current-generation*)) ngen) 0))
	     (bwidth (* 5 nind))
	     (bheight (* 4 *max-allele*))
	     (width (* ngen (+ 5 bwidth)))
	     (height (+ 5 (font-character-height *default-font*) (+ 5 bheight))))
	(setf *analyze-display* (make-instance 'display :width (+ 20 width) :height (+ 60 bheight (height a-done) ) :left 88 :bottom 210
					      :title "GA:Schemata Analysis"))
	(let ((*default-push-button-size-p* nil))
	  (setf *window-list* (cons *analyze-display* *window-list*))
	  (setf *schemata-display* (make-instance 'display :width (- (width *analyze-display*) *static-scroll-bar-width*)
						 :height (- (height *analyze-display*) 10 (height a-done) *static-pann-bar-height*)
						 :inner-width (max 300 width) :inner-height height
						 :left *static-scroll-bar-width*
						 :bottom (+ *static-pann-bar-height* (height a-done) 10)
						 :parent *analyze-display* :title nil))
	  (make-static-pann-bar (window *schemata-display*))
	  (make-static-scroll-bar (window *schemata-display*))
	
	;;; sorting the individuals does not make any difference if you have roulette-wheel selection.
	  (dotimes (gi ngen)
	    (let* ((gen-bm (make-bitmap :width bwidth :height bheight))
		   (gen-button (make-instance 'push-button :bitmap gen-bm))
		   (gen-bottom (font-character-height *default-font*))
		   (cind-list (copy-list (population (car (nthcdr (+ genoffset gi) (populations *current-generation*))))))
		   (ind-list (sort cind-list #'> :key #'fitness-value))
		   (gen-name (format nil "~A" (+ (- (length (populations *current-generation*)) ngen) gi))))
	      (setf (population (car (nthcdr (+ genoffset gi) (populations *current-generation*)))) ind-list)
	      (dotimes (ii nind)
		(draw-individual (car (nthcdr ii ind-list)) gen-bm ii))
	      (set-button gen-button *schemata-display* :left (- (* (width gen-button) gi) 1) :bottom gen-bottom
			  :action `(lambda ()
				     (show-generation ,gen-button
						      (population ,(car (nthcdr (+ genoffset gi) (populations *current-generation*))))
						      ,nind
						      ,(+ (- (length (populations *current-generation*)) ngen) gi))))
	      (write-display *schemata-display* gen-name
			     (- (+ (/ (width gen-button) 2) (* gi (width gen-button))) (/ (font-string-width *default-font* gen-name) 2)) 3)
	      ))
	  )
	(set-button a-done *analyze-display*
		    :bottom 5 :left (- (width *analyze-display*) (width a-done) 5)
		    :action `(lambda nil
			       (close-display ,*analyze-display*)
			       (reset-button ,from-button))))
    (progn
      (display-error "Current Generation is not defined")
      (reset-button *analyze-button*))
    ))


(defun draw-individual (john bitmap col)
  (dotimes (allele *max-allele*)
    (let ((stat (if (car (nthcdr allele (genotype john))) 1 0)))
      (dotimes (i 4)
	(dotimes (j 4)
	  (setf (bitmap-bit bitmap (+ (* 5 col) i) (+ (* 4 allele) j)) stat))))))


(defun show-generation (from-button ind-list n geni)
  (let* ((gend-done (make-instance 'push-button :label "Dismiss"))
	 (headline "Rank   Func.-Val  Parameter")
	 (gend (make-instance 'display :title (format nil "GA:Generation ~A" geni)
			     :inner-width (+ 230 (* 12 (font-character-width *default-font*) *parameter*))
			     :x-scrollbar t
			     :width (max 400 (+ 10 (font-string-width *default-font* headline)))
			     :height (+ 10 (height gend-done) (* (+ 3 n) (font-character-height *default-font*))))))
    (write-display gend headline 10 (- (height gend) 10 (font-character-height (font gend))))
    (dotimes (i (min (length ind-list) n))
      (let* ((yoff (- (height gend) 20 (* 2 (font-character-height (font gend))) (* i (font-character-height (font gend)))))
	    (indiv (genotype (car (nthcdr i ind-list))))
	    (parameter (decode indiv)))
	(write-display gend (format nil "#~2:D    ~6:F     ~a" (1+ i) (apply *fitness-function* (list parameter)) parameter) 10 yoff)
	))
    (set-button gend-done gend :left (- (width gend) (width gend-done) 5) :bottom 5
		:action `(lambda ()
			   (close-display ,gend)
			   (reset-button ,from-button)))
    ))



#|  This extension of the extract routine opens the possibility
    to turn off the anti-aliasing of the encoded genotypes.

(defvar *anti-aliasing* nil)
(defun extract (l &optional (n 0) (i 0)) ; convert list to parameter
  (if l
      (extract (cdr l) (+ n (* (if (car l) 1 0) (expt 2 i))) (+ i 1))
    (if *anti-aliasing*
	(+ *lower-bound* (* *itervall-length* (/ (+ n (random 1.0)) *precision*)))
      (+ *lower-bound* (* *itervall-length* (/  n *precision*))))))

;(setf *anti-aliasing* nil)
;(setf *anti-aliasing* t)
;(format t "~%ANTI-ALIASING ist ~A" (if *anti-aliasing* "ON" "OFF"))

|#


(defun display-message (mstring)
  (if *verbose-mode*
      (if (and *t-display* (status *t-display*))
	  (format-display *t-display* mstring)
	(documentation-print mstring))))

