;;; -*- Mode:Lisp; Syntax:Common-Lisp; Base:10; -*-
;;; ************************************************************************
;;;                                 WIN-SHELL
;;; ************************************************************************
;;;
;;; Filename:   forward-rules-make.cl
;;; Short Desc: WIN-SHELL - a tiny shell from the WINSTON-HORN book
;;; Version:    0.1
;;; Status:     Experimental
;;; Last Mod:   29.5.91 15:00:01 DTA
;;; Author:     DTA
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; ------------------------------------------------------------------------
;;; Change History:
;;; HF  11.11.87  first code, debugged
;;; SK  16.10.89  improved
;;; SK   5.11.90  some pail standards applied
;;; DTA  29.5.91  standards modified
;;; ------------------------------------------------------------------------

;;; DESCRIPTION
;;; ------------------------------------------------------------------------
;;; Make file to load the entire module (code, documentation, examples...)
;;; ------------------------------------------------------------------------

;;; (c) Copyright 1991 University of Zurich.  All rights reserved.
;;; Only for non-commercial research or educational purposes; 
;;; neach copy or derivative work must include this copyright notice in full;
;;; This software is made available AS IS, and there is no warranty about
;;; the software or its performance.

;(defpackage :rules (:use :common-lisp :pail-lib))

(in-package :rules)

(eval-when (load eval compile)
  (export '(demo-forward-rules forward-chain)))

 

;;; ------------------------------------------------------------------------
;;; PARAMETERS
;;; ------------------------------------------------------------------------

(defparameter *forward-rulespath* (add-subdir *pail-path* "forward-rules"))

(defparameter *ebgpath*  (add-subdir *pail-path* "ebg"))

(defvar *number-of-demos* 0)


 
;;;
(ensure-loaded (add-path "unify" (add-subdir *pail-path* "planning")))
(ensure-loaded (add-path "rules" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "pool" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "trees" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "tables" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "table-ed" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "tre2rul" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "ebg-classes" *ebgpath*))
(ensure-loaded (add-path "browser" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "ebg-browser" *ebgpath*))
(ensure-loaded (add-path "obj-forw" *forward-rulespath*))
;(ensure-loaded (add-path "win-back" *forward-rulespath*))

;;; run sks-shell...

(defvar *verbose* nil)

(ensure-loaded (add-path "forward-rules-ex1" *forward-rulespath*))



(if *gin-p* 
    (progn
      (ensure-loaded (add-path "forward-rules-dialog" *forward-rulespath*))
      (setq *number-of-demos*
	  (do* ((i 1 (1+ i))
		(name (make-pathname :name (format nil "forward-rules-ex~a" i)
				     :type *sourcefile-type*)
		      (make-pathname :name (format nil "forward-rules-ex~a" i)
				     :type *sourcefile-type*)))
	      ((not (probe-file (add-path name *forward-rulespath*))) (1- i))
	    (ensure-loaded (add-path name *forward-rulespath*)))))
  (ensure-loaded (add-path "forward-rules-ascii-dialog" *forward-rulespath*)))


;;; ------------------------------------------------------------------------
;;; end of file
;;; ------------------------------------------------------------------------
