;;; -*- Mode:Lisp; Syntax:Common-Lisp; -*-
;;;
;;; ******************************
;;; *  PORTABLE AI LAB - UNI ZH  *
;;; ******************************
;;;
;;; Filename:   .clinit.cl
;;; Short Desc: loaded by cl upon startup (unless started with -qq).
;;; Version:    1.0
;;; Status:     review
;;; Last Mod:   Nov 25, 1991
;;; Author:     na
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; *****************************************************************

;;; If you are using Common Lisp inside Emacs, you need a socket
;;; listener daemon to communicate with the editor.
(cond
 ((find "+ipc" (system:command-line-arguments) :test #'string=)
  (require :ipc)
  (require :emacs)
  (funcall (find-symbol (symbol-name :start-lisp-listener-daemon)
                        (find-package :ipc)))))

;;; To conform with the Unix convention of lowercase filenames -
;;; do not change this.
(set-case-mode :case-insensitive-lower)

;;; COMMON WINDOWS is designed to run with ICCCM-complaint window
;;; managers.  If you are using uwm as window manager, you should set
;;; the value of this variable to  nil.
(setq cw::*icccm-compliant-p* t)

;;; To keep common windows from adding a title-bar to the window. most
;;; window managers have their own titles.
(setq cw::*window-manager-titles-p* t)
(setq cw::*window-manager-notification-broken-p* t)

;;; Some window servers cause the problem, that a window is not
;;; completely ready even though the function that creates the window
;;; returns.  This causes sometimes missing buttons or the error
;;; undefined generic function font called with arguments nil.  A
;;; useful value for this might be between 0.5 and 1.3
;;; one way is also to use the fast MIT X11 server instead of the
;;; memory-intensive NeWS server.
(setq user::*server-delay* 0)

;;; *****************************************************************
;;; The following line is SITE SPECIFIC.  Please insert the pathname
;;; of the directory where the pAILab is installed. 

(load "/home/pail/pail-make.cl")
