;;OKKIO
(in-package :csp)


(defun acknowledge-dialog (cspquery &key (title "Please Click"))
  (let* ((font (my-findfont 13))
         (dw (make-instance 'display  :font font  
               :width (if (> (cw::font-string-width font  cspquery)(scalew  185))
                          (+ (cw::font-string-width font  cspquery)(scalew 20))(scalew  205))
               :left (scalew 100)
               :bottom (scaleh 500)
               :height (scaleh 160)
               :title title))
         (done nil)
         (yb (make-instance 'push-button :label "   OK   " :font font  )))
    (write-display dw cspquery (scalew 10)(scaleh  90))
    (set-button yb dw :left (- (width dw) (scalew 120)) :bottom (scaleh 4 ):action (function (lambda (&rest cw-internals)
                                                                                               (declare (ignore cw-interna
ls))
                                                                                               (setf done 'continue))))
    (mp:process-wait "exit"   #'(lambda nil done)) 
    (close-display dw)
    done))


(defun head-equal (list sublist)
  (cond ((null sublist) t)
	( (null list) nil)
	((equal (car list) (car sublist)) (head-equal (cdr list)( cdr  sublist)))))

(defun terminates-with (substr str)
 (head-equal  (reverse (coerce str 'list))
	      (reverse (coerce substr 'list))))

(defun my-y-or-n-dialog (cspquery &key (title "Please Click"))
  (let ((dw (make-instance 'display   :width  (+ 10 (cw::font-string-width *small-font* cspquery) )
			   :left (scalew 576)
			   :font *small-font*
			   :bottom (scaleh 630)
			   :height (scaleh 80)
			   :title title))
	(done nil)
	(yb (make-instance 'push-button :label " Yes " :font *small-font* ))
	(nb (make-instance 'push-button :label " No  " :font *small-font* )))
    (push  dw *open-displays-list*)
    (write-display dw cspquery (scalew 10)(scaleh  60))
    (set-button yb dw   :left (scalew 10) :bottom (scaleh 10) :action (function (lambda (&rest cw-internals)
							      (declare (ignore cw-internals))
							      (setf done 'Yes))))
    (set-button nb dw :left (- (width dw) 10 (width nb))
		:bottom (scaleh 10) :action (function (lambda (&rest cw-internals)
							       (declare (ignore cw-internals))
							       (setf done 'No))))
    (mp:process-wait "Exit"   #'(lambda nil done))
    (cw:flush (window dw))
    done))

