;;; -*- Mode: LISP; Package: csp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   csp-demo1.cl
;;; Short Desc: First demo on Constraint Propagation
;;;            
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.3.93 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :csp)


;;=====================================================================
;; The definition of demo1
;;=====================================================================

(defun demo-1 ( )
  (setq *open-windows* nil)
  (setq *demo-in-execution* 1)
  (format-display-fill demo-text-disp  (format nil
					       "This demo shows some basic aspects of the Constraint Propagation Module
using an example taken from computer vision. The problem is to interpret a 2-dimensional
drawing as a 3-dimensional one.This approach to hi-level interpretation of figures 
is due to Waltz (1971). "))
  (when (wait)
    (format-display-fill demo-text-disp (format nil
						
" We will concentrate in the field of line-diagram labeling.
we restrict the domain to polyhedra-three-dimensional objects with flat surfaces
buonded by straight lines, allowing only trihedral vertexes.
In short, we restrict ourselves to consider only object resulting by the composistion
of parallelopipeds and cubes"))
    (when (wait)
      (format-display-fill demo-text-disp (format  nil 
						   "Let us view a file containing a problem description
for the interpretation of a cube over a plate."))
      (when (wait)
	(setq *view* (make-instance 'help-display
		       :left   (scalew 20)
		       :bottom (scalew 50)
		       :height (scaleh 400)
		       :width  (scalew 500)
		       :filename  (add-path "demo1" *csp-path*)))
	(push *view*  *open-windows*)
	(protect-display *view* t)
	(format-display-fill demo-text-disp (format  nil  
"Our goal is to identify each line at each vertex of the drawing placing it in one of three classes:
1- convex lines, marked with the label +     (e.g. A-B)
2- concave lines, marked with the label -    (e.g. G-D)
3- boundary lines marked with labels L or R. (e.g. G-B) "))
	(when (wait)
	  (format-display-fill demo-text-disp  (format nil 
"A boundary line denotes the same physical situation as a convex line, but the
object is oriented in such a way that only one face is visible. so, the line marks the
boundary between the polyhedron and the background."))
	  (when (wait)
	  (format-display-fill demo-text-disp  (format nil 
"The idea of Waltz is simple: first we enumerate all the possible
 vertexes and the possible labelings for each vertex. It turns out that
there are four different vertex types in the trihedral polygon world.
We call them L-vert, Y-vert, T-vert.
For instance, in the cube-on-plate example a is a Y-vert, B is 
a W-vert, and E is a L-vert.
 "))
	 (when (wait)
  (format-display-fill demo-text-disp  (format nil 
"Each vertex imposes come constraints on the lines which compose it.
For instance in a W-vert the middle line can be concave or convex, but
not a boudary line, and so on. Each line connects two vertexes so it must satisfy 
both constraints. "))
	 (when (wait)
	   (format-display-fill demo-text-disp  (format nil 
"Solving the problem by constraint propagation means to associate
to every vertex a labeling, or, better, the set of labelings to 
all the neighbor vertexes. Let us load the Constraint Satisfaction Module"))
	 (when (wait)
	  (cspw)
	  (push *csp-main-window* *open-windows*)
	  (protect-display *csp-main-window* t)
	  (format-display-fill demo-text-disp  (format nil  "Now we load the problem description"))
	  (when (wait)
	      (load-csp-demo  (namestring(add-path *csp-path* "demo1")))
	      (my-software-push *graph-button* *csp-main-window*)
		
	      (format-display-fill demo-text-disp (format nil  "Here is a graphical representation of the constraint network.
The problem of 3D interpretations matches the generic CS Problem as follows:
Each vertex in the polyhedra corresponds to a node in the constraint network.
Each line in the polyhedra corresponds to a link in the network.
The domain of each node contains all the possible labeling for the associated
vertex. Let us inspect the domain of node C by pushing the corresponding node in the network
(see the output in CSP Standard Output)"))
		  (when (wait)
		(my-software-push (domain-button (caddr (nodes *main-network*)))
				    (window *main-network*))
		 	
	    (format-display-fill demo-text-disp (format nil  "There are three possible values: for example the third value
((E . +) (F . +) (A . -))
can be read as:
the line C-->E is convex, the line C-->F in convex, the line C-->A is concave."
))

		(when (wait)
		 (format-display-fill demo-text-disp (format nil  "You can set the verbose mode on/off"))
		  (when (wait) 
		    (my-software-push *verbose-button* *csp-main-window*)(sleep 1)
		    (my-software-push *verbose-button* *csp-main-window* )
		    (format-display-fill demo-text-disp  (format nil  
"You can also instruct the system to wait at some points of the computation"))
		    (when (wait) 
		      (my-software-push *stop-at-sol-button* *csp-main-window*)
		      (my-software-push *stop-at-prop-button* *csp-main-window*)
		      (my-software-push *stop-at-arc-button* *csp-main-window*)
		      (sleep 1)
		      (my-software-push *stop-at-arc-button* *csp-main-window*)
		      (my-software-push *stop-at-prop-button* *csp-main-window*)
		      (my-software-push *stop-at-sol-button* *csp-main-window*)
		      (format-display-fill demo-text-disp (format nil  
"Now we start the constraint propagation process by pressing the RUN button. 
See the second demo to understand the details of the algorithm."))
		     (when (wait) 
			  (my-software-push *run-button* *csp-main-window*)
			(format-display-fill demo-text-disp  (format nil  "The system
has discovered four solutions, each of them representing
a possible 3D interpretation for the given drawing."))
			(when (wait)
			  (format-display-fill demo-text-disp  (format nil  
"the solutions can be displayed by pressing the SOLUTIONS button"))
			  (my-software-push *solutions-button* *csp-main-window*)
			  (format-display-fill demo-text-disp  (format nil  
"For example the fourth solution interpretes vertex A as a convex corner
while the sides G-D and D-F are interpretedas concave lines.
The lines F-C, F-I, I-M, M-R, K-L L-H,H-G,G-B, C-E and E-B are all interpreted as boundary lines:
this means that the whole figure is interpreted by the last solution as a solid floating
in the space."))
			  (when (wait) 
			    (my-software-push *stop-at-prop-button* *csp-main-window*)
			    (format-display-fill demo-text-disp  (format nil  "That's All Folks"))
			    
			    (my-software-push *exit-button* *csp-main-window*)
			    (close-display *csp-main-window*))))))))))))))))))