;;; -*- Mode: LISP; Package: cky; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   cky-dialog.cl
;;; Short Desc: dialog handling for Chart-parser
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.92 - FB
;;; Author:     Fabio Baj
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------
 
;;; --------------------------------------------------------------------------
 

;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :cky)



;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================



(defparameter *number-of-demos* 2)
(defparameter *verbose* nil)
(defvar *verbose-disp* nil)
(defvar *execution-terminated* nil)


;;==================================================================
;; THE CKY dialog


(defun init-sizes()
;;; 2073x1687 to resize for a 600x480 screen
;;; 1670x1375 to resize for a screen less than 8000x600
  (setq *original-screen-width* 1152)
  (setq *original-screen-height* 900)
  (setq *chart-h*  (if  (small-screen) (scaleh 140)(scaleh 90)))
  (setq  *chart-w* (if (small-screen) (scalew 180)(scalew 140)))
  (setq *all-msg-subdisp-height* (scaleh 60)))

(defun start-cky-dialog (&optional (from-button nil))
   (init-sizes)
  (setq *demo-in-execution* nil)
  (excl:chdir *cky-path*)
  (if *verbose*
      (progn  (setf *verbose-disp* (make-instance 'scroll-display
				     :title "CKY:Verbose Comments"
				     :width (scaleh 580)
				     :height (scaleh 150)
				     :borders 1
				     :active nil
				     :left (scalew 500)
				     :bottom (scaleh 375)))
	      (activate-display *verbose-disp*)
	      (setf *verbose* *verbose-disp*)
	      (deactivate-display *verbose-disp*))
    (setf *verbose-disp* *verbose*))
  
  (let* ((disp (make-instance 'display :title "CKY:Main Window"
			      :width (scaleh 600)
			      :height (scaleh 250)
			      :borders 1
			      :left (scalew 200)
			      :bottom (scaleh 480)))
	 (menu-button (make-instance 'pop-up-button
			:label "Demos"
			:font (my-findfont 13)
			
			:width (scaleh 100)))
	 (exit-button (make-instance 'push-button :label "Exit" :font (my-findfont 13) :width (scaleh 70)))
	 (help-button (make-instance 'help-button :label "Help" :font (my-findfont 13) :width (scaleh 70)
				     :subject "CKY Module"
				     :technical (add-path "cky-desc-tec.asc" *cky-path*)
				     :general (add-path "cky-desc.asc" *cky-path*)))
	 (tool-button (make-instance 'push-button :label "Tool" :font (my-findfont 13) :width (scaleh 100)))
	 (menu (make-instance 'menu
		 :items  (let ((mlist nil))
			   (dotimes (i *number-of-demos* (nreverse mlist))
			     (setf mlist 
			       (cons (list (format nil "Demo ~a" (1+ i)) 
					   `(lambda () 
					      (demo ,(1+ i) ,menu-button 
						    ,exit-button ,tool-button ,disp))
					   (make-title (1+ i)))
				     mlist))))
		 
		 :font (my-findfont 13) :query " DEMOS ")))
    
    (setf (menu menu-button) menu)
    
    (copy-mask *pail-logo* 0 0 disp
	       (- (width disp) (cw:bitmap-width *pail-logo*) (scalew 15))
	       (- (height disp) (cw:bitmap-height *pail-logo*) (scaleh 15)))
    
    (setf (font disp) (my-findfont 16.5 ))
    (write-display disp
		   "Welcome to ..."
		   (scalew 15) (- (height disp) (scaleh 15) (cw:font-ascent (font disp))))
    (setf (font disp)  (my-findfont  22))
    (write-display disp
		   "Chart Parsing"
		   (scalew 20)
		   (- (height disp) (scaleh 80) (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)
    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) (scalew 15))
		:bottom (scaleh 25)
		:action `(lambda nil
			   (close-display ,disp)
			   (close-display *verbose-disp*)
			   (sleep 1)
			   (if ,from-button (reset-button ,from-button))))
    
    (set-button tool-button disp
		:left (round  (/ (- (width disp) (width menu-button)) 2))
		:bottom (scaleh 25)
		:action `(lambda nil 
			   (disable-button ,exit-button)
			   (disable-button ,menu-button) 
			   (deactivate-display ,disp)            
			   (parser-tool) 
			   (setq  *execution-terminated* nil)
			   (mp:process-wait "running" 
					    '(lambda nil *execution-terminated*))  
			   (activate-display ,disp)(sleep 1)
			   (reset-button ,tool-button)
			   (enable-button ,exit-button)
			   (enable-button ,menu-button)))
    
    
    (set-button help-button disp
		:left (scalew 15) 
		:bottom (scaleh 25))
    
    
    (set-button menu-button disp 
		:left (round  (/ (- (width disp) (width menu-button))  2))
		:bottom (scaleh 65))
    disp))





(defun make-title (nr)
  (format nil "A ~:R Demo on~%~%    Chart~%      Parsing~%" nr))

(defun make-title-w (nr)
  (format nil "A ~:R Demo on Chart Parsing" nr))


