;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   update_new.cl
;;; Short Desc: Memory management module
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================



(in-package :atp)
;;---------------------------------------------------
;; store        : (CLAUSE x ANCESTORS) --> RULE-ID U {nil}
;; Behavior     : this procedure takes a new rule, and stores it in the
;;              : database: a new identifiers has to be generated, and 
;;              : the properties of the rule are computed and stored in
;;              : $rules-info$. The rule is firstly simplified, and if it is
;;              : a simplifier itself it is used to simplify the other rules.
;;              : A check is done to see whether a copy of the rule is already
;;              : in the database.
;; Side effects : The usual rule indexes are updated, togheter with the sets
;;              : associated with the strategy used. If the new rule is a  contradiction
;;              : the flag $contr$ is also updated.

  

(defmethod store (null-clause ancestors) 
  (cond ((eq 'simp (cadr ancestors))
	 (notify-deletion ancestors)
	;; (princ (car ancestors)) (princ " DELETED BY ") (princ (caddr ancestors)) (nl)
	 (remove-from-sets (car ancestors)
			   (delete-sets (eval $strategy$)))
	 'deleted)))


  ;; Attenzione ho tolto queste perche' se una clausola
  ;; non semplificatore veniva semplificata in un semplificatore esistente, essa 
  ;; veniva comunque aggiunta al database
  ;; pero' togliendole quando un semplificatore e' ulteriormente semplficato
  ;; la chiamata a re-duce-an-new-rule lo fa semplificare con se stesso. Per questo
 ;; ho messo la remove car ancestors.
					; (if (eq 'simp (cadr ancestors))
					; (list renamed-clause)
(defmethod store ((cl clause-class) ancestors)
  (let* ((renamed-clause (internal-renvar (norm (orient-equations cl))))
	 (clause-ancestors (if (is-tautology renamed-clause) renamed-clause
			     
			     (re-duce-a-new-rule renamed-clause
						(if  (eq 'simp (cadr ancestors))
						    (remove (car ancestors) $simps$) $simps$))))
	 (new-ancestors (combine-anc ancestors (cdr  clause-ancestors)))
	 (clause-to-store (norm (car clause-ancestors)))) ;ci vuole if per non ripetere la norm.
    (incf $generated-rules$)
    (cond
     ((is-tautology clause-to-store)
      (cond ((eq 'simp (cadr new-ancestors))
	     (notify-deletion new-ancestors)
	     (remove-from-sets (car new-ancestors)
			       
			       (delete-sets (eval $strategy$)))
	     'deleted)))
     (t (let ((clause-to-store (orient-equations clause-to-store))
	      (id (new-clause-id)))
	  (set id  clause-to-store)
	  (setf (get id 'info) (classify clause-to-store new-ancestors))
	  
	  (if $prolog-mode$ (prolog-ins id))
	  (cond ((eq 'added (add-to-sets id)) 
		 (if (eq 'simp (cadr new-ancestors))
		     (remove-from-sets (car new-ancestors) 
				       (delete-sets (eval $strategy$))))
		 (if  (not (eq
			    $output-format$ 'no-output))
		     (output-clause id))
		 (if (or (is-contradiction clause-to-store ) (is-answer clause-to-store))
		     (setq $contr$ id))
		 (if (and (member id $simps$)
			  t)
			  ;;)
			  ;;; SEE PARA1.th
			;;  (not(eq 'simp (cadr new-ancestors))))
		     (simplify (list id)))
		 id)
		(t (if (eq 'simp (cadr new-ancestors))
		       (progn 
			 (remove-from-sets (car new-ancestors) 
					   (delete-sets (eval $strategy$)))
			 (notify-deletion1 ancestors)))
		   (retract-r-id)
		   nil)))))))

(defun notify-deletion1(ancestors)
  (let ((stream (if *interface* *out-disp* t)))
    (format-display stream "      ~A REDUCED BY ~A INTO AN EXISTENT CLAUSE~%" (car ancestors)(caddr ancestors))))
    
	

(defun notify-deletion(ancestors)
  (let ((stream (if *interface* *out-disp* t)))
    (format-display stream "      ~A DELETED BY ~A~%" (car ancestors)(caddr ancestors))))

;--------------  IL controllo di MAX-WGT viene fatto QUI  --------------

(defun  add-if-not-present (id )
  (cond ($exist-check$
	 (cond ((and t
		     (not(member id $rules$ :test #'exists)) )
		(setq $rules$ (cons id $rules$ ))
		'added)))
	(t  (setq $rules$ (cons id $rules$ ))	 
	    'added)))
	
;
;
;(defun  add-if-not-present (id )
;  (cond ((not(member id $rules$ :test #'exists))
;       (setq $rules$ (cons id $rules$ ))
	; 'added)))


(defun add-to-sets (id)
  (cond ((< (size (get id 'info)) $max-wgt$)
	 
	 (cond ((not  (add-simps id))
		(cond ((eq 'added (add-if-not-present id))
		       (add-ch id)
		       'added)))
	       (t (add-ch id)
		  'added)))
	(t  nil)))

(defun add-simps (id)
  (let ((class-l (classlist (get id 'info)))) 
	(cond ((or *all-simplifier*  
		   (and(not $prolog-mode$) (member 'p class-l))
		   (member 'd class-l)
		   (and (not $prolog-mode$) (member 'en class-l)))
	       (setq $simps$ (cons id  $simps$))))))



(defun add-ch (id)
  (mapcar #' (lambda (s)
	       (set s 
		 (funcall $insert-procedure$ id (eval s))))
	       (insert-sets (eval $strategy$))))
;    (funcall (insert-function (eval  $strategy$)) id (eval s))))

  
  (defun ch-insert1 (id set)
  (sort (cons id  set) #'rule-size-comp))
    
(defun remove-from-sets (id set-list)
  (setq $simps$ (delete id $simps$))
  (setq $rules$ (delete id $rules$))
  (mapcar #'(lambda (s)(set s (delete id (eval s)))) set-list))
  

(defun get-clause (id)(change-class
		       (make-clause (positive-atoms (eval id))
				    (negative-atoms (eval id)))
		       (class-of (eval id))))
 
(defun combine-anc (ancestors1 ancestors2)
  (cond ((or (eq 1 (length ancestors1))
	     (null ancestors2)
	     (not (eq 'simp (cadr ancestors1))))
	 (append ancestors1 ancestors2))
	(t  (list (car ancestors1)
		(cadr ancestors1)
		(append (caddr ancestors1)
			(cadr ancestors2))))))
