;;;----------------------------------------------------------------------------------
;;  29.03.90
;;


;; The routine rr (Remove and Replace) reads a file I , and outputs a file O
;; obtained by removing from I every character present in remlist, and replacing
;; using the pairs contained in replist that is an association list.


(defun rr (fileI remlist replist )
  (let (c p)
    (with-open-file  (fI (concatenate 'string "~/BLENprover/theorems/"
				      (string fileI) )
		      :direction :input)
      (with-open-file  (fO (concatenate 'string "~/BLENprover/tmpth/"
				        (string fileI) )
			:direction :output  
			:if-exists :supersede)
	(loop
	  (setq c (read-char fI nil 'eof))
	  (if (eq c 'eof)(return))
	  (cond ((setq p (assoc c replist))  (princ (cdr p) fO))
		((not (member c remlist))(princ c fO))))))))
      
(defun rr_all ()
  (run-shell-command "ls ~/BLENprover/theorems   > tmpdirect")
  (with-open-file (dir "tmpdirect"
		   :direction :input)
    (let (thname)
      (loop
	(setq thname (read-line dir))
	(print (list 'PROCESSING thname))
	(rr thname '(#\^M  #\^z #\:) '())))))

(defun ls_list (string)
  (run-shell-command (concatenate 'string "ls " string "  > tmpdirect" ))
  (with-open-file (dir "tmpdirect"
		   :direction :input)
    (let (name dirlist)
      (loop 
	(setq name (read-line dir nil 'eof)) 
	(if (eq  'eof name)
	    (progn 
		(run-shell-command "rm tmpdirect" )
		(return dirlist)))
	(setq dirlist (append dirlist (list name)))))))

(defun ls_theorems (string)
   (run-shell-command (concatenate 'string
		       "cd ~/BLENprover/theorems ; ls " string ".th   > /tmp/tmpdirect ; cd .." ))
  (with-open-file (dir "/tmp/tmpdirect"
		   :direction :input)
    (let (name dirlist)
      (loop 
	(setq name (read-line dir nil 'eof)) 
	(if (eq  'eof name)
	    (progn 
		(run-shell-command "rm /tmp/tmpdirect" )
		(return dirlist)))
	(setq dirlist (append dirlist (list name)))))))


(defun convert-equality (th_name)
  (let* ((filename (complete_filename (string th_name)))
	 (fileold (concatenate 'string filename "old")))
		  
    (run-shell-command 
      (concatenate 'string
       "mv " filename " "fileold))
    (princ filename) (nl)(princ fileold)
    (with-open-file ( s fileold :direction :input)
      (with-open-file ( out filename :direction :output  :if-exists :supersede )
	(let* ((line "")(ax nil)(sos nil))
	  (loop 
	    (setq line (read-line s  nil 'eof))
	    (if (eq line 'eof) (return))
	    (setq line (remove '#\   line))
	    (princ line out )(nl out)
	    (if (string-equal "list(axioms)." line)
		(progn 
		  (setq ax  
		    (mapcar #'convert-eq (read_formulas s)))
	       (mapcar #'(lambda (x) (princ "    ")(princ x out )(princ "." out )(nl out)) ax)
		  (princ "end_of_list." out)(nl out)))
	  
	    (if (string-equal "list(sos)."    line)
		(progn 
		  (setq sos  
		    (mapcar #'convert-eq (read_formulas s)))
		(mapcar #'(lambda (x) (princ "    ")(princ x out )(princ "." out )(nl out))sos)
	        (princ "end_of_list." out)(nl out)))))))))

(defun convert-eq (fmla-str)
  (let ((fm (pars (make_token_list fmla-str))))
   (print fm)
    (string_form
     (subst '* 'times 
	    (subst '=< '<=
		   (subst '- 'minus 
			  (subst '+ 'plus (subst  '= 'eq fm))))))))

(defun term-to-string (tm)
  (cond 
   ((atom tm) (format nil "~A" tm))
   ((null (cdr  tm)) (string (car tm)))
   ((is-infix-op (car tm))
    (concatenate 'string "(" 
		 (term-to-string (cadr tm))  
		 " "(string (car tm))" "
		 (term-to-string (caddr tm)) ")"))
   (t
    (concatenate 'string (term-to-string (car tm)) "(" (tm-list-st (cdr tm)) ")" ))))
	       
(defun tm-list-st (tml)
  (cond ((null (cdr tml))  (term-to-string (car tml)))
	(t (concatenate 'string 
	     (term-to-string (car tml))
	     ","
	     (tm-list-st (cdr tml))))))
  
(defun string_form (fm)
  (cond ((atomic_pref fm) ( term-to-string fm))
	((member (car fm)'(& +))
	 (concatenate 'string 
	   (string_form (cadr fm))
	   " " (string (car fm)) " "
	   (string_form (caddr fm))))
	((eq '~ (car fm))
	 (concatenate 'string 
	   " ~"
	   (string_form (cadr fm))))
	((member (car fm) '( all exists))
	 (concatenate 'string
	   (string ( car fm))
	   (string ( cadr fm))
	   (string_form (caddr fm))))))

 
