;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-demo6.cl
;;; Short Desc: Second demo on automated theorem proving
;;;             The source file for the demo theorem is in atp-demo6.th
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :atp)



;;=====================================================================
;; The definition of demo6
;;=====================================================================

(defun more-solutions-demo-6()
  (if *first-run*
      (progn
	(setq *first-run* nil)
	(write-display 
	 *dialog-disp* " x = (((3 * (^2)) + 3) / (^(5) + 3)) " 10 10)
	(format-display-fill demo-text-disp (format nil   
			 "~%The 'messages' display shows a syntactic solution
of the given linear equation. Notice that the problem
with the purely syntactic approach is not only in that
you have to evaluate the answer of the prover to obtain
the right solution: you will see that the  proof itself 
is much more complicated and longer than than the one
obtained by evaluating terms as soon as possible"))
	(when (wait)
	  nil))
    (progn 
      (write-display 
       *dialog-disp* " x = 1.5 " 10 10)
      (format-display-fill demo-text-disp (format nil   
		       "~%The 'messages' display shows the solution of the given
linear equation"))
      (when (wait)
        nil))))
 
(defun choose-file-demo-6 ()
  "atp-demo6.th")

 
(defun display-settings-demo-6 ()
  (protect-display set-disp  t)
  (if *first-run*
      (display-settings-demo-6-1)
    (display-settings-demo-6-2)))


(defun display-settings-demo-6-1 ()
  (format-display-fill demo-text-disp (format nil    "~%We want to prove this theorem using the resolution
method and a 'set-of-support' strategy, so we push
the appropriate buttons
"))
  (when (wait)
    (my-software-push  *p-resolution-but*  set-disp)   (sleep 0.8)
    (my-software-push *neg-resolution-but*  set-disp)  (sleep 0.8)
    (my-software-push *resolution-but*  set-disp)  (sleep 0.8)
    (my-software-push *standard-strategy-but*  set-disp) (sleep 0.8)
    (my-software-push *sos-strategy-but*  set-disp)
   (format-display-fill demo-text-disp (format nil    "~%Now we push the <  OK  > button
"))
    (when (wait)
    (my-software-push *exit-disp-set-but* set-disp))))


(defun display-settings-demo-6-2 ()
  (format-display-fill demo-text-disp (format nil    "~%We want to prove this theorem using the resolution
method and a 'set-of-support' strategy, so we push
the appropriate buttons
"))
  (when (wait)
    (my-software-push  *p-resolution-but*  set-disp)    (sleep 0.8)
    (my-software-push *neg-resolution-but*  set-disp)   (sleep 0.8)
    (my-software-push *resolution-but*  set-disp)   (sleep 0.8)
    (my-software-push *standard-strategy-but*  set-disp)   (sleep 0.8)
    (my-software-push *sos-strategy-but*  set-disp)
   (format-display-fill demo-text-disp (format nil    "~%This time we also select to use semantic 
simplification of evaluable terms"))
   (when (wait)
   (my-software-push *sem-sim-but*  set-disp) 
  
   (format-display-fill demo-text-disp (format nil    "~%Now we push the <  OK  > button
"))
    (when (wait)
      (my-software-push *exit-disp-set-but* set-disp)))))

  


(defun demo-6 ( )
  (setq *theorems-dir*  *len-directory*)
  (setq *first-run* t)
  (setq *demo-in-execution* 6)
  (format-display-fill demo-text-disp (format nil   
		   "~%Normally in symbolic logics theorems are proved eclusively
in a syntactic way: if you substitute terms like (x + y)
with foo(y,x) in some formal system  every theorem still holds. 
However, when reasoning about mathematics or some other
well known domain we generally mix symbolic manipulations
with semantic evaluations.
An example is the way in which we solve linear equations:
this process is normally made of  alternate symbolic deductions  
and semantic evaluations."))
  (when (wait)
  (format-display-fill demo-text-disp (format nil   
		   "~%For instance the rewriting step"))
(format-display-fill demo-text-disp (format nil"(x * (A + y))  ---->> (x * A) + (x * y)"))
(format-display-fill demo-text-disp (format nil"is a syntactic transformation, based of the axiom"))
(format-display-fill demo-text-disp (format nil"(x * (z + y)) =  (x * z) + (x * y)"))
(format-display-fill demo-text-disp (format nil "But a step like"))
(format-display-fill demo-text-disp (format nil "(x * (5 + 6))  ---->> (x * 11)"))
(format-display-fill demo-text-disp (format nil "directly uses the intended meaning of symbol +
as the addition between numbers, so it is a semantic step."))
  (when (wait)
  (format-display-fill demo-text-disp (format nil   
		   "~%The ATP module allows the users to set the semantic
simplification of terms. In this way when a term can be
evaluated it is substituted with its value, with
respect to a standard interpretation. "))
  (when (wait)
  (format-display-fill demo-text-disp (format nil   
		   "~%The next example is a simple linear equation.
We will solve the problem first without and then with  
semantic simplification of terms."))
  (when (wait)
  (setq *view* (make-instance 'help-display
			    :left (scalew 10)
			    :bottom (scaleh 50)
			    :height (scaleh 400)
			    :width(scalew  800)
			    :filename  (add-path (choose-file-demo-6) *len-directory*)))
   (protect-display *view* t)
 
  (format-display-fill demo-text-disp (format nil    "~%Now we call the theorem proving tool"))
   (push *view*  *open-displays-list* )
(when (wait)
  (en) 
(push *view*  *open-displays-list* )
  (protect-display *main-disp* t)
  (protect-display *out-disp* t)
  (protect-display *dialog-disp* t)
  (format-display-fill demo-text-disp (format nil    "~%The <LOAD THEOREM> button loads the theorem file
"))
  (when (wait)  
  (my-software-push *load-file-button* *main-disp*)
  (format-display-fill demo-text-disp (format nil    "~%Now we set some parameters for this proof"))
  (when (wait)  
  (my-software-push *display-setting-button*  *main-disp*)
  (enable-the-right-buttons)
  (format-display-fill demo-text-disp (format nil    "~%Pushing the <Prove Theorem> button ..."))
  (when (wait)
  (my-software-push *proof-th-button* *main-disp*)
  (format-display-fill demo-text-disp (format nil    "~%Here is the complete proof"))
  (my-software-push *show-proof-button* *main-disp*) 
  (when (wait)
  (format-display-fill demo-text-disp (format nil   "~%Now we will prove this theorem with semantic 
simplification.First, we must reload the previous file."))  
   (when (wait)
   (my-software-push *clear-button* *main-disp*)  
   (my-software-push *reload-last-button* *main-disp*)  
   (format-display-fill demo-text-disp (format nil   "~%Then, we change the  options for this theorem"))
   (when (wait)
   (my-software-push *display-setting-button* *main-disp*) 

  (format-display-fill demo-text-disp (format nil    "~%Pushing the <Prove Theorem> button ..."))
  (when (wait)
  (my-software-push *proof-th-button* *main-disp*)

 (format-display-fill demo-text-disp (format nil    "~%Here is the proof tree"))
  (my-software-push *show-proof-tree-button* *main-disp*)
    (setq *open-displays-list* (push (display *browser-disp*)  *open-displays-list* ))
  (format-display-fill demo-text-disp (format nil    "~%Push <Continue> to close the browser")) 
  (when (wait)
  (close-display *browser-disp*) 
   (format-display-fill demo-text-disp (format nil   "~%Now we close the theorem proving tool~%"))
  (when (wait)
  (format-display-fill demo-text-disp (format nil   "~%******* End of the fifth DEMO ********"))

  (close-display *main-disp*)
  (close-display *out-disp* )
  (close-display *dialog-disp*)
  (sleep 1))))))))))))))))