;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename :  weights.cl
;;; Short Desc: Functions to compute weigths of rules
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :atp)




(defun tm-wgt (tm)
  (tm-wgt1 tm 0))
(defun tm-wgt1 (tm nesting)
  (cond ((atom tm) (kst-var-wgt tm))
	(t (+ 3 nesting (apply '+
		       (mapcar 
			#'
			(lambda (tmn)(tm-wgt1  tmn (+ $nested-term-weight$ nesting)))
			(cdr tm))))))))


(defun kst-var-wgt (kv)
  (cond ((is-int-var kv) 1)
  (t   $constant-wgt$)))


;	(t   $constant-wgt$)))
;;      (t  (- $constant-wgt$ (ascii-coefficient kv)))))
;; (t  (- $constant-wgt$ (or (get kv 'coeff) (setf (get kv 'coeff) (ascii-coefficient kv)))))))
    
    
    
;; ATTENZIONE ATTENZIONE devo moltiplicare $constant-wgt$
;; per l'ascii-coefficient del symbolo.
;; per esempio: PROBABILMENTE E" CONVENIENTE SOLO PER lE CLAUSOLE
;; E COMUNQUE DEVO ALL'INIZION CALCOALRE IL PESO DI OGNI COSTANTE
;; ed assegnarlo al symbolo con una setf


(defun ascii-coefficient (sym)
  (let ((num-list (mapcar 'char-code (coerce (format nil "~A"sym) 'list))))
    (num-coeff num-list 1 0)))

(defun num-coeff (num-list n  res)
    (cond ((null num-list)
	 (* 
	  (coerce res 'float)
	  (expt 10
		(- (ceiling (log (coerce res 'float) 10))))))
	 (t (num-coeff (cdr num-list) (1+ n) (+ res (* n (car num-list))))))))

   
   
;;====================================================
;;  Weighting  ruotines
;;====================================================
(defun atm-wgt (at)
  (cond ((atom at) 3)
        (t (+ 3 (apply '+
                       (mapcar #'tm-wgt (cdr at)))))))

(defun st-wgt (nterm)
  (apply '+ (mapcar #' atm-wgt nterm)))

(defmethod agata-wgt ((clause clause-class))
  (+ (* 0.5 (st-wgt (positive-atoms clause)))
     (st-wgt (negative-atoms  clause))))



(defmethod rule-wgt ( (clause clause-class))
  (+ (st-wgt (positive-atoms clause))
     (st-wgt (negative-atoms  clause))))
     

; QUesta dimostra andrews

(defmethod andws-wgt ((clause clause-class))
  (+  (length (positive-atoms clause))
     (* 2  (length (negative-atoms  clause)))))

(defmethod obv-wgt ((clause clause-class))
  (+  (length (negative-atoms clause))
      (length (positive-atoms clause))))

 
(defmethod positive-atoms-first ((clause clause-class))
  (+  (* 100 (length (negative-atoms clause)))
      (* 10 (length (positive-atoms clause)))))
