;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-dialog.cl
;;; Short Desc:  Library of useful functions
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :atp)


;
					
;=================================================================
;; 01.03.1990
;; Library of useful functions
;;=================================================================

(defun nl(&optional s)
  (princ '#\newline s))

(defun rotate (l)
  (append (cdr l) (list (car l))))

(defun mask1 () 
     (nl)
     (princ "-------------------------------------------------------------------  ") 
     (nl)
 nil   )

(defun atom-conc (at1 at2)
  (intern  (concatenate 'string
		      (format nil "~A"  at1)
		      (format nil "~A"   at2))
	   :atp))



(defun equalatom ( a1 a2)
  (or (and (listp a1) (listp a2)
	   (eq-sym (car a1)(car a2))
	   (or (equal (cdr a1)(cdr a2))
	       (equal (cdr a1)(list (caddr a2)(cadr a2)))))
      (equal a1 a2)))
	    
	
(defun head-equal (list sublist)
  (cond ((null sublist) t)
	( (null list) nil)
	((equal (car list) (car sublist)) (head-equal (cdr list)( cdr  sublist)))))

(defun terminates-with (substr str)
 (head-equal  (reverse (coerce str 'list))
	      (reverse (coerce substr 'list))))

(defun rem-dot-th (str)
  (coerce (reverse (cdddr (reverse (coerce str 'list)))) 'string))



(defun mylength (s)
    (cond ((atom s) 0)
          (t (length s))))


(defun p-equal (cl1 cl2)
    (cond 
          ((not (eq (mylength cl1)(mylength cl2))) nil)
          ((eq (length cl1) 0) t)
          (t (p-equal (cdr cl1) (del (car cl1) cl2 )))))

(defun del (x l)
  (cond ((null l) nil)
	((equal x (car l)) (cdr l))
	(t (cons (car l)(del x (cdr l))))))

(defun delall (x l)
    (cond ((null l) nil)
          ((eq x (car l)) (delall x (cdr l)))
          (t(cons (car l) (delall x (cdr l))))))



;;----------------------------------


(defun warn-error (string)
  (if (not *interface*)
      (format t "~%** ATP **: ~A~%" string)
    (if (eq 'Cancel (continue-cancel-dialog string :title "ATP: Warning"))
	(throw 'syntax-error nil))))
      
	    
      
(defun l-error (string)
  (if (not *interface*)
      (format t "~%** ATP **: ~A~%" string)
    (acknowledge-dialog string :title "ATP: Error"))
  (throw 'syntax-error nil))

;;----------------------------------
(defun list-rules ()
   (dolist (x (sorted-copy (append $simps$ $rules$)))
     (output-clause x))) 
(defun sorted-copy (x)
  (let ((y (copy-list x)))
  (sort y 'clause-id< ))) 


(defun two-senses (eqt)
  (cond ((eq '-> (car eqt)) (list (cdr eqt)))
	(t (list (list (cadr eqt)( caddr eqt))
		 (list (caddr eqt)(cadr eqt))))))




(defun is-tautology (clause)
  (null clause))

(defmethod  is-contradiction ((clause clause-class))
  (and  (null (positive-atoms clause))
	(null (negative-atoms  clause))))

(defmethod is-simplifier ((clause clause-class))
  (if (is-contradiction clause) nil
    (or (null (positive-atoms clause))
	(null (negative-atoms  clause)))))

(defmethod is-positive-atom ((clause clause-class))
  (and (null (negative-atoms  clause))
       (eq 1 (length (positive-atoms clause)))))

(defmethod is-negative-atom ((clause clause-class))
  (and (null (positive-atoms clause))
       (eq 1 (length (negative-atoms  clause)))))


(defun is-equation (equt)
  (and (listp equt)
       (member (car equt) '(= ->)))) 

(defun collect-equations (st)
  (if $para-backtrack$
      (mapcan #'(lambda (at) (if (is-equation at) (list at))) st)
      (mapcan #'(lambda (at) (if (is-rew-rule at) (list at))) st)))
   
	

;;=================================================================
;; Generation of new symbols
;;

(defun init-gsym ()
 (setq -sym-table (make-hash-table)))

(defun gsym (c)
    (let ((n  (gethash c -sym-table )))
    (cond ((null n)(setf (gethash c -sym-table) 0)
                   (build c 0))
          (t (setf (gethash c -sym-table)  (+ 1 n))
             (build c (+ 1 n))))))

(defun build (at n)
   (read-from-string (coerce (append (coerce (string at) 'list)
	                            (coerce  (int-string n) 'list)) 'string)))   

(defun int-string (n &optional temp)
   (let ((nn) (rest))
   (cond (( < n 10) (coerce (cons (digit-char n) temp) 'string))
        (t (multiple-value-setq (nn rest) (floor n 10))
           (int-string nn (cons (digit-char rest) temp))))))
