;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-dialog.cl
;;; Short Desc: Graphical Interface for the theorem prover
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :atp)



;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================

(defparameter *interface* nil)

(defvar *default-width*   )
(defvar *default-left*    ) 
(defvar *tool-but-width*  )
(defvar *tool-but-height* )
(defvar *tool-but-font*)
(defvar *tool-win-height* )

(defvar *out-win-height*  )
(defvar *msg-win-height*  )
(defvar *last-theorem* "" )

(defvar *theorem-loaded*)
(defvar *aborted* )
(defvar *only-list-db* nil)
(defvar *contradiction*)
(defvar *dialog-disp*)
(defvar *out-disp*)
(defvar *main-disp*)
(defvar *execution-terminated* nil)
(defvar *open-displays-list* nil)    
 

(defun my-findfont (expected-font-size)
  ;; For a window of width width, which was designed to be with
  ;; expected-width, which originally had a font size expected-font
  ;; (integer), this returns a more or less appropriately sized font.  
  (let ((size (/ (* expected-font-size *default-width*) *original-default-width*)))
    (cond
   ;;  ((< size 8.5) gin::*small-font-8*)
     ((< size 9.5) gin::*small-font-9*)
     ((< size 10.5) gin::*small-font*)
     ((< size 11.5) gin::*small-font-11*)
     ((< size 13.5) gin::*bold-font*)
     ((< size  14.5) (open-font :courier :roman 15 :weight :bold))
    ((< size  16.5)  (open-font :courier :roman 18 :weight :bold))
     (t gin::*big-bold-font*))))
     
;;----------------------------------------------------------------------------

(defclass parameter-button (push-button)
  ((parameter :initarg :parameter
	      :accessor parameter)
   (name      :initarg :name
	        :initform ""
	      :accessor name)
   (doc-message      :initarg :doc-message
	      :initform ""
	      :accessor doc-message)
   (value     :initarg :value
	      :accessor value)))
  

(defclass radio-parameter-button (radio-button)
  ((parameter :initarg :parameter
	      :accessor parameter)
   (value :initarg :value
	   :initform nil
	   :accessor value)))
 
(defun atp-close-display (d display)
  (setq  *open-displays-list* (remove d *open-displays-list*))
  (close-display d))

(defun true-height (x)
  (+ (height x)  10))
 
(defun  scalew (x ) 
  (round (* x (/ (width *root-window*) *original-screen-width*))))
(defun  scaleh (x )
  (round (* x (/ (height *root-window*) *original-screen-height*))))

;;==============================================================================

    
 
(defun en()
  (setq *last-theorem* "")
  (setq *theorem-loaded* nil)  
  (setq *files-button* nil)
 (if (not *demo-in-execution*) (setq *theorems-dir* 
    (add-subdir *len-directory* *theorems-subdir*)))
  (setq *execution-terminated* nil)
  (setq *open-displays-list* nil)    
  (setq *contradiction* nil)
  (setq *aborted* nil)
  (setq *interface* t)
  (setq *choose-file-first-time* t)
 (init-parameter-buttons)
  (defconstant *button-list1*  '(*load-file-button* *proof-th-button* *reload-last-button*
				 *show-proof-button*  *show-proof-tree-button*
				 *display-setting-button* *clear-button*
				 *list-db-button* *prolog-button*  *tool-help-button* *exit-button* )) 
  (defconstant *button-list-no-exit*  '(*load-file-button* *proof-th-button* *reload-last-button*
				 *show-proof-button*  *show-proof-tree-button*
				 *display-setting-button* *clear-button*
				 *list-db-button* *prolog-button*))
  (defconstant *display-list* '( *main-disp* *out-disp* *dialog-disp* ))
  
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
 ;                              DISPLAYS
 
  (setf  *dialog-disp*(make-instance 'display   :title "ATP: Messages"  
				     :font (my-findfont   14)
				     :width *default-width* :height *msg-win-height* 
				      :left *default-left*  :bottom (scaleh 10)))
  (push  *dialog-disp* *open-displays-list*)
  (setf *out-disp* (make-instance 'scroll-display   :title "ATP: Output" 
				   :width *default-width* 
				   :font (my-findfont  12)
				   :height (if *demo-in-execution* (scaleh 260) *out-win-height*)
				   :left *default-left*
				   :bottom (+ (bottom *dialog-disp*)
					      (true-height *dialog-disp*))))
   (push  *out-disp* *open-displays-list*)
;;;  (setf (font *out-disp*) *small-font*) 
 (setf *main-disp* (make-instance 'display   :title "ATP: Commands" 
				    :width *default-width* :height *tool-win-height*
				    :left *default-left*  :bottom (+  (bottom *out-disp* )
							   (true-height *out-disp* ))))
   (push  *main-disp* *open-displays-list*)
  ;;  (setf (reshape-method *main-disp*) (function(lambda () (redispose-buttons))))
  ;;======================BUTTONS===================================
  (setf *load-file-button*  (make-instance 'push-button :label "Load Theorem" :width *tool-but-width*
					:font  *tool-but-font* :height *tool-but-height*   :action 'choose-file))
  
  (setf *proof-th-button* (make-instance 'push-button :label "Prove Theorem" :width *tool-but-width*
					:font  *tool-but-font* :height *tool-but-height*  :action 'p-t))
  (setf *show-proof-button* (make-instance 'push-button :label "Show Proof" :width *tool-but-width*
					:font  *tool-but-font*  :height *tool-but-height*   :action 'show-proof))
  (setf *show-proof-tree-button* (make-instance 'push-button :label "Show Proof Tree" :width *tool-but-width*
						:font  *tool-but-font* :height *tool-but-height* :action 'show-proof-tree))
  (setf *display-setting-button* (make-instance 'push-button :label "Theorem Parameters" :action 'display-settings
						:font  *tool-but-font* :height *tool-but-height* :width *tool-but-width*))
  (setf *prolog-button*  (make-instance 'push-button :label "Prolog Session" :width *tool-but-width* 
					:font  *tool-but-font* :height *tool-but-height* :action 'prolog-interpreter))
  (setf *clear-button*  (make-instance 'push-button :label "Clear Output" :width *tool-but-width* 
				    :font  *tool-but-font*   :height *tool-but-height*  :action 'clear-out))
  (setf *list-db-button*  (make-instance 'push-button :label "List Database" :width *tool-but-width* 
					    :font  *tool-but-font*     :height *tool-but-height*  :action 'list-db))
  (setf *tool-help-button*  (make-instance 'help-button :subject "Automated Theorem Proving Tool" 
					:font  *tool-but-font* :height *tool-but-height*    :label "Help" :width *tool-but-width*
					   :technical(add-path "atp-tool-tec.asc" *len-directory*)
					   :general(add-path "atp-tool-desc.asc" *len-directory*) ))
				 
  (setf *exit-button*  (make-instance 'push-button :label "Exit" :width *tool-but-width* 
				:font  *tool-but-font*     :height *tool-but-height*   :action 'exit-function))
  (setf *reload-last-button*  (make-instance 'push-button :label "Load Previous" :width *tool-but-width* 
					:font  *tool-but-font* :height *tool-but-height*      :action 'reload-last))
  (add-buttons *button-list1* *main-disp*)
  (enable-the-right-buttons))

(defun redispose-buttons() 
  (dolist (b  *button-list1* )
    (unset-button (eval b))
    (setf (region (eval b)) nil))
  (setf (cw::window-stream-right-margin 
	 (window *main-disp*)) (width *main-disp*))
  (setf (cw::window-stream-right-margin 
	 (gi::pattern *main-disp*)) (width *main-disp*))
  
  (add-buttons *button-list1* *main-disp*)(enable-the-right-buttons))

  
(defmethod add-buttons (button-list (disp display))
  ;(protect-display*main-disp* t)
  (check-size (eval (car button-list))disp (length button-list))
  (let ((left (scalew 2))
	(bottom (- (height disp) (+  (scalew 2) *tool-but-height*))))
    (dolist (b-id button-list)
      (let ((b  (eval b-id)))
	(if( >  (+ (width b)left) (width disp))
	    (progn
	      (setq left  (scalew 2))(setq bottom (- bottom (height b)))))
	(setf (left  b)left)
	(setf (bottom  b) bottom)
	(set-button b disp :active nil)
        (setq left (+ left (width b)))))))
  ;(protect-display*main-disp* nil))

(defmethod check-size ((b push-button) (disp display) n-but)
  (let* ((columns (truncate (width disp) (width b)))     
	 (the-rows ( ceiling n-but columns))
	 (mininum-height  (* the-rows (height b))))
    (if (< (height disp) mininum-height)
	(setf (height disp) mininum-height))))
    
   
(defun unset-buttons  (bl)
   (dolist ( b bl )(unset-button  (eval b))))
     

(defun exit-function ()
 (disable-button (mapcar 'eval *button-list1*))
  (if (eq (my-y-or-n-dialog "    Really Exit?    ") 'Yes)
      (progn
	(dolist (d *open-displays-list*)
	  (close-display (eval d)))
	(setq *interface* nil)
	(setq *execution-terminated* t ))
    (enable-the-right-buttons)))

(defmethod read-query-from-window ((d display))
  (if *demo-in-execution*
       (read-query-from-window-demo *demo-in-execution*)
     (read-query-from-window-main d)))


(defmethod read-query-from-window-main ((d display))
  (clear-display d) (write-display d  "|? " 5 5)
  (let* ((string  (read-display d 35 5))
	 (token-list (make-token-list string))
	 (goal-pair (goal  (cons '<=  token-list)))
	 (goal-fmla (car goal-pair)) (error (cdr  (cdr goal-pair)))
	 (neg-pos   (bipart-clause (car (clausify-main goal-fmla))))
	 (goal-clause  (renvar-for-internal (make-clause nil (car neg-pos))))
	 (answer-lit (cons '$ans  (collect-integer-vars 
				   (negative-atoms goal-clause)))))
    (cond ( error 
	    (acknowledge-dialog 
	     (format nil "Syntax error in ~A~%" string)
	     :title "ATP: Error")
	    'error)
	  (t  
	   (setq $user-vars$ (collect-vars goal-fmla))
	   (make-clause nil (append (negative-atoms goal-clause)
				    (list  answer-lit)))))))
   
   
 
    
(defun prolog-interpreter()
    ;(protect-display*main-disp* t)
  (setq *contradiction* nil)
  (setq $contr$ nil)
  (setq *only-list-db* t)
  (dolist (b (remove *list-db-button* *button-list-no-exit*))(disable-button  (eval b)))
   ;(protect-display*main-disp* nil)
  (setf (title *dialog-disp*) "Prolog Interpreter: type in a query ('exit' to end)")
  (let ((query nil))
    (loop 
        (enable-button  *list-db-button* )
      (setq $contr$ nil)
      (restore-r-id)
      (clear-display *out-disp*)
      (setq $rules$ (cdr $program$))
      (clear-display *out-disp*)
      (setq $goal-stack$ nil) 
      (clear-display *dialog-disp*)
      (loop
	(setq query  (read-query-from-window *dialog-disp*))
	(if (not (eq 'error query))(return)))
      (if (eq '|exit|  (car (negative-atoms query)))
	  (progn (clear-display *dialog-disp*)
		 (reset-button *prolog-button*) 
		 (dolist (b *button-list-no-exit* )(enable-button (eval b)))
		 (setf (title *dialog-disp*) "ATPlenprover: Messages")
		 (setq *only-list-db* nil)
		 (return)))
      (store  (prolog-sem-red query) '(sos))
      (disable-button *list-db-button* )
      (loop
	(let* ((x-y (prolog-choose))
	       (x (car x-y))(y (cadr x-y)))
	  (if (member nil x-y) 
	      (return (progn (clear-display *dialog-disp*)
			     (write-display  *dialog-disp* " no" 5 5 ))))
	  (make-deductions x y)
	  (if (contradiction) 
	      (progn
		(setq *contradiction* t)
		(if  (more-solutions) 
		    (setq $contr$ nil)
		  (return 'contradiction))
		(clear-display *out-disp*)
		)))))))
      
 

(defun  choose-file ()
  ;(protect-display*main-disp* t)
  (setq *contradiction* nil)
  (dolist (b *button-list-no-exit* )(disable-button  (eval b)))
   ;(protect-display*main-disp* nil)
  (setq filename 
    (if *demo-in-execution*
	(choose-file-demo *demo-in-execution*)
      (choose-file-dialog)))

    (if   (open (concatenate 'string (namestring *theorems-dir*) filename)
		   :direction :input 
		   :if-does-not-exist nil)
	(progn
	  (write-display *dialog-disp*  
			 (format nil "Loading ~A ..." filename)
			 5 50)
	  (setf (title *out-disp*)
	    (concatenate 'string  "ATP: Output  ----   Current theorem:    "
			  (namestring *theorems-dir*) filename))
	  (catch 'syntax-error (preproc1 filename))
	  (if (not (string= "" filename)) (setq *last-theorem* filename))
	  (if (and (eq 0  *errors-found*)(not (string= "Canceled" filename)))
	      (setq *theorem-loaded* t))))
    
  (clear-display *dialog-disp* )
  (reset-button *load-file-button*)
  (if (and (not (string= "Canceled" filename))
	   $contr$ )
	   (progn 
		(setq *contradiction* t)
		(notify-results)))
  (enable-the-right-buttons))
  

(defun reload-last()
   ;(protect-display*main-disp* t)
  (setq *contradiction* nil)
  (dolist (b *button-list-no-exit* )(disable-button  (eval b)))
   ;(protect-display*main-disp* nil)
  (clear-display *dialog-disp* )
  (write-display *dialog-disp*  
		 (format nil "Loading ~A ..." *last-theorem*)
		 5 50)
  (catch 'syntax-error (preproc1  *last-theorem*))
  (clear-display *dialog-disp* )
  (reset-button *reload-last-button*)
  (if $contr$ (setq *contradiction* t)) 
  (if (eq 0  *errors-found*)(setq *theorem-loaded* t))
  (enable-the-right-buttons))

(defun p-t () 
  ;(protect-display*main-disp* t)
  (let ((pause-disp (make-instance 'display   
		      :left (scalew 200)
		      :bottom (scaleh 600)
		      :height  (scaleh 100)
		      :width   (scalew 180)
		      :title "Looking for a proof"))
	(pause-b    (make-instance 'push-button :width (scalew 160)
				   :height (scaleh 20) :font  (my-findfont 14) :label "  Pause   "))
	(continue-b (make-instance 'push-button :width (scalew 160)  
				   :height (scaleh 20) :font   (my-findfont 14) :label " Continue "))
	(abort-b    (make-instance 'push-button :width (scalew 160)  
				   :height (scaleh 20) :font  (my-findfont 14) :label "  Abort   "))
	(the-action nil))
    (if $prolog-mode$ (setq $simps$ nil))
    (push pause-disp  *open-displays-list*)
    (setq *theorem-loaded* nil)
    (setq *aborted* nil)
    (set-button pause-b     pause-disp :left (scalew 10) :bottom (scaleh  10)
		:action (function (lambda nil(setf the-action 'pause))))
    (set-button continue-b  pause-disp :left (scalew  10) :bottom (scaleh 40)
		:active nil :action (function (lambda nil (setf the-action 'continue))))
    (set-button abort-b     pause-disp :left (scalew 10) :bottom (scaleh 70)
		:action (function (lambda nil (setf the-action 'abort)(setq *aborted* t))))
    
    (if (or (eq $strategy$ '*man*)
	    *demo-in-execution* )
	 (protect-display pause-disp t))
     (if (eq *demo-in-execution* 4)
	 (if *first-run*  (setq  *demo-4-loop* 0)))
	     
   (dolist (b *button-list-no-exit* )(disable-button (eval b)))
    (protect-display *main-disp* nil)
    (loop
      (if (eq the-action 'pause)
	  (progn
	    (disable-button pause-b) (enable-button continue-b) 
	    (reset-button  continue-b)
	    (do ()((not (eq the-action 'pause))))))
     
      (if (and (eq *demo-in-execution* 4) *first-run*) 
	  (progn 
	    (incf *demo-4-loop*)
	    (if (> *demo-4-loop* 100) 
		(progn
		  (setq *first-run* nil)
		  (my-software-push  abort-b     pause-disp)))))
      
      (if (eq the-action 'abort)
	  (progn (close-display  pause-disp) (return 'consistent)))
      (if (eq the-action 'continue)
	  (progn 
	    (setf the-action nil)  (reset-button  pause-b)
	    (enable-button pause-b)   (reset-button  continue-b)
	    (disable-button continue-b)))
      (if  (contradiction) 
	  (progn 
	    (setq *contradiction* t)
	    (if  (more-solutions) 
		(setq $contr$ nil)
	      (return 'contradiction))))
      (let* (( x-y (funcall (choose-clauses-function (eval $strategy$))))
	     ( x (car x-y))(y (cadr x-y)))
	(if (member nil x-y) (return 'consistent))
	(make-deductions x  y)))
    
    (close-display  pause-disp)
    (notify-results)(sleep 0.1) (enable-button *proof-th-button*) 
   (reset-button *proof-th-button*)(disable-button *proof-th-button*)
   (if *demo-in-execution* (progn (enable-button *proof-th-button*) 
				  (disable-button *proof-th-button*)))
    (enable-the-right-buttons) ))


					;      (let* (( x-y (funcall (choose-clauses-function $strategy$)))
					;     ( x (car x-y))(y (cadr x-y)))
					;(if (member nil x-y) (return 'consistent))
					;(make-deductions x  y)))


(defun show-proof ()
   (protect-display *main-disp* t)
  (dolist (b *button-list-no-exit* )(disable-button (eval b)))
   (protect-display *main-disp* nil)
  (format-display   *out-disp*
		  "~%        P R O O F ~%")
  (trace-proof-i)
  (reset-button *show-proof-button*)
   (enable-the-right-buttons))
  
(defun list-db ()
   (protect-display *main-disp* t)
  (clear-scroll *out-disp*)
  (if (not *only-list-db*) (dolist (b *button-list-no-exit* )(disable-button (eval b))))
   (protect-display *main-disp* nil)
  (list-rules)
  (reset-button *list-db-button*)
  (if (not *only-list-db*)(enable-the-right-buttons)))
  

(defun clear-out()
  (clear-scroll *out-disp*)
  (reset-button *clear-button*))
 
  

(defun show-proof-tree ()
   (protect-display *main-disp* t)
  (dolist (b *button-list-no-exit* )(disable-button (eval b)))
   (protect-display *main-disp* nil)
  (proof-tree 2)
  (reset-button *show-proof-tree-button*)
   (enable-the-right-buttons))
     
(defmethod  error-and-continue (message)
  (let (( subdisp (make-instance 'display   
		   :left  (scale 115)
		   :bottom (scaleh 90)
		   :title "Warning"
                   :font *small-font*
		   :width (scalew 200) :height (scaleh 100)))
	( continue-button (make-instance 'push-button :label "Continue")))
     (push  subdisp *open-displays-list*)
    (write-display subdisp message 5 50)
    (set-button continue-button subdisp :left (scalew 50) :bottom (scaleh 5) 
		:action `(lambda nil (close-display ,subdisp)))
    (loop (if (eq 1 (status continue-button))(return)))))


;-------------------------------------------------------------

(defun my-y-or-n-dialog (query &key (title "Please Click"))
  (let ((dw (make-instance 'display   :width  (+ 10 (cw::font-string-width *small-font* query) )
			   :left (scalew 576)
			   :font *small-font*
			   :bottom (scaleh 630)
			   :height (scaleh 80)
			   :title title))
	(done nil)
	(yb (make-instance 'push-button :label " Yes " :font *small-font* ))
	(nb (make-instance 'push-button :label " No  " :font *small-font* )))
    (push  dw *open-displays-list*)
    (write-display dw query (scalew 10)(scaleh  60))
    (set-button yb dw   :left (scalew 10) :bottom (scaleh 10) :action (function (lambda (&rest cw-internals)
							      (declare (ignore cw-internals))
							      (setf done 'Yes))))
    (set-button nb dw :left (- (width dw) 10 (width nb))
		:bottom (scaleh 10) :action (function (lambda (&rest cw-internals)
							       (declare (ignore cw-internals))
							       (setf done 'No))))
    (mp:process-wait "Exit"   #'(lambda nil done))
    (cw:flush (window dw))
    done))




(defun continue-cancel-dialog (query &key (title "Please Click"))
  (let* ((font (my-findfont  14))
	 (dw (make-instance 'display   :width (if (> (cw::font-string-width font query)  (scalew 185))
						  (+ (cw::font-string-width font query)  (scalew 20))
						(scalew  205))
			    :left (scalew 200) :font font
			    :bottom (scaleh 500)
			    :height (scaleh 100)
			    :title title))
	 (done nil)
	 (yb (make-instance 'push-button :font font :label "Continue"))
	 (nb (make-instance 'push-button :font font :label " Cancel ")))
    (push  dw *open-displays-list*)
    (write-display dw query  (scalew 10 )(scaleh 70))
    (set-button yb dw :left (scalew 10) :bottom (scaleh 4) :action (function (lambda (&rest cw-internals)
									       (declare (ignore cw-internals))
									       (setf done 'Continue))))
    (set-button nb dw :left (scalew 120) :bottom (scaleh 4) :action (function (lambda (&rest cw-internals)
										(declare (ignore cw-internals))
										(setf done 'Cancel))))
    
    (mp:process-wait "Exit"   #'(lambda nil done))
    (cw:flush (window dw))
    done))

(defun acknowledge-dialog (query &key (title "Please Click"))
  (let* ((font (my-findfont  14))
	 (dw (make-instance 'display   :width  (if (> (cw::font-string-width font query) (scalew 185))
						   (+ (cw::font-string-width font query) (scalew 20) )
						 (scalew  205))
			    :left (scalew 100) :font font
			    :bottom (scaleh 500)
			    :height (scaleh 100)
			    :title title))
	 (done nil)
	 (yb (make-instance 'push-button :font font :label "Continue")))
    (push  dw *open-displays-list*) (write-display dw query (scalew 10) (scaleh 50))
    (set-button yb dw :left  (scalew 15) :bottom (scaleh 4) :action (function (lambda (&rest cw-internals)
											      (declare (ignore cw-internals))
											      (setf done 'Continue))))
    (mp:process-wait "Exit"   #'(lambda nil done)) 
    (cw:flush (window dw))
    done))




(defun enable-the-right-buttons()
  (let ((bl *button-list1*))
    (if (not  *contradiction*)
	(setq bl
	  (remove '*show-proof-button*
		  (remove '*show-proof-tree-button* bl))))
    (if (string= "" *last-theorem*)
	(setq bl
	  (remove '*reload-last-button* bl)))
    (if (not *theorem-loaded*)
	(setq bl
	  (remove  '*proof-th-button* bl)))
    (if (not $prolog-mode$)(setq bl
			     (remove  '*prolog-button* bl)))
    (dolist (b bl)
      (my-enable-button b))))

;	    (remove '*display-setting-button* bl))))


(defun my-enable-button (b)
  (setf (status (eval  b)) -1)
  (enable-button (eval b)))
  
;;==================CHANGING ATP PARAMETERS ======================
;;========= PARAMETER BUTTONS

(defun init-parameter-buttons()
  (setf *on-off-buttons-list* 
    '( *resolution-but* *factor-but*  *p-resolution-but* *neg-resolution-but*  
      *paramodulation-but* *restricted-paramodulation-but* 
      *sem-sim-but* *answering-but*))
  
  (setf *strategy-buttons-list*
    '(*standard-strategy-but* *sos-strategy-but* *manual-strategy-but* *prolog-strategy-but*))
  
  (setf *insert-proc-buttons-list*
    '(*smallest-ins-but* *lifo-ins-but* *fifo-ins-but*))
  
  (setf *output-format-buttons-list*
    '(*clause-format-but* *sequent-format-but* *prolog-format-but*   *no-output-format-but*))
  
  (setf  *neg-resolution-but*
    (make-instance 'radio-parameter-button 
       :font (my-findfont  14)
:label "Negative Resolution    "
      :parameter '$neg-resolution$
      :value t :font (my-findfont 14)
      :status $neg-resolution$))
  (setf  *resolution-but*
    (make-instance 'radio-parameter-button 
      :label "Binary Resolution      "
      :parameter '$resolution$ :font (my-findfont 14)
      :value t
      :status $resolution$))
  (setf  *p-resolution-but*
    (make-instance 'radio-parameter-button 
      :label "Positive Atom Resolution    "
      :parameter '$p-resolution$
      :value t :font (my-findfont 14)
      :status $p-resolution$))
  (setf  *restricted-paramodulation-but*
    (make-instance 'radio-parameter-button 
      :label "Restricted Paramodulation   "
      :parameter '$restricted-paramodulation$
      :value t :font (my-findfont  14)
      :status $restricted-paramodulation$))
  (setf  *paramodulation-but*
    (make-instance 'radio-parameter-button 
      :label "Paramodulation         "
      :parameter '$paramodulation$
       :value t :font (my-findfont 14)
      :status $paramodulation$))
  (setf  *factor-but*
    (make-instance 'radio-parameter-button 
      :label "Factorization       "
      :parameter '$factoring$
      :value t :font (my-findfont 14)
      :status     $factoring$))
  
  (setf  *sem-sim-but*
    (make-instance 'radio-parameter-button 
      :label "Semantic simplification"
      :parameter '$semantic-simplification$
      :value t :font (my-findfont 14)
      :status     $semantic-simplification$))
  
  (setf  *answering-but*
    (make-instance 'radio-parameter-button 
      :label "Answering              "
      :parameter '$answering$
      :value t :font (my-findfont 14)
      :status     $answering$))
  
  
  
  (setf  *sos-strategy-but*  
    (make-instance 'radio-parameter-button 
      :label "Set of Support         "
      :parameter '$strategy$ :font (my-findfont 14)
      :status     (eq $strategy$ '*sos*)
      :value  '*sos*))
  
  
  
  (setf  *prolog-strategy-but*  
    (make-instance 'radio-parameter-button 
      :label "Prolog Strategy        "
      :parameter '$strategy$ :font (my-findfont 14)
      :status     (eq $strategy$ 'prolog-strat)
      :value  'prolog-strat))
  
  
  
  (setf  *manual-strategy-but*  
    (make-instance 'radio-parameter-button 
      :label "Manual Strategy        "
      :parameter '$strategy$ :font (my-findfont 14)
      :status     (eq $strategy$ '*man*)
      :value  '*man*))
  
  
  
  (setf  *standard-strategy-but*  
    (make-instance 'radio-parameter-button 
      :label "Standard               "
      :parameter '$strategy$ :font (my-findfont 14)
      :status     (eq $strategy$ 'standard)
      :value  'standard))
  
  (setf  *fifo-ins-but*  
    (make-instance 'radio-parameter-button 
      :label "First in First Out     "
      :parameter '$insert-procedure$ :font (my-findfont  14)
      :status     (eq $insert-procedure$ 'fifo-ins)
      :value  'fifo-ins))
  
  (setf  *lifo-ins-but*  
    (make-instance 'radio-parameter-button 
      :label "Last in First Out     "
      :parameter '$insert-procedure$ :font (my-findfont 14)
      :status     (eq $insert-procedure$ 'lifo-ins)
      :value  'lifo-ins))
  
  (setf  *smallest-ins-but*  
    (make-instance 'radio-parameter-button 
      :label "Smallest First     "
      :parameter '$insert-procedure$ :font (my-findfont 14)
      :status     (eq $insert-procedure$ 'smallest-ins)
      :value  'smallest-ins))
  
  
  (setf  *clause-format-but*  
    (make-instance 'radio-parameter-button 
      :label "Clause Format     "
      :parameter '$output-format$ :font (my-findfont 14)
      :status     (eq $output-format$ 'clause)
      :value  'clause))
  
  (setf  *prolog-format-but*  
    (make-instance 'radio-parameter-button 
      :label "Prolog Format     "
      :parameter '$output-format$ :font (my-findfont 14)
      :status     (eq $output-format$ 'prolog)
      :value  'prolog))
  
  (setf  *sequent-format-but*  
    (make-instance 'radio-parameter-button 
      :label "Sequent Format     "
      :parameter '$output-format$ :font (my-findfont 14)
      :status     (eq $output-format$ 'sequent)
      :value  'sequent))
  
  (setf  *no-output-format-but*  
    (make-instance 'radio-parameter-button 
      :label "No output "
      :parameter '$output-format$  :font (my-findfont 14)
      :status     (eq $output-format$ 'no-output)
      :value  'no-output))
  
  
  (setf *exit-disp-set-but* (make-instance 'push-button :width (scalew 120) 
					   :font (my-findfont 14)
					   :label "OK"))
  (setf *help-disp-set-but* (make-instance 'help-button   :width  (scalew 120)
                              :label "HELP" :font (my-findfont  14)
			      :subject "Theorem parameters"
			      :general (add-path "atp-param-desc.asc" *len-directory*)
			      :technical(add-path "atp-param-tec.asc" *len-directory*))))



(defun display-settings()
  (protect-display *main-disp* t)
  (dolist (b *button-list-no-exit* )(disable-button  (eval b)))
  (protect-display *main-disp* nil)
  (let ((done nil)(h (scaleh 25)))
    (setq set-disp (make-instance 'display   :title "Theorem Parameters" :width (scalew 380 )
				   :height (scaleh 680) :left (scalew 5) :bottom (scaleh 20)))
    
    (set-button *help-disp-set-but* set-disp :left (scalew 30) :bottom (scaleh 5))
					  
    
    (set-button *exit-disp-set-but* set-disp :left (scalew 180) :bottom (scaleh 5)
		:action (function (lambda ()(setq done t)))) 
    
    
    (push  set-disp *open-displays-list*)
    (dolist ( but-name  *on-off-buttons-list*)
      (setq  h (+ h (scaleh 25)))
      (setf (status (eval but-name)) (eval  (parameter (eval but-name))))
      (set-button (eval but-name) set-disp :left (scalew 20) :bottom h
		  :action `(lambda ()
			     (set (parameter  ,but-name) 
				  (status  ,but-name)))))
    (setq  h (+ h (scaleh 25)))
    (write-display set-disp "Inference Rules" (scalew 10) h)
    (setq  h (+ h (scaleh 20)))
    (draw-line set-disp  0 h  (width set-disp) h)
    
    (dolist ( but-name  *strategy-buttons-list*)
      (setq  h (+ h (scaleh 25)))
      (setf (status (eval but-name))
	(eq (eval(parameter (eval but-name))) (value  (eval but-name))))
      (set-button (eval but-name) set-disp :left (scalew 20) :bottom h
		  :action `(lambda ()
			     (if (status ,but-name) (progn
						      (set (parameter  ,but-name) 
							   (value  ,but-name))
						      (funcall (init-function (eval (value ,but-name))))
						      (restore-strategy-sets))))))
    (setq  h (+ h (scaleh 25)))
    (write-display set-disp "Strategy" (scalew  10) h)
    (setq  h (+ h (scaleh 20)))
    (draw-line set-disp  0 h  (width set-disp) h)
    
    (dolist ( but-name  *insert-proc-buttons-list*)
      (setq  h (+ h (scaleh 25)))
      (setf (status (eval but-name))
	(eq (eval(parameter (eval but-name))) (value  (eval but-name))))
      (set-button (eval but-name) set-disp :left (scalew 25) :bottom h
		  :action `(lambda () (if (status ,but-name) 
					  (progn
					    (set (parameter  ,but-name) 
						 (value  ,but-name)))))))
    (setq  h (+ h (scaleh 25)))
    (write-display set-disp "Insertion Procedure" (scalew 10) h)
    
    (setq  h (+ h (scaleh 20)))
    (draw-line set-disp  0 h  (width set-disp) h)
    
    (dolist ( but-name  *output-format-buttons-list*)
      (setq  h (+ h (scaleh 25)))
      (setf (status (eval but-name))
	(eq (eval(parameter (eval but-name))) (value  (eval but-name))))
      (set-button (eval but-name) set-disp :left (scalew 25) :bottom h
		  :action `(lambda () 
			     (if (status ,but-name) 
				 (progn
				   (set (parameter  ,but-name) 
					(value  ,but-name)))))))
    (setq  h (+ h (scaleh 25)))
    (write-display set-disp "Output Format" (scalew 10) h)
    (set-exclusive *sequent-format-but* *clause-format-but* *prolog-format-but*
		   *no-output-format-but*)
    (set-exclusive *sos-strategy-but* *standard-strategy-but*
		   *manual-strategy-but* *prolog-strategy-but*)
    (set-exclusive *smallest-ins-but* *lifo-ins-but* *fifo-ins-but*)
    (set-exclusive *paramodulation-but* *restricted-paramodulation-but*)
    
    
    
    (if *demo-in-execution*
	(display-settings-demo *demo-in-execution*))
    
    (mp:process-wait "Exit"   #'(lambda nil done))
    (close-display set-disp)
    (enable-the-right-buttons)))
  
;;;;;;;;;;;;;;;;;;
(defun restore-strategy-sets()
  (mapcar #'add-ch (append $simps$ $rules$))
  (init-choose))
    

(defun is-strategy (s)
  (or (not (eq nil (member s '("standard" "*sos*" "*man*") :test 'string=)))
      (continue-cancel-dialog 
       (format nil "~A: Not a valid name for a strategy " s))))

(defun is-weight-proc (s)
  (or (not (eq nil (member s '("agata-wgt" "rule-wgt" "andws-wgt") :test 'string=)))
      (continue-cancel-dialog 
       (format nil "~A:~% Not a valid name for a weighting procedure " s))))

(defun is-insert-proc (s)
  (or (not (eq nil (member s '("smallest-ins" "fifo-ins" "lifo-ins") :test 'string=)))
      (continue-cancel-dialog 
       (format nil "~A:~% Not a valid name for a insert procedure " s))))



	
     
(defun any (s) t)

(defun sinteger (s)
  (or (integerp (read-from-string s))
      (continue-cancel-dialog "An integer was required ")))


(defun add-dollars2 (string)
  (add-dollars (read-from-string string)))



;;;================================================

(defun notify-results()
  (if *demo-in-execution* nil
    (let* ((r-disp (make-instance 'display  
		     :left (scalew 230)
		      :bottom (scaleh 450)
		     :width (scalew 420) :height  (scaleh 200)
		     :font (my-findfont  14)
		     :title "ATP: results"))
	   (ok (make-instance 'push-button :font (my-findfont 14) :label "   OK   "))
	   (done nil)
	   (h (height r-disp)))
      
      
      (setq stringlist (list 
			(if $contr$
			    (if $answering$   (format nil " Answer found at clause ~A" $contr$ )
			      (format nil " Contradiction found at clause ~A" $contr$))
			  (format nil " Contradiction not found"))
			(format nil  " Termination status   : ~A" (if *aborted* "killed by user" "normal"))
			(format nil " Clauses generated    :~10D" $generated-rules$)
			(format nil  " Clauses kept         :~10D" (1- $rule-id))
			(if $contr$ (format nil  " Proof length         :~10D" (proof-length)) "")
			(format nil  " Unification attempts :~10D" $unification-attempts$)
			))
      
      (nl (window r-disp))
      (dolist (s stringlist)
	(write-display    r-disp s 5 (setq h(- h (scaleh 20)))))
      (set-button ok r-disp :left (scalew 250) :bottom (scaleh 10) 
		  :action (function (lambda ()(setf done t)
					    (close-display r-disp))))
      (mp:process-wait "Exit"   #'(lambda nil done)))))
   

(defun proof-length()
  (length (delete 'axiom 
	   (delete 'sos  
		   (remove-duplicates
		    (expand (list (root-id))))))))

