;;======================================================================
;;; -*- Mode:Lisp; Syntax:Common-Lisp; ; Base:10; -*-
;;;
;;; ******************************
;;; *  PORTABLE AI LAB -  IDSIA  *
;;; ******************************
;;;

;;; Filename:     len-filegr.cl
;;; Short Desc:  implementation of the choose-file-dialog
;;
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   Aug 1991
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;


(in-package :atp)

(setq gi::*max-select-items* 50)
(defvar *theorems-dir-up* nil)
(defvar *files-button* nil)
(defvar *choose-done* nil)
(defvar *canceled* nil)
(defvar *loader-buttons-width*)

(defun make-directory ()
  
  (let ((*default-font* *small-font*))
    (setq
	*th-dir-list* 
      (remove-if 
       #'(lambda (fn)
	   (not  (terminates-with ".th" fn))) 
       (sort
	(mapcar #'file-namestring
		(directory (namestring   *theorems-dir*)))
	#'(lambda ( x y) ( string< x y)))))
    (if  *files-button* (unset-button *files-button* ))
    (if (not (null   *th-dir-list* ))
	(progn 
	  
	  (setq *files-button* 
	    (make-instance 'select-button :label ""
			   :items *th-dir-list* 
			   :height (scaleh 460)
			   :width (scalew 250)
			   :exclusive t))
	  (set-button *files-button* *fdisp* :left (scalew 10) :bottom (scaleh 80) )))))
 
(setq *fixed-font*  (cw::open-font-named "fixed"))

(defmethod choose-file-dialog ()
(setq *loader-buttons-width* (scalew 100))
  (let* ((*default-font* *small-font*)
	 (exit-button (make-instance 'push-button  
		       :font *small-font*   :width *loader-buttons-width*   :label  "LOAD"))
	(view-button (make-instance 'push-button   
		       :font *small-font*      :width *loader-buttons-width* :label "VIEW"))
	(refresh-button (make-instance 'push-button  
			  :font *small-font*   :width *loader-buttons-width* :label "REFRESH"))
	(help-on-loader-button
	 (make-instance 'help-button   
	   :width *loader-buttons-width*
	   :font *small-font* :label "HELP" 
	   :subject "Loading files "
	   :technical     (add-path "atp-loader-desc.asc" *len-directory*)
	   :general   (add-path "atp-loader-gen.asc" *len-directory*)))
	(edit-button (make-instance 'push-button     :font *small-font* 
				    :width *loader-buttons-width*  :label "EDIT"))
	(cancel-button (make-instance 'push-button      :font *small-font* 
				      :width *loader-buttons-width* :label "CANCEL")))
    (setq *theorems-dir-up*  (get-the-dir  *theorems-dir*))
    (setf *dir-b*
      (make-instance 'value-button 
	:width (round (* 0.95 (scalew 400)))
	:name  ""
	:font  *small-font* 
	:value (namestring *theorems-dir*)))
    (setq *canceled* nil)
    (setq *choose-done* nil)
    (if *choose-file-first-time*
	(progn
	  (setq *fdisp* (make-instance 'display :height  (scaleh 550)
					        :width  (scalew 400)
				      :left (round (* 0.2 (width *root-window*)))
				      :bottom  (round (* 0.1 (height *root-window*)))
				      :title "Select a file, please"))
	  (push *fdisp* *open-displays-list*)
	  (protect-display *fdisp* t) 
	  (if (not (make-directory))
	      (progn 
		(unset-button *files-button*)
		(mp:process-wait  
		 "Directory empty" 
		 #'(lambda nil
		     (eq 'Continue 
			 (acknowledge-files :width (scalew 380)  "Currently there are no '.th' 
 files in this directory
 Use EDIT to create new theorems"  :title "ATP: Error")))))
	    (protect-display *fdisp* nil))
	  (setq *choose-file-first-time* nil)
	  (write-display *fdisp* "Current directory:" 20 25 )
	  (set-button exit-button *fdisp* :left (- (width *fdisp*) (scalew 20) *loader-buttons-width*) :bottom (scaleh 80)
		      :action (function(lambda nil
					 (if  (choosen-file *files-button*)
					     (progn
					       (reset-button  exit-button)
					       (deactivate-display *fdisp*)
					       (setf *choose-done* t))
					   (reset-button   exit-button)))))
	  (set-button edit-button *fdisp* :left  (- (width *fdisp*) (scalew 20) *loader-buttons-width*) :bottom (scaleh 200)
		      :action (function (lambda nil
					  (if  (choosen-file *files-button*)
					      (open-editor-window 
					       (concatenate 'string
						 (namestring  *theorems-dir*)
						 (choosen-file *files-button*)))
					    (progn
					      (open-editor-window 
					       (concatenate 'string
						 (namestring  *theorems-dir*) "Untitled.th"))))
					    (reset-button  edit-button ))))
	  (set-button refresh-button *fdisp* :left  (- (width *fdisp*)  (scalew 20)*loader-buttons-width*) :bottom (scaleh 380)
		      :action (function(lambda nil 
					 (if (not (make-directory))
					     (progn 
					;(unset-button *files-button*)
					       (mp:process-wait  
						"Directory empty" 
						#'(lambda nil
						    (eq 'Continue 
							(acknowledge-files  "Currently there are no '.th'
 files in this directory
 Use Edit to create new theorem files"
									  :font *small-font*  :width (scalew 380)   :title "ATP: Error")
							)))))
					 (reset-button refresh-button))))
	  
	  (set-button cancel-button *fdisp* :left  (- (width *fdisp*) (scalew 20) *loader-buttons-width*) :bottom (scaleh 320)
		      :action (function(lambda nil 
					 (setq *canceled* t)
					 (reset-button cancel-button)
					 (deactivate-display  *fdisp* ) 
					 (setf *choose-done* t))))
	  (set-button help-on-loader-button *fdisp* :left  (- (width *fdisp*)  (scalew 20) *loader-buttons-width*) :bottom (scaleh 260))
		  
				
				 
	  
	  
	  (set-button view-button *fdisp* :left  (- (width *fdisp*)  (scalew 20) *loader-buttons-width*)
		      :bottom (scaleh 140)
		      :action (function (lambda nil
					  (let 
					      ((ch-f (choosen-file *files-button*)))
					    (if ch-f (progn 
						       (setf hh
							 (make-instance 
							     'help-display
							   :filename
							   (concatenate 'string
							     (namestring *theorems-dir*)
							     ch-f)
							   :from-button view-button
							   :bottom (round (* 0.05 (height *root-window*)))
							   :left  (round (* 0.05 (width *root-window*)))
							   :width  (round (* 0.9 (width *root-window*)))
							   :title    ch-f
							   :button-region t
							   :font *fixed-font*))
						       ))
					    (reset-button  view-button )))))
	  
	  (set-button *dir-b* *fdisp*  :left (scalew 10) :bottom (scaleh 5 )
		      :action `(lambda nil (verify-theorem-pathname ,*dir-b*))))
      (activate-display *fdisp*))
    (mp:process-wait "waiting to exit "   #'(lambda nil *choose-done*))
    (if *canceled* "Canceled"
      (choosen-file *files-button*))))
 
(defun begins-with (l1 l2)
  (eq (car (coerce l1 'list))
      (car (coerce l2 'list))))
(defun get-the-dir (pth)
  (make-pathname 
   :directory
   (reverse (cdr (reverse (pathname-directory  
			   (namestring pth)))))))
 

(defmethod verify-theorem-pathname ((dir-b value-button))
  (let ((complete-filename
	 (if (begins-with "/" (button-value dir-b))
	     (make-pathname :name ( complete-dirname (button-value dir-b)))
	   (add-subdir  *theorems-dir-up* 
			(string-right-trim '(#\/) (button-value dir-b))))))
  
    (if (probe-file (namestring  complete-filename))
	(progn
	  (setq *theorems-dir-up* (get-the-dir complete-filename))
	  (setq *theorems-dir*   complete-filename)
	  (setf (button-value dir-b) (namestring  *theorems-dir*))
	  (protect-display *fdisp* t) 
	  (if (not (make-directory))
	      (progn 
		;(unset-button *files-button*)
		(mp:process-wait 
		 "Directory empty" 
		 #'(lambda nil
		     (eq 'Continue 
			 (acknowledge-files  "Currently there are no '.th'
 files in this directory
 Use Edit to create new theorem files"
				:width 380	    :title "ATP: Error"))))))
	  (protect-display *fdisp* nil))
      (progn 
	(protect-display *fdisp* t)
	(mp:process-wait  "Directory not found!" 
			  #'(lambda nil
			      (eq 'Continue 
				  (acknowledge-dialog "Directory not found!" 
						      :title "ATP: Error"))))
	(setf (button-value dir-b) (namestring  *theorems-dir*))
	(protect-display *fdisp* nil) ))))

(defmethod choosen-file ((sb select-button))
  (let ((result (the-first-such-that #'status (items sb))))
    (if result (label result)
      result)))


(defun the-first-such-that ( pred  lis )
  (cond ((null lis) nil)
	((funcall pred (car lis)) (car lis))
	(t (the-first-such-that  pred  (cdr lis)))))


(defun complete-dirname (dirname)
  (if (terminates-with "/" dirname) dirname
    (concatenate 'string dirname "/")))

(defun open-editor-window (filename)
  (user::run-shell-command
   (concatenate 'string "emacs "
		filename  )
		:wait nil))

(defun acknowledge-files (query &key (width 300)(title "Please Click"))
  (let* ((dw (make-instance 'display   :width width :font (my-findfont 10)
			     :left (scalew 10)  :bottom (scaleh 200)  :height (scaleh 100)  :title title))
	 (done nil)
	 (yb (make-instance 'push-button :label "Continue")))
    (push  dw *open-displays-list*) (write-display dw query 10 (- (height dw) 20))
    
    (set-button yb dw :left (- (width dw) (scalew 200)) :bottom (scaleh 4) :action (function (lambda (&rest cw-internals)
									     (declare (ignore cw-internals))
									     (setf done 'Continue))))
    (mp:process-wait "Exit"   #'(lambda nil done)) 
    (cw:flush (window dw))
    done))

