{ Soundex program in Pascal.}
{ From AI Expert's AI Apprentice column, March 1991, by Mark Minasi. }

program Soundex;
{$G1,P1}
Type
  String255 = String[255];
Var
  ctable:array[' '..'Z'] of char;
  n:string255;


Procedure LoadTable;
{Required because Pascal has such a lousy compile-time data load facility}
var c:char;
begin
  for c:=' ' to 'Z' do ctable[c]:='0';
  ctable['B'] := '1';
  ctable['F'] := '1';
  ctable['P'] := '1';
  ctable['V'] := '1';
  ctable['C'] := '2';
  ctable['G'] := '2';
  ctable['J'] := '2';
  ctable['K'] := '2';
  ctable['Q'] := '2';
  ctable['S'] := '2';
  ctable['X'] := '2';
  ctable['Z'] := '2';
  ctable['D'] := '3';
  ctable['T'] := '3';
  ctable['L'] := '4';
  ctable['M'] := '5';
  ctable['N'] := '5';
  ctable['R'] := '6';
end;

Function Soundout(X:string255):string255;
var
  b,c:char;
  s,t:string255;
  i,l:integer;

function nodouble(x:string255):string255;
var t:string255;
    i,tl:integer;
begin
  i:=2;
  t:=upcase(x[1]);
  tl:=1;
  while i<=length(x) do
  begin
    if t[tl]=upcase(x[i]) then i:=i+1 else
    begin
      tl:=tl+1;
      t:=t+upcase(x[i]);
      i:=i+1;
    end;
  end;
  nodouble:=t;
end;

begin
  if x='' then s:='' else
  begin
    x:=nodouble(x); {remove double letters}
    writeln('after nodouble, =',x);
    l:=length(x);
    s:=x[1];
    for i:=2 to l do
    begin
      t:='';
      c:=x[i];
      if ctable[c]<>'0' then s:=s+ctable[c];
    end;
  end;
  {length check}
  if length(s)<4 then for i:=1 to 4-length(s) do s:=s+'0'
  else if length(s)>4 then s:=copy(s,1,4);
  soundout:=s;
end;

{M A I N   P R O G R A M}

begin
  loadtable;
  repeat
    write('Enter a name for SOUNDEX conversion, or ENTER to stop? ');
    readln(n);
    if n<>'' then writeln(soundout(n));
  until n='';
end.

