PERCEPTRONS LISTING 1


20 ' IMAGE      = The sensory grid array
30 ' NEURALNET  = The associative net---neural interconnections
40 ' SIZE^2     = Number of cells in the sensory grid
50 ' SCAN       = Number of cells required to construct an 8-bit 
60 '              address into the array NEURALNET()
70 ' LSCAN      = The number of iterations for scanning the sensory
80 '              grid (we look at scan cells at random 
90 '              loopscan times)
100 DEFINT A-Z:SIZE=16:SCAN=8:LSCAN=(SIZE^2)/SCAN
120 DIM IMAGE(SIZE,SIZE),NEURALNET(LSCAN*(SIZE^2),2)
130 GOSUB 6000:'                                   Intro message
140 '
150 '************ Training session **********************************
155 RANDOMIZE 5:'                                  Init random
160 CLS: LOCATE 10,50:PRINT"===    TRAINING SESSION    ===="
161 LOCATE 12,50:'                                 Put up a prompt
162 Q$="Automatic training"
163 GOSUB 3000:'                                   Select training
164 IF Q$<>"Y" THEN 170:'                          Manual training
165 GOSUB 4000:GOTO 400:'                          Automatic training
166 '
170 LOCATE 11,50
175 INPUT"Draw class 1 or 2";CLASS:'               Select a class
180 IF CLASS>2 THEN CLASS=2:'                      for this object
190 IF CLASS<2 THEN CLASS=1:'                      within range
200 GOSUB 1000:'                                   Draw an object 
210 FOR I=1 TO LSCAN:'                             Calculate 
220   GOSUB 2000:'                                 indicies into
230   NEURALNET(INDEX,CLASS)=1:'                   neuralnet
240 NEXT:'                                         for this class
250 LOCATE 2,5
260 Q$="Want to conduct more training":'           Loop through more
270 GOSUB 3000:IF Q$="Y" THEN 160:'                training 
271 '
400 ' *********** Classification session *****************************
420 CLS:LOCATE 10,50:PRINT"=== CLASSIFICATION SESSION ===="
430 '
431 RANDOMIZE 5:'                                  Init random
440 GOSUB 1000:'                                   Draw an object
450 MEMBER=0:NONMEMBER=0:'                         Init member count
500 FOR I=1 TO LSCAN:'                             Calculate 
510   GOSUB 2000:'                                 indicies 
540   IF NEURALNET(INDEX,1)=1 THEN MEMBER=MEMBER+1
550   IF NEURALNET(INDEX,2)=1 THEN NONMEMBER=NONMEMBER+1
551   IF NEURALNET(INDEX,1)=0 AND NEURALNET(INDEX,2)=0 THEN 553
552   GOTO 560
553   I=I-1:'                                       Null class found
560 NEXT
571 LOCATE 23,2:PRINT SPC(78)
573 LOCATE 12,50: PRINT"Ratio is ";MEMBER;"/";NONMEMBER
574 LOCATE 13,50: PRINT " favouring class ";
576 IF MEMBER<NONMEMBER THEN 580
577 PRINT"Two.";:GOTO 588
580 PRINT"One.";
588 IF ABS(MEMBER-NONMEMBER)>1 THEN 590
589 LOCATE 9,50:?" * Ratio is close. *"
590 LOCATE 14,50:Q$="Classify another object":GOSUB 3000
600 IF Q$="Y" THEN 400
601'
610 CLS:?:?:?:?:Q$="Want to see NEURALNET":GOSUB 3000
620 IF Q$="Y" THEN GOSUB 7000
670 ?"Emptying Neural Network..."
671 FOR I=1 TO LSCAN*(SIZE^2)
680   FOR J=1 TO 2
690   NEURALNET(I,J)=0
691   NEXT
692 NEXT:GOTO 150
998 '
1000 ' *********** Interactive object drawing ***********
1002 FOR I=1 TO SIZE:FOR J=1 TO SIZE:IMAGE(I,J)=0:NEXT:NEXT
1005 RR=5:CC=20:ROW=1:CLM=1
1006 LOCATE 23,2
1010 PRINT"[D],[U],[L],[R] to move. [.] to plot, [ ] to erase, [S] to stop."
1061 FOR I=1 TO SIZE+1
1062   LOCATE RR+I,CC:PRINT "|";:LOCATE RR+I,CC+17:PRINT "|";
1063   LOCATE RR,CC+I:PRINT "-";:LOCATE RR+17,CC+I:PRINT"-";
1064 NEXT
1070 LOCATE ROW+RR,CLM+CC
1080 A$=INKEY$:IF A$="" THEN 1080
1090 IF A$="U" THEN ROW=ROW-1
1100 IF A$="D" THEN ROW=ROW+1
1110 IF A$="R" THEN CLM=CLM-1
1120 IF A$="L" THEN CLM=CLM+1
1130 IF CLM > SIZE THEN CLM=SIZE
1140 IF CLM < 1 THEN CLM=1
1160 IF ROW < 1 THEN ROW=1
1170 IF ROW > SIZE THEN ROW=SIZE
1171 LOCATE 5,5:PRINT "ROW=";ROW;" CLM=";CLM;
1190 LOCATE ROW+RR,CLM+CC
1191 IF A$="." THEN PRINT CHR$(219):LOCATE ROW+RR,CLM+CC:IMAGE(CLM,ROW)=1
1194 IF A$=" " THEN PRINT" ":LOCATE ROW+RR,CLM+CC:IMAGE(CLM,ROW)=0
1196 IF A$="S" THEN LOCATE 10,1:PRINT"Object completed":GOTO 1210
1205 GOTO 1080
1210 PRINT "ONE MOMENT...":RETURN
1998'
2000 ' Calculate a SCAN digit address into NEURALNET()
2001 ' by scanning any SCAN cells of IMAGE() at random
2002 ' If a cell has an active pixel, it is considered on,
2003 ' else it is considered off. Hence a SCAN digit binary address.
2004 ' Resultant index is in the range 0 and up in size^2 
2005 ' blocks. The address within a block is determined by 
2006 ' the image(a,b) as a power of 2 (line 2040).
2009 INDEX=(SIZE^2)*(I-1)
2010 FOR J=0 TO SCAN-1
2020   FIRST=INT(RND*SIZE)+1:SECOND=INT(RND*SIZE)+1
2040   INDEX=INDEX+IMAGE(FIRST,SECOND)*2^J
2050 NEXT:RETURN
2999 '
3000' Issue a prompt using q$, and return q$=Y/N
3001 PRINT Q$;:INPUT Q$
3010 Q$=LEFT$(Q$,1):
3050 RETURN
3099'
4000 ?"Train the network on vertical vs. horizontal lines."
4001 ?"Note: It takes a while to scan each object, but more "
4002 ?"      objects mean more accurate classification."
4003 CLASS=1:RANDOMIZE 5
4004 INPUT"How many objects of Class One ";KNT
4010     FOR KLOOP=1 TO KNT:CLS: LOCATE 10,30:?KLOOP;" of ";KNT
4011     FOR I=1 TO SIZE+1
4012       LOCATE I,SIZE:?"|";:LOCATE SIZE,I:? "-";
4013     NEXT
4014     ?"Object Class One";
4015 '     Create one horizontal line of length k
4019       FOR I=1 TO SIZE:FOR J=1 TO SIZE:IMAGE(I,J)=0:NEXT:NEXT
4020       KLEN=INT(RND*SIZE+1):IF KLEN<2 THEN 4020
4021       MPOS=INT(RND*SIZE)+1:NPOS=INT(RND*SIZE)+1
4022       IF NPOS+KLEN>SIZE THEN 4020
4023       IF NPOS>=KLEN THEN 4020
4025       FOR A=NPOS TO KLEN
4026          IMAGE(A,MPOS)=1:LOCATE MPOS,A:?CHR$(223);
4027       NEXT
4029       'Now place this image into nerualnet
4030       LOCATE 11,30:?"Scanning object"
4032       LOCATE 12,30:?"Len=";KLEN;" Start=";NPOS;",";MPOS;
4090       FOR I=1 TO LSCAN:GOSUB 2000
4091           NEURALNET(INDEX,CLASS)=1
4092       NEXT
4094     NEXT:CLS
4100 INPUT"How many objects of Class Two ";KNT
4105 CLASS=2:RANDOMIZE 5
4110      FOR KLOOP=1 TO KNT:CLS:LOCATE 10,30:?KLOOP;" of ";KNT
4111     FOR I=1 TO SIZE+1
4112       LOCATE I,SIZE:?"|";:LOCATE SIZE,I:? "-";
4113     NEXT
4114     ?"Object Class Two";
4120       FOR I=1 TO SIZE:FOR J=1 TO SIZE:IMAGE(I,J)=0:NEXT:NEXT
4130       KLEN=INT(RND*SIZE+1):IF KLEN<2 THEN 4130
4135       MPOS=INT(RND*SIZE)+1:NPOS=INT(RND*SIZE)+1
4140       IF NPOS+KLEN>SIZE THEN 4130
4141       IF NPOS>=KLEN THEN 4130
4145       FOR A=NPOS TO KLEN
4150          IMAGE(MPOS,A)=1:LOCATE A,MPOS:?CHR$(219);
4153       NEXT
4154       'Now place this image into nerualnet
4155       LOCATE 11,30:?"Scanning object"
4156       LOCATE 12,30:?"Len=";KLEN;" Start=";NPOS;",";MPOS;
4160       FOR I=1 TO LSCAN:GOSUB 2000
4170           NEURALNET(INDEX,CLASS)=1
4180       NEXT
4190     NEXT:CLS
4200 RETURN
4998'
6000' Put up an intro message
6010 CLS:PRINT"  This program demonstrates how a very simple"
6040 PRINT"network capable of analysing visual information."
6045 PRINT:PRINT:PRINT
6050 PRINT"  Proceed as follows: "
6051 PRINT:PRINT
6060 PRINT" 1) Draw an object and decide if that object is a member of"
6070 PRINT"    a object class one or two. Try vertical versus"
6080 PRINT"    horizontal lines to start."
6081 PRINT" 2) Train the network to recognize objects"
6082 PRINT"    of a particular class by drawing various objects"
6083 PRINT"    from both classes. (This may be done automatically)."
6084 PRINT" 3) Present various objects to the network (some"
6085 PRINT"    old objects may be used, as well as those that it"
6086 PRINT"    has never seen before), and see how successfully it"
6087 PRINT"    classifies new ojects as belonging to the correct class."
6088 PRINT"    This simple simulation will make mistakes, but should"
6089 PRINT"    perform better or even much better than random."
6090 PRINT:PRINT
6091 Q$="Ready.":GOSUB 3000:CLS
6100 RETURN
6999'
7000' Display the contents of the neural network
7030 K=0:KK=0:KZ=0
7031 FOR I=1 TO LSCAN*SIZE^2
7040   FOR J=1 TO 2
7050     A=NEURALNET(I,J):IF A=1 THEN ?"*"; ELSE ?".";
7060     K=K+1:IF K>SIZE THEN K=0:KZ=KZ+1:?"  ";
7061     IF KZ>3 THEN KZ=0:?:KK=KK+1
7062     IF KK>SIZE THEN KK=0:?
7065   NEXT
7066 NEXT
7070 RETURN

(c) Copyright 1986 by Peter Reece.