/*
 * File: cm_cellmoore.c
 *   By: Dave Hiebeler
 *       August 1989
 *
 * Cellsim, cellular automata simulator
 *
 * Routines for running moore neighbor rules
 */


#include "cm_cell.h"

/*
 *
 * Cellsim copyright 1989, 1990 by Chris Langton and Dave Hiebeler
 * (cgl@lanl.gov, hiebeler@heretic.lanl.gov)
 *
 * This package may be freely distributed, as long as you don't:
 * - remove this notice
 * - try to make money by doing so
 * - prevent others from copying it freely
 * - distribute modified versions without clearly documenting your changes
 *   and notifying us
 *
 * Please contact either of the authors listed above if you have questions
 * or feel an exception to any of the above restrictions is in order.
 *
 * If you make changes to the code, or have suggestions for changes,
 * let us know!  If we use your suggestion, you will receive full credit
 * of course.
 */

/*****
 * Cellsim history:
 *
 * Cellsim was originally written on Apollo workstations by Chris Langton.
 *
 * Sun versions:
 *
 * - version 1.0
 *   by C. Ferenbaugh and C. Langton
 *   released 09/02/88
 *
 * - version 1.5
 *   by Dave Hiebeler and C. Langton  May - June 1989
 *   released 07/03/89
 *
 * - version 2.0
 *   by Dave Hiebeler and C. Langton  July - August 1989
 *   never officially released (unofficially released 09/08/89)
 *
 * - version 2.5
 *   by Dave Hiebeler and C. Langton  September '89 - February 1990
 *   released 02/26/90
 *****/



int auto_m();
void probe_m();


/* set up nhood-dependent stuff */
void
set_params_m()
{
    N = 9;
    auto_step = auto_m;
    probe_func = probe_m;
}



/*
 *run for "steps" time-steps; if steps is -1, then keep running until
 * the client says to stop
 */
auto_m(steps)
int steps;
{
    int i, nsteps;
    unsigned char buf[4];

    if (steps == -1) {
	nsteps = 0;
	while (1) {
	    /* do a non-blocking read to see if client said to stop */
	    if (read_from_sock(ns, buf, 1, ON, debug2) == 1)
		return nsteps;
	    usleep(CM_delay);
	    CM_set_context();
	    MGetNorth;
	    MGetSouth;
	    MGetEast;
	    MGetWest;
	    MGetNW;
	    MGetSW;
	    MGetNE;
	    MGetSE;
	    MGetCenter;
	    if (function) {
		update_function();
	    }
	    else {
		CM_aref32_shared_2L(temp_value,trans,
				    nbor_values+2,32,(L*N)-2,max_index);
		/* Ok, temp_value now has 4 8-bit numbers in it.
		 * One of them is the L-bit # we want.  We now get it.
		 */
		CM_array_ref(cell,temp_value,nbor_values,L,2,4,8);
	    }
	    if (!(nsteps%CM_disp_interval)) {
		if (FB_attach_ret_val && use_FB)
		    CMFB_display_image();
	    }
	    nsteps++;
	}
    }
    else {
	for (i=0; i<steps; i++) {
	    usleep(CM_delay);
	    CM_set_context();
	    MGetNorth;
	    MGetSouth;
	    MGetEast;
	    MGetWest;
	    MGetNW;
	    MGetSW;
	    MGetNE;
	    MGetSE;
	    MGetCenter;
	    if (function) {
		update_function();
	    }
	    else {
		CM_aref32_shared_2L(temp_value,trans,
				    nbor_values+2,32,(L*N)-2,max_index);
		/* Ok, temp_value now has 4 8-bit numbers in it.
		 * One of them is the L-bit # we want.  We now get it.
		 */
		CM_array_ref(cell,temp_value,nbor_values,L,2,4,8);
	    }
	    if (!(i%CM_disp_interval)) {
		if (FB_attach_ret_val && use_FB)
		    CMFB_display_image();
	    }
	    if (SOCKET_INUSE)
		count_states();
	}
    }
}

    
/*
 * Look up a transition in the LT on the CM
 */
void
probe_m(buf)
unsigned char buf[];
{
    unsigned int j;

    j = buf[3] + buf[2]*256 + buf[1]*256*256 + buf[0]*256*256*256;
    CM_u_move_constant_1L(nbor_values, j, L*N);
    CM_aref32_shared_2L(temp_value, trans,
			nbor_values+2, 32, (L*N)-2, max_index);
    /* CM_u_move_zero_1L(cell8, 8); */
    CM_array_ref(table_index, temp_value, nbor_values, L, 2, 4, 8);
    buf[0] = CM_u_read_from_processor_1L(0, table_index, 8);
}

