/*
 * File: main_loop.v.c
 *   By: Dave Hiebeler
 *       July 1989
 *
 * Generate a transition-table for von-Neumann neighborhood
 */

#include <stdio.h>
#include <math.h>
#include "nborhood.h"

#define add_index(k)	index <<= L;  index |= k

func_ptr update_function;

main()
{
    char    *ta;			/* t-table array       */
    FILE   *fopen(), *fp;
    int L, N, TSIZE, index, AMASK;
    int     l, c, r, t, b;
    vonn_nbors nbors;


    L = (short) (log((double) NSTATES) / log((double) 2.0));
    N = 5;
    TSIZE = 1 << (L*N);
    AMASK = NSTATES-1;
    if ((ta=(char *)malloc(TSIZE))==NULL) {
	fprintf(stderr,"Couldn't malloc memory for table\n");
	exit(1);
    }
    printf("NSTATES = %d\n",NSTATES);
    init_function();
    for (l = 0; l < NSTATES; l++)
      for (c = 0; c < NSTATES; c++)
	for (r = 0; r < NSTATES; r++)
	 for (t = 0; t < NSTATES; t++)
	   for (b = 0; b < NSTATES; b++) {

	       index = 0;
	       add_index(l);
	       add_index(c);
	       add_index(r);
	       add_index(t);
	       add_index(b);

		nbors.l = l;
		nbors.c = c;
		nbors.r = r;
		nbors.t = t;
		nbors.b = b;
		ta[index] = (update_function(&nbors) & AMASK);

	    }


    fp = fopen(OUTPUT, "w");
    fwrite(ta, sizeof(*ta), TSIZE, fp);
    fclose(fp);

}
