
#|-----------------------------------------------------------------------------
Artificial Intelligence, Second Edition
Elaine Rich and Kevin Knight
McGraw Hill, 1991

This code may be freely copied and used for educational or research purposes.
All software written by Kevin Knight.
Comments, bugs, improvements to knight@cs.cmu.edu
----------------------------------------------------------------------------|#

#|----------------------------------------------------------------------------
		            TERM UNIFICATION
			   "term-unify.lisp"
----------------------------------------------------------------------------|#

#|----------------------------------------------------------------------------

The main call is:

	(unify l1 l2)			unifies two terms

See examples at the end of this file.

----------------------------------------------------------------------------|#

;; Function UNIFY returns a set of substitutions that make its two input
;; terms identical.  Terms are represented as lists.  For example, the 
;; term f(x,g(a)) is represented as (f x (g a)).


(defun unify (l1 l2)
  (cond ((or (constant? l1) (variable? l1)
	     (constant? l2) (variable? l2))
	 (cond ((eq l1 l2) nil)
	       ((variable? l1)
		(if (contains l2 l1) 'fail (list (list l1 '<- l2))))
	       ((variable? l2)
		(if (contains l1 l2) 'fail (list (list l2 '<- l1))))
	       (t 'fail)))
       ((or (not (eq (car l1) (car l2)))
	    (not (= (length l1) (length l2))))
	'fail)
       (t 
	(do ((subst nil)
	     (args1 (cdr l1) (cdr args1))
	     (args2 (cdr l2) (cdr args2))
	     (failed? nil))
	    ((or failed? (null args1))
	     (if failed? 'fail (nreverse subst)))
	  (let ((s (unify (car args1) (car args2))))
	     (cond ((eq s 'fail) (setq failed? t))
		   ((null s) nil)
		   (t (setq args1 (apply-substitution s args1))
		      (setq args2 (apply-substitution s args2))
		      (setq subst (append s subst)))))))))

(defun constant? (a) 
  (and (atom a)
       (not (null a))
       (not (variable? a))))

(defun variable? (a)
  (and (atom a)
       (member a '(x y z x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12))))

(defun contains (tree item)
  (cond ((null tree)
         nil)
        ((atom tree)
         (equal tree item))
        (t 			;   tree is a list
         (or (contains (car tree) item)
             (contains (cdr tree) item)))))


(defun apply-substitution (substs expr)
  (let ((c (copy-tree expr)))
    (mapc #'(lambda (s) 
		(setq c (nsubst (third s) (first s) c)))
	  substs)
    c))


;; (unify '(f x (g a))  '(f (g a) (g y))) ->
;;  ((X <- (G A)) (Y <- A))

