
#|-----------------------------------------------------------------------------
Artificial Intelligence, Second Edition
Elaine Rich and Kevin Knight
McGraw Hill, 1991

This code may be freely copied and used for educational or research purposes.
All software written by Kevin Knight.
Comments, bugs, improvements to knight@cs.cmu.edu
----------------------------------------------------------------------------|#

#|----------------------------------------------------------------------------
		             GENERIC GAME
			    "generic-game.lisp"
----------------------------------------------------------------------------|#

#|----------------------------------------------------------------------------

This file can be used as a template to create new games.  To create your own 
game, fill in the functions below, adding whatever auxiliary functions are
necessary.  The functions are:

 (deep-enough pos depth)	t if the search has proceeded deep enough.
 (static pos player)		evaluation of position pos from player's 
				 point of view.
 (movegen pos player)		generate all successor positions to pos.
 (opposite player)		return the opposite player.
 (print-board pos)		print board position pos.
 (make-move pos player move)	return new position based on old position and 
				 player's move.
 (won? pos player)		t if player has won.
 (drawn? pos)		 	t if pos is a drawn position.

The important variables are:

 *start*			the initial board configuration.

These functions and variables are all called from minimax.lisp.

For an example game, see "tictactoe.lisp".

----------------------------------------------------------------------------|#

;; Variable *START* holds the starting position for the game.

(defvar *start*)

(setq *start* nil)

;; Function DEEP-ENOUGH returns t if the search has proceeded deep enough.  
;; This can be a function of (either or both) the position and the depth of
;; the search.

(defun deep-enough (pos depth)
  nil)


;; Function STATIC returns a number which is the evaluation of position pos
;; from the viewpoint of the player.  A positive number is favorable for the 
;; player; a negative one is unfavorable.

(defun static (pos player)
  nil)

;; Function MOVEGEN takes a position and a player and generates all legal 
;; successor positions, i.e., all possible moves a player could make.

(defun movegen (pos player)
  nil)


;; Function OPPOSITE returns player one when given player two, and 
;; vice-versa.

(defun opposite (player)
  nil)


;; Function PRINT-BOARD prints the game board.

(defun print-board (pos)
  nil)


;; Function MAKE-MOVE returns a new position based on the old position and 
;; a player's move.
				 
(defun make-move (pos player move)
  nil)


;; Function WON? returns t if player has won in position pos.

(defun won? (pos player)
  nil)

;; Function DRAWN? returns t if pos is a drawn (tied) position.

(defun drawn? (pos)
  nil)

