;;;; -*- Mode:Lisp; Syntax: Common-Lisp; Package:UMASS-EXTENDED-LISP; Base:10 -*-
;;;; *-* File: VAX6:DIS$DISK:[GBB.V-120.LOCAL]UMASS-EXTENDED-LISP.LISP *-*
;;;; *-* Last-Edit: Wednesday, February 8, 1989  19:48:55 *-*
;;;; *-* Edited-By: Gallagher *-*
;;;; *-* Machine: Gilgamesh (Explorer II, Microcode 308) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (0.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                  Mini Version of Extended Lisp
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Kevin Gallagher/Philip Johnson/Daniel Corkill/Kelly Murray
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  This file contains extensions to Common Lisp needed by GBB.  All the
;;;  functions in this file are written in Common Lisp.  There is a separate
;;;  file for each lisp implementation contains the implementation dependent
;;;  features.
;;;
;;;  06-10-86 File Created.  (Gallagher)
;;;  10-30-86 Added DEFTRANSFORM.  (Gallagher)
;;;  11-18-86 Added UNTIL, WHILE and %POINTER.  (Gallagher)
;;;  12-12-86 Reorganized and cleaned up the documentation and read time
;;;           conditionalizations.  (Gallagher)
;;;  01-05-87 Patched DEFINE-MODIFY-MACRO for the Explorer.  (Gallagher)
;;;  01-08-87 Added STRUCTURE-SLOT-P.  (Gallagher)
;;;  02-02-87 Corrected Lisp Machine version of STRUCTURE-SLOT-INDEX-1 to
;;;           simply return nil if the slot is not found.  (Gallagher)
;;;  02-17-87 Added DEFSTRUCT-CONC-NAME for VaxLisp.  (Gallagher)
;;;  03-25-87 Split implementation dependent code from the Common Lisp code.
;;;           (Gallagher)
;;;  07-11-87 Added MAPC-MAX.  (Gallagher)
;;;  12-01-87 Rewrote the maps as do loops to reduce consing.
;;;           Deleted MAPC-APPEND.  (Gallagher)
;;;  12-16-87 Added MAPC-+.  (Gallagher)
;;;  10-21-88 Added WITH-PROTECTED-WRITE and WITH-PROTECTED-READ.  (Gallagher)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package 'umass-extended-lisp
	    :use '(lisp))

(export '(string-concatenate
	  short-date-and-time
          with-protected-write 
          with-protected-read
          while
	  until
	  star
	  mapc-and
	  ;; mapc-append
	  mapc-condcons
	  mapc-adjoin
	  mapc-cons
          mapc-eq
	  mapc-max
	  mapc-+
	  remove-nth
	  delete-nth
	  push-acons
	  pushnew-acons
	  ))

(use-package '(lisp))

(proclaim '(optimize (speed 3) (safety 1)))


;;;; --------------------------------------------------------------------------
;;;;   Macros used in this file
;;;; --------------------------------------------------------------------------

(defmacro string-concatenate (&rest strings)

  "STRING-CONCATENATE {simple-string}*

Concatenates all the strings together.  Each argument must be
acceptable to the STRING function."

  `(concatenate 'simple-string
		;; Make sure that each argument is a string.
		,@(mapcar #'(lambda (x)
			      (if (stringp x) x `(string ,x)))
			  strings)))


;;;; --------------------------------------------------------------------------
;;;;   Input and Output
;;;; --------------------------------------------------------------------------

(defmacro WITH-PROTECTED-WRITE  (&BODY body)

  "WITH-PROTECTED-WRITE &BODY body

This macro sets up a standard output environment.  This is useful when
writing machine-readable data that could be affected by various settings
of output switches and parameters."
  
  `(let ((*print-escape* t)
         (*print-pretty* nil)
         (*print-circle* t)
         (*print-base* 10)
         (*print-radix* nil)
         (*print-case* :upcase)
         (*print-gensym* t)
         (*print-level* nil)
         (*print-length* nil)
         (*print-array* t)
         #+TI        (*package* nil)
         #+TI        (ticl::*print-structure* t)
         #+LUCID     (sys::*print-structure* t)
         #+SYMBOLICS (scl::*print-structure-contents* t)
         #+LUCID     (*readtable* lucid::*standard-readtable*)
         #+TI        (*readtable* si::common-lisp-readtable)
         #+SYMBOLICS (*readtable* si::*common-lisp-readtable*)
         )
     ,@body))


(defmacro WITH-PROTECTED-READ  (&BODY body)

  "PROTECTED-READ &BODY body

This macro sets up a standard input environment.  This is useful when
writing machine-readable data that could be affected by various settings
of input switches and parameters."
  
  `(let ((*read-suppress* nil)
         (*read-base* 10)
         #+LUCID     (*readtable* lucid::*standard-readtable*)
         #+TI        (*readtable* si::common-lisp-readtable)
         #+SYMBOLICS (*readtable* si::*common-lisp-readtable*)
         )
     ,@body))

;;;; --------------------------------------------------------------------------
;;;;   Date and time
;;;; --------------------------------------------------------------------------

(defun short-date-and-time (&OPTIONAL (time (get-universal-time)))
  
  "SHORT-DATE-AND-TIME [universal-time]

Returns formatted date/time string (short form)."
  
  (multiple-value-bind (second minute hour date month year)
                       (decode-universal-time time)
    (format nil 
            "~a-~a-~a ~2,'0d:~2,'0d:~2,'0d"
            date
            (nth (1- month)
                 '("Jan" "Feb" "Mar" "Apr" "May" "Jun"
                   "Jul" "Aug" "Sep" "Oct" "Nov" "Dec"))
            year
            hour
            minute
            second)))

;;;; --------------------------------------------------------------------------
;;;;   Iteration Constructs
;;;; --------------------------------------------------------------------------

(defmacro WHILE (pred &BODY body)
  
  "WHILE pred {form}*
  
Standard while loop.  Executes `form's as long as `pred' returns a
non-nil value.  Returns nil."
  
  `(loop
     (unless ,pred
       (return nil))
     ,@body))


(defmacro UNTIL (pred &BODY body)
  
  "UNTIL pred {form}*
  
Standard until loop.  Executes `form's as long as `pred' returns a
nil value.  Returns nil."
  
  `(loop
     (when ,pred
       (return nil))
     ,@body))


;;;; --------------------------------------------------------------------------
;;;;   Map Functions
;;;; --------------------------------------------------------------------------


;;; Circular list builder ::

#-LISPM
(defun star (&REST arglist)

  "STAR &REST arglist

  Returns a circular list containing the elements of arglist.  Useful
  with the generalized map functions."

  (nconc arglist arglist))

;; The lispm puts &REST arguments on the stack so you can't do
;; destructive operations on them.
#+LISPM
(defmacro star (&REST arglist)

  "STAR &REST arglist

  Returns a circular list containing the elements of arglist.  Useful
  with the generalized map functions."

  #+SYMBOLICS `(scl::circular-list ,@arglist)
  #+TI        `(ticl::circular-list ,@arglist)
  )


(defmacro mapc-cons (fn list &rest more-lists)

  "MAPC-CONS function list &REST more-lists
  
This is just MAPCAR.  It applies the function to the first
element of the lists, then to the second element, and so on.
A list of the results of the successive calls to the
function is formed using CONS and returned."

  `(mapcar ,fn ,list ,@more-lists))


(defmacro mapc-condcons (fn list &rest more-lists)

  "MAPC-CONDCONS function list &REST more-lists
  
This function applies the function to the first element of
the lists, then to the second element, and so on.  A list of
the non-nil results of the successive calls to the function
is formed using CONS and returned.

STYLE NOTE: Generally mapc-CONDCONS is preferred to the
idiomatic MAPCAN of listed results when filtering is desired."

  (let* ((vis (mapcar #'(lambda (arg)
                          (let ((var (gensym)))
                            `(,var ,arg (cdr ,var))))
                      (cons list more-lists)))
         (list-vars (mapcar #'car vis))
         (collect-v (gensym))
         (temp-v (gensym))
         (function-v (gensym)))
    `(do ((,collect-v nil)
          (,temp-v nil)
          (,function-v ,fn)
          ,@vis)
         ((or ,@(mapcar #'(lambda (v) `(endp ,v)) list-vars))
          (nreverse ,collect-v))
       (setf ,temp-v (funcall ,function-v
                              ,@(mapcar #'(lambda (v) `(first ,v)) list-vars)))
       (when ,temp-v
         (setf ,collect-v (cons ,temp-v ,collect-v))))))


(defmacro mapc-adjoin (fn list &rest more-lists)

  "MAPC-ADJOIN function list &REST more-lists
  
This function applies the function to the first element of
the lists, then to the second element, and so on.  A set of
the non-nil results of the successive calls to the function
is formed using ADJOIN and returned."

  (let* ((vis (mapcar #'(lambda (arg)
                          (let ((var (gensym)))
                            `(,var ,arg (cdr ,var))))
                      (cons list more-lists)))
         (list-vars (mapcar #'car vis))
         (collect-v (gensym))
         (temp-v (gensym))
         (function-v (gensym)))
    `(do ((,collect-v nil)
          (,temp-v nil)
          (,function-v ,fn)
          ,@vis)
         ((or ,@(mapcar #'(lambda (v) `(endp ,v)) list-vars))
          (nreverse ,collect-v))
       (setf ,temp-v (funcall ,function-v
                              ,@(mapcar #'(lambda (v) `(first ,v)) list-vars)))
       (setf ,collect-v (adjoin ,temp-v ,collect-v)))))


#+IGNORE
(defun mapc-append (fn list &rest more-lists)

  "MAPC-APPEND function list &REST more-lists
  
This function applies the function to the first element
of the lists, then to the second element, and so on.
The results of the successive calls to the function are
concatenated using APPEND and returned."

  ;; This wastes a few conses on the intermediate result of the mapcar
  ;; but if you're using append you're already consing anyway.
  (apply #'append (apply #'mapcar fn list more-lists)))


(defmacro mapc-and (fn list &rest more-lists)

  "MAPC-AND fn list &rest more-lists

This function applies the function to the first element of the
lists, then to the second element, and so on.   It returns nil
as soon as any call returns nil.  If all calls return a non-nil
value then mapc-and returns the value of the last call."

  `(every ,fn ,list ,@more-lists))


(defmacro mapc-+ (fn list &rest more-lists)

  "MAPC-+ fn list &rest more-lists

This function applies the function to the first element of the
lists, then to the second element, and so on.   It returns the
sum of all the results.  If any of the lists are null MAPC-+
returns 0."

  (let* ((vis (mapcar #'(lambda (arg)
                          (let ((var (gensym)))
                            `(,var ,arg (cdr ,var))))
                      (cons list more-lists)))
         (list-vars (mapcar #'car vis))
         (sum-v (gensym))
         (function-v (gensym)))
    `(do ((,sum-v 0)
          (,function-v ,fn)
          ,@vis)
         ((or ,@(mapcar #'(lambda (v) `(endp ,v)) list-vars))
          ,sum-v)
       (setf ,sum-v (+ ,sum-v
		       (funcall ,function-v
				,@(mapcar #'(lambda (v) `(first ,v)) list-vars)))))))


(defmacro mapc-max (fn list &rest more-lists)

  "MAPC-MAX fn list &rest more-lists

This function applies the function to the first element of the
lists, then to the second element, and so on.   It returns the
maximum of all the results.  If any of the lists are null
MAPC-MAX returns nil."

  (let* ((vis (mapcar #'(lambda (arg)
                          (let ((var (gensym)))
                            `(,var ,arg (cdr ,var))))
                      (cons list more-lists)))
         (list-vars (mapcar #'car vis))
         (max-v (gensym))
         (temp-v (gensym))
         (function-v (gensym)))
    `(do ((,max-v nil)
          (,temp-v nil)
          (,function-v ,fn)
          ,@vis)
         ((or ,@(mapcar #'(lambda (v) `(endp ,v)) list-vars))
          ,max-v)
       (setf ,temp-v (funcall ,function-v
                              ,@(mapcar #'(lambda (v) `(first ,v)) list-vars)))
       (setf ,max-v
             (if (null ,max-v)
                 ,temp-v
                 (max ,max-v ,temp-v))))))


(defmacro mapc-eq (fn list &rest more-lists)

  "MAPC-EQ fn list &rest more-lists

This function applies the function to the first element of the
lists, then to the second element, and so on.   It returns true
if the results of all the function applications are EQ."

  (let* ((vis (mapcar #'(lambda (arg)
                          (let ((var (gensym)))
                            `(,var ,arg (cdr ,var))))
                      (cons list more-lists)))
         (list-vars (mapcar #'car vis))
         (result-v (gensym))
         (temp-v (gensym))
         (function-v (gensym)))
    ;; In order to identify the first time through the loop,
    ;; the value of RESULT-V is initialized to a gensym.
    `(do ((,result-v ',result-v)
          (,temp-v nil)
          (,function-v ,fn)
          ,@vis)
         ((or ,@(mapcar #'(lambda (v) `(endp ,v)) list-vars))
          t)
       (setf ,temp-v (funcall ,function-v
                              ,@(mapcar #'(lambda (v) `(first ,v)) list-vars)))
       ;; First time
       (when (eq ,result-v ',result-v)
         (setf ,result-v ,temp-v))
       (unless (eq ,result-v ,temp-v)
         (return nil)))))


;;;; --------------------------------------------------------------------------
;;;;   Sequence Functions
;;;; --------------------------------------------------------------------------


(defun remove-nth (n list)
  
  "REMOVE-NTH n list
Returns a new list constructed from list by removing the nth element.
The former nth+1 element becomes the nth element, the nth+2 element
the nth+1, and so on."
  
  (check-type n (and fixnum (not (satisfies minusp))))
  (let ((first-part nil)
        (list list)
        (i n))
    (declare (list first-part))
    (do ()
	((not (plusp i)))
      (cond
	((atom list)
	 (error "Element index ~S is larger than list length." n))
	(t (push (first list) first-part)
	   (decf i)
	   (pop list))))
    (when (atom list)
      (error "Element index ~S is larger than list length." n))
    (let ((rest (rest list)))
      (nreconc first-part (unless (atom rest)
                            rest)))))


(defun delete-nth (n list)
  
  "DELETE-NTH n list
Destructive version of REMOVE-NTH."
  
  (check-type n (and fixnum (not (satisfies minusp))))
  (cond ((zerop n)
         (rest list))                             ; Just skip first element.
        (t
	 (let ((pointer (nthcdr (- n 1) list)))
	   (when (atom pointer)
	     (error "Element index ~S is larger than list length." n))
	   (let ((rest (rest pointer)))
	     (unless (consp rest)
	       (error "Element index ~S is larger than list length." n))
	     (setf (rest pointer)  (unless (atom (rest rest))
				     (rest rest))))
	   list))))


;;;; --------------------------------------------------------------------------
;;;;   Association List Functions
;;;; --------------------------------------------------------------------------


(define-modify-macro PUSH-ACONS (key datum)
                     (lambda (place key datum)
                       (acons key datum place))

  "PUSH-ACONS place key datum

Pushes an ACONS of key and datum onto the place alist (whether or not 
a matching key exists in the place alist.  Returns the updated alist.")


(define-modify-macro PUSHNEW-ACONS (key datum &REST keys)
                     (lambda (place key datum &REST keys)
                       (let ((assoc-result (apply 'assoc key place keys)))
                         (cond (assoc-result
                                   (setf (rest assoc-result) datum)
                                   place)
                               (t (push-acons place key datum)))))

  "PUSHNEW-ACONS place key datum  &KEYS :TEST :TEST-NOT

Performs an PUSH-ACONS of place, key, and datum only if ASSOC of 
key and place returns NIL.  Otherwise, datum replaces the old
datum of key.  In either case, PUSHNEW-ACONS returns the modified
alist.")


;;; ---------------------------------------------------------------------------
;;;				  End of File
;;; ---------------------------------------------------------------------------
