;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:OPS; Base:10 -*-
;;;; *-* File: VAX6:DIS$DISK:[GBB.V-120.DISTRIBUTION.OPS]OPS.LISP *-*
;;;; *-* Edited-By: Gallagher *-*
;;;; *-* Last-Edit: Thursday, February 9, 1989  13:49:09 *-*
;;;; *-* Machine: Gilgamesh (Explorer II, Microcode 308) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (0.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *         OPS5 Compiling, Loading, and Initialization Definitions
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; This file contains functions for compiling, loading, and initializing the
;;; OPS interpreter.
;;;
;;; OPS Modifications Written by: 
;;;             Daniel Corkill
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; These modifications were written as part of the GBB (Generic Blackboard)
;;; system at the Department of Computer and Information Science (COINS),
;;; University of Massachusetts, Amherst.
;;;
;;; Modifications Copyright (c) 1988 COINS.  
;;; All rights reserved.
;;;
;;; This GBB version of OPS5 was modified from the public domain version based
;;; in part on based on a Franz Lisp implementation done by Charles L. Forgy
;;; at Carnegie Mellon University.  The public domain version was also
;;; modified by George Wood, Dario Giuse, Skef Wholey, Michael Parzen,
;;; and Dan Kuokka.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments;
;;;    ONR URI grant N00014-86-K-0764;
;;;    a contract with Digital Equipment Corporation.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  04-07-88 File Released.  (Cork)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(provide "GBB OPS")

(in-package "OPS")

(require "GBB SIMPLE-SHELL" (user::gbb-file "simple-shell" "simple-shell")) 

(use-package '("LISP" "UMASS-EXTENDED-LISP" "GBB" "SIMPLE-SHELL"))

;;; ---------------------------------------------------------------------------

(defconstant *OPS-FILES*
             '("ops-globals"
               "ops-backup"
               "ops-compile"
               "ops-io"
               "ops-main"
               "ops-match"
               "ops-rhs"
               "ops-util"
               ;; simple-shell interface
               "ops-simple-shell-interface"))

;;; ---------------------------------------------------------------------------

(defparameter *OPS-SOURCE-DIRECTORY*
              (user::gbb-subdirectory "ops")
  "Directory where the OPS source and compiled files will be stored.")

;;;; --------------------------------------------------------------------------
;;;;   Simple Loading Functions
;;;; --------------------------------------------------------------------------

(defun LOAD-OPS ()

  "Load OPS.  If any compiled files exist this will load them;
otherwise it will load the source files."

  (let ((defaults (pathname *ops-source-directory*)))
    (flet ((load-file (file) (load-a-file file defaults)))
      (mapc #'load-file *ops-files*))
    t))

;;; ---------------------------------------------------------------------------

(defun LOAD-UNCOMPILED-OPS ()

  "Load uncompiled OPS.  This will only load source files, whether or not
any compiled versions exist."

  (let ((defaults (pathname *ops-source-directory*)))
       (flet ((load-file (file)
              (load-a-file file defaults t)))
      (mapc #'load-file *ops-files*))
    t))

;;; ---------------------------------------------------------------------------

(defun COMPILE-AND-LOAD-OPS (&OPTIONAL recompile)

  "Compile and load OPS.  If a compiled file already exists it
will be loaded.  If the optional argument RECOMPILE is true
then all the files will be compiled regardless of whether a
compiled file exists."

  (let ((defaults (pathname *ops-source-directory*)))
    (load-uncompiled-ops)       
    (flet ((load-file (file)
              (compile-and-load-a-file file defaults recompile)))
      (mapc #'load-file *ops-files*))
    t))

;;; ---------------------------------------------------------------------------

(defun LOAD-A-FILE (file-name
                    &OPTIONAL
                    (defaults *default-pathname-defaults*)
                    (load-source-only nil))
  (let* ((source-file (make-pathname :name file-name
                                     :type user::*source-file-type*
                                     :defaults defaults))
         (compiled-file (make-pathname :name file-name
                                       :type user::*compiled-file-type*
                                       :defaults defaults))
         (selected-file (if (and (not load-source-only)
                                 (probe-file compiled-file))
                            compiled-file
                            source-file)))
    (format t "~&;;; Loading ~a~%" (namestring selected-file))
    (load selected-file :verbose nil)))

;;; ---------------------------------------------------------------------------

(defun COMPILE-AND-LOAD-A-FILE (file-name
                                &OPTIONAL
                                (defaults *default-pathname-defaults*)
                                recompile)
  (let ((source-file (make-pathname :name file-name
                                    :type user::*source-file-type*
                                    :defaults defaults))
        (compiled-file (make-pathname :name file-name
                                      :type user::*compiled-file-type*
                                      :defaults defaults)))
    (when (or recompile (not (probe-file compiled-file)))
      (format t "~&;;; Compiling ~a~%" (namestring source-file))
      (compile-file source-file))
    (format t "~&;;; Loading ~a~%" (namestring compiled-file))
    (load compiled-file :verbose nil)))

;;; ---------------------------------------------------------------------------
;;;                                 End of File
;;; ---------------------------------------------------------------------------



