;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:(OPS USE '(GBB SIMPLE-SHELL)); Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL.OPS]OPS-SIMPLE-SHELL-INTERFACE.LISP *-*
;;;; *-* Last-Edit: Thursday, September 15, 1988  14:30:38; Edited-By: Cork *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                           OPS GBB KS SHELL
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Daniel Corkill
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1988 by COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments, Inc.;
;;;    ONR URI grant N00014-86-K-0764;
;;;    a contract with Digital Equipment Corporation.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  05-18-88 File Released.  (Cork)
;;;  09-06-88 Updated to V1.2 simple shell specifications.  (Cork)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package "OPS")

(use-package '("GBB"
               "SIMPLE-SHELL"))

(proclaim '(optimize (speed 3) (safety 1)))

;;; --------------------------------------------------------------------------

(defvar *OPS-SYSTEM-DEFINITIONS* '()

  "*OPS-SYSTEM-DEFINITIONS*

Contains system definitions of shared OPS KS systems.")

;;; --------------------------------------------------------------------------
;;;
;;; OPS KS Unit Definition ::
;;;
;;; --------------------------------------------------------------------------

(define-unit (OPS-KS
               :EXPORT
               (:INCLUDE basic-ks))          ; Include the control shell's
                                             ; basic KS definition.
  "OPS KS (Knowledge Source)

This unit type contains knowledge source information."
  
  :SLOTS
  (ops-precondition-globals
    ops-ks-globals))

;;; --------------------------------------------------------------------------
;;;
;;; Basic KSI Unit Definition ::
;;;
;;; --------------------------------------------------------------------------

(define-unit (OPS-KSI
               :EXPORT
               (:INCLUDE basic-ksi))         ; Include the control shell's
                                             ; basic KSI definition.
  "OPS-KSI (Knowledge Source Instance)

This unit type represents a knowledge source instantiation (or activation)
record on the scheduling queue.")

;;; --------------------------------------------------------------------------
;;;
;;; OPS KS Defining Form Definition ::
;;;
;;; --------------------------------------------------------------------------

(defmacro DEFINE-OPS-SYSTEM (name ops-expressions)

  (check-type name symbol)
  `(pushnew-acons *ops-system-definitions* ',name
                  (let ((*ops-globals-structure* (ops-init)))
                    ,@ops-expressions
                    *ops-globals-structure*)))

;;; --------------------------------------------------------------------------

(defun USE-OPS-SYSTEM (name)

  (check-type name symbol)
  (let ((system (assoc name *ops-system-definitions*)))
     (when (null system)
       (error "OPS System ~S was not defined." name))
     (rest system)))

;;; --------------------------------------------------------------------------

(defmacro DEFINE-OPS-KS (name &KEY trigger-conditions
                         ops-precondition ops-precondition-system
                            precondition-function
                         ops-ks ops-ks-system ks-function)

  "DEFINE-OPS-KS name &KEY trigger-conditions
                           {ops-precondition | ops-precondition-system |
                                precondition-function}
                           {ops-ks | ops-ks-system | ks-function}

Notifies the control shell of the existence of OPS KS `name'.  `Name' must
be a symbol naming the KS.

The legal `trigger-conditions' are:
  (:UNIT-CREATION unit-types)
  (:UNIT-DELETION unit-types)
  (:UNIT-ADDITION-TO-SPACE {(unit-types path-specificiations)}+)
  (:UNIT-REMOVAL-FROM-SPACE {(unit-types path-specificiations)}+)
  (:SLOT-ACCESS {(unit-types slot-names)}+)
  (:SLOT-UPDATE {(unit-types slot-names)}+)
  (:LINK-ACCESS {(unit-types link-names)}+)
  (:LINK-UPDATE {(unit-types link-names)}+)
  (:UNLINK {(unit-types link-names)}+)
  (:QUEUE-QUIESCENCE).

`OPS-KS' and `OPS-precondition' are complete and disjoint sets of extended
GBB/OPS statements.  (`OPS-precondition' can be nil for the initial KS).

`OPS-KS-system' and `OPS-precondition-system' can be used in place of 
`OPS-KS' and `OPS-precondition' to refer to an OPS system defined using 
DEFINE-OPS-SYSTEM.

`Ks-function' and `precondition-function' must be valid arguments for
FUNCALL.  (`Precondition-function' can be nil for the initial KS)."

  
  ;; Verify arguments ::
  (check-type name symbol)
  (when (and (null ops-ks) (null ops-ks-system) (null ks-function))
    (error "An OPS-KS or OPS-KS-SYSTEM ruleset or a KS-FUNCTION must ~
            be supplied to DEFINE-OPS-KS."))
  (when (and ops-precondition precondition-function)
    (error "OPS-PRECONDITION and PRECONDITION-FUNCTION cannot both ~
            be specified in DEFINE-OPS-KS."))
  (when (and ops-precondition ops-precondition-system)
    (error "OPS-PRECONDITION and OPS-PRECONDITION-SYSTEM cannot both ~
            be specified in DEFINE-OPS-KS."))
  (when (and ops-precondition-system precondition-function)
    (error "OPS-PRECONDITION-SYSTEM and PRECONDITION-FUNCTION cannot both ~
            be specified in DEFINE-OPS-KS."))
  (when (and ops-ks ks-function)
    (error "OPS-KS and KS-FUNCTION cannot both be specified in ~
            DEFINE-OPS-KS."))
  (when (and ops-ks ops-ks-system)
    (error "OPS-KS and OPS-KS-SYSTEM cannot both be specified in ~
            DEFINE-OPS-KS."))
  (when (and ops-ks-system ks-function)
    (error "OPS-KS-SYSTEM and KS-FUNCTION cannot both be specified in ~
            DEFINE-OPS-KS."))
  (when (and (null ops-precondition)
             (null ops-precondition-system)
             (null precondition-function)
             (not (null trigger-conditions)))
    (error "A TRIGGER-CONDITIONS argument cannot be specified ~
            without also supplying an OPS-PRECONDITION, ~
            OPS-PRECONDITION-SYSTEM, or PRECONDITION-FUNCTION."))
    
    
  (let ((event-types '())
        (unit-types '())
        (slot/link-names '())
        (paths '()))
    (labels

      ;; Helper to check the number of values given to trigger-condition
      ;; parameters ::
      ((value-check (value min max name &OPTIONAL (form value))
         (let ((length (length value)))
           (when (< length min)
             (error "Too few values were supplied to ~A.~
                     ~%   ~S ~:[are~;is~] required, ~S ~:[were~;was~] ~
                     supplied in:~
                     ~%   ~S."
                    name min (= 1 min) length length form))
           (when (and max (> length max))
             (error "Too many values were supplied to ~A.~
                     ~%   ~S ~:[are~;is~] required, ~S ~:[were~;was~] ~
                     supplied in:~
                     ~%   ~S."
                    name max (= 1 max) length length form))))

       ;; Helper to process individual trigger condition.  Since trigger
       ;; conditions containing bb/space-paths must be converted to
       ;; MAKE-PATH form, this function returns the (possibly modified)
       ;; trigger condition for all event types.
       (process-trigger-condition (trigger-condition)
         (let ((event-type (first trigger-condition)))
           (case event-type

             ;;
             ;; Unit Creation and Deletion Triggers ::
             ;;
             ((:unit-creation :unit-deletion)
              (value-check (rest trigger-condition) 1 1
                           ':trigger-condition trigger-condition)
              (pushnew event-type event-types :TEST 'eq)
              (check-type (second trigger-condition) symbol)
              (pushnew (second trigger-condition) unit-types :TEST 'eq)
              `',trigger-condition)             ; Return it unchanged.
             
             ;;
             ;; Unit Addition and Removal Triggers ::
             ;;
             ((:unit-addition-to-space :unit-removal-from-space)
              (value-check (rest trigger-condition) 1 nil
                           ':trigger-condition trigger-condition)
              (pushnew event-type event-types :TEST 'eq)
              (let ((subconditions
                      (mapcar
                        #'(lambda (subcondition)
                            (value-check subcondition 2 2
                                         "unit-type/path specification")
                            (let ((unit-types-spec
                                    (gbb::assure-list (first subcondition)))
                                  (paths-spec (second subcondition)))
                              (dolist (unit-type unit-types-spec)
                                (check-type unit-type symbol))
                              (setf unit-types
                                  (union unit-types-spec unit-types
                                         :TEST 'eq))
                              (check-type paths-spec cons)
                              (setf paths (union paths-spec paths
                                                 :TEST 'equal))
                              `(list ',unit-types-spec
                                     (make-paths :PATHS ',paths-spec))))
                        (rest trigger-condition))))

                ;; Return modified trigger-condition ::
                `(list ',(first trigger-condition) ,@subconditions)))

             ;;
             ;; Slot and Link Access, Update, and Unlink Triggers ::
             ;;
             ((:slot-access :slot-update :link-access :link-update :unlink)
              (pushnew event-type event-types :TEST 'eq)
              (value-check (rest trigger-condition) 1 nil
                           ':trigger-condition trigger-condition)
              (dolist (subcondition (rest trigger-condition))
                (value-check subcondition 2 2
                             "unit-type/path specification")
                (let ((unit-types-spec
                        (gbb::assure-list (first subcondition)))
                      (slots/links-spec
                        (gbb::assure-list (second subcondition))))
                  (dolist (unit-type unit-types-spec)
                    (check-type unit-type symbol))
                  (dolist (slot/link-name slots/links-spec)
                    (check-type slot/link-name symbol))
                  (setf unit-types
                        (union unit-types-spec unit-types
                               :TEST 'eq))
                  (setf slot/link-names
                        (union slots/links-spec slot/link-names
                               :TEST 'eq))))
              `',trigger-condition)             ; Return it unchanged.
             
             ;;
             ;; Queue Quiescence Trigger ::
             ;;
             (:queue-quiescence
              (value-check (rest trigger-condition) 0 0
                           ':trigger-condition trigger-condition)
              (pushnew event-type event-types :TEST 'eq)
              `',trigger-condition)             ; Return it unchanged.
             
             (otherwise
              (error "Illegal trigger condition event name: ~S." event-type))))))

      (setf trigger-conditions
            (mapcar #'process-trigger-condition trigger-conditions)))

    ;; Define the KS ::
    `(progn
       (pushnew-acons
         simple-shell::*ks-definition-forms*
         ',name
         '(let ((ks (make-ops-ks
                      :NAME ',name
                      :KSI-CREATION-FUNCTION 'make-ops-ksi
                      :PRECONDITION-FUNCTION
                        ,(if (or ops-precondition ops-precondition-system)
                             ''run-ops-precondition
                             precondition-function)
                      :OPS-PRECONDITION-GLOBALS
                        ,(cond (ops-precondition
                                '(ops-init))
                               (ops-precondition-system
                                `(use-ops-system ',ops-precondition-system)))
                      :KS-FUNCTION
                        ,(if (or ops-ks ops-ks-system)
                             ''run-ops-ks
                             ks-function)
                      :OPS-KS-GLOBALS 
                        ,(cond (ops-ks
                                '(ops-init))
                               (ops-ks-system
                                `(use-ops-system ',ops-ks-system)))
                      :TRIGGER-CONDITIONS (list ,@trigger-conditions)
                      :EVENT-TYPES ',event-types
                      :UNIT-TYPES ',unit-types
                      :SLOT/LINK-NAMES ',slot/link-names
                      :PATHS
                        (append ,@(mapcar #'(lambda (path)
                                              `(make-paths :PATHS '(,path)))
                                          paths)))))
            ,@(when ops-precondition
                `((let ((*ops-globals-structure*
                          (ops-ks$ops-precondition-globals ks)))
                    ,@ops-precondition)))
            ,@(when ops-ks
                `((let ((*ops-globals-structure* (ops-ks$ops-ks-globals ks)))
                    ,@ops-ks))))
         :TEST #'eq)
       ',name)))

;;; ---------------------------------------------------------------------------

(defun RUN-OPS-PRECONDITION (ks stimulus-unit)
  (let ((*ops-globals-structure* (ops-ks$ops-precondition-globals ks)))
    (ops-reinit)
    (ops-make `(stimulus ,stimulus-unit))
    (when (global-break-on-entry)
      (break "Break at OPS PRECONDITION ~A" (basic-ks$name ks)))
    (run)))

;;; ---------------------------------------------------------------------------

(defun RUN-OPS-KS (ks ksi)
  (let ((*ops-globals-structure* (ops-ks$ops-ks-globals ks)))
    (ops-reinit)
    (ops-make `(ksi ,ksi))
    (when (global-break-on-entry)
      (break "Break at OPS KS ~A" (basic-ks$name ks)))
    (run)))

;;; **************************************************************************
;;;                                End of File
;;; **************************************************************************


