;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:OPS; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL.OPS]OPS-RHS.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Thursday, September 15, 1988  14:25:21 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                       OPS5 RHS Action Definitions
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; This file contains all functions necessary for RHS actions including
;;; $actions.
;;;
;;; OPS5 Modifications Written by: 
;;;             Daniel Corkill
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; These modifications were written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst.
;;;
;;; Modifications Copyright (c) 1988 COINS.  
;;; All rights reserved.
;;;
;;; This GBB version of OPS5 was modified from the public domain version based
;;; in part on based on a Franz Lisp implementation done by Charles L. Forgy
;;; at Carnegie Mellon University.  The public domain version was also
;;; modified by George Wood, Dario Giuse, Skef Wholey, Michael Parzen,
;;; and Dan Kuokka.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments;
;;;    ONR URI grant N00014-86-K-0764;
;;;    a contract with Digital Equipment Corporation.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  04-07-88 File Released.  (Cork)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package "OPS")

(shadow '(remove write))
#+EXPLORER 
(shadow '(bind call))

(export '(accept
           acceptline
           build
           cbind
           closefile
           compute
           crlf
           default
           halt
           litval
           make
           make-cer-var-bind
           make-var-bind
           modify
           openfile
           remove
           return-values
           rjust
           substr
           tabto
           write))

;(proclaim '(special *ptrace* *cycle-count* *halt-flag* *wtrace*))


;;; External global variables
;;; *SIZE-RESULT-ARRAY*, *IN-RHS*, *CURRENT-WM*, *MAX-WM*, 
;;; *ACTION-COUNT*, and *CRITICAL*.


;;; Internal global variables
;;; *WMPART-LIST*, *RESULT-ARRAY*, *VARIABLE-MEMORY*, *LAST*,
;;; *MAX-INDEX*, *NEXT-INDEX*, *DATA-MATCHED*, *CE-VARIABLE-MEMORY*, 
;;; *REST*, and *BUILD-TRACE*.


;;; ---------------------------------------------------------------------------
;;; Functions for RHS evaluation
;;; ---------------------------------------------------------------------------

(defun RHS-INIT ()

  "RHS-INIT nil

This function initializes the RHS file constants."

  (rhs-reinit))

;;; ---------------------------------------------------------------------------

(defun RHS-REINIT ()

  "RHS-REINIT nil

This function reinitializes the RHS file constants for the next
OPS invocation instance."

  ; if the size of result-array changes, change the line in i-g-v which
  ; sets the value of *size-result-array*
  (setf (global-size-result-array) 255)
  (setf (global-result-array)
        (make-array (1+ (global-size-result-array))
                    :INITIAL-ELEMENT nil))
  (setf (global-in-rhs) nil)
  (setf (global-build-trace) nil)
  (setf (global-max-wm) 0)
  (setf (global-current-wm) 0)
  (setf (global-action-count) 0)
  (setf (global-critical) nil)
  (setf (global-wmpart-list) nil))

;;; ---------------------------------------------------------------------------

(defun EVAL-RHS (pname data)
  (prog (node port)
    (cond ((global-ptrace)
	   (setf port (trace-file))
           (format port "~%~4D. ~A" (global-cycle-count) pname)
	   (time-tag-print data port)))
    (setf (global-data-matched) data)
    (setf (global-p-name) pname)
    (setf (global-last) nil)
    (setf node (get-ops-prop pname (global-topnode-props)))
    (init-var-mem (var-part node))
    (init-ce-var-mem (ce-var-part node))
    (begin-record pname data)
    (setf (global-in-rhs) t)
    (eval (rhs-part node))
    (setf (global-in-rhs) nil)
    (end-record)))

;;; ---------------------------------------------------------------------------

(defun EVAL-ARGS (z)
  (rhs-tab 1)
  (prog (r)
     la
        (and (atom z) (return nil))
        (setf r (first z))
        (setf z (rest z))
        (when (eq r '^)
          (rhs-tab (first z))
          (setf r (second z))
          (setf z (rest (rest z))))
        (cond
          ((eq r '//)
           ($value (first z))
           (setf z (rest z)))
          (t ($change r)))
        (go la))) 

;;; ---------------------------------------------------------------------------
;;; RHS actions
;;; Some of these can be called at the top level.
;;; ---------------------------------------------------------------------------

(eval-when (compile eval load)

(defmacro MAKE (&body z)

  "MAKE [class-name] [{scalar-attribute value}*] [vector-attribute value]

Creates a working-memory element."

  `(ops-make ',z))

;;; ---------------------------------------------------------------------------

(defmacro REMOVE (&body z)

  "REMOVE {element-designator}+

Deletes elements from working memory."

  `(ops-remove ',z))

;;; ---------------------------------------------------------------------------

(defmacro MODIFY (&body z)

  "MODIFY element-designator {attribute value}+

Changes a working-memory element."

  `(ops-modify ',z))

;;; ---------------------------------------------------------------------------

(defmacro OPENFILE (&body z)

  "OPENFILE file-id file-spec mode

Opens a file for input or output.  `Mode' is either IN or OUT."

  `(ops-openfile ',z))

;;; ---------------------------------------------------------------------------

(defmacro CLOSEFILE (&body z)

  "CLOSEFILE {file-id}+

Closes the open file associated with `file-id'."

  `(ops-closefile ',z))

;;; ---------------------------------------------------------------------------

(defmacro DEFAULT (&body z)

  "DEFAULT {file-id | nil} use

Sets the file associated with `file-id' or the terminal (if nil is supplied) 
for input/output of type `use'.  `Use' is one of ACCEPT, TRACE, or WRITE. "

  `(ops-default ',z))

;;; ---------------------------------------------------------------------------

(defmacro WRITE (&body z)

  "WRITE [file-id] rhs-expression

Outputs to a terminal or file."

  `(ops-write ',z))

;;; ---------------------------------------------------------------------------

(defmacro CRLF (&body z)

  "CRLF

Forces WRITE action to start a new line."

  `(ops-crlf ',z))

;;; ---------------------------------------------------------------------------

(defmacro TABTO (&body z)

  "TABTO column

Forces WRITE action to move to column `column'."

  `(ops-tabto ',z))

;;; ---------------------------------------------------------------------------

(defmacro RJUST (&body z)

  "RJUST width

Forces WRITE action to right justify output in a field of width `width'."

  `(ops-rjust ',z))

;;; ---------------------------------------------------------------------------

(defmacro CALL (&body z)

  "CALL external-routine-name

Calls an external Lisp subroutine.  Values are passed via the result element.
(See GBB/OPS extension CL-CALL that passes values directly.)"

  `(ops-call ',z))

;;; ---------------------------------------------------------------------------

(defmacro CL-CALL (&body z)

  "CL-CALL external-routine-name {arguments}*

This GBB/OPS extension allows any number of evaluated arguments
to be passed to an external Common Lisp function.  Multiple return
values are placed into the result element for extraction using 
$parameter.

Supports the GBB OPS list datatype extensions."

  `(ops-cl-call ',z))

;;; ---------------------------------------------------------------------------

(defmacro RETURN-VALUES (&body z)

  "RETURN-VALUES {value}*

This GBB/OPS extension stops OPS from executing recognize-act cycles after the 
current cycle ends, and returns a Common Lisp multiple value to the invoker of
GBB/OPS."

  `(ops-return-values ',z))

;;; ---------------------------------------------------------------------------

(defmacro BIND (&body z)

  "BIND variable [rhs-expression]

Binds a variable to the result of evaluating rhs-expression."

  `(ops-bind ',z))

;;; ---------------------------------------------------------------------------

(defmacro CBIND (&body z)

  "CBIND element-variable

Binds an element variable to the last element added to working memory by a 
MAKE, MODIFY, CALL, or CL-CALL action."

  `(ops-cbind ',z))

;;; ---------------------------------------------------------------------------

(defmacro BUILD (&body z)

  "BUILD production-name lhs-expression --> rhs-expression

Adds a new production to the executing GBB/OPS system."

  `(ops-build ',z))

;;; ---------------------------------------------------------------------------

(defmacro SUBSTR (&body l)

  "SUBSTR element-designator first-value last-value

Copies a sequence of atoms from a working-memory element to a WRITE, MAKE, or
MODIFY action."

  `(ops-substr ',l))

;;; ---------------------------------------------------------------------------

(defmacro COMPUTE (&body z)

  "COMPUTE arithmetic-expression

Evaluates an arithmetic expression and returns the result."

  `(ops-compute ',z))

;;; ---------------------------------------------------------------------------

(defmacro LITVAL (&body z)

  "LITVAL attribute-name

Returns an integer representing an attribute's field."

  `(ops-litval ',z))

;;; ---------------------------------------------------------------------------

(defmacro ACCEPT (&body z)

  "ACCEPT [file-id]

Reads an atom or list of atoms from the terminal or a file."

  `(ops-accept ',z))

;;; ---------------------------------------------------------------------------

(defmacro ACCEPTLINE (&body z)

  "ACCEPTLINE [file-id] [{default-value}*]

Reads a line of input atoms and lists of atoms from the terminal or a file.
The default values are used if the line is empty or the file at its end."

  `(ops-acceptline ',z))

;;; ---------------------------------------------------------------------------
;;;
;;; Utility macros ::
;;;
;;; ---------------------------------------------------------------------------

(defmacro MAKE-CE-VAR-BIND (var elem)
  `(push (cons ,var ,elem) (global-ce-variable-memory)))

(defmacro MAKE-VAR-BIND (var elem)
  `(push (cons ,var ,elem) (global-variable-memory)))

(defmacro QUOTED-P (exp)
  ;; This macro should only be called with symbol args ::
  `(and (consp ,exp)
        (eq (first ,exp) '$quote)))

) ;; end eval-when

;;; ---------------------------------------------------------------------------

(defun OPS-MAKE (z)
  ($reset)
  (eval-args z)
  ($assert))

;;; ---------------------------------------------------------------------------

(defun OPS-REMOVE (z)
  (prog (old)
        (and (not (global-in-rhs))
             (return (top-level-remove z)))
     top
        (and (atom z) (return nil))
        (setf old (get-ce-var-bind (first z)))
        (cond ((null old)
               (%warn "Argument is not an element variable:" 'remove (first z))
               (return nil)))
        (remove-from-wm old)
        (setf z (rest z))
        (go top))) 

;;; ---------------------------------------------------------------------------

(defun OPS-MODIFY (z)
  (prog (old)
        (cond ((not (global-in-rhs))
               (%warn "Cannot be called at top level:" 'modify)
               (return nil)))
        (setf old (get-ce-var-bind (first z)))
        (cond ((null old)
               (%warn "First argument must be an element variable:"
                      'modify
                      (first z))
               (return nil)))
        (remove-from-wm old)
        (setf z (rest z))
        ($reset)
     copy
        (and (atom old) (go fin))
        ($change (first old))
        (setf old (rest old))
        (go copy)
     fin
        (eval-args z)
        ($assert)))

;;; ---------------------------------------------------------------------------

(defun OPS-BIND (z)
  (prog (val)
        (cond ((not (global-in-rhs))
               (%warn "Cannot be called at top level:" 'bind)
               (return nil)))
        (cond ((< (length z) 1)
               (%warn "Wrong number of arguments:" 'bind z)
               (return nil))
              ((not (symbolp (first z)))
               (%warn "Illegal argument:" 'bind (first z))
               (return nil))
              ((= (length z) 1) (setf val (gensym)))
              (t ($reset)
                 (eval-args (rest z))
                 (setf val ($parameter 1))))
        (return (make-var-bind (first z) val))))

;;; ---------------------------------------------------------------------------

(defun OPS-CBIND (z)
  (cond ((not (global-in-rhs))
	 (%warn "Cannot be called at top level:" 'cbind))
	((not (= (length z) 1))
	 (%warn "Wrong number of arguments:" 'cbind z))
	((not (symbolp (first z)))
	 (%warn "Illegal argument:" 'cbind (first z)))
	((null (global-last))
	 (%warn "Nothing added yet:" 'cbind (first z)))
	(t (make-ce-var-bind (first z) (global-last))))) 

;;; ---------------------------------------------------------------------------

(defun OPS-CALL (z)
  (let ((f (first z)))
    ($reset)
    (eval-args (cdr z))
    (funcall f)))

;;; ---------------------------------------------------------------------------

(defun OPS-CL-CALL (z)
  ;; This version of CALL performs the evaluation and spreading of arguments;
  ;; avoiding the need to explicitly do it in the called Common Lisp function.
  ;; Also, each returned result value is placed into a reinitialized result 
  ;; element for later use within OPS.
  (let ((f (first z))
        (saved (save-result-array)))
    ($reset)
    (eval-args (rest z))
    (let ((result nil)
          (count ($parametercount)))
      (while (plusp count)
        (let ((arg ($parameter count)))
          (when (quoted-p arg)
            (setf arg (second arg)))
          (push arg result))
        (decf count))
      (restore-result-array saved)
      (dolist (result (multiple-value-list (apply f result)))
        (cond ((consp result)
               ($value (list '$quote result)))
              (t ($value result))))))) 

;;; ---------------------------------------------------------------------------

(defun $FIRST (&REST ignore)

  "$FIRST GBB/OPS-list

Returns the first element of a GBB/OPS list."

  (declare (ignore ignore))
  (%warn "Cannot be called at top level:" '$first))

;;; ---------------------------------------------------------------------------

(defun $REST (&REST ignore)

  "$FIRST GBB/OPS-list

Returns a GBB/OPS list containing all elements but the first from
`GBB/OPS-list'."

  (declare (ignore ignore))
  (%warn "Cannot be called at top level:" '$rest))

;;; ---------------------------------------------------------------------------

(defun $LIST (&REST ignore)

  "$LIST {element}*

Returns a GBB/OPS list containing the supplied elements.  The elements are
evaluated as required."

  (declare (ignore ignore))
  (%warn "Cannot be called at top level:" '$list))

;;; ---------------------------------------------------------------------------

(defun $CONS (&REST ignore)

  "$CONS element GBB/OPS-list

Adds element to the front of `GBB/OPS-list'."

  (declare (ignore ignore))
  (%warn "Cannot be called at top level:" '$cons))

;;; ---------------------------------------------------------------------------

(defun $QUOTE (&REST ignore)

  "$QUOTE GBB/OPS-list

Returns the GBB/OPS list without evaluating its composite elements.  This
is an alternate syntax for // when constructing constant GBB/OPS-lists."

  (declare (ignore ignore))
  (%warn "Cannot be called at top level:" '$quote))

;;; ---------------------------------------------------------------------------

(defun HALT ()

  "HALT

Stops OPS from executing recognize-act cycles after the current cycle ends."

  (cond ((not (global-in-rhs))
	 (%warn "Cannot be called at top level:" 'halt))
	(t (setf (global-return-values) nil)
           (setf (global-halt-flag) t)))) 

;;; ---------------------------------------------------------------------------

(defun OPS-RETURN-VALUES (z)
  (cond ((not (global-in-rhs))
	 (%warn "Cannot be called at top level:" 'return-values))
	(t ($reset)
           (eval-args z)
           (prog1
             (let ((result nil)
                   (count ($parametercount)))
               (while (plusp count)
                 (let ((value ($parameter count)))
                   (if (quoted-p value)
                       (push (second value) result)
                       (push value result)))
                 (decf count))
               (setf (global-return-values) result))
             (setf (global-halt-flag) t)))))

;;; ---------------------------------------------------------------------------

(defun OPS-BUILD (z)
  (prog (r)
        (cond ((not (global-in-rhs))
               (%warn "Cannot be called at top level:" 'build)
               (return nil)))
        ($reset)
        (build-collect z)
        (setf r (unflat (use-result-array)))
        (and (global-build-trace) (funcall (global-build-trace) r))
        (compile-production (first r) (rest r)))) 

;;; ---------------------------------------------------------------------------

(defun OPS-COMPUTE (z)
  ($value (ari z))) 

;;; ---------------------------------------------------------------------------

(defun ARI (x)
  (cond ((atom x)
	 (%warn "Bad syntax in arithmetic expression:" 'compute x)
	 0)
	((atom (rest x)) (ari-unit (first x)))
	((eq (second x) '+)
	 (+ (ari-unit (first x)) (ari (cddr x))))
	((eq (second x) '-)
	 (- (ari-unit (first x)) (ari (cddr x))))
	((eq (second x) '*)
	 (* (ari-unit (first x)) (ari (cddr x))))
	((eq (second x) '//)
	 (floor (ari-unit (first x)) (ari (cddr x))))   ;@@@ quotient? /
	;@@@ kluge only works for integers
	((eq (second x) '\\)
	 (mod (floor (ari-unit (first x))) (floor (ari (cddr x)))))
	(t (%warn "Bad syntax in arithmetic expression:" 'compute x) 0))) 

;;; ---------------------------------------------------------------------------

(defun ARI-UNIT (a)
  (prog (r)
        (cond ((consp a) (setf r (ari a)))
              (t (setf r ($varbind a))))
        (cond ((not (numberp r))
               (%warn "Bad value in arithmetic expression:" 'compute a)
               (return 0))
              (t (return r))))) 

;;; ---------------------------------------------------------------------------

(defun OPS-SUBSTR (l)
  (prog (k elm start end)
        (cond ((not (= (length l) 3))
               (%warn "Wrong number of arguments:" 'substr l)
               (return nil)))
        (setf elm (get-ce-var-bind (first l)))
        (cond ((null elm)
               (%warn "First argument must be a ce var:"
                      'substr l)
               (return nil)))
        (setf start ($varbind (second l)))
        (setf start ($litbind start))
        (cond ((not (numberp start))
               (%warn "Second argument must be a number:"
                      'substr l)
               (return nil)))
        ;; If a variable is bound to INF, the following
        ;; will get the binding and treat it as INF is
        ;; always treated.  That may not be good.
        (setf end ($varbind (third l)))
        (cond ((eq end 'inf) (setf end (length elm))))
        (setf end ($litbind end))
        (cond ((not (numberp end))
               (%warn "Third argument must be a number:"
                      'substr l)
               (return nil)))
        ;; This loop does not check for the end of elm
        ;; instead it relies on cdr of nil being nil.
        ;; This may not work in non-Common Lisp.
        (setf k 1)
     la
        (cond ((> k end) (return nil))
              ((not (< k start)) ($value (first elm))))
        (setf elm (rest elm))
        (setf k (1+ k))
        (go la))) 

;;; ---------------------------------------------------------------------------

(defun GENATOM nil

  "GENATOM

Returns a unique system-generated atom."

  ($value (gensym))) 

;;; ---------------------------------------------------------------------------

(defun OPS-LITVAL (z)
  (prog (r)
        (cond ((not (= (length z) 1))
               (%warn "Wrong number of arguments:" 'litval z)
               ($value 0) 
               (return nil))
              ((numberp (first z)) ($value (first z)) (return nil)))
        (setf r ($litbind ($varbind (first z))))
        (cond ((numberp r) ($value r) (return nil)))
        (%warn "Argument has no literal binding:" 'litval (first z))
        ($value 0)))

;;; ---------------------------------------------------------------------------
;;; rhs-tab implements the tab ('^') function in the rhs.  it has
;;; four responsibilities:
;;;	- to move the array pointers
;;;	- to watch for tabbing off the left end of the array
;;;	  (ie, to watch for pointers less than 1)
;;;	- to watch for tabbing off the right end of the array
;;;	- to write nil in all the slots that are skipped
;;; the last is necessary if the result array is not to be cleared
;;; after each use; if rhs-tab did not do this, $reset
;;; would be much slower.
;;; ---------------------------------------------------------------------------

(defun RHS-TAB (z)
  ($tab ($varbind z)))

;;; ---------------------------------------------------------------------------

(defun TIME-TAG-PRINT (data port)
  (cond ((not (null data))
	 (time-tag-print (rest data) port)
	 (princ " " port)
	 (princ (creation-time (first data)) port))))

;;; ---------------------------------------------------------------------------

(defun INIT-VAR-MEM (vlist)
  (prog (v ind r)
        (setf (global-variable-memory) nil)
     top
        (and (atom vlist) (return nil))
        (setf v (first vlist))
        (setf ind (second vlist))
        (setf vlist (cddr vlist))
        (setf r (gelm (global-data-matched) ind))
        (push (cons v r) (global-variable-memory))
        (go top))) 

;;; ---------------------------------------------------------------------------

(defun INIT-CE-VAR-MEM (vlist)
  (prog (v ind r)
        (setf (global-ce-variable-memory) nil)
     top
        (and (atom vlist) (return nil))
        (setf v (first vlist))
        (setf ind (second vlist))
        (setf vlist (cddr vlist))
        (setf r (ce-gelm (global-data-matched) ind))
        (push (cons v r) (global-ce-variable-memory))
        (go top))) 

;;; ---------------------------------------------------------------------------

(defun GET-CE-VAR-BIND (x)
  (cond ((numberp x) (get-num-ce x))
        (t (rest (assq x (global-ce-variable-memory))))))

;;; ---------------------------------------------------------------------------

(defun GET-NUM-CE (x)
  (prog (r l d)
        (setf r (global-data-matched))
        (setf l (length r))
        (setf d (- l x))
        (and (> 0 d) (return nil))
     la
        (cond ((null r) (return nil))
              ((> 1 d) (return (first r))))
        (setf d (1- d))
        (setf r (rest r))
        (go la))) 

;;; ---------------------------------------------------------------------------

(defun BUILD-COLLECT (z)
  (prog (r)
     la
        (and (atom z) (return nil))
        (setf r (first z))
        (setf z (rest z))
        (cond ((consp r)
               ($value '\()
               (build-collect r)
               ($value '\)))
              ((eq r '\\) ($change (first z)) (setf z (rest z)))
              (t ($value r)))
        (go la))) 

;;; ---------------------------------------------------------------------------

(defun UNFLAT (x)
  (setf (global-rest) x) (unflat*)) 

;;; ---------------------------------------------------------------------------

(defun UNFLAT* ()
  (prog (c)
        (cond ((atom (global-rest)) (return nil)))
        (setf c (first (global-rest)))
        (setf (global-rest) (rest (global-rest)))
        (cond ((eq c '\() (return (cons (unflat*) (unflat*))))
              ((eq c '\)) (return nil))
              (t (return (cons c (unflat*))))))) 

;;; ---------------------------------------------------------------------------
;;; $Functions.
;;; These functions provide an interface to the result array.
;;; The result array is used to organize attribute values into their
;;; correct slot.
;;; ---------------------------------------------------------------------------

(defun $LITBIND (x)

  "$LITBIND attribute-name

Returns the integer atom representing the field associated with an attribute 
name."

  (prog (r)
        (cond ((and (symbolp x) (setf r (literal-binding-of x)))
               (return r))
              (t (return x))))) 

;;; ---------------------------------------------------------------------------

(defun $VARBIND (x)
  (prog (r)
        (and (not (global-in-rhs)) (return x))
        (setf r (assq x (global-variable-memory)))
        (cond (r (return (rest r)))
              (t (return x))))) 

;;; ---------------------------------------------------------------------------

(defun $CHANGE (x)
  (prog nil
        (cond ((consp x) (eval-function x))
              (t ($value ($varbind x)))))) 

;;; ---------------------------------------------------------------------------

(defun $RESET nil

  "$RESET nil

Deletes all atoms in the result array."

  (setf (global-max-index) 0)
  (setf (global-next-index) 1)) 

;;; ---------------------------------------------------------------------------

(defun $TAB (z)

  "$TAB field

Specifies the field in which the next entry is to be placed in the result
array."

  (prog (edge next)
        (setf next ($litbind z))
        (and (floatp next) (setf next (floor next)))
        (cond ((or (not (numberp next)) 
                   (> next (global-size-result-array))
                   (> 1 next))             ; ( " ")
               (%warn "Illegal index after ^:" 'tab next)
               (return (global-next-index))))
        (setf edge (- next 1))
        (cond ((> (global-max-index) edge) (go ok)))
     clear
        (cond ((== (global-max-index) edge) (go ok)))
        (putvector (global-result-array) edge nil)
        (setf edge (1- edge))
        (go clear)
     ok
        (setf (global-next-index) next)
        (return next))) 

;;; ---------------------------------------------------------------------------

(defun $VALUE (v)

  "$VALUE value

Places an atom into the result array."

  (cond ((> (global-next-index) (global-size-result-array))
	 (%warn "Index too large:" 'value (global-next-index)))
	(t
	 (and (> (global-next-index) (global-max-index))
	      (setf (global-max-index) (global-next-index)))
	 (putvector (global-result-array) (global-next-index) v)
	 (incf (global-next-index)))))

;;; ---------------------------------------------------------------------------

(defun $ASSERT ()

  "$ASSERT

Adds the result element to working memory, creating a new working-memory
element."

  (setf (global-last) (use-result-array))
  (add-to-wm (global-last) nil))

;;; ---------------------------------------------------------------------------

(defun $PARAMETERCOUNT ()

  "$PARAMETERCOUNT

Returns the number of argument values stored in the result element."

  (global-max-index))

;;; ---------------------------------------------------------------------------

(defun $PARAMETER (k)

  "$PARAMETER integer

Returns the specified argument value from the result element."

  (cond ((or (not (numberp k)) (> k (global-size-result-array)) (< k 1))
	 (%warn "Illegal parameter number:" 'parameter k)
	 nil)
	((> k (global-max-index)) nil)
	(t (getvector (global-result-array) k))))

;;; ---------------------------------------------------------------------------

(defun $IFILE (x)

  "$IFILE file-id

Returns the Common Lisp stream of an input file."

  (cond ((symbolp x) (get-ops-prop x (global-inputfile-props)))
	(t nil)))

;;; ---------------------------------------------------------------------------

(defun $OFILE (x) 

  "$OFILE file-id

Returns the Common Lisp stream of an output file."

  (cond ((symbolp x) (get-ops-prop x (global-outputfile-props)))
	(t nil)))


;;; ---------------------------------------------------------------------------
;;; Use-result-array returns the contents of the result array as a list.

(defun USE-RESULT-ARRAY ()
  (prog (k r)
    (setf k (global-max-index))
    (setf r nil)
    top  (and (== k 0) (return r))
    (setf r (cons (getvector (global-result-array) k) r))
    (setf k (1- k))
    (go top))) 

;;; ---------------------------------------------------------------------------

(defun EVAL-FUNCTION (form)

  (flet ((check-for-$list (x operator)
           (unless (and (consp x)
                        (member (first x) '($quote $list)
                                :TEST #'eq))
             (%warn "Not a list value:" operator x))))
           
    (cond ((not (global-in-rhs))
           (%warn "Functions cannot be used at top level:" (first form)))
          ;; This is a HACK to put list-building interface into CL-CALL
          ;; DDC 5-15-88 ::
          ((eq (first form) '$quote) ($value form))
          
          ((eq (first form) '$first)
           (let ((saved (save-result-array)))
             ($reset)
             (eval-args (rest form))
             (let ((result ($parameter 1)))
               (check-for-$list result '$first)
               (setf result (first (second result)))
               (restore-result-array saved)
               ($value (if (consp result)
                           (list '$quote result)
                           result)))))

          ((eq (first form) '$rest)
           (let ((saved (save-result-array)))
             ($reset)
             (eval-args (rest form))
             (let ((result ($parameter 1)))
               (check-for-$list result '$rest)
               (setf result (rest (second result)))
               (restore-result-array saved)
               ($value (if (consp result)
                           (list '$quote result)
                           result)))))

          ((eq (first form) '$list)
           (let ((saved (save-result-array))
                 (result nil)
                 (count))
             ($reset)
             (eval-args (rest form))
             (setf count ($parametercount))
             (while (plusp count)
               (let ((arg ($parameter count)))
                 (when (quoted-p arg)
                   (setf arg (second arg)))
                 (push arg result))
               (decf count))
             (restore-result-array saved)
             ($value (list '$quote result))))

          ((eq (first form) '$cons)
           (let ((saved (save-result-array)))
             ($reset)
             (eval-args (rest form))
             (when (/= ($parametercount) 2)
               (%warn "Wrong number of arguments" '$cons form))
             (let ((result ($parameter 2)))
               (cond ((quoted-p result)
                      (setf result (cons ($parameter 1) (second result))))
                     (t
                      (push ($parameter 1) result)))
               (restore-result-array saved)
               ($value (list '$quote result)))))
          ;; End of HACK
          
          (t (eval form)))))

;;; ---------------------------------------------------------------------------

(defun SAVE-RESULT-ARRAY ()
  (let ((saved-result (first *ops-saved-result-resource*)))
    (cond
      ;; We have a resource element to use ::
      (saved-result
       (setf *ops-saved-result-resource* (first saved-result))
       (setf (first saved-result) (global-max-index))
       (setf (second saved-result) (global-next-index))
       (replace (third saved-result) (global-result-array))
       saved-result)

      ;; Allocate a new resource element ::
      (t
       (list (global-max-index)
             (global-next-index)
             (copy-seq (global-result-array)))))))

;;; ---------------------------------------------------------------------------

(defun RESTORE-RESULT-ARRAY (saved-data)
  (setf (global-max-index) (first saved-data))
  (setf (global-next-index) (second saved-data))
  (replace (global-result-array) (third saved-data))
  (setf (first saved-data) *ops-saved-result-resource*)
  (setf *ops-saved-result-resource* saved-data))

;;; ---------------------------------------------------------------------------
;;; WM maintaining functions
;;;
;;; The order of operations in the following two functions is critical.
;;; add-to-wm order: (1) change wm (2) record change (3) match 
;;; remove-from-wm order: (1) record change (2) match (3) change wm
;;; (back will not restore state properly unless wm changes are recorded
;;; before the cs changes that they cause)  (match will give errors if 
;;; the thing matched is not in wm at the time)

(defun ADD-TO-WM (wme override)
  (prog (fa z part timetag port)
        (setf (global-critical) t)
        (incf (global-current-wm))
        (and (> (global-current-wm) (global-max-wm))
             (setf (global-max-wm) (global-current-wm)))
        (incf (global-action-count))
        (setf fa (wm-hash wme))
        (or (member fa (global-wmpart-list))
            (push fa (global-wmpart-list)))
        (setf part (get-ops-prop fa (global-wmpart*-props)))
        (cond (override (setf timetag override))
              (t (setf timetag (global-action-count))))
        (setf z (cons wme timetag))
        (put-ops-prop fa (cons z part) (global-wmpart*-props))
        (record-change '=>wm (global-action-count) wme)
        (match 'new wme)
        (setf (global-critical) nil)
        (cond ((and (global-in-rhs) (global-wtrace))
               (setf port (trace-file))
               (terpri port)
               (princ "=>WM: " port)
               (ppelm wme port))))) 

;;; ---------------------------------------------------------------------------
;;; REMOVE-FROM-WM uses EQ, not EQUAL, to determine if wme is present
;;; ---------------------------------------------------------------------------

(defun REMOVE-FROM-WM (wme)
  (let* ((fa (wm-hash wme))
         (part (get-ops-prop fa (global-wmpart*-props)))
         (z (assq wme part))
         (timetag))
    (unless z
      (return-from remove-from-wm nil))
    (setf timetag (rest z))
    (cond ((and (global-wtrace) (global-in-rhs))
           (let ((port (trace-file)))
             (format port "~&<=WM: ")
             (ppelm wme port))))
    (incf (global-action-count))
    (setf (global-critical) t)
    (decf (global-current-wm))
    (record-change '<=wm timetag wme)
    (match nil wme)
    (put-ops-prop fa (delq z part) (global-wmpart*-props))
    (setf (global-critical) nil)))

;;; ---------------------------------------------------------------------------
;;; MAPWM maps down the elements of wm, applying fn to each element
;;; each element is of form (datum . creation-time)
;;; ---------------------------------------------------------------------------

(defun MAPWM (fn)
  (dolist (wmp (global-wmpart-list))
    (mapc fn (get-ops-prop wmp (global-wmpart*-props)))))

;;; ---------------------------------------------------------------------------

(defun OPS-WM (a) 
  (dolist (z (get-wm a))
    (terpri)
    (ppelm z *standard-output*))
  nil) 

;;; ---------------------------------------------------------------------------

(defun CREATION-TIME (wme)
  (rest (assq wme (get-ops-prop (wm-hash wme) (global-wmpart*-props))))) 

;;; ---------------------------------------------------------------------------

(defun GET-WM (z)
  (let ((result nil))
    (mapwm #'(lambda (elem)
               (cond ((or (null z)
                          (member (rest elem) z))
                      (push (first elem) result)))))
    result))

;;; ---------------------------------------------------------------------------

(defun WM-HASH (x)
  (cond ((not x) '<default>)
	((not (first x)) (wm-hash (rest x)))
	((symbolp (first x)) (first x))
	(t (wm-hash (rest x))))) 

;;; ---------------------------------------------------------------------------

(defun REFRESH ()

  "REFRESH 

Updates all working-memory elements to new time tags."

  (let ((result nil))
    (mapwm #'(lambda (x)
               (push x result)))
    (dolist (x result)
      (remove-from-wm (first x))
      (add-to-wm (first x) (rest x)))
    result))

;;; ---------------------------------------------------------------------------
;;;                                 End of File
;;; ---------------------------------------------------------------------------

