;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:OPS; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL.OPS]OPS-MATCH.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Thursday, September 15, 1988  14:24:50 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                  OPS5 Pattern Matching Definitions
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; This file contains the functions that match working memory
;;; elements against productions LHS.
;;;
;;; OPS5 Modifications Written by: 
;;;             Daniel Corkill
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; These modifications were written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst.
;;;
;;; Modifications Copyright (c) 1988 COINS.  
;;; All rights reserved.
;;;
;;; This GBB version of OPS5 was modified from the public domain version based
;;; in part on based on a Franz Lisp implementation done by Charles L. Forgy
;;; at Carnegie Mellon University.  The public domain version was also
;;; modified by George Wood, Dario Giuse, Skef Wholey, Michael Parzen,
;;; and Dan Kuokka.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments;
;;;    ONR URI grant N00014-86-K-0764;
;;;    a contract with Digital Equipment Corporation.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  04-07-88 File Released.  (Cork)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package "OPS")

;;; External global variables
;;; *CURRENT-TOKEN*.

;;; Internal global variables
;;; *ALPHA-DATA-PART*, *ALPHA-FLAG-PART*, *FLAG-PART*, *DATA-PART*,
;;; *SENDTOCALL*, and *SIDE*.


;;; ---------------------------------------------------------------------------
;;;
;;; Network interpreter
;;;
;;; ---------------------------------------------------------------------------

(defun MATCH-INIT ()

  "MATCH-INIT nil

This function initializes the MATCH file constants."

  (match-reinit))

;;; ---------------------------------------------------------------------------

(defun MATCH-REINIT ()

  "MATCH-REINIT nil

This function reinitializes the MATCH file constants for the next
OPS invocation instance."

  (setf (global-registers) (make-array #.(1+ *ops-maximum-field-count*)))
  (setf (global-current-token) 0))

;;; ---------------------------------------------------------------------------

(defun MATCH (flag wme)
  (sendto flag (list wme) 'left (list (global-first-node))))

;;; ---------------------------------------------------------------------------

;; note that eval-nodelist is not set up to handle building
;; productions.  would have to add something like ops4's build-flag

(defun EVAL-NODELIST (nl)
  (dolist (n nl)
    (setf (global-sendtocall) nil)
    (setf (global-last-node) n)
    (apply (first n) (rest n))))

;;; ---------------------------------------------------------------------------

(defun SENDTO (flag data side nl)
  (dolist (n nl)
    (setf (global-side) side)
    (setf (global-flag-part) flag)
    (setf (global-data-part) data)
    (setf (global-sendtocall) t)
    (setf (global-last-node) n)
    (apply (first n) (rest n))))

;;; ---------------------------------------------------------------------------

;; &bus sets up the registers for the one-input nodes.

(defun &BUS (outs)
  (setf (global-alpha-flag-part) (global-flag-part))
  (setf (global-alpha-data-part) (global-data-part))
  ;; The first cell is intentionally left empty to match the one-origin
  ;; indexes assigned to field names ::
  (replace (global-registers) (first (global-data-part))
           :START1 1 :END1 #.(1+ *ops-maximum-field-count*)
           :START2 0)
  (eval-nodelist outs))

; ---------------------------------------------------------------------------

(defun &ANY (outs register const-list)
  (prog (z c)
        (setf z (fast-symeval register))
        (cond ((numberp z) (go number)))
     symbol
        (cond ((null const-list) (return nil))
              ((eq (first const-list) z) (go ok))
              (t (setf const-list (rest const-list)) (go symbol)))
     number
        (cond ((null const-list) (return nil))
              ((and (numberp (setf c (first const-list)))
                    (=alg c z))
               (go ok))
              (t (setf const-list (rest const-list)) (go number)))
     ok
        (eval-nodelist outs))) 

; ---------------------------------------------------------------------------

(defun TEQA (outs register constant)
  (and (eq (fast-symeval register) constant)
       (eval-nodelist outs))) 

; ---------------------------------------------------------------------------

(defun TNEA (outs register constant)
  (and (not (eq (fast-symeval register) constant))
       (eval-nodelist outs))) 

; ---------------------------------------------------------------------------

(defun TXXA (outs register constant)
  (declare (ignore constant))
  (and (symbolp (fast-symeval register))
       (eval-nodelist outs))) 

; ---------------------------------------------------------------------------

(defun TEQN (outs register constant)
  (let ((z (fast-symeval register)))
    (and (numberp z)
         (=alg z constant)
         (eval-nodelist outs)))) 

; ---------------------------------------------------------------------------

(defun TNEN (outs register constant)
  (let ((z (fast-symeval register)))
    (and (or (not (numberp z))
             (not (=alg z constant)))
         (eval-nodelist outs)))) 

; ---------------------------------------------------------------------------

(defun TXXN (outs register constant)
  (declare (ignore constant))
  (and (numberp (fast-symeval register)) (eval-nodelist outs)))

; ---------------------------------------------------------------------------

(defun TLTN (outs register constant)
  (let ((z (fast-symeval register)))
    (and (numberp z)
         (> constant z)
         (eval-nodelist outs)))) 

; ---------------------------------------------------------------------------

(defun TGTN (outs register constant)
  (let ((z (fast-symeval register)))
    (and (numberp z)
         (> z constant)
         (eval-nodelist outs)))) 

; ---------------------------------------------------------------------------

(defun TGEN (outs register constant)
  (let ((z (fast-symeval register)))
    (and (numberp z)
         (not (> constant z))
         (eval-nodelist outs)))) 

; ---------------------------------------------------------------------------

(defun TLEN (outs register constant)
  (let ((z (fast-symeval register)))
    (and (numberp z)
	 (not (> z constant))
	 (eval-nodelist outs)))) 

; ---------------------------------------------------------------------------

(defun TEQS (outs vara varb)
  (let ((a (fast-symeval vara))
        (b (fast-symeval varb)))
    (cond ((eq a b)
           (eval-nodelist outs))
          ((and (numberp a) (numberp b) (=alg a b))
           (eval-nodelist outs)))))

; ---------------------------------------------------------------------------

(defun TNES (outs vara varb)
  (let ((a (fast-symeval vara))
        (b (fast-symeval varb)))
    (cond ((eq a b)
           nil)
          ((and (numberp a)
                (numberp b)
                (=alg a b))
           nil)
	  (t (eval-nodelist outs)))))

; ---------------------------------------------------------------------------

(defun TXXS (outs vara varb)
  (let ((a (fast-symeval vara))
        (b (fast-symeval varb)))
    (cond ((and (numberp a) (numberp b))
           (eval-nodelist outs))
          ((and (not (numberp a)) (not (numberp b)))
           (eval-nodelist outs))))) 

; ---------------------------------------------------------------------------

(defun TLTS (outs vara varb)
  (let ((a (fast-symeval vara))
        (b (fast-symeval varb)))
    (when (and (numberp a)
               (numberp b)
               (> b a))
      (eval-nodelist outs))))

; ---------------------------------------------------------------------------

(defun TGTS (outs vara varb)
  (let ((a (fast-symeval vara))
        (b (fast-symeval varb)))
    (when (and (numberp a)
               (numberp b)
               (> a b))
      (eval-nodelist outs))))

; ---------------------------------------------------------------------------

(defun TGES (outs vara varb)
  (let ((a (fast-symeval vara))
        (b (fast-symeval varb)))
    (when (and (numberp a)
               (numberp b)
               (not (> b a)))
      (eval-nodelist outs))))

; ---------------------------------------------------------------------------

(defun TLES (outs vara varb)
  (let ((a (fast-symeval vara))
        (b (fast-symeval varb)))
    (when (and (numberp a)
               (numberp b)
               (not (> a b)))
      (eval-nodelist outs))))

; ---------------------------------------------------------------------------

(defun &TWO (left-outs right-outs)
  (let (fp dp)
    (cond ((global-sendtocall)
           (setf fp (global-flag-part))
           (setf dp (global-data-part)))
          (t
           (setf fp (global-alpha-flag-part))
           (setf dp (global-alpha-data-part))))
    (sendto fp dp 'left left-outs)
    (sendto fp dp 'right right-outs))) 

; ---------------------------------------------------------------------------

(defun &MEM (left-outs right-outs memory-list)
  (let (fp dp)
    (cond ((global-sendtocall)
           (setf fp (global-flag-part))
           (setf dp (global-data-part)))
          (t
           (setf fp (global-alpha-flag-part))
           (setf dp (global-alpha-data-part))))
    (sendto fp dp 'left left-outs)
    (add-token memory-list fp dp nil)
    (sendto fp dp 'right right-outs)))

; ---------------------------------------------------------------------------

(defun &AND (outs lpred rpred tests)
  (let (mem)
    (cond ((eq (global-side) 'right)
           (setf mem (memory-part lpred)))
          (t (setf mem (memory-part rpred))))
    (cond ((not mem)
           nil)
          ((eq (global-side) 'right)
           (and-right outs mem tests))
          (t (and-left outs mem tests)))))

; ---------------------------------------------------------------------------

(defun AND-LEFT (outs mem tests)
  (prog (fp dp memdp tlist tst lind rind res)
        (setf fp (global-flag-part))
        (setf dp (global-data-part))
     fail
        (and (null mem) (return nil))
        (setf memdp (first mem))
        (setf mem (rest mem))
        (setf tlist tests)
     tloop
        (and (null tlist) (go succ))
        (setf tst (first tlist))
        (setf tlist (rest tlist))
        (setf lind (first tlist))
        (setf tlist (rest tlist))
        (setf rind (first tlist))
        (setf tlist (rest tlist))
        ;###        (comment the next line differs in and-left & -right)
        (setf res (funcall tst (gelm memdp rind) (gelm dp lind)))
        (cond (res (go tloop))
              (t (go fail)))
     succ 
        ;###	(comment the next line differs in and-left & -right)
        (sendto fp (cons (first memdp) dp) 'left outs)
        (go fail))) 

; ---------------------------------------------------------------------------

(defun AND-RIGHT (outs mem tests)
  (prog (fp dp memdp tlist tst lind rind res)
        (setf fp (global-flag-part))
        (setf dp (global-data-part))
     fail
        (and (null mem) (return nil))
        (setf memdp (first mem))
        (setf mem (rest mem))
        (setf tlist tests)
     tloop
        (and (null tlist) (go succ))
        (setf tst (first tlist))
        (setf tlist (rest tlist))
        (setf lind (first tlist))
        (setf tlist (rest tlist))
        (setf rind (first tlist))
        (setf tlist (rest tlist))
        ;###        (comment the next line differs in and-left & -right)
        (setf res (funcall tst (gelm dp rind) (gelm memdp lind)))
        (cond (res (go tloop))
              (t (go fail)))
     succ 
        ;###        (comment the next line differs in and-left & -right)
        (sendto fp (cons (first dp) memdp) 'right outs)
        (go fail))) 

; ---------------------------------------------------------------------------

(defun TEQB (new eqvar)
  (cond ((eq new eqvar) t)
	((not (numberp new)) nil)
	((not (numberp eqvar)) nil)
	((=alg new eqvar) t)
	(t nil))) 

; ---------------------------------------------------------------------------

(defun TNEB (new eqvar)
  (cond ((eq new eqvar) nil)
	((not (numberp new)) t)
	((not (numberp eqvar)) t)
	((=alg new eqvar) nil)
	(t t))) 

; ---------------------------------------------------------------------------

(defun TLTB (new eqvar)
  (cond ((not (numberp new)) nil)
	((not (numberp eqvar)) nil)
	((> eqvar new) t)
	(t nil))) 

; ---------------------------------------------------------------------------

(defun TGTB (new eqvar)
  (cond ((not (numberp new)) nil)
	((not (numberp eqvar)) nil)
	((> new eqvar) t)
	(t nil))) 

; ---------------------------------------------------------------------------

(defun TGEB (new eqvar)
  (cond ((not (numberp new)) nil)
	((not (numberp eqvar)) nil)
	((not (> eqvar new)) t)
	(t nil))) 

; ---------------------------------------------------------------------------

(defun TLEB (new eqvar)
  (cond ((not (numberp new)) nil)
	((not (numberp eqvar)) nil)
	((not (> new eqvar)) t)
	(t nil))) 

; ---------------------------------------------------------------------------

(defun TXXB (new eqvar)
  (cond ((numberp new)
	 (cond ((numberp eqvar) t)
	       (t nil)))
	(t
	 (cond ((numberp eqvar) nil)
	       (t t))))) 

; ---------------------------------------------------------------------------

(defun &P (rating name var-dope ce-var-dope rhs)
  (declare (ignore var-dope ce-var-dope rhs))
  (let (fp dp)
    (cond ((global-sendtocall)
           (setf fp (global-flag-part))
           (setf dp (global-data-part)))
          (t
           (setf fp (global-alpha-flag-part))
           (setf dp (global-alpha-data-part))))
    (and (member fp '(nil old)) (removecs name dp))
    (and fp (insertcs name dp rating)))) 

; ---------------------------------------------------------------------------

(defun &OLD (a b c d e)
  (declare (ignore a b c d e))
  nil) 

; ---------------------------------------------------------------------------

(defun &NOT (outs lmem rpred tests)
  (cond ((and (eq (global-side) 'right)
              (eq (global-flag-part) 'old))
         nil)
	((eq (global-side) 'right)
         (not-right outs (first lmem) tests))
	(t
         (not-left outs (memory-part rpred) tests lmem)))) 

; ---------------------------------------------------------------------------

(defun NOT-LEFT (outs mem tests own-mem)
  (prog (fp dp memdp tlist tst lind rind res c)
        (setf fp (global-flag-part))
        (setf dp (global-data-part))
        (setf c 0)
     fail
        (and (null mem) (go fin))
        (setf memdp (first mem))
        (setf mem (rest mem))
        (setf tlist tests)
     tloop
        (and (null tlist) (incf c) (go fail))
        (setf tst (first tlist))
        (setf tlist (rest tlist))
        (setf lind (first tlist))
        (setf tlist (rest tlist))
        (setf rind (first tlist))
        (setf tlist (rest tlist))
        ;###        (comment the next line differs in not-left & -right)
        (setf res (funcall tst (gelm memdp rind) (gelm dp lind)))
        (cond (res (go tloop))
              (t (go fail)))
     fin
        (add-token own-mem fp dp c)
        (and (== c 0) (sendto fp dp 'left outs)))) 

; ---------------------------------------------------------------------------

(defun NOT-RIGHT (outs mem tests)
  (prog (fp dp memdp tlist tst lind rind res newfp inc newc)
        (setf fp (global-flag-part))
        (setf dp (global-data-part))
        (cond ((not fp) (setf inc -1) (setf newfp 'new))
              ((eq fp 'new) (setf inc 1) (setf newfp nil))
              (t (return nil)))
     fail
        (and (null mem) (return nil))
        (setf memdp (first mem))
        (setf newc (second mem))
        (setf tlist tests)
     tloop
        (and (null tlist) (go succ))
        (setf tst (first tlist))
        (setf tlist (rest tlist))
        (setf lind (first tlist))
        (setf tlist (rest tlist))
        (setf rind (first tlist))
        (setf tlist (rest tlist))
        ;###        (comment the next line differs in not-left & -right)
        (setf res (funcall tst (gelm dp rind) (gelm memdp lind)))
        (cond (res (go tloop))
              (t (setf mem (cddr mem)) (go fail)))
     succ
        (incf newc inc)
        (rplaca (rest mem) newc)
        (cond ((or (and (== inc -1) (== newc 0))
                   (and (== inc 1) (== newc 1)))
               (sendto newfp memdp 'right outs)))
        (setf mem (cddr mem))
        (go fail))) 

; ---------------------------------------------------------------------------
;
; Node memories
;
; ---------------------------------------------------------------------------

(defun ADD-TOKEN (memlis flag data-part num)
  (cond ((eq flag 'new)
         (real-add-token memlis data-part num)
         nil)
        ((not flag) 
         (remove-old memlis data-part num))
        ((eq flag 'old) t)))

; ---------------------------------------------------------------------------

(defun REAL-ADD-TOKEN (lis data-part num)
  (incf (global-current-token))
  (cond (num (rplaca lis (cons num (first lis)))))
  (rplaca lis (cons data-part (first lis)))) 

; ---------------------------------------------------------------------------

(defun REMOVE-OLD (lis data num)
  (cond (num (remove-old-num lis data))
	(t (remove-old-no-num lis data)))) 

; ---------------------------------------------------------------------------

(defun REMOVE-OLD-NUM (lis data)
  (prog (m next last)
        (setf m (first lis))
        (cond ((atom m) (return nil))
              ((top-levels-eq data (first m))
               (decf (global-current-token))
               (rplaca lis (cddr m))
               (return (first m))))
        (setf next m)
     loop
        (setf last next)
        (setf next (cddr next))
        (cond ((atom next) (return nil))
              ((top-levels-eq data (first next))
               (rplacd (rest last) (cddr next))
               (decf (global-current-token))
               (return (first next)))
              (t (go loop))))) 

; ---------------------------------------------------------------------------

(defun REMOVE-OLD-NO-NUM (lis data)
  (prog (m next last)
        (setf m (first lis))
        (cond ((atom m) (return nil))
              ((top-levels-eq data (first m))
               (decf (global-current-token))
               (rplaca lis (rest m))
               (return (first m))))
        (setf next m)
     loop
        (setf last next)
        (setf next (rest next))
        (cond ((atom next) (return nil))
              ((top-levels-eq data (first next))
               (rplacd last (rest next))
               (decf (global-current-token))
               (return (first next)))
              (t (go loop))))) 

; ---------------------------------------------------------------------------
;                                 End of File
; ---------------------------------------------------------------------------




