;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:GBB; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL]MACROS.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Thursday, September 15, 1988  12:44:03 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *           MACROS, DEFSTRUCT FUNCTIONS, AND OTHER USEFUL CODE
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Kevin Gallagher
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights reserved.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments, Inc.;
;;;    ONR URI grant N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  01-08-86 File Created.  (Gallagher)
;;;     ...   Added some macros.  Refined them all several times.
;;;           (Gallagher and Johnson)
;;;  01-02-87 Added DOLISTS*.  (Gallagher)
;;;  01-06-87 Fixed DO-ARRAY-REGION to evaluate the region argument only once.
;;;           Added ENTIRE-ARRAY-REGION.   (Gallagher)
;;;  01-08-87 Added NPUSH-LIST.  (Gallagher)
;;;  01-14-87 Added WITH-EVENTS-ENABLED and WITH-EVENTS-DISABLED. (Johnson)
;;;  01-14-87 Added DOLIST-OR-ATOM.  (Gallagher)
;;;  03-12-88 Moved NEWSYM from Utilities.  (Gallagher)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package 'GBB :use '(lisp umass-extended-lisp))

(use-package '(lisp umass-extended-lisp))

(proclaim `(optimize (speed ,*gbb-optimize-speed*)
                     (safety ,*gbb-optimize-safety*)))


;;;; --------------------------------------------------------------------------
;;;;   Functions used in the following macros
;;;; --------------------------------------------------------------------------

;;; Sometimes it's nice to have your gensyms mean something when
;;; you're reading the macroexpansion of some form.  The problem
;;; is that if you give a prefix to GENSYM it remains the prefix
;;; until you change it.  

(eval-when (compile load eval)

(defvar *newsym-counter* 0
  "Counter used by NEWSYM for generating print names.")

(defun newsym (&optional (prefix "X"))
  "Create a new uninterned symbol whose print name begins with PREFIX.
   This differs from GENSYM in that the prefix is not sticky."
  (unless (stringp prefix)
    (setf prefix (string prefix)))
  (make-symbol (format nil "~a~4,'0d" prefix (incf *newsym-counter*))))

) ;; End of Eval-When


;;;; --------------------------------------------------------------------------
;;;;   Creating symbols
;;;; --------------------------------------------------------------------------

(defmacro form-symbol-in-package (pkg &rest names)
  "FORM-SYMBOL-IN-PACKAGE pkg &rest names
   Return a symbol interned in PKG whose print name is the concatenation
   of NAMES.  Each name must be acceptable to the string function."
  `(intern (concatenate
	     'simple-string
	     ,@(mapcar #'(lambda (name)
			   (if (stringp name) name `(string ,name)))
		       names))
	   ,pkg))

(defmacro form-symbol (&rest names)
  "FORM-SYMBOL &rest names
   Return a symbol interned in the current package whose print name is the
   concatenation of NAMES.  Each name must be acceptable to the string function."
  `(form-symbol-in-package *package* ,@names))

(defmacro form-gbb-symbol (&rest names)
  "FORM-GBB-SYMBOL &rest names
   Return a symbol interned in the GBB package whose print name is the
   concatenation of NAMES.  Each name must be acceptable to the string function."
  `(form-symbol-in-package "GBB" ,@names))

(defmacro form-keyword (&rest names)
  "FORM-KEYWORD &rest names
   Return a symbol interned in the keyword package whose print name is the
   concatenation of NAMES.  Each name must be acceptable to the string function."
  `(form-symbol-in-package "KEYWORD" ,@names))

(defmacro form-uninterned-symbol (&rest names)
  "FORM-UNINTERNED-SYMBOL &rest names
   Return an uninterned symbol whose print name is the concatenation of NAMES.
   Each name must be acceptable to the string function."
  `(make-symbol (concatenate
		  'simple-string
		  ,@(mapcar #'(lambda (name)
				(if (stringp name) name `(string ,name)))
			    names))))


;;;; --------------------------------------------------------------------------
;;;;   Variations on DOLIST
;;;; --------------------------------------------------------------------------

;;; DOLISTS:
;;;
;;;   (dolists ((x list1)
;;;             (y list2)
;;;             ...)
;;;      <body>)

(defmacro dolists (varlist &body body)

  "DOLISTS ({(var list)}*) &body body

   Parallel dolist.  Steps a number of variables in parallel.  The first
   argument to DOLISTS is a list of lists -- this is a binding list (similar
   to the first argument to LET).  The first element of each sublist is the
   iteration variable.  The second element should evaluate to a list.  The
   body is executed once for each element of the shortest list with the
   variables bound to successive elements of their respective lists."

  (let ((bindings nil)
	(end-test nil)
	variable gensym)
    (dolist (pair varlist)
      (setf gensym (gensym)
	    variable (first pair))
      ;; Note that because I am using push, these clauses appear here
      ;; in reverse order so that `bindings' will have the clauses
      ;; in the proper order in the expanded code.
      (push `(,variable (car ,gensym) (car ,gensym))
	    bindings)
      (push `(,gensym ,(second pair) (cdr ,gensym))
	    bindings)
      (push `(endp ,gensym) end-test))
    `(do* ,bindings
	  ((or ,@end-test))
       ,@body)))


;;; DOLIST-SLICES:
;;;
;;;   (dolist-slices (var list-of-lists)
;;;     <body>)
;;;
;;; This macro is roughly equivalent to
;;;
;;;   (apply #'mapc
;;;          #'(lambda (&rest var)
;;;              <body>)
;;;          list-of-lists)
;;;
;;; but should cons less.

(defmacro dolist-slices ((var list-of-lists) &body body)

  "DOLIST-SLICES (var list-of-lists) &body body

   DOLIST-SLICES iterates over successive sublists of a list.  List-of-lists
   should be a list of lists.  The iteration variable, Var, is bound to
   successive `slices' through the sublists.  That is, the first time
   through the loop, Var will be a list of the first elements of the
   sublists; the second time through, Var will be a list of the second
   elements; and so on.  Iteration stops when the shortest list runs out.

   Note that the list that Var is bound to is destructivly modified
   each time through the loop."

  (let ((columns (gensym)))
    `(do* ((,columns (copy-list ,list-of-lists))
	   (,var (make-list (length ,columns))))
	  ((some #'endp ,columns) nil)
       ;; Step row to the next row.
       (mapl #'(lambda (columns-list row-list)
		 ;; Set row to be a single row
		 (setf (car row-list) (caar columns-list))
		 ;; Push columns down to the next row
		 (setf (car columns-list) (cdar columns-list)))
	     ,columns ,var)
       ,@body)))


;;; DOLIST-BY-TWOS:
;;;
;;;   (dolist-by-twos (key value key-value-pairs)
;;;      <body>)

(defmacro dolist-by-twos ((v1 v2 list &optional result) &body body)

  "DOLIST-BY-TWOS (v1 v2 list &optional result) &body body

   Cddrs down a list.  Each time through, V1 is bound to the first
   remaining element of the list and V2 is bound to the second remaining
   element.  This is useful for looking at keyword-value pairs."

  (let ((remaining-list (gensym)))
    `(do* ((,remaining-list ,list (cddr ,remaining-list))
	   (,v1 (first ,remaining-list) (first ,remaining-list))
	   (,v2 (second ,remaining-list) (second ,remaining-list)))
	  ((null ,remaining-list)
           ;; Reference these two variables here to suppress
           ;; possible compiler warnings if one is not used.
           ,v1 ,v2
           ,result)
       ,@body)))


;;; DOLIST-OR-ATOM:
;;;
;;;   (dolist-or-atom (var maybe-list)
;;;      <body>)

(defmacro dolist-or-atom ((var possible-list &optional test-form) &body body)

  "DOLIST-OR-ATOM (var possible-list &optional test-form) &body body

   This macro handles those cases where a variable may be a single object or
   a list of objects.  If `Possible-List' is a list then DOLIST-OR-ATOM will
   act like DOLIST; if `Possible-List' is not a list then this will act like
   LET.  The optional `Test-Form' is a form that should return true if you
   want the DOLIST behavior.  It defaults to the form (LISTP Possible-List).

   Note that `Possible-List' may be evaluated twice so it should not be a
   form with side-effects or one that is expensive to compute."

  ;; This could be coded as follows but if body is large the
  ;; space penalty is significant.
  ;; 
  ;; (if ,test-form
  ;;     (dolist (,var ,possilble-list) ,@body)
  ;;     (let ((,var ,possible-list)) ,@body))

  (let ((test-result (gensym))
	(remaining (gensym)))
    (when (null test-form)
      (setf test-form `(listp ,possible-list)))
    `(do* ((,test-result ,test-form)
	   (,remaining ,possible-list (cdr ,remaining))
	   (,var (if ,test-result (first ,remaining) ,remaining)
	         (first ,remaining)))
	  ((when ,test-result
	     (endp ,remaining)))
       ,@body
       (unless ,test-result (return nil)))))


;;;; --------------------------------------------------------------------------
;;;;   Keyword Parsing
;;;; --------------------------------------------------------------------------

;;; WITH-KEYWORDS-BOUND:
;;;
;;; (with-keywords-bound (((key1 default1)
;;;                        (key2 default2)
;;;                        ...)
;;;                       arglist)
;;;   <body>)

(defmacro with-keywords-bound ((key-specs arg-list &rest args)
			       &body body)

  "WITH-KEYWORDS-BOUND (key-specs arg-list [error-msg | keyvar] &rest otherwise)
                 &body body)

   Look through ARG-LIST for keywords and bind them, similar to the
   processing of lambda-list keywords.  ARG-LIST is evaluated and should
   be a list of keywords and values.  KEY-SPECS describes the keywords
   to check for.  Each element should be a symbol that will be bound to
   the keyword value from ARG-LIST or a list of the symbol and a default
   value.

   If the third argument is a string it is used as the format string for
   the error message when an unknown keyword is found.

   If the third argument is a symbol then it is used as the variable
   which is used internally to hold the remaining part of the list during
   processing.  OTHERWISE is code that will be executed (in an implicit
   progn) if any keyword from ARG-LIST is not a recognized keyword.
   This code can refer to KEYVAR."

  (let* ((key-symbols (mapcar #'(lambda (key)
				  (if (symbolp key) key (car key)))
			      key-specs))
	 (error-msg (if (stringp (car args)) (car args) nil))
	 (keyvar (if (and (symbolp (car args))
			  (not (null (car args))))
		     (car args)
		     (newsym "KEY")))
	 (otherwise (if error-msg nil (cdr args))))
    (or otherwise
	error-msg
	(setf error-msg (format nil "~~s is not one of (~{:~a~^ ~})."
				key-symbols)))
    `(let ,key-specs
       (when (consp ,arg-list)
	 (do ((,keyvar ,arg-list (cdr ,keyvar)))
	     ((null ,keyvar))
	   (case (car ,keyvar)
	     ,@(mapcar #'(lambda (key)
			   `(,(form-keyword key)
			     (setf ,key (car (setf ,keyvar (cdr ,keyvar))))))
		       key-symbols)
	     (otherwise
	      ,@(or otherwise
		    `((error ,error-msg (car ,keyvar))))))))
       ,@body)))


;;;; --------------------------------------------------------------------------
;;;;   Array Macros
;;;; --------------------------------------------------------------------------

;;; (PUSH X (APPLY #'AREF ARRAY INDEXES)) doesn't work in VaxLisp but
;;; SETF does.  Use these macros instead of push.  Note that place will
;;; be evaluated twice so keep the place form simple.

#+DEC
(defmacro push-onto-array (item place)
  `(setf ,place (cons ,item ,place)))

#+DEC
(defmacro pushnew-onto-array (item place)
  `(setf ,place (adjoin ,item ,place)))

(defmacro remove-from-array (item place)
  `(setf ,place (delete ,item ,place :test #'eq)))

#-DEC
(defmacro push-onto-array (item place)
  `(push ,item ,place))

#-DEC
(defmacro pushnew-onto-array (item place)
  `(pushnew ,item ,place))


;;; This should take a second argument, region, which is a list whose
;;; cons cells can be reused.

(defun entire-array-region (array)

  "ENTIRE-ARRAY-REGION array

   Returns a `region' suitable for use with DO-ARRAY-REGION that
   marks the whole array."
  
  (mapcar #'(lambda (max) (cons 0 max))
	  (array-dimensions array)))


;;; DO-ARRAY-REGION:
;;;
;;; (do-array-region (array-indexes array-region)
;;;   <body>)

(defmacro do-array-region ((subscripts region) &body body)

  "DO-ARRAY-REGION (subscripts region) &body body

   This macro provides iteration over a logically contiguous region of
   an array (a subarray of the array).

   REGION is a list of the form ((x1 .  x2) (y1 .  y2) ...) which
   specifies the two end points of the subarray of the array.
   Specifically, REGION is a list of pairs, one pair for each dimension
   of the array, such that (mapcar #'car region) produces the ``lower
   left'' point of the subarray and (mapcar #'cdr region) produces the
   ``upper right'' point of the subarray.  The upper bound is exclusive.
   Any pair of coordinates can be replaced by a single element list or
   an atom to indicate just one row (column, plane, whatever).

   SUBSCRIPTS is a symbol which is bound to successive lists of array
   indexes.

   BODY is executed once for each combination of array indexes.

   A typical call would be:

      (do-array-region (indexes array-region)
        (setf (apply #'aref <some-array> indexes) <some-value>))

   A block named DO-ARRAY-REGION surrounds the form so RETURN-FROM may
   be used to exit the loop early."

  (let* ((finish-state (newsym "FINISH"))
         (len (newsym "LENGTH"))
         (i (newsym "I"))
	 (temp (newsym "T"))
	 (region-value (newsym "REGION")))
    `(block do-array-region
       ;; Subscripts gets stepped each time through the loop.  Finish-state
       ;; holds the exclusive upper bounds for each dimension.
       (do* ((,region-value ,region)
	     (,subscripts (mapcar #'(lambda (x) (if (consp x) (car x) x))
				  ,region-value))
	     (,finish-state
	         (mapcar #'(lambda (x)
			     (cond ((not (consp x)) (1- x))
				   ((cdr x) (1- (cdr x)))
				   (t (1- (car x)))))
			 ,region-value))
             (,len (1- (length ,subscripts))))
            (())
         (progn ,@body)
         (do ((,i ,len (1- ,i))
	      (,temp))
             ((< ,i 0) (return-from do-array-region nil))
           (incf (nth ,i ,subscripts))
	   ;; If we've reached the upper limit for this dimension then
	   ;; go back to the start.
           (cond ((> (nth ,i ,subscripts) (nth ,i ,finish-state))
		  (setf ,temp (nth ,i ,region-value))
		  (setf (nth ,i ,subscripts)
		     (if (consp ,temp) (car ,temp) ,temp)))
		 (t (return nil))))))))


;;; Macros for array-regions:

(defmacro with-region-bounds ((start end region) &body body)

  "WITH-REGION-BOUNDS (start end region) &body body

   Execute BODY with the symbols START and END bound to the
   start and end of REGION."

  (let ((region-v (gensym)))
    `(let* ((,region-v ,region)
            ,start ,end)
       (if (consp ,region-v)
           (setf ,start (car ,region-v)
                 ,end   (or (cdr ,region-v) ,start))
           (setf ,start ,region-v
                 ,end   (1+ ,start)))
       ,@body)))

(defmacro region-bounds-setf (start end region)

  "REGION-BOUNDS-SETF start end region

   Set the value of START and END (place forms) to the start
   and end of REGION."
 
  (let ((region-v (gensym)))
    `(let* ((,region-v ,region))
       (if (consp ,region-v)
           (setf ,start (car ,region-v)
                 ,end   (or (cdr ,region-v) ,start))
           (setf ,start ,region-v
                 ,end   (1+ ,start))))))


;;;; --------------------------------------------------------------------------
;;;;   Miscellaneous Macros
;;;; --------------------------------------------------------------------------

;;; These macros are used in FIND-UNITS to mark the fact that I've already
;;; looked at a unit.  They hide the implementation of the mark.

(defmacro set-unit-mark (unit value)
  `(setf (basic-unit.%%mark-1%% ,unit) ,value))

(defmacro get-unit-mark (unit)
  `(basic-unit.%%mark-1%% ,unit))


;; Common Lisp leaves the specification of TYPE-OF vague.  In particular,
;; it's not required that
;;
;;    (type-of <structure-instance>)
;;
;; return the most specific defstruct type for <structure-instance> (which
;; is what I need for GBB.  In fact all implementations so far do the
;; `right' thing, but this macro just makes it much simpler when I find
;; one doesn't.

(defmacro unit-type-of (obj)
  "Return the type of OBJ.  In particular, if OBJ is a structure
   instance, this will return the its most specific structure type."
  `(type-of ,obj))


(defmacro npush-list (list place)

  "NPUSH-LIST list place

   Nconc's List onto place and sets Place to that new value."

  `(setf ,place (nconc ,list ,place)))


;;; These two macros are like assert but don't have any place forms.
;;; Things are usually too complicated to make proceeding from the error
;;; be simply a matter of providing a new value.

(defmacro error-when (test-form &body format-args)

  "ERROR-WHEN test-form &rest format-args
   Signals an error if the value of test-form is true."

  `(when ,test-form
     (error ,@format-args)))


(defmacro error-unless (test-form &body format-args)

  "ERROR-UNLESS test-form &rest format-args
   Signals an error if the value of test-form is nil."

  `(unless ,test-form
     (error ,@format-args)))


(defmacro gbb-warning (format-string &rest args)

  "GBB-WARNING format-string &rest args
   Prints a warning message on *error-output*."

  `(format *error-output* "~2&Warning: ~@?" ,format-string ,@args))


;;; --------------------------------------------------------------------------
;;;   Event Macros
;;; --------------------------------------------------------------------------

(defmacro with-events-enabled (&body body)

  "WITH-EVENTS-ENABLED &body body

   Enables running of events during BODY."

  `(let ((%%run-events%% t))
     ,@body))


(defmacro with-events-disabled (&body body)

  "WITH-EVENTS-DISABLED &body body

   Disables running of events during BODY"

  `(let ((%%run-events%% nil))
     ,@body))

;;; --------------------------------------------------------------------------
;;;                                End of File
;;; --------------------------------------------------------------------------
