;;;; -*- Mode:Lisp; Syntax: Common-Lisp; Package:UMASS-EXTENDED-LISP; Base:10 -*-
;;;; *-* File: SYS:NIL *-*
;;;; *-* Last-Edit: Wednesday, October 10, 1990  14:59:55 *-*
;;;; *-* Edited-By: Gallagher *-*
;;;; *-* Machine: Gilgamesh (Explorer II, Microcode 432) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *              Extensions for Macintosh Allegro Common Lisp
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Kevin Gallagher/Philip Johnson/Daniel Corkill/Kelly Murray
;;;
;;; Copyright (c) 1990 Blackboard Technology Group, Inc., Amherst MA 01002
;;; Copyright (c) 1986, 1987, 1988, 1989 COINS, University of Massachusetts
;;; All rights reserved.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  This file contains extensions to Common Lisp needed by GBB.  The functions
;;;  in this file depend on the details of the Macintosh Allegro Common Lisp
;;;  Version 1.3.2 implementation.  The file UMASS-EXTENDED-LISP.LISP contains
;;;  extensions to Common Lisp that are written in Common Lisp.
;;;
;;;  01-16-90 File Created.  (Gallagher)
;;;  05-05-90 Updated to MACL Version 1.3.1
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package 'umass-extended-lisp
	    :use '(lisp))

(export '(defstruct-p
	  defstruct-conc-name
	  structure-slot-names
	  structure-slot-p
	  get-structure-slot
	  deftransform
	  delete-transform
	  %pass%
	  %pointer))

(use-package '(lisp))

(proclaim '(optimize (speed 3) (safety 1)))

#-:ccl-1.3
(eval-when (compile load eval)
  (error "This file is specific to Macintosh Allegro CL Version 1.3.~@
          It may not work in this version."))

;;; The functions that must be defined in this file are:
;;;
;;;     defstruct-p
;;;     get-defstruct-description
;;;     defstruct-conc-name
;;;     structure-slot-names
;;;     structure-slot-p
;;;     get-structure-slot  (and corresponding setf method)
;;;     deftransform
;;;     delete-transform
;;;     %pointer
;;;
;;; See the documentation with each function for arguments and purpose.



;;;; --------------------------------------------------------------------------
;;;;   Generic Defstruct Functions
;;;; --------------------------------------------------------------------------

;;; It is a hole in Common Lisp that you can't access a slot in a structure
;;; via the slot name.  For example, if I have an instance of the following
;;; defstruct,
;;;
;;;    (defstruct (foo (:conc-name FOO->))
;;;      (a nil)
;;;      (b nil))
;;;
;;; I want to be able to get the value of slot A with a call like:
;;;
;;;    (get-structure-slot object 'A).
;;;
;;; This is because I may not know what the accessor function is for that
;;; slot.  Even if I did know the name of the accessor function, I wouldn't
;;; be able to use it to alter the value of the slot because Setf needs to
;;; know the function name at compile time.  This means that code such as
;;; the following won't work.
;;;
;;;    (defun set-structure-slot (object slot-accessor new-value)
;;;      (setf (funcall slot-accessor object) new-value))
;;;
;;; Obviously, setf shouldn't need to handle that as a place form.  This
;;; just points out the need for a general slot accessor function which
;;; will work as a place form for setf.

;;; GBB uses the functions Get-Structure-Slot and Defstruct-Conc-Name
;;; which are defined below.


(defun dd.slot-descriptions (dd)
  (cdr (the list (svref dd 2))))

(defun sd.name (sd)
  (first (the list sd)))

(defun get-defstruct-description (name)

  "GET-DESFSTRUCT-DESCRIPTION name

   If NAME has been defined as a structure then return its
   description.  Otherwise signal an error."

  (or (and (symbolp name)
           (get (the symbol name) 'ccl::%defstruct))
      (error "~s is not a structure type." name)))

(defun defstruct-p (name)

  "DEFSTRUCT-P name

   This predicate returns true if NAME is the name of a
   defstruct type; nil otherwise.  NAME must be a symbol."
 
  (if (and (symbolp name)
           (get (the symbol name) 'ccl::%defstruct))
      t
      nil))

(defun defstruct-conc-name (structure)

  "DEFSTRUCT-CONC-NAME structure

   Return a string which is the prefix for building defstruct slot
   accessors for this structure.  STRUCTURE must be a symbol which
   names a structure type."

  (let ((conc-name (concatenate 'string (string structure) "-")))
    (warn "DEFSTRUCT-CONC-NAME has not been written for ~A yet.~@
           Using the default conc-name `~a'."
          (machine-type) conc-name)
    conc-name))

(defun structure-slot-names (type)

  "STRUCTURE-SLOT-NAMES type

   This function returns a list of slot names for the structure
   named by TYPE, which must be a symbol."

  (mapcar #'(lambda (sd)
              (sd.name sd))
          (dd.slot-descriptions (get-defstruct-description type))))

(defun structure-slot-p (type slot)

  "STRUCTURE-SLOT-P type slot

   This function returns true if SLOT is the name of a slot in the
   defstruct type named by TYPE."

  (member slot (the list (dd.slot-descriptions (get-defstruct-description type)))
          :key #'sd.name :test #'string=))


;;;
;;; Structure Slot Access Functions :::
;;;

(defun get-slot-index (slot type)
  ;; Return the slot index for SLOT in the structure named TYPE.
  (let* ((sds (dd.slot-descriptions (get-defstruct-description type)))
         (index (position slot (the list sds) :key #'sd.name :test #'string=)))
    (if index
        (1+ (the fixnum index))
        (error "~s is not a slot in ~s." slot type))))

(defun get-structure-slot (object slot)

  "GET-STRUCTURE-SLOT object slot

   Returns the value of a slot in a structure
   given the name of the slot.

   This function may be used as a place form for SETF."

  (let* ((type (type-of object))
         (index (get-slot-index slot type)))
    (ccl::struct-ref object (the fixnum index))))

;;;
;;; Structure Slot Setting Functions :::
;;;

(defun set-structure-slot (object slot value)

  ;; SET-STRUCTURE-SLOT object slot value
  ;;
  ;; Sets the value of a slot in a structure
  ;; given the name of the slot.

  (let* ((type (type-of object))
         (index (get-slot-index slot type)))
     (ccl::struct-set object (the fixnum index) value)))


(defsetf get-structure-slot set-structure-slot)


;;;; --------------------------------------------------------------------------
;;;;   Compiler Transforms.
;;;; --------------------------------------------------------------------------

;;; The body of the transform should return the symbol %PASS% if it
;;; doesn't apply.  If it does apply then it should return the
;;; transformed form.  For example, a common optimization is to do
;;; keyword analysis at compile time.
;;;
;;;     (defun foo (x &key a b)
;;;       ...)
;;;
;;;     (deftransform (foo keyword) (x &rest keyword-args)
;;;       (if (literal-keywords-in-arglist keyword-args)
;;;           (let ((a (getf keyword-args :a))
;;;                 (b (getf keyword-args :b)))
;;;             `(foo-internal ,x ,a ,b))
;;;           '%pass%))
;;;
;;;     (defun foo-internal (x a b)
;;;       ...)


;;; GBB will define several compiler transforms.  If this feature is
;;; not available in your lisp GBB will still run --- it will just run
;;; a little slower than it would if this feature was available.  If
;;; DEFTRANSFORM is defined then DELETE-TRANSFORM must be defined as
;;; well.

(defmacro DEFTRANSFORM ((function transform-name) arglist &body body)
  
  "DEFTRANSFORM (function transform-name) arglist {form}*

   Defines a source level compiler transform for FUNCTION labeled
   TRANSNAME.  If FUNCTION already has a transform labeled
   TRANSFORM-NAME then the old one will be replaced."

  (declare (ignore function transform-name arglist body))
  nil)


(defun delete-transform (function transform-name)

  "DELETE-TRANSFORM function transform-name

   This function will remove the compiler transform for FUNCTION
   designated by TRANSFORM-NAME."

  (declare (ignore function transform-name))
  nil)


;;;; --------------------------------------------------------------------------
;;;;   Miscellaneous Non Common Lisp Functions
;;;; --------------------------------------------------------------------------

;;; This function is used when printing internal GBB objects.  If your
;;; implementation doesn't provide an easy way to get the address of
;;; an object it is ok to simply return zero.  GBB doesn't depend on the
;;; value of this function uniquely identifying an object.

(defun %pointer (x)

  "%POINTER x

   Returns the address of X.  This is only used in printing to easily 
   distiguish two objects.  Its value should not be relied on."

  (ccl::%ptr-to-int x))



;;; ---------------------------------------------------------------------------
;;;				  End of File
;;; ---------------------------------------------------------------------------
