;;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:W; Base:10; Patch-file:T -*- 
;;;; *-* File: VAX6:DIS$DISK:[GBB.V-120.LOCAL.GRAPHICS]WINDOW-PATCHES.LISP *-*
;;;; *-* Edited-By: Gallagher *-*
;;;; *-* Last-Edit: Thursday, July 13, 1989  15:35:57 *-*
;;;; *-* Machine: Gilgamesh (Explorer II, Microcode 416) *-*
;;;; *-* Software: TI Common Lisp System 4.105 *-*
;;;; *-* Lisp: TI Common Lisp System 4.105 (0.0) *-*

;;;; ==========================================================================
;;;;
;;;;                   WINDOW SYSTEM PATCHES FOR GBB GRAPHICS                 
;;;;
;;;; ==========================================================================
;;;
;;; Written by: Kevin Gallagher
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst.
;;;
;;; Copyright (c) 1987, 1988 COINS.  All rights reserved.
;;; Portions Copyright (c) 1983, 1987 Texas Instruments Incorporated.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments, Inc.;
;;;    ONR URI grant N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  11-12-87 File Created.  (Gallagher)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

#+SYMBOLICS
(in-package 'tv :nicknames '(w))

(in-package 'w)

(proclaim '(optimize (speed 3) (safety 1)))
 


;;; ---------------------------------------------------------------------------
;;;   Patch to SCROLL-BAR-MIXIN
;;; ---------------------------------------------------------------------------

;;; Patches to scroll-bar-mixin.  These patches are necessary because TI
;;; puts the scroll bar in the border margin region and they make it very
;;; difficult to put it anywhere else.
;;;
;;;  1.  Initiate bump scrolling when the mouse passes the top or bottom
;;;      of the scroll bar region.  TI had bump scrolling happen when the
;;;      mouse reaches the top or bottom of the window.
;;;
;;;      This required changing (:method scroll-bar-mixin :around :mouse-moves)
;;;      to compare the mouse Y position with the top and bottom of the
;;;      scroll region.  I also changed (scroll-bar-mixin :bump) to bump
;;;      the mouse back into the scroll bar region and to accept two
;;;      optional arguments: the top and bottom of the scroll bar region.
;;;
;;;      (:method scroll-bar-mixin :around :mouse-moves) now checks
;;;      scroll-bar-mode doesn't do anything unless it is non-nil.  This
;;;      fixes the brain damaged behavior that changes the mouse to a fat
;;;      up/down arrow but there is no scroll bar displayed.
;;;
;;;  2.  Add a new mixin, LOCATABLE-SCROLL-BAR-MIXIN, which disables the
;;;      default placment of the scroll bar (in the border margin region)
;;;      and provides a :compute-margins method that will run in sequence
;;;      with all the other compute margins mixins.


#+TI
(defmethod (scroll-bar-mixin :around :mouse-moves) (cont mt ignore x y)

  "Change the mouse cursor when entering or leaving the scroll-bar area.
   Also implement bump scrolling at top and bottom of scroll-bar."

  (if (or (not (send self :scroll-bar-mode))
          (and (< (sheet-inside-left) x (sheet-inside-right))	; don't slow down the mouse 
               (not scroll-bar-active-state)))			;  when not in scroll area

    ;; The common path, not in scroll-bar.
    (funcall-with-mapping-table cont mt :mouse-moves x y)

    ;; Possibly in the scroll bar.
    (let ((top (scroll-bar-region-top scroll-bar-region))
          ;; Scroll bar region bottom should always be negative.
          (bottom (+ height (scroll-bar-region-bottom scroll-bar-region))))
      (if (if (eq :left (scroll-bar-region-side scroll-bar-region))
              (<= x (scroll-bar-region-right scroll-bar-region))  ;;needs adjustment...
              (>= x (+ width (scroll-bar-region-left scroll-bar-region))))
          ; mouse is in scroll region.
          (cond ((= (send mouse-blinker :character) *scroll-bar-char-index*)
                 (if (or (< y top)
                         (>= y bottom))
		     (send self :bump y top bottom)		; bumping top or bottom
		     (mouse-set-blinker-cursorpos x y)))	; staying in scroll region
                ((multiple-value-bind (ignore n-lines ignore n-screen-lines)
                     (send self :scroll-position)		; entering scroll region
                   (and (< n-screen-lines n-lines)
                        (plusp (send self :scroll-bar-icon-width))))
                 (setq scroll-bar-active-state :region)
                 (mouse-set-blinker-definition :character *scroll-bar-char-x-offset*
					       *scroll-bar-char-y-offset* :on
					       :set-character *scroll-bar-char-index*))
		(t						; nothing to scroll or no real region
		 (funcall-with-mapping-table cont mt :mouse-moves x y)))
	  ; mouse is not in scroll region.
	  (cond ((eq :region scroll-bar-active-state)		; leaving scroll region
		 (mouse-standard-blinker)
		 (setq scroll-bar-active-state nil))
		((eq :bump scroll-bar-active-state)
		 (if (or (< y top)
                         (>= y bottom))
		     (send self :bump y top bottom)		; bumping top or bottom
		     (mouse-set-blinker-cursorpos x y)))	; moving in bump region
		(t						; slipped by first quick check.
		 (funcall-with-mapping-table cont mt :mouse-moves x y)))))))

#+TI
(defmethod (scroll-bar-mixin :bump)
           (y
            &optional
            (top (scroll-bar-region-top scroll-bar-region))
            ;; Scroll bar region bottom should always be negative.
            ;; (but be safe anyway).
            (bottom (+ height (scroll-bar-region-bottom scroll-bar-region))))

  "Warp the mouse from y back into the window and scroll up or down one line."

  (multiple-value-bind (ignore window-y-offset)
      (sheet-calculate-offsets self mouse-sheet)
    ; Maybe make this hard coded 8 into a special variable?
    (mouse-warp mouse-x (+ (if (< y top)
                               (+ top 8.)
                               (- bottom 8.))
                           window-y-offset))
    (send self :scroll-to (if (< y top) -1 1) :relative)))


#+TI
(defflavor locatable-scroll-bar-mixin
           ()
           (scroll-bar-mixin)
  (:required-flavors w:scroll-bar-mixin)
  (:documentation
    "A version of w:scroll-bar-mixin that doesn't have to appear in the
     border margin area.  This mixin gives you control over where the
     scroll bar appears.  It disables the default placment of the scroll
     bar (in the border margin region) and, instead, provides a
     :compute-margins method that will run in sequence with all the
     other compute margins mixins.  It also draws all four sides of the
     scroll bar rather than leaving three of them to be take care of by
     the border."))

#+TI
(defmethod (locatable-scroll-bar-mixin :compute-margins) (lm tm rm bm)

  "Compute the margins for the scroll bar."
  ;; This code is based on
  ;; (w:scroll-bar-mixin :around :compute-border-margin-area-margins).
  
  (let ((side (w:scroll-bar-region-side w:scroll-bar-region)) ; set up at init
	(region-width (if (send self :scroll-bar-on?)
			  (w:scroll-bar-area-width self)
			  0))
	(left lm)
	(right (- rm)))
    ;; Unfortunately HEIGHT and WIDTH are not available now
    ;; so when the region is on the right, LEFT and RIGHT are
    ;; negative to indicate that they still need to be subtracted 
    ;; from WIDTH.
    ;;
    ;; NOTE: BOTTOM is always negative.
    (if (eq side :left)
	(setq lm (+ lm region-width)
	      right (1- lm))
	(setq rm (+ rm region-width)
	      left (- rm)))
    (setq w:scroll-bar-region (list side region-width left tm right (- bm)))
    (values lm tm rm bm)))

#+TI
(defwrapper (locatable-scroll-bar-mixin :compute-border-margin-area-margins)
            ((&rest ignore) . body)
  
  "Disable the placement of the scroll bar in the border margin region.
   In particular, don't add anymore space in the border margin for the
   scroll bar.  This method undoes the effect of
   (w:scroll-bar-mixin :around :compute-border-margin-area-margins)."

  ;; The arguments to :compute-border-margin-area-margins are:
  ;; BORDER-SPEC, LM, TM, RM, and BM, but I don't need the starting values
  ;; of these.

  `(let ((side (w:scroll-bar-region-side w:scroll-bar-region)) ; set up at init
         (region-width (if (send self :scroll-bar-on?)
                           (w:scroll-bar-area-width self)
                           0)))
     (multiple-value-bind (new-border-spec new-lm new-tm new-rm new-bm)
         (progn ,@body)
       (if (eq side :left)
           (setq new-lm (- new-lm region-width))
           (setq new-rm (- new-rm region-width)))
       (values new-border-spec new-lm new-tm new-rm new-bm))))


;;; ---------------------------------------------------------------------------
;;;                                End of File
;;; ---------------------------------------------------------------------------
