;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:GBB-GRAPHICS; Base:10 -*-
;;;; *-* File: VAX6:DIS$DISK:[GBB.V-120.LOCAL.GRAPHICS]CONFIGURATIONS.LISP *-*
;;;; *-* Last-Edit: Thursday, July 13, 1989  15:06:10; Edited-By: Gallagher *-*
;;;; *-* Machine: Gilgamesh (Explorer II, Microcode 416) *-*
;;;; *-* Software: TI Common Lisp System 4.105 *-*
;;;; *-* Lisp: TI Common Lisp System 4.105 (0.0) *-*

;;;; ==========================================================================
;;;;
;;;;             CONSTRAINT FRAME CONFIGURATIONS FOR GBB GRAPHICS
;;;;
;;;; ==========================================================================
;;;
;;; Written by: Kevin Gallagher
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1987, 1988 COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;; This file contains the constraint frame configuration constraints and
;;; stuff like that.  It is in a separate file to keep from cluttering up
;;; explorer-graphics.
;;;
;;;  06-23-87 File Created.  (Gallagher)
;;;  07-13-89 Merged John's Symbolics modifications into this file.
;;;           (Gallagher)
;;;
;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(in-package 'GBB-GRAPHICS)

(proclaim '(optimize (speed 3) (safety 1)))


;;; ---------------------------------------------------------------------------
;;;   Pane Stuff
;;; ---------------------------------------------------------------------------

;;; To make things more convenient, the number of graphics panes that
;;; will be created is determined by this variable.  However, if this
;;; number is reduced make sure that there are no stray references to
;;; panes that will no longer exist.  In particular, check the
;;; configurations defined later in this file.

(defparameter *number-of-graphics-panes* 15
  "Number of graphics panes in each frame.")


;;; This is a list of the names of the graphics panes (i.e., the panes
;;; that can display the contents of a space) for the GBB graphics
;;; frame.  The symbols must correspond to the names given to the
;;; graphics panes below (*GRAPHICS-FRAME-PANES*).

(defparameter *GRAPHICS-PANE-NAMES*
    (loop for i from 1 to *number-of-graphics-panes*
          collect (gbb::form-symbol "GRAPHICS-" (format nil "~d" i)))
  "Names of the graphics panes in the GBB graphics constraint frame.")


;;; This is a list of :panes acceptable to constraint frames.  The
;;; message pane is intended for any random output that an application
;;; may want to display.  It is unused at the moment.

;; Note that on the Symbolics the background process is created in
;; the init method for the frame; so, no process is specified for
;; the pane graphics-1.

(defparameter *GRAPHICS-FRAME-PANES*
    `((ll		gbb-lisp-listener-pane
			:label (:string "Lisp Listener" :font fonts:hl12i)
			#+TI :font-map #+TI (fonts:cptfont))
      (logo		gbb-logo-pane)
      (message	   	w:window
			:label nil
			:blinker-p nil)
      (menu        	gbb-menu-pane
			#+TI :font-map #+TI (fonts:hl12b))
      (graphics-1  	gbb-graphics-pane
                        #+TI :process #+TI gbb-graphics-frame-process)
      ,@(mapcar #'(lambda (pane-name) (list pane-name 'gbb-graphics-pane))
                (cdr *GRAPHICS-PANE-NAMES*)))

  "The list of panes for the GBB graphics frame.
   It is a list suitable for the :panes initialization option
   of tv:constraint-frame.")


;;; This is a list of the panes that are going to share an IO buffer
;;; with the pane GRAPHICS-1.  The IO buffer is used to communicate
;;; mouse blips to the `background' process which is associated with
;;; GRAPHICS-1.

(defparameter *GRAPHICS-IO-BUFFER-SHARERS*
             `(menu ,@(cdr *GRAPHICS-PANE-NAMES*))
  "Names of the panes that share a single IO buffer.")


;;; ---------------------------------------------------------------------------
;;;   Configuration Stuff
;;; ---------------------------------------------------------------------------


(defparameter *GRAPHICS-FRAME-CONFIGURATIONS* nil

  "This is a list of configurations for the GBB graphics frame.
   It is a list of constraints appropriate for the :constraints
   initialization option of tv:constraint-frame.  To add a
   configuration, use the macro DEFINE-CONFIGURATION.")


(defparameter *GRAPHICS-INITIAL-CONFIGURATION*
              '|Four Panes (2X2) with Listener, Logo|
  "The name of the initial configuation for the GBB graphics frame.")


(defmacro DEFINE-CONFIGURATION (name &body args)

  "DEFINE-CONFIGURATION name [documentation] configuration

   Define a configuration for the GBB graphics frame."

  (let ((doc (and (stringp (first args)) (pop args)))
	(config (first args)))
    `(progn
       (pushnew-acons *graphics-frame-configurations*
		      ',name ',config
		      :test #'eq)
       (setf (get ',name :configuration-documentation) ',doc))))

  
;;; The configuration constraints::

(define-configuration |Single Pane with Logo, Listener|
  "A single, large graphics pane with a GBB logo and a lisp listener on the right."
  ((whole)
   ((whole :horizontal (:even)
	   (graphics-1 etc)
	   ((graphics-1 .75))
	   ((etc :vertical (:even)
		 (logo ll)
		 ((logo .22))
		 ((ll :even))))))))

(define-configuration |Single Pane with tall Listener|
  "A single, large graphics pane with a lisp listener on the right."
  ((whole)
   ((whole :horizontal (:even)
	   (graphics-1 ll)
	   ((graphics-1 .75))
           ((ll :even))))))

(define-configuration |Single Pane with Listener|
  "A single, large graphics pane with a lisp listener along the bottom."
  ((graphics-1 ll)
   ((ll 4 :lines))
   ((graphics-1 :even))))

(define-configuration |Single Pane with Listener, Menu|
  "A single, large graphics pane with a small lisp listener and command menu along the bottom."
  ((graphics-1 menu ll)
   ((ll 4 :lines))
   ((menu 2 :lines))
   ((graphics-1 :even))))

(define-configuration |Two Panes (Stacked) with Listener, Logo|
  "Two graphics panes stacked one on top of the other with a GBB logo pane and a lisp listener on the right."
  ((whole)
   ((whole :horizontal (:even)
	   (left right)
	   ((left :vertical (.75)
		  (graphics-1 graphics-2)
		  ((graphics-1 :even)
		   (graphics-2 :even))))
	   ((right :vertical (:even)
		   (logo ll)
		   ((logo .22))
		   ((ll :even))))))))

(define-configuration |Two Panes (Stacked) with tall Listener|
  "Two graphics panes stacked one on top of the other with a lisp listener on the right."
  ((whole)
   ((whole :horizontal (:even)
	   (left ll)
	   ((left :vertical (.75)
		  (graphics-1 graphics-2)
		  ((graphics-1 :even)
		   (graphics-2 :even))))
           ((ll :even))))))

(define-configuration |Two Panes (Stacked) with Listener|
  "Two graphics panes stacked one on top of the other with a lisp listener on the bottom."
  ((graphics-1 graphics-2 ll)
   ((ll 4 :lines))
   ((graphics-1 .5))
   ((graphics-2 :even))))

(define-configuration |Two Panes (Stacked) with Listener, Menu|
  "Two graphics panes stacked one on top of the other with a lisp listener and command menu on the bottom."
  ((graphics-1 graphics-2 menu ll)
   ((ll 4 :lines))
   ((menu 2 :lines))
   ((graphics-1 .5))
   ((graphics-2 :even))))

(define-configuration |Two Panes (Side By Side) with Listener, Logo|
  "Two graphics panes side by side with a GBB logo pane and a lisp listener on the right."
  ((whole)
   ((whole :horizontal (:even)
	   (graphics-1 graphics-2 right)
	   ((right :vertical (.25)
		   (logo ll)
		   ((logo .22))
		   ((ll :even))))
	   ((graphics-1 :even)
	    (graphics-2 :even))))))

(define-configuration |Two Panes (Side By Side) with tall Listener|
  "Two graphics panes side by side with a lisp listener on the right."
  ((whole)
   ((whole :horizontal (:even)
	   (graphics-1 graphics-2 ll)
	   ((ll .25))
	   ((graphics-1 .5))
	   ((graphics-2 :even))))))

(define-configuration |Two Panes (Side By Side) with Listener|
  "Two graphics panes side by side with a Listener on the bottom."
  ((top ll)
   ((ll 4 :lines))
   ((top :horizontal (:even)
         (graphics-1 graphics-2)
         ((graphics-1 :even)
          (graphics-2 :even))))))

(define-configuration |Two Panes (Side By Side) with Listener and Menu|
  "Two graphics panes side by side with a lisp listener and command menu on the bottom."
  ((top menu ll)
   ((menu 2 :lines))
   ((ll 4 :lines))
   ((top :horizontal (:even)
         (graphics-1 graphics-2)
         ((graphics-1 :even)
          (graphics-2 :even))))))

(define-configuration |Two Panes with Big Listener|
  "Two graphics panes stacked one on top of the other with a big lisp listener on the right."
  ((whole)
   ((whole :horizontal (:even)
	   (left ll)
	   ((left :vertical (.30)
		  (graphics-1 graphics-2)
		  ((graphics-1 :even)
		   (graphics-2 :even))))
	   ((ll :even))))))

(define-configuration |Three Panes (Stacked) with Listener, Logo|
  "Three graphics panes stacked on top of each other with a GBB logo pane and a lisp listener on the right."
  ((whole)
   ((whole :horizontal (:even)
	   (left right)
	   ((left :vertical (.75)
		  (graphics-1 graphics-2 graphics-3)
		  ((graphics-1 :even)
		   (graphics-2 :even)
		   (graphics-3 :even))))
	   ((right :vertical (:even)
		   (logo ll)
		   ((logo .22))
		   ((ll :even))))))))

(define-configuration |Three Panes (Stacked) with tall Listener|
  "Three graphics panes stacked on top of each other with a lisp listener on the right."
  ((whole)
   ((whole :horizontal (:even)
	   (left ll)
	   ((left :vertical (.75)
		  (graphics-1 graphics-2 graphics-3)
		  ((graphics-1 :even)
		   (graphics-2 :even)
		   (graphics-3 :even))))
           ((ll :even))))))

(define-configuration |Three Panes (Stacked) with Listener|
  "Three graphics panes stacked on top of each other with a lisp listener on the bottom."
  ((graphics-1 graphics-2 graphics-3 ll)
   ((ll 4 :lines))
   ((graphics-1 .33))
   ((graphics-2 .5))
   ((graphics-3 :even))))

(define-configuration |Three Panes (Stacked) with Listener, Menu|
  "Three graphics panes stacked on top of each other with a lisp listener and command menu on the bottom."
  ((graphics-1 graphics-2 graphics-3 menu ll)
   ((ll 4 :lines))
   ((menu 2 :lines))
   ((graphics-1 .33))
   ((graphics-2 .5))
   ((graphics-3 :even))))

(define-configuration |Three Panes with Big Listener|
  "Three graphics panes in an L-shape with a lisp listener in the bottom right."
  ((whole)
   ((whole :horizontal (:even)
	   (left right)
	   ((left :vertical (.35)
		  (graphics-1 graphics-3)
		  ((graphics-1 .30))
		  ((graphics-3 :even))))
	   ((right :vertical (:even)
		   (graphics-2 ll)
		   ((graphics-2 .30))
		   ((ll :even))))))))

(define-configuration |Four Panes (Stacked) with Listener, Logo|
  "Four graphics panes stacked on top of each other with a GBB logo pane and a lisp listener on the right."
  ((whole)
   ((whole :horizontal (:even)
	   (left right)
	   ((left :vertical (.75)
		  (graphics-1 graphics-2 graphics-3 graphics-4)
		  ((graphics-1 :even)
		   (graphics-2 :even)
		   (graphics-3 :even)
                   (graphics-4 :even))))
	   ((right :vertical (:even)
		   (logo ll)
		   ((logo .22))
		   ((ll :even))))))))

(define-configuration |Four Panes (Stacked) with tall Listener|
  "Four graphics panes stacked on top of each other with a lisp listener on the right."
  ((whole)
   ((whole :horizontal (:even)
	   (left ll)
	   ((left :vertical (.75)
		  (graphics-1 graphics-2 graphics-3 graphics-4)
		  ((graphics-1 :even)
		   (graphics-2 :even)
		   (graphics-3 :even)
                   (graphics-4 :even))))
           ((ll :even))))))

(define-configuration |Four Panes (Stacked) with Listener|
  "Four graphics panes stacked on top of each other with a lisp listener on the bottom."
  ((graphics-1 graphics-2 graphics-3 graphics-4 ll)
   ((ll 4 :lines))
   ((graphics-1 .25))
   ((graphics-2 .33))
   ((graphics-3 .5))
   ((graphics-4 :even))))

(define-configuration |Four Panes (Stacked) with Listener, Menu|
  "Four graphics panes stacked on top of each other with a lisp listener and command menu on the bottom."
  ((graphics-1 graphics-2 graphics-3 graphics-4 menu ll)
   ((ll 4 :lines))
   ((menu 2 :lines))
   ((graphics-1 .25))
   ((graphics-2 .33))
   ((graphics-3 .5))
   ((graphics-4 :even))))

(define-configuration |Four Panes (2X2) with Listener, Logo|
  "Four graphics panes with a GBB logo pane and a lisp listener on the right."
  ((whole)
   ((whole :horizontal (:even)
	   (left middle right)
	   ((right  :vertical (.25)
		    (logo ll)
		    ((logo .22))
		    ((ll :even))))
	   ((left   :vertical (:even)
		    (graphics-1 graphics-3)
		    ((graphics-1 :even)
		     (graphics-3 :even)))
	    (middle :vertical (:even)
		    (graphics-2 graphics-4)
		    ((graphics-2 :even)
		     (graphics-4 :even))))))))

(define-configuration |Four Panes (2X2) with Listener|
  "Four graphics panes with a lisp listener on the bottom."
  ((top bottom ll)
   ((ll 4 :lines))
   ((top :horizontal (:even)
	 (graphics-1 graphics-2)
	 ((graphics-1 :even)
	  (graphics-2 :even)))
    (bottom :horizontal (:even)
	    (graphics-3 graphics-4)
	    ((graphics-3 :even)
	     (graphics-4 :even))))))

(define-configuration |Four Panes (2X2) with Listener, Menu|
  "Four graphics panes with a lisp listener and command menu on the bottom."
  ((top bottom menu ll)
   ((ll 4 :lines))
   ((menu 2 :lines))
   ((top :horizontal (:even)
	 (graphics-1 graphics-2)
	 ((graphics-1 :even)
	  (graphics-2 :even)))
    (bottom :horizontal (:even)
	    (graphics-3 graphics-4)
	    ((graphics-3 :even)
	     (graphics-4 :even))))))

(define-configuration |Five Panes with Listener|
  "Five graphics panes with a lisp listener in the bottom right corner."
  ((top bottom)
   ((top :horizontal (:even)
	 (graphics-1 graphics-2 graphics-3)
	 ((graphics-1 :even)
	  (graphics-2 :even)
	  (graphics-3 :even)))
    (bottom :horizontal (:even)
	    (graphics-4 graphics-5 ll)
	    ((graphics-4 :even)
	     (graphics-5 :even)
	     (ll :even))))))

(define-configuration |Six Panes (3 Narrow, 3 Wide) with Listener|
  "Six graphics panes (3 Narrow, 3 Wide) with a lisp listener on the bottom."
  ((top middle bottom ll)
   ((ll 4 :lines))
   ((top :horizontal (:even)
	 (graphics-1 graphics-2)
	 ((graphics-1 .2))
	 ((graphics-2 :even)))
    (middle :horizontal (:even)
	    (graphics-3 graphics-4)
	    ((graphics-3 .2))
	    ((graphics-4 :even)))
    (bottom :horizontal (:even)
	    (graphics-5 graphics-6)
	    ((graphics-5 .2))
	    ((graphics-6 :even))))))
	  
(define-configuration |Six Panes (2X3) with Listener|
  "Six graphics panes (2 Rows, 3 Columns) with a lisp listener on the bottom."
  ((top bottom ll)
   ((ll 4 :lines))
   ((top :horizontal (:even)
	 (graphics-1 graphics-2 graphics-3)
	 ((graphics-1 :even)
	  (graphics-2 :even)
	  (graphics-3 :even)))
    (bottom :horizontal (:even)
	    (graphics-4 graphics-5 graphics-6)
	    ((graphics-4 :even)
	     (graphics-5 :even)
	     (graphics-6 :even))))))

(define-configuration |Six Panes (2X3) with Listener, Menu|
  "Six graphics panes (2 Rows, 3 Columns) with a lisp listener and command menu on the bottom."
  ((top bottom menu ll)
   ((ll 4 :lines))
   ((menu 2 :lines))
   ((top :horizontal (:even)
	 (graphics-1 graphics-2 graphics-3)
	 ((graphics-1 :even)
	  (graphics-2 :even)
	  (graphics-3 :even)))
    (bottom :horizontal (:even)
	    (graphics-4 graphics-5 graphics-6)
	    ((graphics-4 :even)
	     (graphics-5 :even)
	     (graphics-6 :even))))))

(define-configuration |Eight Panes (4 Horizontal, 4 Vertical) with Listener|
  "Eight graphics panes with a lisp listener on the bottom."
  ((top ll)
   ((top :horizontal (.7)
	 (left graphics-5 graphics-6 graphics-7 graphics-8)
	 ((left :vertical (.5)
		(graphics-1 graphics-2 graphics-3 graphics-4)
		((graphics-1 :even)
		 (graphics-2 :even)
		 (graphics-3 :even)
		 (graphics-4 :even))))
	 ((graphics-5 :even)
	  (graphics-6 :even)
	  (graphics-7 :even)
	  (graphics-8 :even))))
   ((ll :even))))

(define-configuration |Ten Panes (Six and Four)|
  "Ten graphics panes without a lisp listener."
  ((whole)
   ((whole :horizontal (:even)
	   (wide1 wide2 narrow1 narrow2)
	   ((wide1 :vertical (.333)
		   (graphics-1 graphics-2 graphics-3)
		   ((graphics-1 :even) (graphics-2 :even) (graphics-3 :even)))
	    (wide2 :vertical (.333)
		   (graphics-4 graphics-5 graphics-6)
		   ((graphics-4 :even) (graphics-5 :even) (graphics-6 :even)))
	    (narrow1 :vertical (.166)
		     (graphics-7 graphics-8)
		     ((graphics-7 :even) (graphics-8 :even))))
	   ((narrow2 :vertical (:even)
		     (graphics-9 graphics-10)
		     ((graphics-9 :even) (graphics-10 :even))))))))

(define-configuration |Ten Panes (Six and Four) with Listener|
  "Ten graphics panes with a lisp listener on the bottom."
  ((top ll)
   ((top :horizontal (.90)
	 (wide1 wide2 narrow1 narrow2)
	 ((wide1 :vertical (.333)
		 (graphics-1 graphics-2 graphics-3)
		 ((graphics-1 :even) (graphics-2 :even) (graphics-3 :even)))
	  (wide2 :vertical (.333)
		 (graphics-4 graphics-5 graphics-6)
		 ((graphics-4 :even) (graphics-5 :even) (graphics-6 :even)))
	  (narrow1 :vertical (.166)
		   (graphics-7 graphics-8)
		   ((graphics-7 :even) (graphics-8 :even))))
	 ((narrow2 :vertical (:even)
		   (graphics-9 graphics-10)
		   ((graphics-9 :even) (graphics-10 :even))))))
   ((ll :even))))

(define-configuration |Ten Panes (Six and Four) with Listener, Menu|
  "Ten graphics panes with a lisp listener and command menu on the bottom."
  ((top menu ll)
   ((menu 2 :lines))
   ((ll 4 :lines))
   ((top :horizontal (:even)
	 (wide1 wide2 narrow1 narrow2)
	 ((wide1 :vertical (.333)
		 (graphics-1 graphics-2 graphics-3)
		 ((graphics-1 :even) (graphics-2 :even) (graphics-3 :even)))
	  (wide2 :vertical (.333)
		 (graphics-4 graphics-5 graphics-6)
		 ((graphics-4 :even) (graphics-5 :even) (graphics-6 :even)))
	  (narrow1 :vertical (.166)
		   (graphics-7 graphics-8)
		   ((graphics-7 :even) (graphics-8 :even))))
	 ((narrow2 :vertical (:even)
		   (graphics-9 graphics-10)
		   ((graphics-9 :even) (graphics-10 :even))))))))
		   
;;; ---------------------------------------------------------------------------
;;; Special Purpose Configurations

(define-configuration |ISR -- Three Panes|
  ((top ll)
   ((top :horizontal (.6)
         (graphics-1 graphics-2 graphics-3)
         ((graphics-1 .4)
          (graphics-2 .4))
         ((graphics-3 :even))))
   ((ll :even))))

(define-configuration |ISR -- Four Panes|
  ((top bottom)
   ((top :horizontal (.5)
         (graphics-1 graphics-2 graphics-3)
         ((graphics-1 .4)
          (graphics-2 .4))
         ((graphics-3 :even))))
   ((bottom :horizontal (:even)
            (graphics-4 ll)
            ((graphics-4 .4))
            ((ll :even))))))

(define-configuration |GBB1 Execution Shell|
  ((top bottom)
   ((top :horizontal (.55)
	 (graphics-1 graphics-2 column-3 column-4)
	 ((graphics-1 :even)
	  (graphics-2 :even)
	  (column-3 :vertical (:even)
		    (graphics-3 graphics-4)
		    ((graphics-3 :even)
		     (graphics-4 :even)))
	  (column-4 :vertical (:even)
		    (graphics-5 graphics-6)
		    ((graphics-5 :even)
		     (graphics-6 :even))))))
   ((bottom :horizontal (:even)
	    (graphics-7 ll)
	    ((graphics-7 .45))
	    ((ll :even))))))

(define-configuration |GBB1 Hyp Pyramid|
  ((top bottom)
   ((top :horizontal (.55)
	 (graphics-1 graphics-2 column-3 column-4)
	 ((graphics-1 :even)
	  (graphics-2 :even)
	  (column-3 :vertical (:even)
		    (graphics-3 graphics-4)
		    ((graphics-3 :even)
		     (graphics-4 :even)))
	  (column-4 :vertical (:even)
		    (graphics-5 graphics-6)
		    ((graphics-5 :even)
		     (graphics-6 :even))))))
   ((bottom :horizontal (:even)
	    (levels ll)
	    ((levels :vertical (.45)
		     (graphics-7 graphics-8 graphics-9 graphics-10)
		     ((graphics-7 :even)
		      (graphics-8 :even)
		      (graphics-9 :even)
		      (graphics-10 :even))))
	    ((ll :even))))))

;;; ---------------------------------------------------------------------------
;;;                                End of File
;;; ---------------------------------------------------------------------------
