;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:GBB1; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL.GBB1]KSS-GBB.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Thursday, September 15, 1988  15:10:49 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *           GBB1 KS Shell: GBB Control KS Definitions
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Philip Johnson
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  06-18-87 File Created.  (Johnson)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package "GBB1")

(use-package '(lisp umass-extended-lisp gbb))


#|| ==========================================================================

Here's how this works.  In the KS Shell, each control definition results in
the creation of 3 GBB unit types: a KS unit type, and KSAR unit type, and a
PLAN-OBJECT unit type.  The KSs reside on the KS space, the KSARs reside on
the agenda spaces, and the PLAN-OBJECTS reside on the CONTROL-PLAN space.
The CONTROL-PLAN space is where the action is, proverbially speaking, for it
is there that the information used to determine which KSAR actions to
execute next is stored.  Control KSs are (normally) triggered by noticing
something they wish to do to the control plan, their KSARs are rated
according to the value of this modification, and their action is (normally)
to either add a control plan object or modify an existing one.

Control comes in three flavors, Strategies, Focii, and Heuristics.  

Strategies describe general problem solving behaviors, and are implemented
by a set of focii.  This set of focii is called the strategy's prescription.
To provide flexibility in the application of the prescription focii to solve
the problem addressed by the strategy, the prescription is divided into
three sets.  The future-prescription set consists of the focii waiting to be
used in problem solving.  The current-prescription set consists of the focii
currently being used in problem solving, and the past-prescription set
consists of the focii which have already been used.  While the
future-prescription set may be given an initial value at Control KS
definition time, it is normally the case that KSs are defined specifically
for the task of maintaining and updating the prescription sets for strategy
KSs.  (GBB1 supplies default KSs for this purpose, though the user is free
to define their own.)

Focii describe more specific, local, problem solving behaviors than
strategies.  Each focus has associated with it a goal function which can be
used to determine when its purpose has been acheived.  You may ask yourself,
how does it achieve its purpose?  Well, it achieves it by giving high
ratings to those KSARs whose actions fulfill its purpose.  This is
accomplished in two stages.  First, each focus is implemented in terms of a
set of heuristics, who each return an individual rating for the KSAR's
actions.  Each focus has a rating integration function, which determines a
single rating for the KSAR given the set of heuristic ratings.  (This set of
integrated ratings is then combined into the KSAR's priority, and so on.)

Heuristics are the lowest level of this hierarchy, and as stated above,
contain a function used to rate KSARs.  In addition, they have an attribute
stability associated with them, which is used to determine whether or not
they need to re-rate KSARs they've seen before, as well as a weight
attribute, used to determine the strength of the rating.

All of these control types have the attribute status, which can be either
operative or inoperative.  Only operative heuristics and focii are used to
rate KSARs.  Making a focii inoperative effectively makes its heuristics
inoperative, since they won't be used in the rating process.  However, since
strategy POs are not used in the rating process, making a strategy
inoperative must involve manually making all of its implementing focii
inoperative as well.

========================================================================== ||#

;;;-----------------------------------------------------------------------------
;;;
;;;  Control Plan Structure Definitions.
;;;
;;;-----------------------------------------------------------------------------

(defstruct (ksar-rating (:conc-name "KSAR-RATING$")
			)

  "Stores stable priority values and focus ratings for KSARs."

  priority       ;; NIL or the priority value
  focus-ratings  ;; filled with a hash table storing focus-rating structures.
  )

;;;-----------------------------------------------------------------------------

(defstruct (focus-rating (:conc-name "FOCUS-RATING$")
			 )

  "Stores the (stable) integrated rating and heuristic ratings of the KSAR
   by a single focus."

  integrated-rating  ;; NIL or the integrated rating value.
  heuristic-ratings  ;; filled with a hash table storing (numerical) heuristic ratings.
  )

;;;-----------------------------------------------------------------------------
;;;
;;;  Control KSARs
;;;
;;;-----------------------------------------------------------------------------

(define-unit (GBB1-EVENT (:include atomic-event)
			 :export)
  
  :paths
  ((:path '(events))))

;;;-----------------------------------------------------------------------------

(define-unit (BASIC-KSAR (:constructor nil)
			 (:predicate nil)
			 (:include atomic-ksar)
			 :export)
  
  "The version of basic-ksar for the KS shell."
  
  :slots ((ratings (make-ksar-rating
		     :priority nil
		     :focus-ratings (make-hash-table))))
  
  :paths
  ((:path `(gbb1 control agendas ,agenda-index))))


;;;; --------------------------------------------------------------------------

(define-unit (BASIC-CONTROL-KSAR (:constructor nil)
				 (:predicate nil)
				 (:include basic-ksar)
				 :export)

 "Define control slots and links for all control (strategy, focus, and heuristic) KSs.")


;;;-----------------------------------------------------------------------------
;;;
;;;  Control KSs
;;;
;;;-----------------------------------------------------------------------------

(define-unit (BASIC-KS (:constructor nil)
		       (:predicate nil)
		       (:include atomic-ks)
		   :export )

  "Define the basic-ks unit for the KS shell."

  :paths
  ((:path '(gbb1 kb kss))))

;;;-----------------------------------------------------------------------------

(define-unit (basic-control-ks (:constructor nil)
			       (:predicate nil)
			       (:include basic-ks)
			       :export)

 "Define control slots for all control (strategy, focus, and heuristic) KSs."

 :slots ((control-type nil)))

;;;-----------------------------------------------------------------------------

(define-unit (basic-heuristic-ks (:constructor nil)
				 (:predicate nil)
				 (:include basic-control-ks)
				 :export)

  "Define slots for all heuristic KSs"

  ;;; no additional slots need be defined currently.
  )
;;;-----------------------------------------------------------------------------

(define-unit (basic-focus-ks (:constructor nil)
			     (:predicate nil)
			     (:include basic-control-ks)
			     :export)

  "Define slots and links for all focii KSs"

  :links ((current-prescription-for (basic-strategy-po current-prescription)))
  )

;;;-----------------------------------------------------------------------------

(define-unit (basic-strategy-ks (:constructor nil)
				(:predicate nil)
			        (:include basic-control-ks)
				:export)

  "Define slots and links for all strategy KSs"

  ;; no additional slots or links need be declared currently.
  )

;;;-----------------------------------------------------------------------------
;;;
;;;  Control Plan Blackboard Objects
;;;
;;;-----------------------------------------------------------------------------

;; It would be nice to put the CONTROL-TYPE slot into BASIC-CONTROL-PO
;; and that way it could have CONTROL-TYPE as a dimensional index.
;; Unfortunately, it is easier to initialize the control type slot in
;; the basic strategy, focus, and heuristic units.  The problem arises
;; when you try to do something like
;;
;;    (find-units t *cpl-agenda-path* ...)
;;
;; You get an error that "(BASIC-CONTROL-PO :PLUS-SUBTYPES) does not have
;; CONTROL-TYPE as a dimensional index." 
;;
;; Anyway, the consequence of this is that all PO types must include one
;; of BASIC-STRATEGY-PO, BASIC-FOCUS-PO, or BASIC-HEURISTIC-PO and not
;; BASIC-CONTROL-PO.


(define-unit (basic-control-po (:constructor nil)
			       (:predicate nil)
			       (:creation-events gbb1-creation)
			       :export)
  
  "Define slots and links for all control (strategy, focus, and heuristic)
   plan objects."

  ;; the update events update the ratings structure of all the KSARs on the 
  ;; executable agenda
 
  :slots ((status         :operative :update-events (status-change-rating-update))
	  (stability      :dynamic   :update-events (stability-change-rating-update))
	  (first-cycle *execution-cycle*)
	  (last-cycle  nil)
	  (goal-function  nil)
	  ;; It would be nice if the KS slot was a link but if it was
          ;; then we couldn't give it an initial value.
	  (ks             (basic-control-ksar$triggering-ks *this-ksar*)))

  :paths ((:path '(gbb1 control control-plan))))

;;;-----------------------------------------------------------------------------

(define-unit (basic-heuristic-po (:constructor nil)
				 (:predicate nil)
				 (:include basic-control-po)
				 :export)

  "Define slots and links for heuristic control plan objects."

  :slots ((rating-function  nil)
	  (control-type     :heuristic)
	  (weight           0))

  :dimensional-indexes ((control-type control-type :type :label))

  :links ((implementor-of (basic-focus-po implemented-by)
			  :initialization-events (heuristic-addition-rating-update)
			  :update-events (heuristic-addition-rating-update)
			  :unlink-events (heuristic-deletion-rating-update))))

;;;-----------------------------------------------------------------------------

(define-unit (basic-focus-po (:constructor nil)
			     (:predicate nil)
			     (:include basic-control-po)
			     (:creation-events focus-addition-rating-update)
			     (:deletion-events focus-deletion-rating-update)
			     :export)

  "Define slots and links for focus control plan objects."

  :slots ((control-type               :focus)
          ;; The integrated rating function takes two arguments:
          ;; a KSAR and a FOCUS-INSTANCE.
	  (integrated-rating-function  #'sum-of-weights-times-ratings)
	  (heuristics                  nil)
	  (weight                      1))

  :dimensional-indexes ((control-type control-type :type :label))

  :links ((implementor-of (basic-strategy-po implemented-by))
	  (implemented-by (basic-heuristic-po implementor-of)))
  )

;;;-----------------------------------------------------------------------------

(define-unit (basic-strategy-po (:constructor nil)
				(:predicate nil)
				(:include basic-control-po)
				:export)

  "Define slots and links for strategy control plan objects."

  :slots ((future-prescription nil :update-events (gbb1-slot-update))
	  (past-prescription   nil)
	  (control-type        :strategy))

  :dimensional-indexes ((control-type control-type :type :label))

  :links ((current-prescription (basic-focus-ks current-prescription-for)
				:update-events (gbb1-link-update)
				:unlink-events (gbb1-unlink))
	  (implemented-by       (basic-focus-po implementor-of))))


;;;-----------------------------------------------------------------------------
;;;
;;;  Control Plan Modification Events (for the rating process)
;;;
;;;-----------------------------------------------------------------------------

(defun focus-po-p (object)
  (typep object 'basic-focus-po))

(defun heuristic-po-p (object)
  (typep object 'basic-heuristic-po))

(defun strategy-po-p (object)
  (typep object 'basic-strategy-po))

;;;-----------------------------------------------------------------------------
;;;
;;; Deal with status changes
;;;
;;;-----------------------------------------------------------------------------

(defun status-change-rating-update (plan-object slot new-status old-status)

  "STATUS-CHANGE-RATING-UPDATE plan-object slot new-status old-status

   This event handler updates the KSARs on the executable agenda to reflect
   the change in status of a plan object."

  ;; dispatch based upon the type of the plan object being modified.

  (declare (ignore old-status slot))

  (cond ((focus-po-p plan-object)
	 (if (eq new-status :operative)
	     (remove-saved-priority-and-integrated-rating plan-object)
	     (remove-saved-priority)))
	 ((heuristic-po-p plan-object)
	  (remove-saved-priority-and-integrated-rating
	    (basic-heuristic-po$implementor-of plan-object)))))

;;;-----------------------------------------------------------------------------
;;;
;;; Deal with stability changes.
;;;
;;;-----------------------------------------------------------------------------

(defun stability-change-rating-update (plan-object slot new-status old-status)

  "STABILITY-CHANGE-RATING-UPDATE plan-object slot new-status old-status

   This event handler updates the KSARs on the executable agenda to reflect
   the change in stability of a plan object."

  ;; dispatch based upon the type of the plan object being modified.
  ;; note that when an object becomes stable, no updating needs to be made.

  (declare (ignore old-status slot))

  (cond ((focus-po-p plan-object)
	 (when (eq new-status :dynamic)
	     (remove-saved-priority-and-integrated-rating plan-object)))
	 ((heuristic-po-p plan-object)
	  (when (eq new-status :dynamic)
	      (remove-saved-priority-and-integrated-rating
		(basic-heuristic-po$implementor-of plan-object))))))

;;;-----------------------------------------------------------------------------
;;;
;;; Deal with focus and heuristic additions/deletions
;;;
;;;-----------------------------------------------------------------------------

(defun focus-addition-rating-update (focus-po)

  "FOCUS-ADDITION-RATING-UPDATE focus-po

   Removes the saved priority from KSARs on the executable agenda. "

  (declare (ignore focus-po))
  (remove-saved-priority))

;;;-----------------------------------------------------------------------------

(defun focus-deletion-rating-update (focus-po)

  "FOCUS-DELETION-RATING-UPDATE focus-po

   Removes saved priorities from KSARs on the executable agenda, and
   removes the focus rating table for this focus-po as well."

  (map-space #'(lambda (ksar)
		 (setf (basic-ksar$priority ksar) nil)
		 (remhash focus-po (ksar-rating$focus-ratings (basic-ksar$ratings ksar))))
	     t
	     *exe-agenda-path*))

;;;-----------------------------------------------------------------------------

(defun heuristic-addition-rating-update (heuristic-po link-name focus-po &optional old-link-val)

  "HEURISTIC-ADDITION-RATING-UPDATE heuristic-po link-name focus-po old-link-val

   Remove saved priorities and integrated rating."

  (declare (ignore heuristic-po link-name old-link-val))
  (remove-saved-priority-and-integrated-rating focus-po))

;;;-----------------------------------------------------------------------------

(defun heuristic-deletion-rating-update (heuristic-po link-name current-val focus-po)

  "HEURISTIC-DELETION-RATING-UPDATE heuristic-po link-name current-val focus-po

   Remove saved priorities and integrated rating. Also removes the 
   heuristic from the heuristic rating table."

  (declare (ignore link-name current-val))

  (map-space #'(lambda (ksar)
		 (let ((focus-table (get-focus-rating
				      focus-po
				      (ksar-rating$focus-ratings (basic-ksar$ratings ksar)))))
		   (setf (basic-ksar$priority ksar) nil)
		   (setf (focus-rating$integrated-rating focus-table) nil)
		   (remhash heuristic-po (focus-rating$heuristic-ratings focus-table))))
	     t
	     *exe-agenda-path*))
  
;;;-----------------------------------------------------------------------------
;;;
;;;  Utility functions for updating the executable agenda
;;;
;;;-----------------------------------------------------------------------------

(defun remove-saved-priority ()

  "REMOVE-SAVED-PRIORITY nil

   Remove saved priority rating from all KSARs on the executable agenda."

  (map-space #'(lambda (ksar)
		 (setf (basic-ksar$priority ksar) nil))
	     t
	     *exe-agenda-path*))

;;;-----------------------------------------------------------------------------

(defun remove-saved-priority-and-integrated-rating (focus-po)

  "REMOVE-SAVED-PRIORITY-AND-INTEGRATED-RATING focus-po

   Remove saved priority and int rating from all KSARs on the exe. agenda."

  (map-space #'(lambda (ksar)
		 (setf (basic-ksar$priority ksar) nil)
		 (setf (focus-rating$integrated-rating
			 (get-focus-rating
			   focus-po (ksar-rating$focus-ratings
				      (basic-ksar$ratings ksar))))
		       nil))
	     t
	     *exe-agenda-path*))

  
;;;-----------------------------------------------------------------------------
;;;                            End of file
;;;-----------------------------------------------------------------------------

