;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:GBB1; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL.GBB1]GBB1-VARS.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Friday, September 16, 1988  10:25:18 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                      GBB1 ES Shell Variable Definitions
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Philip Johnson
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  Variable Definitions for GBB1
;;;
;;;  01-08-86 File Created.  (Johnson)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package "GBB1")

(use-package '(lisp umass-extended-lisp gbb))

(export '(*execution-cycle*
	  *trigger-event*
	  *this-ksar* 
	  *this-ks*))

;;; -----------------------------------------------------------------
;;;
;;;  User visible variables
;;;
;;; -----------------------------------------------------------------

(defvar *execution-cycle* 0
  "The current execution cycle")

(defvar *this-ksar* nil
  "The current KSAR whose preconditions are being tested.")

(defvar *this-ks* nil
  "The current KS whose trigger conditions are being tested.") 

(defvar *trigger-event* nil
  "The current event unit being tested against the trigger conditions.")


;;; -----------------------------------------------------------------
;;;
;;; Vars to hold execution time parameters set by user.
;;;
;;; -----------------------------------------------------------------

(defvar *precondition-recheck-interval* 3
  "How many execution cycles to skip between rechecking preconditions")

(defvar *obviation-recheck-interval* 3
  "How many execution cycles to skip between rechecking obviation conditions.")

(defvar *trace-function* nil
  "The user supplied function to display things during the execution cycle")

(defvar *priority-function* nil
  "The priority function")

(defvar *priority-fn-stability* nil
  "The priority function")

(defvar *recommendation-function* nil
  "The recommendation function")

(defvar *termination-function* nil
  "The termination condition")

(defvar *max-execution-cycles* 100
  "The upper bound on the number of execution cycles.")

(defvar *unit-width* 24
  "The width of printed entries in the agenda printing function.")


;;; -----------------------------------------------------------------
;;;
;;;  Vars to hold info collected at KS definition time
;;;
;;; -----------------------------------------------------------------


(defvar *current-ks-phase-list* (list :default-phase)
  "A list of the current problem solving KS phases for the system.")

(defvar *current-ksar-phase-list* (list :default-phase)
  "A list of the current problem solving KSAR phases for the system.")

(defvar *make-kss* nil
  "A list of calls to MAKE-<ks-unit-type> to be executed after blackboard instantiation.")

(defvar *triggering-space-labels* nil
  "A list of calls to make-paths used in the FROM-BB field of KSs to filter events.")

(defvar *from-bb-space-instances* nil
  "The actual space instances referred to by the FROM-BB field.")

(defvar *ks-phases* (list :default-phase)
  "A list of the problem solving phases for KSs.")

(defvar *ksar-phases* (list :default-phase)
  "A list of the problem solving phases for KSARs.")

(defvar *ks-units* nil
  "A list of the currently defined KSs.")

(defvar *ksar-units* nil
  "A list of the currently defined KSARs.")

;;; -----------------------------------------------------------------
;;;
;;;  Path structures
;;;
;;; -----------------------------------------------------------------

(defvar *exe-agenda-path* nil
  "Executable agenda path")

(defvar *tri-agenda-path* nil
  "Triggered agenda path")

(defvar *obv-agenda-path* nil
  "Obviated agenda path")

(defvar *exd-agenda-path* nil
  "Executed agenda path")						

(defvar *eve-agenda-path* nil
  "Event agenda path")

(defvar *KSs-agenda-path* nil
  "KSs agenda path")


;;; -----------------------------------------------------------------
;;;
;;;  Miscellaneous variables
;;;
;;; -----------------------------------------------------------------

(defvar *ksar-id* 0
  "Used to generate unique ID numbers for each KSAR")

;;; -----------------------------------------------------------------
;;;
;;;  KS Shell-specific variables.
;;;
;;; -----------------------------------------------------------------

(defvar *po-units* nil
  "all the control plan unit types.")

(defvar *cpl-agenda-path* nil
  "the agenda path structure for the control plan")

(defvar *heu-agenda-path* nil
  "heuristic agenda path")

(defvar *foc-agenda-path* nil
  "focus agenda path")

(defvar *str-agenda-path* nil
  "strategy agenda path")

;;; -----------------------------------------------------------------
;;;
;;;  Metering Variables
;;;
;;; -----------------------------------------------------------------

(defvar *retrieved-KSs* 0
  "Number KSs retrieved during problem solving.")

(defvar *retrieved-KSARs* 0
  "Number KSARs retrieved during problems solving.")

(defvar *tested-triggers* 0
  "Number of trigger conditions tested.")

(defvar *tested-preconditions* 0
  "Number of preconditions tested.")

(defvar *tested-obviation-conditions* 0
  "Number of obviation conditions tested.")

(defvar *generated-events* 0
  "Number of events generated.")

(defvar *retrieved-events* 0
  "Number of events retrieved.")

(defvar *meter-gbb1* nil
  "Flag to monitor GBB1.")

;;; --------------------------------------------------------------------------
;;;				End of File
;;; --------------------------------------------------------------------------
