;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:GBB1; Base:10 -*-
;;;; *-* File: VAX6:DIS$DISK:[GBB.V-120.LOCAL.GBB1]GBB1-UTILS.LISP *-*
;;;; *-* Edited-By: Gallagher *-*
;;;; *-* Last-Edit: Wednesday, February 8, 1989  16:20:32 *-*
;;;; *-* Machine: Gilgamesh (Explorer II, Microcode 308) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (0.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *           GBB1 Execution Shell: Function Definitions
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Philip Johnson
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  03-05-87 File Created.  (Johnson)
;;;  05-19-87 Conversion to GBB1 Execution Shell Version 1.0  (Johnson)
;;;  09-16-88 Updated MOVE-UNIT-TO-AGENDA to use add-unit-to-space and 
;;;           remove-unit-from-space functions.  (Cork)
;;;  02-07-89 Fixed above update to MOVE-UNIT-TO-AGENDA.  (Gallagher)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


(in-package "GBB1")

(use-package '(lisp umass-extended-lisp gbb))

;;; -----------------------------------------------------------------
;;;
;;;	Utilities
;;;
;;; -----------------------------------------------------------------

(defun AGENDA-NAME (agenda-path-structure)

  "AGENDA-NAME agenda-path-structure

   Returns the name of the agenda, passed its path structure."

  (get-space-name-from-path-structure agenda-path-structure))

;;; -----------------------------------------------------------------

(defun AGENDA-PATH (agenda-name)

  "AGENDA-PATH agenda-name

   Returns the path structure to an agenda, given its name"
  
  (case agenda-name
     (:executable *exe-agenda-path*)
     (:triggered *tri-agenda-path*)
     (:obviated *obv-agenda-path*)
     (:executed *exd-agenda-path*)
     (otherwise (error "~s is not an agenda name" agenda-name))))

;;; -----------------------------------------------------------------

(defun EMPTY-EXECUTABLE-AGENDA-P ()

  "EMPTY-EXECUTABLE-AGENDA-P nil

   Returns T if the executable agenda is empty."

  (empty-space-p *exe-agenda-path*))

;;; -----------------------------------------------------------------

(defun COPY-VECTOR (vec)

  "COPY-VECTOR vec

   Returns a copy of the vector VEC"

  (map (type-of vec) #'identity vec))

;;; -----------------------------------------------------------------

(defun MOVE-UNIT-TO-AGENDA (ksar new-agenda-path)

  "MOVE-UNIT-TO-AGENDA ksar new-agenda-path

   Move KSAR to the space indicated by NEW-AGENDA-PATH, unless it's
   already on it."

  (check-type new-agenda-path (or list gbb::path-structure))

  (let* ((old-agenda-name (basic-ksar$status ksar))
         (new-agenda-name (agenda-name new-agenda-path))
	 (old-agenda-path (agenda-path old-agenda-name)))
         
    (unless (eq new-agenda-name old-agenda-name)
      (let ((gbb::%%run-events%% nil))
        (setf (basic-ksar$status ksar) new-agenda-name))
      (delete-unit-from-space ksar old-agenda-path)
      (add-unit-to-space ksar new-agenda-path))))

  
;;; -----------------------------------------------------------------
;;;
;;;	Blackboard Execution Trace Functions
;;;
;;; -----------------------------------------------------------------

(defun PRINT-GBB1-AGENDAS (&key (comment "")
                                (unit-width *unit-width*)
                                (stream *trace-stream*))
  
  "PRINT-GBB1  &optional stream unit-width

   Print out the state of the agendas."

  (let* ((triggered  (list-agenda *tri-agenda-path*))
	 (executable (list-agenda *exe-agenda-path*))
	 (obviated   (list-agenda *obv-agenda-path*))
	 (executed   (list-agenda *exd-agenda-path*))
	 (events     (find-units t *eve-agenda-path* 
				 `(:pattern-object
				    (:index-type execution-cycle-type
				     :index-object ,*execution-cycle*))))
        (longest (max (length triggered) (length executable) (length events)
		      (length obviated)  (length executed))))
    
    (format stream "~2%~V,1,0,'=A~
                    ~%~a ~VTCycle: ~d~
                    ~%Triggered~VTExecutable~VTObviated~VTExecuted~VTEvents~
                    ~%~V,1,0,'-A"
	    (* 5 unit-width) ""
	    comment (- (* 5 unit-width) 10) *execution-cycle*
	    unit-width (* 2 unit-width) (* 3 unit-width) (* 4 unit-width)
	    (* 5 unit-width) "")

    (dotimes (i longest)
      (format stream "~%")
      (when triggered
	(format stream "~a" (first triggered))
	(pop triggered))
      (when executable
	(format stream "~VT~a" unit-width (first executable))
	(pop executable))
      (when obviated
	(format stream "~VT~a" (* 2 unit-width) (first obviated))
	(pop obviated))
      (when executed
	(format stream "~VT~a" (* 3 unit-width) (first executed))
	(pop executed))
      (when events
	(format stream "~VT~a" (* 4 unit-width) (first events))
	(pop events)))))

;;; -----------------------------------------------------------------

(defun LIST-AGENDA (agenda-path)

  "LIST-AGENDA agenda-path

   Returns a list of the unit-instances on AGENDA-PATH."

  (let ((path-list nil))
    (map-space #'(lambda (unit-instance)
		   (push unit-instance path-list))
	       t agenda-path)
    path-list))

;;; --------------------------------------------------------------------------
;;;				End of File
;;; --------------------------------------------------------------------------




