;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:GBB1; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL.GBB1]GBB1-KS.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Friday, September 16, 1988  10:24:02 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *           GBB1 Layer-independent KS Definitions.
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Philip Johnson
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  05-12-87 File created.  (Johnson)
;;;  09-16-88 Added :addition-to-space-events and :removal-from-space-events
;;;           (Cork)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package "GBB1")

(use-package '(lisp umass-extended-lisp gbb))

;;; -----------------------------------------------------------------
;;;
;;;  DEFINE-GBB1-KSAR 
;;;
;;;  This macro defines user-customized KSARs (i.e. they have additional
;;;  GBB slots, links, etc. over and above the defaults.
;;;
;;; -----------------------------------------------------------------

(defmacro DEFINE-GBB1-KSAR (name-and-options &body args &aux documentation)
  
  "DEFINE-GBB1-KSAR name-and-options [documentation]
     &KEY ks-unit-type slots dimensional-indexes links path-indexes paths

   DEFINE-GBB1-KSAR defines a knowledge source activation record. KS-UNIT-TYPE
   is the KS which will generate KSARs of this type.

   The keywords' syntax are:

   KS-UNIT-TYPE:            symbol
   KSAR-EVENT-CLASSES:     ({event-class}*) | :ALL
   Event-class:            {:creation-events | :deletion-events | 
                            :addition-to-space-events | :removal-from-space-events
                            :slot-access-events | :slot-update-events | 
                            :link-access-events | :link-update-events | :unlink-events}
   SLOTS:                  ({(slot-name [init-form {keyword value}*])}*)
   LINKS:                  ({(link-name [:singular]
                                        {:reflexive |
                                         (inverse-link-unit inverse-link-name [:singular])}
                                        {keyword value}*)}*)
   DIMENSIONAL-INDEXES:    ({(index-name slot-name [:type index-element-type])}*)
   PATH-INDEXES:           ({(index-name slot-name [:type index-element-type])}*)
   PATHS:                  ({(path-predicate path-spec)}*)
   AUTHOR:                 symbol"
  
  (setf documentation
	(if (stringp (car args)) (pop args) "No Documentation Supplied"))
  
  (with-keywords-bound ((ks-unit-type ksar-event-classes slots links
			 dimensional-indexes path-indexes paths author)
			args
			"~s is not a valid keyword for DEFINE-KSAR.")
    
    (let* ((ksar-unit-type (first-if-list name-and-options)))
      `(progn
	 (eval-when (load eval compile) 
	   (pushnew ',ksar-unit-type *ksar-units*))

	 ;; build the call to DEFINE-UNIT.
	 ,.(build-custom-ksar-define-unit name-and-options ksar-event-classes
					  slots dimensional-indexes
					  links path-indexes paths documentation)
	 
	 ;; Return the unit-type.
	 ',ksar-unit-type))))

;;; -----------------------------------------------------------------
;;;
;;;  DEFINE-GBB1-UNIT
;;;
;;;  This macro is identical to the standard GBB define-unit, except that
;;;  it provides one additional name-and-options option: :EVENT-CLASSES,
;;;  which indicate which classes of GBB1 events should be generated by operations
;;;  on unit instances of this type.
;;;
;;; -----------------------------------------------------------------

(defmacro define-gbb1-unit (name-and-options &body args &aux documentation)
  
  "DEFINE-GBB1-UNIT name-and-options [documentation]
     &KEY event-classes slots dimensional-indexes links path-indexes paths

   DEFINE-GBB1-UNIT defines a GBB unit with the GBB1 events specified for each
   of the supplied :EVENT-CLASSES.

   The keywords' syntax are:

   EVENT-CLASSES:         ({event-class}*) | :ALL
   Event-class:            {:creation-events | :deletion-events | 
                            :addition-to-space-events | :removal-from-space-events
                            :slot-access-events | :slot-update-events | 
                            :link-access-events | :link-update-events | :unlink-events}
   SLOTS:                  ({(slot-name [init-form {keyword value}*])}*)
   LINKS:                  ({(link-name [:singular]
                                        {:reflexive |
                                         (inverse-link-unit inverse-link-name [:singular])}
                                        {keyword value}*)}*)
   DIMENSIONAL-INDEXES:    ({(index-name slot-name [:type index-element-type])}*)
   PATH-INDEXES:           ({(index-name slot-name [:type index-element-type])}*)
   PATHS:                  ({(path-predicate path-spec)}*)"
  
  (setf documentation
	(if (stringp (car args)) (pop args) "No Documentation Supplied"))
  
  (with-keywords-bound ((event-classes slots links dimensional-indexes path-indexes paths)
			args
			"~s is not a valid keyword for DEFINE-KSAR.")

    ;; build the DEFINE-UNIT call, putting the event calls in
    `(define-unit
       ;; add event class and included unit to name-and-options 
       ,(update-name-and-options name-and-options event-classes :gbb-unit)
       ,documentation
       :links               ,links
       :slots               ,slots
       :dimensional-indexes ,dimensional-indexes
       :path-indexes        ,path-indexes
       :paths               ,paths)))


;;; --------------------------------------------------------------------------
;;;				End of File
;;; --------------------------------------------------------------------------
