;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:GBB1; Base:10 -*-
;;;; *-* File: VAX6:DIS$DISK:[GBB.V-120.LOCAL.GBB1]GBB1-GBB.LISP *-*
;;;; *-* Edited-By: Gallagher *-*
;;;; *-* Last-Edit: Wednesday, February 8, 1989  16:20:23 *-*
;;;; *-* Machine: Gilgamesh (Explorer II, Microcode 308) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (0.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *           GBB1 Control Shell: GBB Structure Definitions
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Philip Johnson
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  03-05-87 File Created.  (Johnson)
;;;  04-22-87 Start of redesign for version 1.0 of GBB1.
;;;  09-16-88 Added :addition-to-space-events and :removal-from-space-events
;;;           (Cork)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package "GBB1")

(use-package '(lisp umass-extended-lisp gbb))

;;;; --------------------------------------------------------------------------
;;;;
;;;;  Index Structures.
;;;;
;;;; --------------------------------------------------------------------------

(define-index-structure KS-PHASE-SET
  :composite-type list
  :composite-index :none
  :element-type symbol
  :indexes ((KS-phase :label)))

;;;; --------------------------------------------------------------------------

(define-index-structure KSAR-PHASE-SET
  :composite-type list
  :composite-index :none
  :element-type symbol
  :indexes ((KSAR-phase :label)))

;;;; --------------------------------------------------------------------------

(define-index-structure TRIGGERING-SPACE-SET
  :composite-type list
  :composite-index :none
  :element-type symbol
  :indexes ((triggering-space :label)))

;;;; --------------------------------------------------------------------------

(define-index-structure EXECUTION-CYCLE-TYPE
  :type integer
  :indexes ((execution-cycle :point)))

;;;; --------------------------------------------------------------------------

(define-index-structure AGENDA-TYPE
  :type symbol
  :indexes ((agenda-index :label)))

;;;; --------------------------------------------------------------------------
;;;;  Event Handler Functions.  
;;;;
;;;;  These are the functions which create the GBB1-Event units.  They will
;;;;  be included in the KS definition depending upon the value of 
;;;;  KS-EVENT-CLASSES and KSAR-EVENT-CLASSES in DEFINE-KS.
;;;; --------------------------------------------------------------------------

;;; actually, we should have both a triggering-space slot, which holds the actual
;;; space instance list, and a triggering-space-label slot, which holds the spaces
;;; in the from-bb slot or :default-space if none.

(defun GBB1-CREATION (unit-instance)
  (make-gbb1-event 
    :triggering-space (get-triggering-space-instances unit-instance)
    :event-type :unit-creation
    :unit-instance unit-instance
    :execution-cycle *execution-cycle*))

;;;; --------------------------------------------------------------------------

(defun GBB1-DELETION (unit-instance)
  (make-gbb1-event
    :triggering-space (get-triggering-space-instances unit-instance)
    :event-type :unit-deletion
    :unit-instance unit-instance
    :execution-cycle *execution-cycle*))

;;;; --------------------------------------------------------------------------

(defun GBB1-ADDITION-TO-SPACE (unit-instance path)
  (declare (ignore path))
  (make-gbb1-event
    :triggering-space (get-triggering-space-instances unit-instance)
    :event-type :unit-addition-to-space
    :unit-instance unit-instance
    :execution-cycle *execution-cycle*))

;;;; --------------------------------------------------------------------------

(defun GBB1-REMOVAL-FROM-SPACE (unit-instance path)
  (declare (ignore path))
  (make-gbb1-event
    :triggering-space (get-triggering-space-instances unit-instance)
    :event-type :unit-removal-from-space
    :unit-instance unit-instance
    :execution-cycle *execution-cycle*))

;;;; --------------------------------------------------------------------------

(defun GBB1-LINK-UPDATE (unit-instance link new-value added-links)
  (declare (ignore added-links))
  (make-gbb1-event
    :triggering-space (get-triggering-space-instances unit-instance)
    :event-type :link-update
    :unit-instance unit-instance
    :slot-or-link link
    :new-value new-value
    :execution-cycle *execution-cycle*))

;;;; --------------------------------------------------------------------------

(defun GBB1-SLOT-UPDATE (unit-instance slot new-value old-value)
  (declare (ignore old-value))
  (make-gbb1-event
    :triggering-space (get-triggering-space-instances unit-instance)
    :event-type :slot-update
    :unit-instance unit-instance
    :slot-or-link slot
    :new-value new-value
    :execution-cycle *execution-cycle*))

;;;; --------------------------------------------------------------------------

(defun GBB1-LINK-ACCESS (unit-instance link link-value)
  (declare (ignore link-value))
  (make-gbb1-event
    :triggering-space (get-triggering-space-instances unit-instance)
    :event-type :link-access
    :unit-instance unit-instance
    :slot-or-link link
    :execution-cycle *execution-cycle*))

;;;; --------------------------------------------------------------------------

(defun GBB1-SLOT-ACCESS (unit-instance slot slot-value)
  (declare (ignore slot-value))
  (make-gbb1-event
    :triggering-space (get-triggering-space-instances unit-instance)
    :event-type :slot-access
    :unit-instance unit-instance
    :slot-or-link slot
    :execution-cycle *execution-cycle*))

;;;; --------------------------------------------------------------------------

(defun GBB1-LINK-INITIALIZATION (unit-instance link value)
  (declare (ignore value))
  (make-gbb1-event
    :triggering-space (get-triggering-space-instances unit-instance)
    :event-type :link-initialization
    :unit-instance unit-instance
    :slot-or-link link
    :execution-cycle *execution-cycle*))

;;;; --------------------------------------------------------------------------

(defun GBB1-SLOT-INITIALIZATION (unit-instance slot value)
  (declare (ignore value))
  (make-gbb1-event
    :triggering-space (get-triggering-space-instances unit-instance)
    :event-type :slot-initialization
    :unit-instance unit-instance
    :slot-or-link slot
    :execution-cycle *execution-cycle*))

;;;; --------------------------------------------------------------------------

(defun GBB1-UNLINK (unit-instance link new-value deleted-links)
  (declare (ignore deleted-links))
  (make-gbb1-event
    :triggering-space (get-triggering-space-instances unit-instance)
    :event-type :unlink
    :unit-instance unit-instance
    :slot-or-link link
    :new-value new-value
    :execution-cycle *execution-cycle*))

;;;; --------------------------------------------------------------------------

(defun get-triggering-space-instances (unit-instance)
  "Return a list of space instances for the TRIGGERING-SPACE slot
   of a GBB1 event."
  (or (intersection *from-bb-space-instances*
                    (gbb::basic-unit.%%space-instances%% unit-instance))
      '(:default-space)))

;;;; --------------------------------------------------------------------------
;;;;   Unit Print Functions.
;;;; --------------------------------------------------------------------------

(defun GBB1-EVENT-PRINTER (object stream depth)
  (declare (ignore depth))
  (let ((event-type (string (gbb1-event$event-type object))))
    (format stream ":~a ~a"
	    (if (> (length event-type) 10)
		(subseq event-type 0 9)
		event-type)
	    (gbb::basic-unit.name  (gbb1-event$unit-instance object)))))

;;;; --------------------------------------------------------------------------

(defun GBB1-KS-PRINTER (object stream depth)
  (declare (ignore depth))
  (format stream "#<KS: ~a>"
	  (basic-ks$name object)))

;;;; --------------------------------------------------------------------------

(defun DEFAULT-KSAR-PRINT-FUNCTION (object stream depth)
  (declare (ignore depth))
  (format stream "~a" (basic-ksar$name object)))

;;;; --------------------------------------------------------------------------
;;;;   Units.
;;;; --------------------------------------------------------------------------

(define-unit (ATOMIC-EVENT (:print-function gbb1-event-printer)
			   (:predicate nil)
			   (:constructor nil))
  :slots
  ((event-type     nil)
   (unit-instance  nil)
   (slot-or-link   nil)
   (new-value      nil)
   (execution-cycle 0  :type execution-cycle-type)
   (triggering-space (list :default-space) :type triggering-space-set))

  :links
  ((triggered-ksars (atomic-ksar trigger-event :singular)))
  
  :dimensional-indexes
  ((execution-cycle execution-cycle)
   (triggering-space triggering-space)))

;;;; --------------------------------------------------------------------------

(define-unit (ATOMIC-KS (:constructor nil)
			(:predicate nil)
			)
  "Defines the slots and links common to all KSs."

  :slots
  ((trigger-conditions     nil)
   
   (active-preconditions   nil)
   (all-preconditions      NIL)
   (dynamic-preconditions  NIL)
   (precondition-vector-size 0)
   
   (active-obv-conditions  NIL)
   (all-obv-conditions     NIL)
   (dynamic-obv-conditions NIL)
   (obviation-vector-size    0)
   
   (context-slots          (list nil nil))
   (action-function        nil)
   
   (from-bb                nil)
   (to-bb                  nil)
   
   (ks-phases              (list :default-phase) :type ks-phase-set)
   (ksar-phases            (list :default-phase) :type ksar-phase-set)
   
   (ksar-unit-type         nil)
   (ksar-make-name         nil)
   (author                 nil)
   (cost                   nil)
   (reliability            nil)
   (ks-type                :domain)  
   )
  :links
  ((triggered-ksars (atomic-ksar triggering-ks :singular)))

  :dimensional-indexes
  ((ks-phase ks-phases)))

;;;; --------------------------------------------------------------------------

(define-unit (ATOMIC-KSAR (:constructor nil)
			  (:predicate nil))

  "Defines the slots and links common to all KSARs."

  :slots
  ((active-preconditions   nil)
   (all-preconditions      NIL)
   (dynamic-preconditions  NIL)
   (precondition-vector-size 0)
   
   (active-obv-conditions  NIL)
   (all-obv-conditions     NIL)
   (dynamic-obv-conditions NIL)
   (obviation-vector-size    0)
   
   (ksar-phases            (list :default-phase) :type ksar-phase-set)
   (cost                   nil)
   (reliability            nil)
;   (author                 nil)
   (status                 :triggered :type agenda-type)
   (priority               nil) ;; only used with stable priority functions
   (executed-cycle         :not-executed)
   (ks-unit-type           nil)
   (ksar-num                 0)
   (ksar-type              :domain))

  :links
  ((triggering-ks :singular (atomic-ks triggered-ksars))
   (trigger-event :singular (atomic-event triggered-ksars)))
  
  :dimensional-indexes
  ((ksar-phase ksar-phases))

  :path-indexes
  ((agenda-index status)))

;;; -----------------------------------------------------------------
;;;				End of File
;;; -----------------------------------------------------------------
