 /* $Id: user.h,v 3.13 1994/05/31 11:13:16 ingber Exp ingber $ */

 /* user.h for Adaptive Simulated Annealing */

#include "asa_user.h"

 /* print the time every PRINT_FREQUENCY function evaluations
    Define PRINT_FREQUENCY to 0 to not print out the time. */
#define PRINT_FREQUENCY ((LONG_INT) 1000)

FILE *ptr_out;

 /* system function prototypes */
#if HAVE_ANSI

/* This block gives trouble under some Ultrix */
#if FALSE
#if OPTIONS_FILE
int fscanf (FILE * fp, char *string,...);
#endif
#endif

#if IO_PROTOTYPES
#if OPTIONS_FILE
int fscanf ();
#endif
#endif

 /* user-defined */
double cost_function (double *cost_parameters,
		      double *parameter_lower_bound,
		      double *parameter_upper_bound,
		      double *cost_tangents,
		      double *cost_curvature,
		      ALLOC_INT * parameter_dimension,
		      int *parameter_int_real,
		      int *cost_flag,
		      int *exit_code,
		      USER_DEFINES * USER_OPTIONS);
#if ASA_LIB
int asa_main ();
#else
int main (int argc, char **argv);
#endif

 /* possibly with accompanying data file */
void initialize_parameters (double *cost_parameters,
			    double *parameter_lower_bound,
			    double *parameter_upper_bound,
			    double *cost_tangents,
			    double *cost_curvature,
			    ALLOC_INT * parameter_dimension,
			    int *parameter_int_real,
			    USER_DEFINES * USER_OPTIONS);

double myrand (void);
double randflt (void);
void initialize_rng (void);

#if USER_COST_SCHEDULE
double user_cost_schedule (double test_temperature,
			   USER_DEFINES * USER_OPTIONS);
#endif

#if USER_REANNEAL_FUNCTION
double user_reanneal (double current_temp,
		      double tangent,
		      double max_tangent,
		      USER_DEFINES * USER_OPTIONS);
#endif

#if ASA_SAMPLE
#if ASA_TEMPLATE
void sample (FILE * ptr_out, FILE * ptr_asa);
#endif
#endif

#else /* HAVE_ANSI */

#if IO_PROTOTYPES
#if OPTIONS_FILE
int fscanf ();
#endif
#endif

 /* user-defined */
double cost_function ();
#if ASA_LIB
int asa_main ();
#else
int main ();
#endif
void initialize_parameters ();	/* possibly with accompanying
				   data file */
double myrand ();
double randflt ();
void initialize_rng ();

#if USER_COST_SCHEDULE
double user_cost_schedule ();
#endif

#if USER_REANNEAL_FUNCTION
double user_reanneal ();
#endif

#if ASA_SAMPLE
#if ASA_TEMPLATE
void sample ();
#endif
#endif
#endif /* HAVE_ANSI */

#if SELF_OPTIMIZE
static LONG_INT funevals = 0;
#define RECUR_PRINT_FREQUENCY ((LONG_INT) 1)

#if HAVE_ANSI			/* HAVE_ANSI SELF_OPTIMIZE */
double recur_cost_function (double *recur_cost_parameters,
			    double *recur_parameter_lower_bound,
			    double *recur_parameter_upper_bound,
			    double *recur_cost_tangents,
			    double *recur_cost_curvature,
			    ALLOC_INT * recur_parameter_dimension,
			    int *recur_parameter_int_real,
			    int *recur_cost_flag,
			    int *recur_exit_code,
			    USER_DEFINES * RECUR_USER_OPTIONS);

void recur_initialize_parameters (double *recur_cost_parameters,
				  double *recur_parameter_lower_bound,
				  double *recur_parameter_upper_bound,
				  double *recur_cost_tangents,
				  double *recur_cost_curvature,
				  ALLOC_INT * recur_parameter_dimension,
				  int *recur_parameter_int_real,
				  USER_DEFINES * RECUR_USER_OPTIONS);

#if USER_COST_SCHEDULE
double recur_user_cost_schedule (double test_temperature,
				 USER_DEFINES * RECUR_USER_OPTIONS);
#endif

#if USER_REANNEAL_FUNCTION
double recur_user_reanneal (double current_temp,
			    double tangent,
			    double max_tangent,
			    USER_DEFINES * RECUR_USER_OPTIONS);
#endif

#else /* HAVE_ANSI SELF_OPTIMIZE */

double recur_cost_function ();
void recur_initialize_parameters ();

#if USER_COST_SCHEDULE
double recur_user_cost_schedule ();
#endif

#if USER_REANNEAL_FUNCTION
double recur_user_reanneal ();
#endif

#endif /* HAVE_ANSI SELF_OPTIMIZE */
#endif /* SELF_OPTIMIZE */
