 /* $Id: asa_user.h,v 3.13 1994/05/31 11:13:21 ingber Exp ingber $ */

 /* asa_user.h for Adaptive Simulated Annealing */

#include <errno.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>		/* misc defs on most machines */
#include <string.h>

#define	TRUE			1
#define	FALSE			0

 /* DEFAULT PARAMETERS SETTINGS */

 /* Pre-Compile Options */

#ifndef OPTIONS_FILE
#define OPTIONS_FILE FALSE
#endif

#ifndef ASA_LIB
#define ASA_LIB FALSE
#endif

#ifndef HAVE_ANSI
#define HAVE_ANSI TRUE
#endif

#ifndef IO_PROTOTYPES
#define IO_PROTOTYPES TRUE
#endif

#ifndef TIME_CALC
#define TIME_CALC FALSE
#endif

#ifndef INT_LONG
#define INT_LONG TRUE
#endif

#if INT_LONG
#define LONG_INT long int
#else
#define LONG_INT int
#endif

#ifndef INT_ALLOC
#define INT_ALLOC FALSE
#endif

#if INT_ALLOC
#define ALLOC_INT int
#else
#define ALLOC_INT LONG_INT
#endif

 /* You can define SMALL_FLOAT to better correlate to your machine's
    precision, i.e., as used in asa */
#ifndef SMALL_FLOAT
#define SMALL_FLOAT 1.0E-18
#endif

 /* You can define your machine's maximum and minimum doubles here */
#ifndef MIN_DOUBLE
#define MIN_DOUBLE SMALL_FLOAT
#endif

#ifndef MAX_DOUBLE
#define MAX_DOUBLE (1.0/SMALL_FLOAT)
#endif

#ifndef EPS_DOUBLE
#define EPS_DOUBLE SMALL_FLOAT
#endif

#ifndef ASA_TEST
#define ASA_TEST FALSE
#endif

#ifndef ASA_TEMPLATE
#define ASA_TEMPLATE FALSE
#endif

#ifndef OPTIONAL_DATA
#define OPTIONAL_DATA FALSE
#endif

#ifndef USER_REANNEAL_FUNCTION
#define USER_REANNEAL_FUNCTION FALSE
#endif

#ifndef USER_COST_SCHEDULE
#define USER_COST_SCHEDULE FALSE
#endif

#define INTEGER_TYPE		((int) 1)
#define REAL_TYPE		((int) -1)
#define INTEGER_NO_REANNEAL	((int) 2)
#define REAL_NO_REANNEAL	((int) -2)

 /* Set this to TRUE to self-optimize the Program Options */
#ifndef SELF_OPTIMIZE
#define SELF_OPTIMIZE FALSE
#endif

#ifndef USER_ASA_OUT
#define USER_ASA_OUT FALSE
#endif

#ifndef ASA_SAMPLE
#define ASA_SAMPLE FALSE
#endif

#ifndef __GNUC__		/* this can be useful when using gcc */
#define __GNUC__ FALSE
#endif

 /* Program Options */

typedef struct
  {
    LONG_INT LIMIT_ACCEPTANCES;
    LONG_INT LIMIT_GENERATED;
    int LIMIT_INVALID_GENERATED_STATES;
    double ACCEPTED_TO_GENERATED_RATIO;

    double COST_PRECISION;
    int MAXIMUM_COST_REPEAT;
    int NUMBER_COST_SAMPLES;
    double TEMPERATURE_RATIO_SCALE;
    double COST_PARAMETER_SCALE;
    double TEMPERATURE_ANNEAL_SCALE;
    int USER_INITIAL_COST_TEMP;
    double *user_cost_temperature;

    int INCLUDE_INTEGER_PARAMETERS;
    int USER_INITIAL_PARAMETERS;
    ALLOC_INT SEQUENTIAL_PARAMETERS;
    double INITIAL_PARAMETER_TEMPERATURE;
    int RATIO_TEMPERATURE_SCALES;
    double *user_temperature_ratio;
    int USER_INITIAL_PARAMETERS_TEMPS;
    double *user_parameter_temperature;

    int TESTING_FREQUENCY_MODULUS;
    int ACTIVATE_REANNEAL;
    double REANNEAL_RESCALE;
    LONG_INT MAXIMUM_REANNEAL_INDEX;

    double DELTA_X;
    int DELTA_PARAMETERS;
    double *user_delta_parameter;
    int CURVATURE_0;

    int QUENCH_PARAMETERS;
    double *user_quench_param_scale;
    int QUENCH_COST;
    double *user_quench_cost_scale;

#if OPTIONAL_DATA
    double *asa_data;
#endif
#if USER_ASA_OUT
    char *asa_out_file;
#endif
#if USER_COST_SCHEDULE
    double (*cost_schedule) ();
#endif
#if USER_REANNEAL_FUNCTION
    double (*reanneal_function) ();
#endif
#if ASA_SAMPLE
    LONG_INT n_accepted;
    double bias_acceptance;
    double *bias_generated;
    double average_weights;
    double limit_weights;
#endif
  }
USER_DEFINES;

 /* system function prototypes */

#if HAVE_ANSI

/* This block gives trouble under some Ultrix */
#if FALSE
int fprintf (FILE * fp, char *string,...);
void exit (int code);
#endif

#if IO_PROTOTYPES
int fprintf ();
int fflush (FILE * fp);
int fclose (FILE * fp);
void exit ();
#endif

double asa (double (*user_cost_function) (),
	    double (*user_random_generator) (),
	    double *parameter_initial_final,
	    double *parameter_minimum,
	    double *parameter_maximum,
	    double *tangents,
	    double *curvature,
	    ALLOC_INT * number_parameters,
	    int *parameter_type,
	    int *valid_state_generated_flag,
	    int *exit_status,
	    USER_DEFINES * OPTIONS);

#if TIME_CALC
void print_time (char *message, FILE * ptr_out);
#endif

#else /* HAVE_ANSI */

#if IO_PROTOTYPES
int fprintf ();
int fflush ();
int fclose ();
#endif

double asa ();

#if TIME_CALC
void print_time ();
#endif

#endif /* HAVE_ANSI */
