% File: cell.pl
% Created: 23-Feb-93
% Last Update: 
% Author: Afzal Ballim
% Purpose: implement memory cells, that can be 
%          created and destroyed using assert/retract
%	   For use in double-linked lists, etc.
%
% Needs: indexed dynamic predicates.

:- public cell_create/2,
	  cell_get/2,
	  cell_destroy/1,
	  cell_update/3.

:- dynamic ':::cell:::'/2, ':::cell_count:::'/1.

cell_create(Contents,Ref) :-
	cell_newref(Ref),!,
	asserta(':::cell:::'(Ref,Contents)).

cell_newref(Ref) :-
	clause(':::cell_count:::'(Oc),true,IntRef),
	Ref is Oc+1,
	erase(IntRef),
	asserta(':::cell_count:::'(Ref)).

cell_newref(0) :-
	asserta(':::cell_count:::'(0)).

cell_get(Ref,Contents) :-
	':::cell:::'(Ref,Contents).

cell_destroy(Ref) :-
	clause(':::cell:::'(Ref,_),true,IntRef),!,
	erase(IntRef).

cell_update(Ref,OldContents,NewContents) :-
	clause(':::cell:::'(Ref,OldContents),true,IntRef),!,
	erase(IntRef),
	asserta(':::cell:::'(Ref,NewContents)).
	
