%
%
%    Boot: boot-strap for my library stuff.
%
%	-Afzal Ballim (15/2/93)
%
%


%============================================================
%
% Every library has 4 parts to it:
%
%	1) Library includes     - the files it calls.
%	2) Library dependencies - other files that it needs.
%	3) Library description  - a synopsis of the library.
%	4) Public predicates	- predicates for the user.
%
% Ideally, then a library should be of the form:
%
% :-  library_description(libname,'A description').
% :-  library_includes(libname,[inc1,inc2|Incs]).
% :-  library_dependencies(libanme,[dep1,dep2|Deps]).
% :-  library_publics(libname,[predspec1,predspec2|PredSpecs]).
%
% The user then needs a number of predicates that they can call,
%
%	library_list/0		= list all loaded libraries
%	library_description/1	= describe a library
%

% dynamic multifile declarations

:- multifile library_directory/1.

:- dynamic library_directory/1, lib_includes/2,
	   lib_dependencies/2, lib_synopsis/2, lib_publics/2.

% this library uses...
library_directory('.').
library_directory('/usr/afzal/src/vf-hetis/lib').
library_directory('/usr/afzal/src/vf-hetis/lib/predicates').
library_directory('/usr/afzal/src/vf-hetis/lib/collections').


:- ensure_loaded(library('LibUser')).


:- ensure_loaded(library('LibMaker')).

% The only predicate defined in here, libchecker/0
libchecker :- ensure_loaded(library('LibCheck')).
